/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.op.topic.DefaultTopics;

public class Topic {
    @Parameter(description="input-nanopubs")
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    @Parameter(names={"-i"}, description="Property URIs to ignore, separated by '|' (has no effect if -d is set)")
    private String ignoreProperties;
    @Parameter(names={"-h"}, description="Topic handler class")
    private String handlerClass;
    private RDFFormat rdfInFormat;
    private OutputStream outputStream = System.out;
    private BufferedWriter writer;
    private TopicHandler topicHandler;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Topic obj = new Topic();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        obj.init();
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static Topic getInstance(String args) throws ParameterException {
        NanopubImpl.ensureLoaded();
        if (args == null) {
            args = "";
        }
        Topic obj = new Topic();
        JCommander jc = new JCommander(obj);
        jc.parse(args.trim().split(" "));
        obj.init();
        return obj;
    }

    private void init() {
        if (this.handlerClass != null && !this.handlerClass.isEmpty()) {
            String detectorClassName = this.handlerClass;
            if (!this.handlerClass.contains(".")) {
                detectorClassName = "org.nanopub.op.topic." + this.handlerClass;
            }
            try {
                this.topicHandler = (TopicHandler)Class.forName(detectorClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            this.topicHandler = new DefaultTopics(this.ignoreProperties);
        }
    }

    public void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        if (this.inputNanopubs == null || this.inputNanopubs.isEmpty()) {
            throw new ParameterException("No input files given");
        }
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            if (this.outputFile != null) {
                this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream));
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        Topic.this.writer.write(np.getUri() + " " + Topic.this.getTopic(np) + "\n");
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.writer.flush();
            if (this.outputStream == System.out) continue;
            this.writer.close();
        }
    }

    public String getTopic(Nanopub np) {
        return this.topicHandler.getTopic(np);
    }

    public static interface TopicHandler {
        public String getTopic(Nanopub var1);
    }
}

