/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.trusty;

import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class CrossRefResolver
implements RDFHandler {
    private Map<Resource, IRI> tempRefMap;
    private Map<String, String> tempPrefixMap;
    private RDFHandler nestedHandler;
    private static ValueFactory vf = SimpleValueFactory.getInstance();

    public CrossRefResolver(Map<Resource, IRI> tempRefMap, Map<String, String> tempPrefixMap, RDFHandler nestedHandler) {
        this.tempRefMap = tempRefMap;
        this.tempPrefixMap = tempPrefixMap;
        this.nestedHandler = nestedHandler;
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.nestedHandler.handleStatement(SimpleValueFactory.getInstance().createStatement((Resource)this.replace(st.getSubject()), (IRI)this.replace(st.getPredicate()), this.replace(st.getObject()), (Resource)this.replace(st.getContext())));
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        String transformedUri = this.replace(SimpleValueFactory.getInstance().createIRI(uri)).stringValue();
        this.nestedHandler.handleNamespace(prefix, transformedUri);
    }

    private Value replace(Value v) {
        if (!(v instanceof Resource)) {
            return v;
        }
        IRI i = this.tempRefMap.get(v);
        if (i != null) {
            return i;
        }
        if (v instanceof IRI && this.tempPrefixMap != null) {
            for (String prefix : this.tempPrefixMap.keySet()) {
                if (!v.stringValue().startsWith(prefix)) continue;
                return vf.createIRI(v.stringValue().replace(prefix, this.tempPrefixMap.get(prefix)));
            }
        }
        return v;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.nestedHandler.startRDF();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.nestedHandler.endRDF();
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        this.nestedHandler.handleComment(comment);
    }
}

