/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.trusty;

import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.nanopub.Nanopub;

public class TempUriReplacer
implements RDFHandler {
    public static final String tempUri = "http://purl.org/nanopub/temp/";
    public static final String normUri = "http://purl.org/np/ARTIFACTCODE-PLACEHOLDER/";
    private String uriPrefix;
    private RDFHandler nestedHandler;
    private Map<Resource, IRI> transformMap;

    public TempUriReplacer(Nanopub np, RDFHandler nestedHandler, Map<Resource, IRI> transformMap) {
        this.uriPrefix = np.getUri().stringValue();
        this.nestedHandler = nestedHandler;
        this.transformMap = transformMap;
    }

    public static boolean hasTempUri(Nanopub np) {
        return np.getUri().stringValue().startsWith(tempUri);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.nestedHandler.handleStatement(SimpleValueFactory.getInstance().createStatement((Resource)this.replace(st.getSubject()), (IRI)this.replace(st.getPredicate()), this.replace(st.getObject()), (Resource)this.replace(st.getContext())));
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        if (uri.startsWith(this.uriPrefix)) {
            uri = uri.replace(this.uriPrefix, normUri);
        }
        this.nestedHandler.handleNamespace(prefix, uri);
    }

    private Value replace(Value v) {
        if (v instanceof IRI && v.stringValue().startsWith(this.uriPrefix)) {
            IRI i = SimpleValueFactory.getInstance().createIRI(v.stringValue().replace(this.uriPrefix, normUri));
            if (this.transformMap != null) {
                this.transformMap.put((IRI)v, i);
            }
            return i;
        }
        return v;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.nestedHandler.startRDF();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.nestedHandler.endRDF();
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        this.nestedHandler.handleComment(comment);
    }
}

