# src/scrapy_algova/captcha_provider/base_captcha.py

from abc import ABC, abstractmethod


class BaseCaptchaProvider(ABC):
    """
    Common interface for captcha providers.
    """

    @abstractmethod
    def build_submit_request(
        self,
        *,
        website_url: str,
        website_key: str,
        final_callback,
        errback=None,
        meta=None,
        task_type: str = "TurnstileTaskProxyless",
        task_params: dict = None,
    ):
        """
        Return a scrapy.Request that submits the captcha to the provider
        (createTask). Its callback deberá terminar yield-ando un
        CaptchaWaitRequest.
        """
        raise NotImplementedError

    @abstractmethod
    def build_result_request_params(self, captcha_id: str) -> dict:
        """
        Return kwargs para scrapy.Request al hacer getTaskResult:

            {
                "url": "...",
                "method": "POST" | "GET",
                "body": bytes|str,
                "headers": {...},
            }
        """
        raise NotImplementedError

    @abstractmethod
    def parse_result(self, response):
        """
        Parse polling response.

        Returns:
            (status, payload)
            status: "pending" | "ready" | "failed"
            payload: solution token / text / error message
        """
        raise NotImplementedError