/* 
 * @author: George petropoulos <gnp>  <petropoulos@gmail.com>
 *              
 * @Description: Solves a system of
 *               equations generated by 
 *               MPIDiagonalSOE
 *               
 * @Date: 12/05
 *
 * Copyright: ALL RIGHTS RESERVED BY AUTHOR
 *
 */


#include <MPIDiagonalSolver.h>
#include <MPIDiagonalSOE.h>
#include <Channel.h>

//#include <essl.h>


MPIDiagonalSolver::MPIDiagonalSolver(int classTag)
:LinearSOESolver(classTag),
 theSOE(0), minDiagTol(0.0)
{
  notSet = true;
}    

MPIDiagonalSolver::MPIDiagonalSolver(double tol)
:LinearSOESolver(SOLVER_TAGS_MPIDiagonalSolver),
 theSOE(0), minDiagTol(tol)
{
  notSet = true;
}    

MPIDiagonalSolver::~MPIDiagonalSolver()    
{

}    

int 
MPIDiagonalSolver::setLinearSOE(MPIDiagonalSOE &theSetSOE)
{
  
  theSOE = &theSetSOE;
  return 0;
}

int 
MPIDiagonalSolver::setSize(void)
{
  //int size = theSOE->size;
  //int processID = theSOE->processID;
  return 0;
}


int 
MPIDiagonalSolver::solve(void)
{

  int processID = theSOE->processID;
  int numNeighbours = theSOE->actualNeighbors;
  MPI_Request *theRequests = new MPI_Request[numNeighbours];
  MPI_Status  *theStatuses = new MPI_Status[numNeighbours];
 
  //MPI_Request requests[2*numNeighbours];
  //MPI_Status statuses[2*numNeighbours];
  bool debug_on = false;
  static int size = theSOE->size;
  static int numShared = theSOE->numShared;
  bool isAfactored = theSOE->isAfactored;
  ID &myDOFs = theSOE->myDOFs;
  ID &myDOFsShared = theSOE->myDOFsShared;
  
  double *X = theSOE->X;
  double *B = theSOE->B;
  double *A = theSOE->A;

  double* sharedA = theSOE->sharedA;
  double* sharedB = theSOE->sharedB;
  double* maxSharedA = theSOE->maxSharedA;
  double* maxSharedB = theSOE->maxSharedB;
  int* myDOFsArray = theSOE->myDOFsArray;
  int*myDOFsSharedArray = theSOE->myDOFsSharedArray;
  int*maxDOFsSharedArray = theSOE->maxDOFsSharedArray;
  int maxShared = theSOE->maxShared;
  int* myNeighbors = theSOE->myNeighbors;
  int* myNeighborsSizes = theSOE->myNeighborsSizes;
  int maxNeighbors = theSOE->maxNeighbors;
  int* tmpnumShared = new int[1];
  *tmpnumShared = numShared;

  if (notSet) {
    for (int i=0; i<maxNeighbors; i++) {
       for (int j=0; j<maxShared; j++) {
	maxDOFsSharedArray[j] = 0;
	maxSharedB[j] = 0;
	maxSharedA[j] = 0;
       }
       for (int j=0; j<numShared; j++) {
	 maxDOFsSharedArray[j] = myDOFsSharedArray[j];
	 maxSharedB[j] = sharedB[j];
	 maxSharedA[j] = sharedA[j];
       }
       MPI_Bcast(maxDOFsSharedArray, myNeighborsSizes[i],MPI_INT,i,MPI_COMM_WORLD);
       MPI_Bcast(maxSharedB, myNeighborsSizes[i],MPI_DOUBLE,i,MPI_COMM_WORLD);
       MPI_Bcast(maxSharedA, myNeighborsSizes[i],MPI_DOUBLE,i,MPI_COMM_WORLD);
       MPI_Barrier(MPI_COMM_WORLD);
      
       if ((i != processID ) && (myNeighbors[i]==1)) {
	 // cached neighbors
	 int* temp = ((theSOE->myActualNeighborsSharedDOFs).find(i)->second);
	 for (int k=0; k<theSOE->maxShared; k++)
	   temp[k] = maxDOFsSharedArray[k];

	 //	 int* data = new int[2*myNeighborsSizes[i]];
	 int* data = new int[myNeighborsSizes[i]];
	 theSOE->myActualNeighborsBsToSend[i]= new double[myNeighborsSizes[i]];
	 intersectionsAB(myDOFs, (theSOE->myActualNeighborsSharedDOFs).find(i)->second, size, myNeighborsSizes[i], A, maxSharedA, B, maxSharedB,data,i);
       }
    }
    //
    // solution step
    // case notset
    // direct solve using inverses of aii
    // so direct multiplication, ie ~ ten plus faster
    if(!isAfactored) {
      double invaii;
      for (int i=0; i<size; i++) {
	invaii = 1/A[i];
	X[i] = B[i]*invaii;
	A[i] = invaii;
      }
      notSet = false;
      theSOE->isAfactored = true;
    }
    return 0;
  }
  else {
    int ct =0;
    for (int i=0; i<maxNeighbors; i++) {
      if ((i != processID ) && (myNeighbors[i]==1)) {
	MPI_Irecv(((theSOE->myActualNeighborsSharedBs).find(i)->second), maxShared, MPI_DOUBLE, i, MPI_ANY_TAG, MPI_COMM_WORLD, &theRequests[ct++]);
      }
    }
    for (int i=0; i<maxNeighbors; i++) {
      if ((i != processID ) && (myNeighbors[i]==1)) {
	int upto = myNeighborsSizes[i];
	double* tmpptr = (theSOE->myActualNeighborsBsToSend).find(i)->second;
	int* tmpptr2 = (theSOE->myActualNeighborsSharedDOFs).find(i)->second;
	for (int jj=0; jj<upto; jj++) 
	  tmpptr[jj] = B[tmpptr2[jj]];
	//	  tmpptr[jj] = B[tmpptr2[2*jj]];

	//MPI_Send(tmpptr, upto, MPI_DOUBLE, i, i, MPI_COMM_WORLD);

	// gnp changing to isend
	//MPI_Isend(tmpptr, upto, MPI_DOUBLE, i, i, MPI_COMM_WORLD,&requests[ct++]);
      }
    }

    /////////////////////////gnp next change
    for (int i=0; i<maxNeighbors; i++) {
      if ((i != processID ) && (myNeighbors[i]==1)) {
	int upto = myNeighborsSizes[i];
	double* tmpptr = (theSOE->myActualNeighborsBsToSend).find(i)->second;
	MPI_Isend(tmpptr, upto, MPI_DOUBLE, i, i, MPI_COMM_WORLD, &theRequests[ct++]);
      }
    }
    /////////////////////////gnp next change ENDS
    
    MPI_Waitall(ct,theRequests,theStatuses);

    for (int i=0; i<maxNeighbors; i++) {
      if ((i != processID ) && (myNeighbors[i]==1)) {
	int* posloc = (theSOE->myActualNeighborsSharedDOFs).find(i)->second;
	double* dat =  (theSOE->myActualNeighborsSharedBs).find(i)->second;
	// update RHS
	for (int k =0; k<myNeighborsSizes[i]; k++) 
	  B[posloc[k]] += dat[k];
	//	  B[posloc[2*k]] += dat[k];
      }
    }
    // done updating RHS, solve step

    // general way
    // should be used in all cases but for datastar or bluegene ( essl library call )
    //
    for (int i=0; i<size; i++)
      *X++ = *B++ * *A++;
    //

    /// Link to ibm ESSL library in datastar or bluegene else uncomment above for loop 
    /// for general case and comment below call 
    //    dvem(size, B,1,A,1,X,1);
    
	delete []theRequests;
	delete []theStatuses;

    //if we get here we are done and return
    return 0;
  }
}

int
MPIDiagonalSolver::sendSelf(int cTag,
			       Channel &theChannel)
{
  return 0;
}


int 
MPIDiagonalSolver::recvSelf(int cTag,
			       Channel &theChannel, 
			       FEM_ObjectBroker &theBroker)
{
  return 0;
}


void
MPIDiagonalSolver::intersectionsAB(ID& arrayA, int* arrayB, int sizeA, int sizeB, double* A, double* sharedA, double* B, double* sharedB, int* storage, int neighbor_pid)
{

  /// Assumes a, b arrays are SORTED!!!!!!!!!!!!!!
  /// SO make sure you have sorted your dofs before calling this !!!
  /// shared array is equal to thesize of smallest of those two input arrays
  /// arrayA is my_rank dofs
  /// arrayB is the incoming rank's dofs
  /// A,B are my_rank SOE: A,b
  /// sharedA,sharedB are incoming rank's SOE A,b 
  int i =0;
  int j =0;
  int ct =0;
  if (notSet) {
    while ( (i<sizeA) && (j<sizeB) ) {
      if ( arrayA[i] == arrayB[j] ) {
	A[i]+= sharedA[j];
	B[i]+= sharedB[j];
	storage[ct++] = i;
	//	storage[2*ct] = i;
	//	storage[2*ct+1] = j;
	//	ct++;
	i++;
	j++;
      }
      else if (arrayA[i] > arrayB[j] ) {
	j++;
      }
      else {
	i++;
      }
    }
  }
  else {
    while ( (i<sizeA) && (j<sizeB) ) {
      if ( arrayA[i] == arrayB[j] ) {
	B[i]+= sharedB[j];
	i++;
	j++;
      }
      else if (arrayA[i] > arrayB[j] ) {
	j++;
      }
      else {
	i++;
      }
    }
  }
  /// so after the pass to intersectionsAB
  /// storage array contains : storage[i] for i in { 0,2,4,...} the locations on my rank pid that are to be updated from 
  /// the locations at storage[i] for i in {1,3,5,...} from the RHS i receive from myNeighbors[i]
  delete [] (theSOE->myActualNeighborsSharedDOFs).find(neighbor_pid)->second;
  (theSOE->myActualNeighborsSharedDOFs).find(neighbor_pid)->second =storage;
  theSOE->myNeighborsSizes[neighbor_pid]=ct;
}
