import pathlib
from typing import Any

import neighborly.plugins.talktown.occupation_types as tot_occupations
from neighborly.components.business import OccupationTypes
from neighborly.loaders import load_data_file
from neighborly.plugins.talktown import business_components
from neighborly.plugins.talktown.personality import (
    BigFivePersonality,
    BigFivePersonalityFactory,
)
from neighborly.plugins.talktown.school import SchoolSystem, Student
from neighborly.simulation import Neighborly, PluginInfo

plugin_info = PluginInfo(
    name="Talk of the Town",
    plugin_id="default.talktown",
    version="0.1.0",
)


def setup(sim: Neighborly, **kwargs: Any) -> None:
    sim.world.add_system(SchoolSystem())

    # Register student component for school system
    sim.register_component(Student)

    # Register Personality component
    sim.register_component(BigFivePersonality, factory=BigFivePersonalityFactory())

    # Register Business components
    sim.register_component(business_components.ApartmentComplex)
    sim.register_component(business_components.Bakery)
    sim.register_component(business_components.Bank)
    sim.register_component(business_components.Bar)
    sim.register_component(business_components.BarberShop)
    sim.register_component(business_components.BlacksmithShop)
    sim.register_component(business_components.Brewery)
    sim.register_component(business_components.BusDepot)
    sim.register_component(business_components.ButcherShop)
    sim.register_component(business_components.CandyStore)
    sim.register_component(business_components.CarpentryCompany)
    sim.register_component(business_components.Cemetery)
    sim.register_component(business_components.CityHall)
    sim.register_component(business_components.ClothingStore)
    sim.register_component(business_components.CoalMine)
    sim.register_component(business_components.ConstructionFirm)
    sim.register_component(business_components.Dairy)
    sim.register_component(business_components.DaycareCenter)
    sim.register_component(business_components.Deli)
    sim.register_component(business_components.DentistOffice)
    sim.register_component(business_components.DepartmentStore)
    sim.register_component(business_components.Diner)
    sim.register_component(business_components.Distillery)
    sim.register_component(business_components.DrugStore)
    sim.register_component(business_components.Farm)
    sim.register_component(business_components.FireStation)
    sim.register_component(business_components.Foundry)
    sim.register_component(business_components.FurnitureStore)
    sim.register_component(business_components.GeneralStore)
    sim.register_component(business_components.GroceryStore)
    sim.register_component(business_components.HardwareStore)
    sim.register_component(business_components.Hospital)
    sim.register_component(business_components.Hotel)
    sim.register_component(business_components.Inn)
    sim.register_component(business_components.InsuranceCompany)
    sim.register_component(business_components.JewelryShop)
    sim.register_component(business_components.LawFirm)
    sim.register_component(business_components.OptometryClinic)
    sim.register_component(business_components.PaintingCompany)
    sim.register_component(business_components.Park)
    sim.register_component(business_components.Pharmacy)
    sim.register_component(business_components.PlasticSurgeryClinic)
    sim.register_component(business_components.PlumbingCompany)
    sim.register_component(business_components.PoliceStation)
    sim.register_component(business_components.Quarry)
    sim.register_component(business_components.RealtyFirm)
    sim.register_component(business_components.Restaurant)
    sim.register_component(business_components.School)
    sim.register_component(business_components.ShoemakerShop)
    sim.register_component(business_components.Supermarket)
    sim.register_component(business_components.TailorShop)
    sim.register_component(business_components.TattooParlor)
    sim.register_component(business_components.Tavern)
    sim.register_component(business_components.TaxiDepot)
    sim.register_component(business_components.University)

    # Register OccupationTypes
    OccupationTypes.add(tot_occupations.apprentice)
    OccupationTypes.add(tot_occupations.architect)
    OccupationTypes.add(tot_occupations.baker)
    OccupationTypes.add(tot_occupations.banker)
    OccupationTypes.add(tot_occupations.bank_teller)
    OccupationTypes.add(tot_occupations.barber)
    OccupationTypes.add(tot_occupations.barkeeper)
    OccupationTypes.add(tot_occupations.bartender)
    OccupationTypes.add(tot_occupations.bottler)
    OccupationTypes.add(tot_occupations.blacksmith)
    OccupationTypes.add(tot_occupations.brewer)
    OccupationTypes.add(tot_occupations.bricklayer)
    OccupationTypes.add(tot_occupations.builder)
    OccupationTypes.add(tot_occupations.busboy)
    OccupationTypes.add(tot_occupations.bus_driver)
    OccupationTypes.add(tot_occupations.butcher)
    OccupationTypes.add(tot_occupations.carpenter)
    OccupationTypes.add(tot_occupations.cashier)
    OccupationTypes.add(tot_occupations.clothier)
    OccupationTypes.add(tot_occupations.concierge)
    OccupationTypes.add(tot_occupations.cook)
    OccupationTypes.add(tot_occupations.cooper)
    OccupationTypes.add(tot_occupations.daycare_provider)
    OccupationTypes.add(tot_occupations.dentist)
    OccupationTypes.add(tot_occupations.dishwasher)
    OccupationTypes.add(tot_occupations.distiller)
    OccupationTypes.add(tot_occupations.doctor)
    OccupationTypes.add(tot_occupations.dressmaker)
    OccupationTypes.add(tot_occupations.druggist)
    OccupationTypes.add(tot_occupations.engineer)
    OccupationTypes.add(tot_occupations.farmer)
    OccupationTypes.add(tot_occupations.farmhand)
    OccupationTypes.add(tot_occupations.fire_chief)
    OccupationTypes.add(tot_occupations.fire_fighter)
    OccupationTypes.add(tot_occupations.grocer)
    OccupationTypes.add(tot_occupations.groundskeeper)
    OccupationTypes.add(tot_occupations.hotel_maid)
    OccupationTypes.add(tot_occupations.inn_keeper)
    OccupationTypes.add(tot_occupations.insurance_agent)
    OccupationTypes.add(tot_occupations.janitor)
    OccupationTypes.add(tot_occupations.jeweler)
    OccupationTypes.add(tot_occupations.joiner)
    OccupationTypes.add(tot_occupations.laborer)
    OccupationTypes.add(tot_occupations.landlord)
    OccupationTypes.add(tot_occupations.lawyer)
    OccupationTypes.add(tot_occupations.manager)
    OccupationTypes.add(tot_occupations.miner)
    OccupationTypes.add(tot_occupations.milkman)
    OccupationTypes.add(tot_occupations.mayor)
    OccupationTypes.add(tot_occupations.molder)
    OccupationTypes.add(tot_occupations.mortician)
    OccupationTypes.add(tot_occupations.nurse)
    OccupationTypes.add(tot_occupations.optometrist)
    OccupationTypes.add(tot_occupations.owner)
    OccupationTypes.add(tot_occupations.painter)
    OccupationTypes.add(tot_occupations.pharmacist)
    OccupationTypes.add(tot_occupations.plasterer)
    OccupationTypes.add(tot_occupations.plastic_surgeon)
    OccupationTypes.add(tot_occupations.plumber)
    OccupationTypes.add(tot_occupations.police_chief)
    OccupationTypes.add(tot_occupations.police_officer)
    OccupationTypes.add(tot_occupations.principal)
    OccupationTypes.add(tot_occupations.professor)
    OccupationTypes.add(tot_occupations.proprietor)
    OccupationTypes.add(tot_occupations.puddler)
    OccupationTypes.add(tot_occupations.quarry_man)
    OccupationTypes.add(tot_occupations.realtor)
    OccupationTypes.add(tot_occupations.seamstress)
    OccupationTypes.add(tot_occupations.secretary)
    OccupationTypes.add(tot_occupations.stocker)
    OccupationTypes.add(tot_occupations.shoemaker)
    OccupationTypes.add(tot_occupations.stonecutter)
    OccupationTypes.add(tot_occupations.tailor)
    OccupationTypes.add(tot_occupations.tattoo_artist)
    OccupationTypes.add(tot_occupations.taxi_driver)
    OccupationTypes.add(tot_occupations.teacher)
    OccupationTypes.add(tot_occupations.turner)
    OccupationTypes.add(tot_occupations.waiter)
    OccupationTypes.add(tot_occupations.whitewasher)
    OccupationTypes.add(tot_occupations.woodworker)

    # Load remaining data from data file
    load_data_file(pathlib.Path(__file__).parent / "data.yaml")
