"""Generated client library for businessmessages version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from . import businessmessages_v1_messages as messages


class BusinessmessagesV1(base_api.BaseApiClient):
  """Generated client library for service businessmessages version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://businessmessages.googleapis.com/'
  MTLS_BASE_URL = u'https://businessmessages.mtls.googleapis.com/'

  _PACKAGE = u'businessmessages'
  _SCOPES = ['https://www.googleapis.com/auth/userinfo.email']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'BusinessmessagesV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new businessmessages handle."""
    url = url or self.BASE_URL
    super(BusinessmessagesV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.conversations_events = self.ConversationsEventsService(self)
    self.conversations_messages = self.ConversationsMessagesService(self)
    self.conversations_surveys = self.ConversationsSurveysService(self)
    self.conversations = self.ConversationsService(self)

  class ConversationsEventsService(base_api.BaseApiService):
    """Service class for the conversations_events resource."""

    _NAME = u'conversations_events'

    def __init__(self, client):
      super(BusinessmessagesV1.ConversationsEventsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an event in a conversation.

      Args:
        request: (BusinessmessagesConversationsEventsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BusinessMessagesEvent) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/conversations/{conversationsId}/events',
        http_method=u'POST',
        method_id=u'businessmessages.conversations.events.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'eventId'],
        relative_path=u'v1/{+parent}/events',
        request_field=u'businessMessagesEvent',
        request_type_name=u'BusinessmessagesConversationsEventsCreateRequest',
        response_type_name=u'BusinessMessagesEvent',
        supports_download=False,
    )

  class ConversationsMessagesService(base_api.BaseApiService):
    """Service class for the conversations_messages resource."""

    _NAME = u'conversations_messages'

    def __init__(self, client):
      super(BusinessmessagesV1.ConversationsMessagesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Sends a message from an agent to a user. If a conversation doesn't exist or an agent tries to send a message in a conversation that it isn't authorized to participate in, returns a `PERMISSION DENIED` error.

      Args:
        request: (BusinessmessagesConversationsMessagesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BusinessMessagesMessage) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/conversations/{conversationsId}/messages',
        http_method=u'POST',
        method_id=u'businessmessages.conversations.messages.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'forceFallback'],
        relative_path=u'v1/{+parent}/messages',
        request_field=u'businessMessagesMessage',
        request_type_name=u'BusinessmessagesConversationsMessagesCreateRequest',
        response_type_name=u'BusinessMessagesMessage',
        supports_download=False,
    )

  class ConversationsSurveysService(base_api.BaseApiService):
    """Service class for the conversations_surveys resource."""

    _NAME = u'conversations_surveys'

    def __init__(self, client):
      super(BusinessmessagesV1.ConversationsSurveysService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a customer satisfaction survey in a conversation. If an agent sends multiple surveys in the same conversation within 24 hours, surveys after the first return a `RESOURCE_EXHAUSTED` error. If the client doesn't support the survey feature, survey returns a `FAILED_PRECONDITION` error.

      Args:
        request: (BusinessmessagesConversationsSurveysCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BusinessMessagesSurvey) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/conversations/{conversationsId}/surveys',
        http_method=u'POST',
        method_id=u'businessmessages.conversations.surveys.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'surveyId'],
        relative_path=u'v1/{+parent}/surveys',
        request_field=u'businessMessagesSurvey',
        request_type_name=u'BusinessmessagesConversationsSurveysCreateRequest',
        response_type_name=u'BusinessMessagesSurvey',
        supports_download=False,
    )

  class ConversationsService(base_api.BaseApiService):
    """Service class for the conversations resource."""

    _NAME = u'conversations'

    def __init__(self, client):
      super(BusinessmessagesV1.ConversationsService, self).__init__(client)
      self._upload_configs = {
          }
