/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"0896b22af1": function _(s,t,e,i,o){i();const c=(0,s("tslib").__importStar)(s("3c0c5c52d0"));e.HighChartsExtensions=c;(0,s("@bokehjs/base").register_models)(c)},
"3c0c5c52d0": function _(a,h,i,t,g){t(),g("HighChart",a("df31ad65ef").HighChart),g("HighStock",a("60e97661a4").HighStock),g("HighMap",a("6d1e48a659").HighMap),g("HighGantt",a("dd1f1d4ad4").HighGantt)},
"df31ad65ef": function _(h,t,i,a,e){a();const _=h("f43d669328");class r extends _.HighBaseView{create_chart(h,t,i){return h.Highcharts.chart(t,i)}}i.HighChartView=r,r.__name__="HighChartView";class s extends _.HighBase{static init_HighChart(){this.prototype.default_view=r}}i.HighChart=s,s.__name__="HighChart",s.__module__="panel_highcharts.models.highchart",s.init_HighChart()},
"f43d669328": function _(e,t,n,i,s){i();const o=e("@bokehjs/models/layouts/html_box");class r extends o.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.config.change,this.render),this.connect(this.model.properties.config_update.change,this._handle_config_update_change),this.connect(this.model.properties._add_series.change,this._add_series)}render(){super.render(),this.chart&&this.chart.destroy();const e=window;if(e.Highcharts){const t=this._clean_config(this.model.config);this.chart=this.create_chart(e,this.el,t)}else console.error("HighCharts .js is not loaded. Could not create chart")}create_chart(e,t,n){return e.Highcharts.stockChart(t,n)}after_layout(){super.after_layout(),this._resize()}_resize(){this.chart&&this.chart.reflow()}_add_series(){if(this.chart){const e=this.model._add_series;e.options=this._clean_config(e.options),this.chart.addSeries(e.options,e.redraw,e.animation)}}_handle_config_update_change(){const e=this._clean_config(this.model.config_update);this.chart.update(e)}_clean_config(e){return c(e,this.model),e}}n.HighBaseView=r,r.__name__="HighBaseView";class a extends o.HTMLBox{constructor(e){super(e)}static init_HighBase(){this.prototype.default_view=r,this.define((({Any:e})=>({config:[e],config_update:[e],event:[e],_add_series:[e]}))),this.override({height:400,width:600})}}function c(e,t){if(null===e)return e;for(var n=0;n<Object.keys(e).length;n++){const i=Object.keys(e)[n],s=e[i];if("object"==typeof s)c(s,t);else if("string"==typeof s&&""!==s)if("@"===s[0].charAt(0)){const n=s.slice(1,s.length);e[i]=e=>h(e,t,n)}else if(s.startsWith("function")&&s.indexOf("{")>-1&&s.lastIndexOf("}")>-1){const t=s.indexOf("{"),n=s.lastIndexOf("}"),o=s.slice(t+1,n);try{e[i]=new Function(o)}catch(t){e[i]=null,console.log("Could not set key '"+i+"' to function '"+o+"'. ",t)}}}}function h(e,t,n=null){const i=function(e,t=null){const n={};null!==t&&""!==t&&(n.channel=t);return n.type=e.type,d(e,n),n}(e,n);i.uuid="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(e){var t=16*Math.random()|0;return("x"==e?t:3&t|8).toString(16)})),t.event=i}function d(e,t){e.hasOwnProperty("index")&&void 0!==e.index&&(t.index=e.index),e.hasOwnProperty("name")&&void 0!==e.name&&(t.name=e.name),e.hasOwnProperty("x")&&void 0!==e.x&&(t.x=e.x),e.hasOwnProperty("y")&&void 0!==e.y&&(t.y=e.y),e.hasOwnProperty("target")&&(t.target={},d(e.target,t.target)),e.hasOwnProperty("series")&&(t.series={},d(e.series,t.series)),e.hasOwnProperty("point")&&(t.point={},d(e.point,t.point))}n.HighBase=a,a.__name__="HighBase",a.__module__="panel_highcharts.models.highbase",a.init_HighBase()},
"60e97661a4": function _(t,i,e,h,_){h();const c=t("f43d669328");class s extends c.HighBaseView{create_chart(t,i,e){return t.Highcharts.stockChart(i,e)}}e.HighStockView=s,s.__name__="HighStockView";class a extends c.HighBase{static init_HighStock(){this.prototype.default_view=s}}e.HighStock=a,a.__name__="HighStock",a.__module__="panel_highcharts.models.highstock",a.init_HighStock()},
"6d1e48a659": function _(a,i,e,h,t){h();const _=a("f43d669328");class s extends _.HighBaseView{create_chart(a,i,e){return a.Highcharts.mapChart(i,e)}}e.HighMapView=s,s.__name__="HighMapView";class g extends _.HighBase{static init_HighMap(){this.prototype.default_view=s}}e.HighMap=g,g.__name__="HighMap",g.__module__="panel_highcharts.models.highmap",g.init_HighMap()},
"dd1f1d4ad4": function _(t,a,i,e,n){e();const h=t("f43d669328");class _ extends h.HighBaseView{create_chart(t,a,i){return t.Highcharts.ganttChart(a,i)}}i.HighGanttView=_,_.__name__="HighGanttView";class s extends h.HighBase{static init_HighGantt(){this.prototype.default_view=_}}i.HighGantt=s,s.__name__="HighGantt",s.__module__="panel_highcharts.models.highgantt",s.init_HighGantt()},
}, "0896b22af1", {"index":"0896b22af1","models/index":"3c0c5c52d0","models/highchart":"df31ad65ef","models/highbase":"f43d669328","models/highstock":"60e97661a4","models/highmap":"6d1e48a659","models/highgantt":"dd1f1d4ad4"}, {});});
