# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ansible-keyring', 'ansible-keyring.cli']

package_data = \
{'': ['*']}

install_requires = \
['keyring>=23.5.0,<24.0.0', 'passlib>=1.7.4,<2.0.0']

extras_require = \
{'recommended': ['aiohttp>=3.7.4,<4.0.0',
                 'arrow>=1.1.1,<2.0.0',
                 'better-exceptions>=0.3.3,<0.4.0',
                 'celery>=5.1.2,<6.0.0',
                 'click>=8.0.3,<9.0.0',
                 'fire>=0.4.0,<0.5.0',
                 'furl>=2.1.2,<3.0.0',
                 'requests>=2.26.0,<3.0.0',
                 'rich>=10.9.0,<11.0.0',
                 'schedule>=1.1.0,<2.0.0',
                 'schema>=0.7.4,<0.8.0',
                 'sh>=1.14.2,<2.0.0',
                 'sphinx>=4.1.2,<5.0.0',
                 'sphinx-press-theme>=0.8.0,<0.9.0'],
 'semantic': ['pip>=21.3.0,<22.0.0',
              'setuptools>=58.2.0,<59.0.0',
              'twine>=3.8.0,<4.0.0',
              'wheel>=0.37.1,<0.38.0']}

entry_points = \
{'console_scripts': ['ansible-local = ansible-keyring.cli.ansible_local:main',
                     'ansible-mkpasswd = '
                     'ansible-keyring.cli.ansible_mkpasswd:main',
                     'ansible-vault-helper = '
                     'ansible-keyring.cli.ansible_vault_helper:main',
                     'vaultify = ansible-keyring.cli.vaultify:main']}

setup_kwargs = {
    'name': 'ansible-keyring',
    'version': '1.2.7',
    'description': 'A CLI that extends ansible, ansible-playbook, and ansible-vault to use the system keyring for vault passwords',
    'long_description': '<!-- ⚠️ This README has been generated from the file(s) ".config/docs/blueprint-readme-cli.md" ⚠️--><div align="center">\n  <center>\n    <a href="https://github.com/ProfessorManhattan/ansible-keyring">\n      <img width="148" height="148" alt="Ansible Keyring logo" src="https://gitlab.com/megabyte-labs/python/cli/ansible-keyring/-/raw/master/logo.png" />\n    </a>\n  </center>\n</div>\n<div align="center">\n  <center><h1 align="center">Python CLI: Ansible Keyring - A System Keyring Integration CLI<i></i></h1></center>\n  <center><h4 style="color: #18c3d1;">A Python CLI created by <a href="https://megabyte.space" target="_blank">Megabyte Labs</a></h4><i></i></center>\n</div>\n\n<div align="center">\n  <a href="https://megabyte.space" title="Megabyte Labs homepage" target="_blank">\n    <img alt="Homepage" src="https://img.shields.io/website?down_color=%23FF4136&down_message=Down&label=Homepage&logo=home-assistant&logoColor=white&up_color=%232ECC40&up_message=Up&url=https%3A%2F%2Fmegabyte.space&style=for-the-badge" />\n  </a>\n  <a href="https://github.com/ProfessorManhattan/ansible-keyring/blob/master/docs/CONTRIBUTING.md" title="Learn about contributing" target="_blank">\n    <img alt="Contributing" src="https://img.shields.io/badge/Contributing-Guide-0074D9?logo=github-sponsors&logoColor=white&style=for-the-badge" />\n  </a>\n  <a href="https://app.slack.com/client/T01ABCG4NK1/C01NN74H0LW/details/" title="Chat with us on Slack" target="_blank">\n    <img alt="Slack" src="https://img.shields.io/badge/Slack-Chat-e01e5a?logo=slack&logoColor=white&style=for-the-badge" />\n  </a>\n  <a href="https://github.com/ProfessorManhattan/ansible-keyring" title="GitHub mirror" target="_blank">\n    <img alt="GitHub" src="https://img.shields.io/badge/Mirror-GitHub-333333?logo=github&style=for-the-badge" />\n  </a>\n  <a href="https://gitlab.com/megabyte-labs/python/cli/ansible-keyring" title="GitLab repository" target="_blank">\n    <img alt="GitLab" src="https://img.shields.io/badge/Repo-GitLab-fc6d26?logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgAQMAAABJtOi3AAAABlBMVEUAAAD///+l2Z/dAAAAAXRSTlMAQObYZgAAAHJJREFUCNdNxKENwzAQQNEfWU1ZPUF1cxR5lYxQqQMkLEsUdIxCM7PMkMgLGB6wopxkYvAeI0xdHkqXgCLL0Beiqy2CmUIdeYs+WioqVF9C6/RlZvblRNZD8etRuKe843KKkBPw2azX13r+rdvPctEaFi4NVzAN2FhJMQAAAABJRU5ErkJggg==&style=for-the-badge" />\n  </a>\n</div>\n<br/>\n<div align="center">\n  <a title="Version: 1.2.7" href="https://github.com/ProfessorManhattan/ansible-keyring" target="_blank">\n    <img alt="Version: 1.2.7" src="https://img.shields.io/badge/version-1.2.7-blue.svg?logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgAQMAAABJtOi3AAAABlBMVEUAAAD///+l2Z/dAAAAAXRSTlMAQObYZgAAACNJREFUCNdjIACY//+BEp9hhM3hAzYQwoBIAqEDYQrCZLwAAGlFKxU1nF9cAAAAAElFTkSuQmCC&cacheSeconds=2592000&style=flat-square" />\n  </a>\n  <a title="Build status on GitLab" href="https://gitlab.com/megabyte-labs/python/cli/ansible-keyring/-/commits/master" target="_blank">\n    <img alt="GitLab build status" src="https://img.shields.io/gitlab/pipeline-status/megabyte-labs/python/cli/ansible-keyring?branch=master&label=build&logo=gitlab&style=flat-square">\n  </a>\n  <a title="Test coverage report" href="https://gitlab.com/megabyte-labs/python/cli/ansible-keyring/-/commits/master" target="_blank">\n    <img alt="Coverage status" src="https://img.shields.io/gitlab/coverage/megabyte-labs/python/cli/ansible-keyring/master/?label=coverage&logo=pytest&style=flat-square">\n  </a>\n  <a title="Documentation" href="https://megabyte.space/docs/python" target="_blank">\n    <img alt="Documentation" src="https://img.shields.io/badge/documentation-yes-brightgreen.svg?logo=readthedocs&style=flat-square" />\n  </a>\n  <a title="Supported Python versions" href="https://pypi.org/project/{{(if customPyPiPackageName customPyPiPackageName (append repository.prefix.github slug))}}/" target="_blank">\n    <img alt="Python versions" src="https://img.shields.io/pypi/pyversions/{{(if customPyPiPackageName customPyPiPackageName (append repository.prefix.github slug))}}/?label=python&logo=python&style=flat-square">\n  </a>\n  <a title="PyPi status" href="https://pypi.org/project/{{(if customPyPiPackageName customPyPiPackageName (append repository.prefix.github slug))}}/" target="_blank">\n    <img alt="Status" src="https://img.shields.io/pypi/status/{{(if customPyPiPackageName customPyPiPackageName (append repository.prefix.github slug))}}/?label=status&logo=pypi&style=flat-square">\n  </a>\n  <a title="License: MIT" href="https://github.com/ProfessorManhattan/ansible-keyring/blob/master/LICENSE" target="_blank">\n    <img alt="License: MIT" src="https://img.shields.io/badge/license-MIT-yellow.svg?logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgAQMAAABJtOi3AAAABlBMVEUAAAD///+l2Z/dAAAAAXRSTlMAQObYZgAAAHpJREFUCNdjYOD/wMDAUP+PgYHxhzwDA/MB5gMM7AwMDxj4GBgKGGQYGCyAEEgbMDDwAAWAwmk8958xpIOI5zKH2RmOyhxmZjguAiKmgIgtQOIYmFgCIp4AlaQ9OczGkJYCJEAGgI0CGwo2HmwR2Eqw5SBnNIAdBHYaAJb6KLM15W/CAAAAAElFTkSuQmCC&style=flat-square" />\n  </a>\n</div>\n\n> </br><h4 align="center">**subheader_description**</h4></br>\n\n<!--TERMINALIZE![terminalizer_title](repository.group.python_cli/ansible-keyring* **github**: /raw/master/docs/demo.gif\n* **gitlab**: /-/raw/master/docs/demo.gif)TERMINALIZE-->\n\n<a href="#table-of-contents" style="width:100%"><img style="width:100%" src="https://gitlab.com/megabyte-labs/assets/-/raw/master/png/aqua-divider.png" /></a>\n\n## Table of Contents\n\n- [Overview](#overview)\n- [Installation](#installation)\n  - [PyPi](#pypi)\n  - [Install Doctor](#install-doctor)\n  - [Homebrew](#homebrew)\n  - [Chocolatey](#chocolatey)\n  - [Binary Releases](#binary-releases)\n- [Requirements](#requirements)\n- [Contributing](#contributing)\n- [License](#license)\n\n<a href="#overview" style="width:100%"><img style="width:100%" src="https://gitlab.com/megabyte-labs/assets/-/raw/master/png/aqua-divider.png" /></a>\n\n## Overview\n\nThis repository is home to **[ansible-keyring](https://github.com/ProfessorManhattan/ansible-keyring)** a CLI that extends the `ansible`, `ansible-playbook`, and `ansible-vault` command to retrieve vault passwords from the system keyring. It is based on the work of [ansible-tools](https://pypi.org/project/ansible-tools/) with a couple usability improvements. The features it adds are:\n\n- Does not have to be run only in directories where `ansible.cfg` is present\n- New, shorter, more intuitive command aliases\n\n{{ load:docs/partials/guide.md }}\n\n<a href="#installation" style="width:100%"><img style="width:100%" src="https://gitlab.com/megabyte-labs/assets/-/raw/master/png/aqua-divider.png" /></a>\n\n## Installation\n\nTo accomodate everyone, this CLI can be installed using a variety of methods.\n\n### PyPi\n\nIf you already have Python 3 and pip3 installed, you can install the CLI by running:\n\n```shell\npip3 install {{(if customPyPiPackageName customPyPiPackageName (append repository.prefix.github slug))}}\n```\n\n### Install Doctor\n\nOn **macOS or Linux**, you can run:\n\n```shell\nbash -sS https://install.doctor/py/{{(if customPyPiPackageName customPyPiPackageName (append repository.prefix.github slug))}}\n```\n\nAnd on **Windows**, you can run:\n\n```powershell\nSet-ExecutionPolicy Bypass -Scope Process -Force; [System.Net.ServicePointManager]::SecurityProtocol = [System.Net.ServicePointManager]::SecurityProtocol -bor 3072; iex ((New-Object System.Net.WebClient).DownloadString(\'https://install.doctor/py/{{(if customPyPiPackageName customPyPiPackageName (append repository.prefix.github slug))}}?os=win\'))\n```\n\n### Homebrew\n\nIf you have [Homebrew](https://brew.sh/) installed, you can install the package by running:\n\n```shell\nbrew install installdoc/py/{{(if customPyPiPackageName customPyPiPackageName (append repository.prefix.github slug))}}\n```\n\nOr if you prefer to keep Python off your system, and install a binary, you can run:\n\n```shell\nbrew install installdoc/py/{{(if customPyPiPackageName customPyPiPackageName (append repository.prefix.github slug))}}-binary\n```\n\n### Chocolatey\n\nIf you are on Windows, you can install a binary version (without the Python dependency), using [Chocolatey](https://chocolatey.org/):\n\n```powershell\nchoco install {{(if customPyPiPackageName customPyPiPackageName (append repository.prefix.github slug))}}\n```\n\n### Binary Releases\n\nThere are also binaries (in various formats) available for download on both [GitHub](https://github.com/ProfessorManhattan/ansible-keyring/releases) and [GitLab](https://gitlab.com/megabyte-labs/python/cli/ansible-keyring/-/releases).\n\n<a href="#requirements" style="width:100%"><img style="width:100%" src="https://gitlab.com/megabyte-labs/assets/-/raw/master/png/aqua-divider.png" /></a>\n\n## Requirements\n\nTo run this project, all you need is [Python 3](https://www.python.org/) and [pip3](https://pip.pypa.io/en/stable/). See the [Installation section](#installation) for instructions that include alternate installation methods that do not require Python to be installed.\n\nIf you are interested in contributing or would like to make some modifications, please see the [CONTRIBUTING](/docs/CONTRIBUTING.md) guide. There are a handful of build tools we incorporate into the development process. All of them are installed automatically via our Taskfile system. You can get started customizing this project by running:\n\n```shell\nbash .config/scripts/start.sh\ntask start\ntask --list\n```\n\n<a href="#contributing" style="width:100%"><img style="width:100%" src="https://gitlab.com/megabyte-labs/assets/-/raw/master/png/aqua-divider.png" /></a>\n\n## Contributing\n\nContributions, issues, and feature requests are welcome! Feel free to check the [issues page](https://github.com/ProfessorManhattan/ansible-keyring/issues). If you would like to contribute, please take a look at the [contributing guide](https://github.com/ProfessorManhattan/ansible-keyring/blob/master/docs/CONTRIBUTING.md).\n\n<details>\n<summary><b>Sponsorship</b></summary>\n<br/>\n<blockquote>\n<br/>\nDear Awesome Person,<br/><br/>\nI create open source projects out of love. Although I have a job, shelter, and as much fast food as I can handle, it would still be pretty cool to be appreciated by the community for something I have spent a lot of time and money on. Please consider sponsoring me! Who knows? Maybe I will be able to quit my job and publish open source full time.\n<br/><br/>Sincerely,<br/><br/>\n\n**_Brian Zalewski_**<br/><br/>\n\n</blockquote>\n\n<a title="Support us on Open Collective" href="https://opencollective.com/megabytelabs" target="_blank">\n  <img alt="Open Collective sponsors" src="https://img.shields.io/opencollective/sponsors/megabytelabs?logo=opencollective&label=OpenCollective&logoColor=white&style=for-the-badge" />\n</a>\n<a title="Support us on GitHub" href="https://github.com/ProfessorManhattan" target="_blank">\n  <img alt="GitHub sponsors" src="https://img.shields.io/github/sponsors/ProfessorManhattan?label=GitHub%20sponsors&logo=github&style=for-the-badge" />\n</a>\n<a href="https://www.patreon.com/ProfessorManhattan" title="Support us on Patreon" target="_blank">\n  <img alt="Patreon" src="https://img.shields.io/badge/Patreon-Support-052d49?logo=patreon&logoColor=white&style=for-the-badge" />\n</a>\n\n</details>\n\n<a href="#license" style="width:100%"><img style="width:100%" src="https://gitlab.com/megabyte-labs/assets/-/raw/master/png/aqua-divider.png" /></a>\n\n## License\n\nCopyright © 2020-2021 [Megabyte LLC](https://megabyte.space). This project is [MIT](https://gitlab.com/megabyte-labs/python/cli/ansible-keyring/-/blob/master/LICENSE) licensed.\n',
    'author': 'Brian Zalewski',
    'author_email': 'brian@megabyte.space',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://megabyte.space',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.10.0,<3.11',
}


setup(**setup_kwargs)
