# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DomainMappingMetadata',
    'DomainMappingSpec',
    'DomainMappingStatus',
    'DomainMappingStatusCondition',
    'DomainMappingStatusResourceRecord',
    'IamBindingCondition',
    'IamMemberCondition',
    'ServiceMetadata',
    'ServiceStatus',
    'ServiceStatusCondition',
    'ServiceTemplate',
    'ServiceTemplateMetadata',
    'ServiceTemplateSpec',
    'ServiceTemplateSpecContainer',
    'ServiceTemplateSpecContainerEnv',
    'ServiceTemplateSpecContainerEnvFrom',
    'ServiceTemplateSpecContainerEnvFromConfigMapRef',
    'ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReference',
    'ServiceTemplateSpecContainerEnvFromSecretRef',
    'ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReference',
    'ServiceTemplateSpecContainerPort',
    'ServiceTemplateSpecContainerResources',
    'ServiceTraffic',
    'GetServiceMetadataResult',
    'GetServiceStatusResult',
    'GetServiceStatusConditionResult',
    'GetServiceTemplateResult',
    'GetServiceTemplateMetadataResult',
    'GetServiceTemplateSpecResult',
    'GetServiceTemplateSpecContainerResult',
    'GetServiceTemplateSpecContainerEnvResult',
    'GetServiceTemplateSpecContainerEnvFromResult',
    'GetServiceTemplateSpecContainerEnvFromConfigMapRefResult',
    'GetServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceResult',
    'GetServiceTemplateSpecContainerEnvFromSecretRefResult',
    'GetServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceResult',
    'GetServiceTemplateSpecContainerPortResult',
    'GetServiceTemplateSpecContainerResourceResult',
    'GetServiceTrafficResult',
]

@pulumi.output_type
class DomainMappingMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceVersion":
            suggest = "resource_version"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMappingMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMappingMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMappingMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: str,
                 annotations: Optional[Mapping[str, str]] = None,
                 generation: Optional[int] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 resource_version: Optional[str] = None,
                 self_link: Optional[str] = None,
                 uid: Optional[str] = None):
        """
        :param str namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number.
        :param Mapping[str, str] annotations: Annotations is a key value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata. More
               info: http://kubernetes.io/docs/user-guide/annotations
               **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
               If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
               or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        :param int generation: -
               A sequence number representing a specific generation of the desired state.
        :param Mapping[str, str] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects. May match selectors of replication controllers
               and routes.
               More info: http://kubernetes.io/docs/user-guide/labels
        :param str resource_version: -
               An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
               More info:
               https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        :param str self_link: -
               SelfLink is a URL representing this object.
        :param str uid: -
               UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
               More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        pulumi.set(__self__, "namespace", namespace)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        """
        Annotations is a key value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata. More
        info: http://kubernetes.io/docs/user-guide/annotations
        **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
        If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
        or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        -
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.
        More info: http://kubernetes.io/docs/user-guide/labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[str]:
        """
        -
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[str]:
        """
        -
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def uid(self) -> Optional[str]:
        """
        -
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class DomainMappingSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routeName":
            suggest = "route_name"
        elif key == "certificateMode":
            suggest = "certificate_mode"
        elif key == "forceOverride":
            suggest = "force_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMappingSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMappingSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMappingSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 route_name: str,
                 certificate_mode: Optional[str] = None,
                 force_override: Optional[bool] = None):
        """
        :param str route_name: The name of the Cloud Run Service that this DomainMapping applies to.
               The route must exist.
        :param str certificate_mode: The mode of the certificate.
               Default value is `AUTOMATIC`.
               Possible values are `NONE` and `AUTOMATIC`.
        :param bool force_override: If set, the mapping will override any mapping set before this spec was set.
               It is recommended that the user leaves this empty to receive an error
               warning about a potential conflict and only set it once the respective UI
               has given such a warning.
        """
        pulumi.set(__self__, "route_name", route_name)
        if certificate_mode is not None:
            pulumi.set(__self__, "certificate_mode", certificate_mode)
        if force_override is not None:
            pulumi.set(__self__, "force_override", force_override)

    @property
    @pulumi.getter(name="routeName")
    def route_name(self) -> str:
        """
        The name of the Cloud Run Service that this DomainMapping applies to.
        The route must exist.
        """
        return pulumi.get(self, "route_name")

    @property
    @pulumi.getter(name="certificateMode")
    def certificate_mode(self) -> Optional[str]:
        """
        The mode of the certificate.
        Default value is `AUTOMATIC`.
        Possible values are `NONE` and `AUTOMATIC`.
        """
        return pulumi.get(self, "certificate_mode")

    @property
    @pulumi.getter(name="forceOverride")
    def force_override(self) -> Optional[bool]:
        """
        If set, the mapping will override any mapping set before this spec was set.
        It is recommended that the user leaves this empty to receive an error
        warning about a potential conflict and only set it once the respective UI
        has given such a warning.
        """
        return pulumi.get(self, "force_override")


@pulumi.output_type
class DomainMappingStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mappedRouteName":
            suggest = "mapped_route_name"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "resourceRecords":
            suggest = "resource_records"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMappingStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMappingStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMappingStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.DomainMappingStatusCondition']] = None,
                 mapped_route_name: Optional[str] = None,
                 observed_generation: Optional[int] = None,
                 resource_records: Optional[Sequence['outputs.DomainMappingStatusResourceRecord']] = None):
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if mapped_route_name is not None:
            pulumi.set(__self__, "mapped_route_name", mapped_route_name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if resource_records is not None:
            pulumi.set(__self__, "resource_records", resource_records)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DomainMappingStatusCondition']]:
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="mappedRouteName")
    def mapped_route_name(self) -> Optional[str]:
        return pulumi.get(self, "mapped_route_name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="resourceRecords")
    def resource_records(self) -> Optional[Sequence['outputs.DomainMappingStatusResourceRecord']]:
        return pulumi.get(self, "resource_records")


@pulumi.output_type
class DomainMappingStatusCondition(dict):
    def __init__(__self__, *,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class DomainMappingStatusResourceRecord(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 rrdata: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: Name should be a verified domain
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rrdata is not None:
            pulumi.set(__self__, "rrdata", rrdata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name should be a verified domain
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rrdata(self) -> Optional[str]:
        return pulumi.get(self, "rrdata")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class IamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class IamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ServiceMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceVersion":
            suggest = "resource_version"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, str]] = None,
                 generation: Optional[int] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 namespace: Optional[str] = None,
                 resource_version: Optional[str] = None,
                 self_link: Optional[str] = None,
                 uid: Optional[str] = None):
        """
        :param Mapping[str, str] annotations: Annotations is a key value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata. More
               info: http://kubernetes.io/docs/user-guide/annotations
               **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
               If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
               or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
               Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
               - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
               for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
        :param int generation: -
               A sequence number representing a specific generation of the desired state.
        :param Mapping[str, str] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects. May match selectors of replication controllers
               and routes.
               More info: http://kubernetes.io/docs/user-guide/labels
        :param str namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number.
        :param str resource_version: -
               An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
               More info:
               https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        :param str self_link: -
               SelfLink is a URL representing this object.
        :param str uid: -
               UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
               More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        """
        Annotations is a key value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata. More
        info: http://kubernetes.io/docs/user-guide/annotations
        **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
        If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
        or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
        - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
        for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        -
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.
        More info: http://kubernetes.io/docs/user-guide/labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[str]:
        """
        -
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[str]:
        """
        -
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def uid(self) -> Optional[str]:
        """
        -
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ServiceStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestCreatedRevisionName":
            suggest = "latest_created_revision_name"
        elif key == "latestReadyRevisionName":
            suggest = "latest_ready_revision_name"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.ServiceStatusCondition']] = None,
                 latest_created_revision_name: Optional[str] = None,
                 latest_ready_revision_name: Optional[str] = None,
                 observed_generation: Optional[int] = None,
                 url: Optional[str] = None):
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if latest_created_revision_name is not None:
            pulumi.set(__self__, "latest_created_revision_name", latest_created_revision_name)
        if latest_ready_revision_name is not None:
            pulumi.set(__self__, "latest_ready_revision_name", latest_ready_revision_name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.ServiceStatusCondition']]:
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="latestCreatedRevisionName")
    def latest_created_revision_name(self) -> Optional[str]:
        return pulumi.get(self, "latest_created_revision_name")

    @property
    @pulumi.getter(name="latestReadyRevisionName")
    def latest_ready_revision_name(self) -> Optional[str]:
        return pulumi.get(self, "latest_ready_revision_name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceStatusCondition(dict):
    def __init__(__self__, *,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceTemplate(dict):
    def __init__(__self__, *,
                 metadata: Optional['outputs.ServiceTemplateMetadata'] = None,
                 spec: Optional['outputs.ServiceTemplateSpec'] = None):
        """
        :param 'ServiceTemplateMetadataArgs' metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param 'ServiceTemplateSpecArgs' spec: RevisionSpec holds the desired state of the Revision (from the client).
               Structure is documented below.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.ServiceTemplateMetadata']:
        """
        Metadata associated with this Service, including name, namespace, labels,
        and annotations.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ServiceTemplateSpec']:
        """
        RevisionSpec holds the desired state of the Revision (from the client).
        Structure is documented below.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class ServiceTemplateMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceVersion":
            suggest = "resource_version"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, str]] = None,
                 generation: Optional[int] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None,
                 resource_version: Optional[str] = None,
                 self_link: Optional[str] = None,
                 uid: Optional[str] = None):
        """
        :param Mapping[str, str] annotations: Annotations is a key value map stored with a resource that
               may be set by external tools to store and retrieve arbitrary metadata. More
               info: http://kubernetes.io/docs/user-guide/annotations
               **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
               If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
               or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
               Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
               - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
               for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
        :param int generation: -
               A sequence number representing a specific generation of the desired state.
        :param Mapping[str, str] labels: Map of string keys and values that can be used to organize and categorize
               (scope and select) objects. May match selectors of replication controllers
               and routes.
               More info: http://kubernetes.io/docs/user-guide/labels
        :param str name: Name of the port.
        :param str namespace: In Cloud Run the namespace must be equal to either the
               project ID or project number.
        :param str resource_version: -
               An opaque value that represents the internal version of this object that
               can be used by clients to determine when objects have changed. May be used
               for optimistic concurrency, change detection, and the watch operation on a
               resource or set of resources. They may only be valid for a
               particular resource or set of resources.
               More info:
               https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        :param str self_link: -
               SelfLink is a URL representing this object.
        :param str uid: -
               UID is a unique id generated by the server on successful creation of a resource and is not
               allowed to change on PUT operations.
               More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        """
        Annotations is a key value map stored with a resource that
        may be set by external tools to store and retrieve arbitrary metadata. More
        info: http://kubernetes.io/docs/user-guide/annotations
        **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
        If the provider plan shows a diff where a server-side annotation is added, you can add it to your config
        or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
        Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
        - `run.googleapis.com/ingress` sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
        for the Service. For example, `"run.googleapis.com/ingress" = "all"`.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def generation(self) -> Optional[int]:
        """
        -
        A sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers
        and routes.
        More info: http://kubernetes.io/docs/user-guide/labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the port.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        In Cloud Run the namespace must be equal to either the
        project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[str]:
        """
        -
        An opaque value that represents the internal version of this object that
        can be used by clients to determine when objects have changed. May be used
        for optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. They may only be valid for a
        particular resource or set of resources.
        More info:
        https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[str]:
        """
        -
        SelfLink is a URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def uid(self) -> Optional[str]:
        """
        -
        UID is a unique id generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ServiceTemplateSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerConcurrency":
            suggest = "container_concurrency"
        elif key == "serviceAccountName":
            suggest = "service_account_name"
        elif key == "servingState":
            suggest = "serving_state"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_concurrency: Optional[int] = None,
                 containers: Optional[Sequence['outputs.ServiceTemplateSpecContainer']] = None,
                 service_account_name: Optional[str] = None,
                 serving_state: Optional[str] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int container_concurrency: ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
               requests per container of the Revision. Values are:
        :param Sequence['ServiceTemplateSpecContainerArgs'] containers: Container defines the unit of execution for this Revision.
               In the context of a Revision, we disallow a number of the fields of
               this Container, including: name, ports, and volumeMounts.
               The runtime contract is documented here:
               https://github.com/knative/serving/blob/master/docs/runtime-contract.md
               Structure is documented below.
        :param str service_account_name: Email address of the IAM service account associated with the revision of the
               service. The service account represents the identity of the running revision,
               and determines what permissions the revision has. If not provided, the revision
               will use the project's default service account.
        :param str serving_state: -
               ServingState holds a value describing the state the resources
               are in for this Revision.
               It is expected
               that the system will manipulate this based on routability and load.
        :param int timeout_seconds: TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
        """
        if container_concurrency is not None:
            pulumi.set(__self__, "container_concurrency", container_concurrency)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if serving_state is not None:
            pulumi.set(__self__, "serving_state", serving_state)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="containerConcurrency")
    def container_concurrency(self) -> Optional[int]:
        """
        ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
        requests per container of the Revision. Values are:
        """
        return pulumi.get(self, "container_concurrency")

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainer']]:
        """
        Container defines the unit of execution for this Revision.
        In the context of a Revision, we disallow a number of the fields of
        this Container, including: name, ports, and volumeMounts.
        The runtime contract is documented here:
        https://github.com/knative/serving/blob/master/docs/runtime-contract.md
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[str]:
        """
        Email address of the IAM service account associated with the revision of the
        service. The service account represents the identity of the running revision,
        and determines what permissions the revision has. If not provided, the revision
        will use the project's default service account.
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="servingState")
    def serving_state(self) -> Optional[str]:
        """
        -
        ServingState holds a value describing the state the resources
        are in for this Revision.
        It is expected
        that the system will manipulate this based on routability and load.
        """
        return pulumi.get(self, "serving_state")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ServiceTemplateSpecContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envFroms":
            suggest = "env_froms"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None,
                 env_froms: Optional[Sequence['outputs.ServiceTemplateSpecContainerEnvFrom']] = None,
                 envs: Optional[Sequence['outputs.ServiceTemplateSpecContainerEnv']] = None,
                 ports: Optional[Sequence['outputs.ServiceTemplateSpecContainerPort']] = None,
                 resources: Optional['outputs.ServiceTemplateSpecContainerResources'] = None,
                 working_dir: Optional[str] = None):
        """
        :param str image: Docker image name. This is most often a reference to a container located
               in the container registry, such as gcr.io/cloudrun/hello
               More info: https://kubernetes.io/docs/concepts/containers/images
        :param Sequence[str] args: Arguments to the entrypoint.
               The docker image's CMD is used if this is not provided.
               Variable references $(VAR_NAME) are expanded using the container's
               environment. If a variable cannot be resolved, the reference in the input
               string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
               double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
               regardless of whether the variable exists or not.
               More info:
               https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[str] commands: Entrypoint array. Not executed within a shell.
               The docker image's ENTRYPOINT is used if this is not provided.
               Variable references $(VAR_NAME) are expanded using the container's
               environment. If a variable cannot be resolved, the reference in the input
               string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
               double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
               regardless of whether the variable exists or not.
               More info:
               https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['ServiceTemplateSpecContainerEnvFromArgs'] env_froms: -
               (Optional, Deprecated)
               List of sources to populate environment variables in the container.
               All invalid keys will be reported as an event when the container is starting.
               When a key exists in multiple sources, the value associated with the last source will
               take precedence. Values defined by an Env with a duplicate key will take
               precedence.
               Structure is documented below.
        :param Sequence['ServiceTemplateSpecContainerEnvArgs'] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param Sequence['ServiceTemplateSpecContainerPortArgs'] ports: List of open ports in the container.
               More Info:
               https://cloud.google.com/run/docs/reference/rest/v1/RevisionSpec#ContainerPort
               Structure is documented below.
        :param 'ServiceTemplateSpecContainerResourcesArgs' resources: Compute Resources required by this container. Used to set values such as max memory
               More info:
               https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#requests-and-limits
               Structure is documented below.
        :param str working_dir: -
               (Optional, Deprecated)
               Container's working directory.
               If not specified, the container runtime's default will be used, which
               might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if env_froms is not None:
            pulumi.set(__self__, "env_froms", env_froms)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Docker image name. This is most often a reference to a container located
        in the container registry, such as gcr.io/cloudrun/hello
        More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Arguments to the entrypoint.
        The docker image's CMD is used if this is not provided.
        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.
        More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        Entrypoint array. Not executed within a shell.
        The docker image's ENTRYPOINT is used if this is not provided.
        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.
        More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="envFroms")
    def env_froms(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainerEnvFrom']]:
        """
        -
        (Optional, Deprecated)
        List of sources to populate environment variables in the container.
        All invalid keys will be reported as an event when the container is starting.
        When a key exists in multiple sources, the value associated with the last source will
        take precedence. Values defined by an Env with a duplicate key will take
        precedence.
        Structure is documented below.
        """
        return pulumi.get(self, "env_froms")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainerEnv']]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ServiceTemplateSpecContainerPort']]:
        """
        List of open ports in the container.
        More Info:
        https://cloud.google.com/run/docs/reference/rest/v1/RevisionSpec#ContainerPort
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ServiceTemplateSpecContainerResources']:
        """
        Compute Resources required by this container. Used to set values such as max memory
        More info:
        https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#requests-and-limits
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[str]:
        """
        -
        (Optional, Deprecated)
        Container's working directory.
        If not specified, the container runtime's default will be used, which
        might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ServiceTemplateSpecContainerEnv(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: Name of the port.
        :param str value: Variable references $(VAR_NAME) are expanded
               using the previous defined environment variables in the container and
               any route environment variables. If a variable cannot be resolved,
               the reference in the input string will be unchanged. The $(VAR_NAME)
               syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
               references will never be expanded, regardless of whether the variable
               exists or not.
               Defaults to "".
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the port.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Variable references $(VAR_NAME) are expanded
        using the previous defined environment variables in the container and
        any route environment variables. If a variable cannot be resolved,
        the reference in the input string will be unchanged. The $(VAR_NAME)
        syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
        references will never be expanded, regardless of whether the variable
        exists or not.
        Defaults to "".
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapRef":
            suggest = "config_map_ref"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerEnvFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerEnvFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerEnvFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_ref: Optional['outputs.ServiceTemplateSpecContainerEnvFromConfigMapRef'] = None,
                 prefix: Optional[str] = None,
                 secret_ref: Optional['outputs.ServiceTemplateSpecContainerEnvFromSecretRef'] = None):
        """
        :param 'ServiceTemplateSpecContainerEnvFromConfigMapRefArgs' config_map_ref: The ConfigMap to select from.
               Structure is documented below.
        :param str prefix: An optional identifier to prepend to each key in the ConfigMap.
        :param 'ServiceTemplateSpecContainerEnvFromSecretRefArgs' secret_ref: The Secret to select from.
               Structure is documented below.
        """
        if config_map_ref is not None:
            pulumi.set(__self__, "config_map_ref", config_map_ref)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> Optional['outputs.ServiceTemplateSpecContainerEnvFromConfigMapRef']:
        """
        The ConfigMap to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "config_map_ref")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        An optional identifier to prepend to each key in the ConfigMap.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.ServiceTemplateSpecContainerEnvFromSecretRef']:
        """
        The Secret to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvFromConfigMapRef(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerEnvFromConfigMapRef. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerEnvFromConfigMapRef.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerEnvFromConfigMapRef.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_object_reference: Optional['outputs.ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReference'] = None,
                 optional: Optional[bool] = None):
        """
        :param 'ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceArgs' local_object_reference: The Secret to select from.
               Structure is documented below.
        :param bool optional: Specify whether the Secret must be defined
        """
        if local_object_reference is not None:
            pulumi.set(__self__, "local_object_reference", local_object_reference)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> Optional['outputs.ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReference']:
        """
        The Secret to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def optional(self) -> Optional[bool]:
        """
        Specify whether the Secret must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReference(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Name of the port.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the port.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvFromSecretRef(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerEnvFromSecretRef. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerEnvFromSecretRef.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerEnvFromSecretRef.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_object_reference: Optional['outputs.ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReference'] = None,
                 optional: Optional[bool] = None):
        """
        :param 'ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceArgs' local_object_reference: The Secret to select from.
               Structure is documented below.
        :param bool optional: Specify whether the Secret must be defined
        """
        if local_object_reference is not None:
            pulumi.set(__self__, "local_object_reference", local_object_reference)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> Optional['outputs.ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReference']:
        """
        The Secret to select from.
        Structure is documented below.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def optional(self) -> Optional[bool]:
        """
        Specify whether the Secret must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReference(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Name of the port.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the port.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateSpecContainerPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateSpecContainerPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateSpecContainerPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateSpecContainerPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: int,
                 name: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        :param int container_port: Port number.
        :param str name: Name of the port.
        :param str protocol: Protocol used on port. Defaults to TCP.
        """
        pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        """
        Port number.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the port.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol used on port. Defaults to TCP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ServiceTemplateSpecContainerResources(dict):
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, str]] = None,
                 requests: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] limits: Limits describes the maximum amount of compute resources allowed.
               The values of the map is string form of the 'quantity' k8s type:
               https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param Mapping[str, str] requests: Requests describes the minimum amount of compute resources required.
               If Requests is omitted for a container, it defaults to Limits if that is
               explicitly specified, otherwise to an implementation-defined value.
               The values of the map is string form of the 'quantity' k8s type:
               https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, str]]:
        """
        Limits describes the maximum amount of compute resources allowed.
        The values of the map is string form of the 'quantity' k8s type:
        https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Mapping[str, str]]:
        """
        Requests describes the minimum amount of compute resources required.
        If Requests is omitted for a container, it defaults to Limits if that is
        explicitly specified, otherwise to an implementation-defined value.
        The values of the map is string form of the 'quantity' k8s type:
        https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class ServiceTraffic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestRevision":
            suggest = "latest_revision"
        elif key == "revisionName":
            suggest = "revision_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTraffic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTraffic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTraffic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 percent: int,
                 latest_revision: Optional[bool] = None,
                 revision_name: Optional[str] = None):
        """
        :param int percent: Percent specifies percent of the traffic to this Revision or Configuration.
        :param bool latest_revision: LatestRevision may be optionally provided to indicate that the latest ready
               Revision of the Configuration should be used for this traffic target. When
               provided LatestRevision must be true if RevisionName is empty; it must be
               false when RevisionName is non-empty.
        :param str revision_name: RevisionName of a specific revision to which to send this portion of traffic.
        """
        pulumi.set(__self__, "percent", percent)
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if revision_name is not None:
            pulumi.set(__self__, "revision_name", revision_name)

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Percent specifies percent of the traffic to this Revision or Configuration.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[bool]:
        """
        LatestRevision may be optionally provided to indicate that the latest ready
        Revision of the Configuration should be used for this traffic target. When
        provided LatestRevision must be true if RevisionName is empty; it must be
        false when RevisionName is non-empty.
        """
        return pulumi.get(self, "latest_revision")

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> Optional[str]:
        """
        RevisionName of a specific revision to which to send this portion of traffic.
        """
        return pulumi.get(self, "revision_name")


@pulumi.output_type
class GetServiceMetadataResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 generation: int,
                 labels: Mapping[str, str],
                 namespace: str,
                 resource_version: str,
                 self_link: str,
                 uid: str):
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_version", resource_version)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def generation(self) -> int:
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> str:
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def uid(self) -> str:
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetServiceStatusResult(dict):
    def __init__(__self__, *,
                 conditions: Sequence['outputs.GetServiceStatusConditionResult'],
                 latest_created_revision_name: str,
                 latest_ready_revision_name: str,
                 observed_generation: int,
                 url: str):
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "latest_created_revision_name", latest_created_revision_name)
        pulumi.set(__self__, "latest_ready_revision_name", latest_ready_revision_name)
        pulumi.set(__self__, "observed_generation", observed_generation)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetServiceStatusConditionResult']:
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="latestCreatedRevisionName")
    def latest_created_revision_name(self) -> str:
        return pulumi.get(self, "latest_created_revision_name")

    @property
    @pulumi.getter(name="latestReadyRevisionName")
    def latest_ready_revision_name(self) -> str:
        return pulumi.get(self, "latest_ready_revision_name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> int:
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def url(self) -> str:
        return pulumi.get(self, "url")


@pulumi.output_type
class GetServiceStatusConditionResult(dict):
    def __init__(__self__, *,
                 message: str,
                 reason: str,
                 status: str,
                 type: str):
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> str:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceTemplateResult(dict):
    def __init__(__self__, *,
                 metadatas: Sequence['outputs.GetServiceTemplateMetadataResult'],
                 specs: Sequence['outputs.GetServiceTemplateSpecResult']):
        pulumi.set(__self__, "metadatas", metadatas)
        pulumi.set(__self__, "specs", specs)

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetServiceTemplateMetadataResult']:
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetServiceTemplateSpecResult']:
        return pulumi.get(self, "specs")


@pulumi.output_type
class GetServiceTemplateMetadataResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 generation: int,
                 labels: Mapping[str, str],
                 name: str,
                 namespace: str,
                 resource_version: str,
                 self_link: str,
                 uid: str):
        """
        :param str name: The name of the Cloud Run Service.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "resource_version", resource_version)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def generation(self) -> int:
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> str:
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def uid(self) -> str:
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetServiceTemplateSpecResult(dict):
    def __init__(__self__, *,
                 container_concurrency: int,
                 containers: Sequence['outputs.GetServiceTemplateSpecContainerResult'],
                 service_account_name: str,
                 serving_state: str,
                 timeout_seconds: int):
        pulumi.set(__self__, "container_concurrency", container_concurrency)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "service_account_name", service_account_name)
        pulumi.set(__self__, "serving_state", serving_state)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="containerConcurrency")
    def container_concurrency(self) -> int:
        return pulumi.get(self, "container_concurrency")

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetServiceTemplateSpecContainerResult']:
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> str:
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="servingState")
    def serving_state(self) -> str:
        return pulumi.get(self, "serving_state")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> int:
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetServiceTemplateSpecContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[str],
                 commands: Sequence[str],
                 env_froms: Sequence['outputs.GetServiceTemplateSpecContainerEnvFromResult'],
                 envs: Sequence['outputs.GetServiceTemplateSpecContainerEnvResult'],
                 image: str,
                 ports: Sequence['outputs.GetServiceTemplateSpecContainerPortResult'],
                 resources: Sequence['outputs.GetServiceTemplateSpecContainerResourceResult'],
                 working_dir: str):
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "env_froms", env_froms)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="envFroms")
    def env_froms(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvFromResult']:
        return pulumi.get(self, "env_froms")

    @property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvResult']:
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def image(self) -> str:
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.GetServiceTemplateSpecContainerPortResult']:
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetServiceTemplateSpecContainerResourceResult']:
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> str:
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the Cloud Run Service.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvFromResult(dict):
    def __init__(__self__, *,
                 config_map_reves: Sequence['outputs.GetServiceTemplateSpecContainerEnvFromConfigMapRefResult'],
                 prefix: str,
                 secret_reves: Sequence['outputs.GetServiceTemplateSpecContainerEnvFromSecretRefResult']):
        pulumi.set(__self__, "config_map_reves", config_map_reves)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "secret_reves", secret_reves)

    @property
    @pulumi.getter(name="configMapReves")
    def config_map_reves(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvFromConfigMapRefResult']:
        return pulumi.get(self, "config_map_reves")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="secretReves")
    def secret_reves(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvFromSecretRefResult']:
        return pulumi.get(self, "secret_reves")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvFromConfigMapRefResult(dict):
    def __init__(__self__, *,
                 local_object_references: Sequence['outputs.GetServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceResult'],
                 optional: bool):
        pulumi.set(__self__, "local_object_references", local_object_references)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReferences")
    def local_object_references(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceResult']:
        return pulumi.get(self, "local_object_references")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        return pulumi.get(self, "optional")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvFromConfigMapRefLocalObjectReferenceResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The name of the Cloud Run Service.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvFromSecretRefResult(dict):
    def __init__(__self__, *,
                 local_object_references: Sequence['outputs.GetServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceResult'],
                 optional: bool):
        pulumi.set(__self__, "local_object_references", local_object_references)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReferences")
    def local_object_references(self) -> Sequence['outputs.GetServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceResult']:
        return pulumi.get(self, "local_object_references")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        return pulumi.get(self, "optional")


@pulumi.output_type
class GetServiceTemplateSpecContainerEnvFromSecretRefLocalObjectReferenceResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The name of the Cloud Run Service.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceTemplateSpecContainerPortResult(dict):
    def __init__(__self__, *,
                 container_port: int,
                 name: str,
                 protocol: str):
        """
        :param str name: The name of the Cloud Run Service.
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetServiceTemplateSpecContainerResourceResult(dict):
    def __init__(__self__, *,
                 limits: Mapping[str, str],
                 requests: Mapping[str, str]):
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Mapping[str, str]:
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Mapping[str, str]:
        return pulumi.get(self, "requests")


@pulumi.output_type
class GetServiceTrafficResult(dict):
    def __init__(__self__, *,
                 latest_revision: bool,
                 percent: int,
                 revision_name: str):
        pulumi.set(__self__, "latest_revision", latest_revision)
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision_name", revision_name)

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> bool:
        return pulumi.get(self, "latest_revision")

    @property
    @pulumi.getter
    def percent(self) -> int:
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> str:
        return pulumi.get(self, "revision_name")


