"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const kms = require("@aws-cdk/aws-kms");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/cdk");
const ses = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-ses-receipt');
const topic = new sns.Topic(stack, 'Topic');
const fn = new lambda.Function(stack, 'Function', {
    code: lambda.Code.inline('exports.handler = async (event) => event;'),
    handler: 'index.handler',
    runtime: lambda.Runtime.NodeJS810
});
const bucket = new s3.Bucket(stack, 'Bucket');
const kmsKey = new kms.Key(stack, 'Key');
const ruleSet = new ses.ReceiptRuleSet(stack, 'RuleSet', {
    dropSpam: true
});
const firstRule = ruleSet.addRule('FirstRule', {
    actions: [
        new ses.ReceiptRuleAddHeaderAction({
            name: 'X-My-Header',
            value: 'value'
        }),
        new ses.ReceiptRuleLambdaAction({
            function: fn,
            invocationType: ses.LambdaInvocationType.RequestResponse,
            topic
        }),
        new ses.ReceiptRuleS3Action({
            bucket,
            kmsKey,
            objectKeyPrefix: 'emails/',
            topic
        }),
        new ses.ReceiptRuleSnsAction({
            encoding: ses.EmailEncoding.Base64,
            topic
        })
    ],
    name: 'FirstRule',
    recipients: ['cdk-ses-receipt-test@yopmail.com'],
    scanEnabled: true,
    tlsPolicy: ses.TlsPolicy.Require,
});
firstRule.addAction(new ses.ReceiptRuleBounceAction({
    sender: 'cdk-ses-receipt-test@yopmail.com',
    template: ses.ReceiptRuleBounceActionTemplate.MessageContentRejected,
    topic
}));
const secondRule = ruleSet.addRule('SecondRule');
secondRule.addAction(new ses.ReceiptRuleStopAction({
    topic
}));
new ses.WhiteListReceiptFilter(stack, 'WhiteList', {
    ips: [
        '10.0.0.0/16'
    ]
});
app.run();
//# sourceMappingURL=data:application/json;base64,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