"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'can create receipt rules with second after first'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        new lib_1.ReceiptRuleSet(stack, 'RuleSet', {
            rules: [
                {
                    name: 'FirstRule',
                },
                {
                    enabled: false,
                    name: 'SecondRule',
                    recipients: ['hello@aws.com'],
                    scanEnabled: true,
                    tlsPolicy: lib_1.TlsPolicy.Require
                }
            ]
        });
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "RuleSetE30C6C48": {
                    "Type": "AWS::SES::ReceiptRuleSet"
                },
                "RuleSetRule023C3B8E1": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Name": "FirstRule",
                            "Enabled": true
                        },
                        "RuleSetName": {
                            "Ref": "RuleSetE30C6C48"
                        }
                    }
                },
                "RuleSetRule117041B57": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Enabled": false,
                            "Name": "SecondRule",
                            "Recipients": [
                                "hello@aws.com"
                            ],
                            "ScanEnabled": true,
                            "TlsPolicy": "Require"
                        },
                        "RuleSetName": {
                            "Ref": "RuleSetE30C6C48"
                        },
                        "After": {
                            "Ref": "RuleSetRule023C3B8E1"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'import receipt rule'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        const receiptRule = lib_1.ReceiptRule.fromReceiptRuleName(stack, 'ImportedRule', 'MyRule');
        const receiptRuleSet = new lib_1.ReceiptRuleSet(stack, 'RuleSet');
        receiptRuleSet.addRule('MyRule', {
            after: receiptRule
        });
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "RuleSetE30C6C48": {
                    "Type": "AWS::SES::ReceiptRuleSet"
                },
                "RuleSetMyRule60B1D107": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Enabled": true
                        },
                        "RuleSetName": {
                            "Ref": "RuleSetE30C6C48"
                        },
                        "After": "MyRule"
                    }
                }
            },
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5yZWNlaXB0LXJ1bGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LnJlY2VpcHQtcnVsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsNENBQXlDO0FBQ3pDLHNDQUFxQztBQUVyQyxnQ0FBZ0U7QUFJaEUsaUJBQVM7SUFDUCxrREFBa0QsQ0FBQyxJQUFVO1FBQzNELFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssRUFBRSxDQUFDO1FBRTFCLE9BQU87UUFDUCxJQUFJLG9CQUFjLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRTtZQUNuQyxLQUFLLEVBQUU7Z0JBQ0w7b0JBQ0UsSUFBSSxFQUFFLFdBQVc7aUJBQ2xCO2dCQUNEO29CQUNFLE9BQU8sRUFBRSxLQUFLO29CQUNkLElBQUksRUFBRSxZQUFZO29CQUNsQixVQUFVLEVBQUUsQ0FBQyxlQUFlLENBQUM7b0JBQzdCLFdBQVcsRUFBRSxJQUFJO29CQUNqQixTQUFTLEVBQUUsZUFBUyxDQUFDLE9BQU87aUJBQzdCO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxPQUFPO1FBQ1AsZUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sQ0FBQztZQUNwQixXQUFXLEVBQUU7Z0JBQ1gsaUJBQWlCLEVBQUU7b0JBQ2pCLE1BQU0sRUFBRSwwQkFBMEI7aUJBQ25DO2dCQUNELHNCQUFzQixFQUFFO29CQUN0QixNQUFNLEVBQUUsdUJBQXVCO29CQUMvQixZQUFZLEVBQUU7d0JBQ1osTUFBTSxFQUFFOzRCQUNOLE1BQU0sRUFBRSxXQUFXOzRCQUNuQixTQUFTLEVBQUUsSUFBSTt5QkFDaEI7d0JBQ0QsYUFBYSxFQUFFOzRCQUNiLEtBQUssRUFBRSxpQkFBaUI7eUJBQ3pCO3FCQUNGO2lCQUNGO2dCQUNELHNCQUFzQixFQUFFO29CQUN0QixNQUFNLEVBQUUsdUJBQXVCO29CQUMvQixZQUFZLEVBQUU7d0JBQ1osTUFBTSxFQUFFOzRCQUNOLFNBQVMsRUFBRSxLQUFLOzRCQUNoQixNQUFNLEVBQUUsWUFBWTs0QkFDcEIsWUFBWSxFQUFFO2dDQUNaLGVBQWU7NkJBQ2hCOzRCQUNELGFBQWEsRUFBRSxJQUFJOzRCQUNuQixXQUFXLEVBQUUsU0FBUzt5QkFDdkI7d0JBQ0QsYUFBYSxFQUFFOzRCQUNiLEtBQUssRUFBRSxpQkFBaUI7eUJBQ3pCO3dCQUNELE9BQU8sRUFBRTs0QkFDUCxLQUFLLEVBQUUsc0JBQXNCO3lCQUM5QjtxQkFDRjtpQkFDRjthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELHFCQUFxQixDQUFDLElBQVU7UUFDOUIsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksV0FBSyxFQUFFLENBQUM7UUFFMUIsT0FBTztRQUNQLE1BQU0sV0FBVyxHQUFHLGlCQUFXLENBQUMsbUJBQW1CLENBQUMsS0FBSyxFQUFFLGNBQWMsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUNyRixNQUFNLGNBQWMsR0FBRyxJQUFJLG9CQUFjLENBQUMsS0FBSyxFQUFFLFNBQVMsQ0FBQyxDQUFDO1FBRTVELGNBQWMsQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFO1lBQy9CLEtBQUssRUFBRSxXQUFXO1NBQ25CLENBQUMsQ0FBQztRQUVILE9BQU87UUFDUCxlQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUFDO1lBQ3BCLFdBQVcsRUFBRTtnQkFDWCxpQkFBaUIsRUFBRTtvQkFDakIsTUFBTSxFQUFFLDBCQUEwQjtpQkFDbkM7Z0JBQ0QsdUJBQXVCLEVBQUU7b0JBQ3ZCLE1BQU0sRUFBRSx1QkFBdUI7b0JBQy9CLFlBQVksRUFBRTt3QkFDWixNQUFNLEVBQUU7NEJBQ04sU0FBUyxFQUFFLElBQUk7eUJBQ2hCO3dCQUNELGFBQWEsRUFBRTs0QkFDYixLQUFLLEVBQUUsaUJBQWlCO3lCQUN6Qjt3QkFDRCxPQUFPLEVBQUUsUUFBUTtxQkFDbEI7aUJBQ0Y7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZXhwZWN0IH0gZnJvbSAnQGF3cy1jZGsvYXNzZXJ0JztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY2RrJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgeyBSZWNlaXB0UnVsZSwgUmVjZWlwdFJ1bGVTZXQsIFRsc1BvbGljeSB9IGZyb20gJy4uL2xpYic7XG5cbi8vIHRzbGludDpkaXNhYmxlOm9iamVjdC1saXRlcmFsLWtleS1xdW90ZXNcblxuZXhwb3J0ID0ge1xuICAnY2FuIGNyZWF0ZSByZWNlaXB0IHJ1bGVzIHdpdGggc2Vjb25kIGFmdGVyIGZpcnN0Jyh0ZXN0OiBUZXN0KSB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuXG4gICAgLy8gV0hFTlxuICAgIG5ldyBSZWNlaXB0UnVsZVNldChzdGFjaywgJ1J1bGVTZXQnLCB7XG4gICAgICBydWxlczogW1xuICAgICAgICB7XG4gICAgICAgICAgbmFtZTogJ0ZpcnN0UnVsZScsXG4gICAgICAgIH0sXG4gICAgICAgIHtcbiAgICAgICAgICBlbmFibGVkOiBmYWxzZSxcbiAgICAgICAgICBuYW1lOiAnU2Vjb25kUnVsZScsXG4gICAgICAgICAgcmVjaXBpZW50czogWydoZWxsb0Bhd3MuY29tJ10sXG4gICAgICAgICAgc2NhbkVuYWJsZWQ6IHRydWUsXG4gICAgICAgICAgdGxzUG9saWN5OiBUbHNQb2xpY3kuUmVxdWlyZVxuICAgICAgICB9XG4gICAgICBdXG4gICAgfSk7XG5cbiAgICAvLyBUSEVOXG4gICAgZXhwZWN0KHN0YWNrKS50b01hdGNoKHtcbiAgICAgIFwiUmVzb3VyY2VzXCI6IHtcbiAgICAgICAgXCJSdWxlU2V0RTMwQzZDNDhcIjoge1xuICAgICAgICAgIFwiVHlwZVwiOiBcIkFXUzo6U0VTOjpSZWNlaXB0UnVsZVNldFwiXG4gICAgICAgIH0sXG4gICAgICAgIFwiUnVsZVNldFJ1bGUwMjNDM0I4RTFcIjoge1xuICAgICAgICAgIFwiVHlwZVwiOiBcIkFXUzo6U0VTOjpSZWNlaXB0UnVsZVwiLFxuICAgICAgICAgIFwiUHJvcGVydGllc1wiOiB7XG4gICAgICAgICAgICBcIlJ1bGVcIjoge1xuICAgICAgICAgICAgICBcIk5hbWVcIjogXCJGaXJzdFJ1bGVcIixcbiAgICAgICAgICAgICAgXCJFbmFibGVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcIlJ1bGVTZXROYW1lXCI6IHtcbiAgICAgICAgICAgICAgXCJSZWZcIjogXCJSdWxlU2V0RTMwQzZDNDhcIlxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAgXCJSdWxlU2V0UnVsZTExNzA0MUI1N1wiOiB7XG4gICAgICAgICAgXCJUeXBlXCI6IFwiQVdTOjpTRVM6OlJlY2VpcHRSdWxlXCIsXG4gICAgICAgICAgXCJQcm9wZXJ0aWVzXCI6IHtcbiAgICAgICAgICAgIFwiUnVsZVwiOiB7XG4gICAgICAgICAgICAgIFwiRW5hYmxlZFwiOiBmYWxzZSxcbiAgICAgICAgICAgICAgXCJOYW1lXCI6IFwiU2Vjb25kUnVsZVwiLFxuICAgICAgICAgICAgICBcIlJlY2lwaWVudHNcIjogW1xuICAgICAgICAgICAgICAgIFwiaGVsbG9AYXdzLmNvbVwiXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIFwiU2NhbkVuYWJsZWRcIjogdHJ1ZSxcbiAgICAgICAgICAgICAgXCJUbHNQb2xpY3lcIjogXCJSZXF1aXJlXCJcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcIlJ1bGVTZXROYW1lXCI6IHtcbiAgICAgICAgICAgICAgXCJSZWZcIjogXCJSdWxlU2V0RTMwQzZDNDhcIlxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwiQWZ0ZXJcIjoge1xuICAgICAgICAgICAgICBcIlJlZlwiOiBcIlJ1bGVTZXRSdWxlMDIzQzNCOEUxXCJcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9KTtcblxuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdpbXBvcnQgcmVjZWlwdCBydWxlJyh0ZXN0OiBUZXN0KSB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuXG4gICAgLy8gV0hFTlxuICAgIGNvbnN0IHJlY2VpcHRSdWxlID0gUmVjZWlwdFJ1bGUuZnJvbVJlY2VpcHRSdWxlTmFtZShzdGFjaywgJ0ltcG9ydGVkUnVsZScsICdNeVJ1bGUnKTtcbiAgICBjb25zdCByZWNlaXB0UnVsZVNldCA9IG5ldyBSZWNlaXB0UnVsZVNldChzdGFjaywgJ1J1bGVTZXQnKTtcblxuICAgIHJlY2VpcHRSdWxlU2V0LmFkZFJ1bGUoJ015UnVsZScsIHtcbiAgICAgIGFmdGVyOiByZWNlaXB0UnVsZVxuICAgIH0pO1xuXG4gICAgLy8gVEhFTlxuICAgIGV4cGVjdChzdGFjaykudG9NYXRjaCh7XG4gICAgICBcIlJlc291cmNlc1wiOiB7XG4gICAgICAgIFwiUnVsZVNldEUzMEM2QzQ4XCI6IHtcbiAgICAgICAgICBcIlR5cGVcIjogXCJBV1M6OlNFUzo6UmVjZWlwdFJ1bGVTZXRcIlxuICAgICAgICB9LFxuICAgICAgICBcIlJ1bGVTZXRNeVJ1bGU2MEIxRDEwN1wiOiB7XG4gICAgICAgICAgXCJUeXBlXCI6IFwiQVdTOjpTRVM6OlJlY2VpcHRSdWxlXCIsXG4gICAgICAgICAgXCJQcm9wZXJ0aWVzXCI6IHtcbiAgICAgICAgICAgIFwiUnVsZVwiOiB7XG4gICAgICAgICAgICAgIFwiRW5hYmxlZFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJSdWxlU2V0TmFtZVwiOiB7XG4gICAgICAgICAgICAgIFwiUmVmXCI6IFwiUnVsZVNldEUzMEM2QzQ4XCJcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcIkFmdGVyXCI6IFwiTXlSdWxlXCJcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfVxufTtcbiJdfQ==