# Generated by Django 3.1.14 on 2022-04-27 22:00

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models

import ob_dj_store.utils.helpers
import ob_dj_store.utils.model


class Migration(migrations.Migration):

    dependencies = [
        ("stores", "0005_auto_20220427_1729"),
        ("stores", "0005_auto_20220425_2119"),
    ]

    operations = [
        migrations.CreateModel(
            name="Attribute",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(help_text="Name", max_length=200)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Attribute ",
                "verbose_name_plural": "Attributes",
            },
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AttributeChoice",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(help_text="Name", max_length=200)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Attribute Choice",
                "verbose_name_plural": "Attribute Choices",
            },
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
        migrations.CreateModel(
            name="Product",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(help_text="Name", max_length=200)),
                ("slug", models.SlugField(max_length=255, unique=True)),
                ("description", models.TextField(blank=True, null=True)),
                ("is_active", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "category",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="products",
                        to="stores.category",
                    ),
                ),
                (
                    "store",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="products",
                        to="stores.store",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product",
                "verbose_name_plural": "Products",
            },
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductAttribute",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(help_text="Name", max_length=200)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "attribute",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="product_attributes",
                        to="stores.attribute",
                    ),
                ),
                (
                    "attribute_choices",
                    models.ManyToManyField(
                        blank=True,
                        related_name="product_attributes",
                        to="stores.AttributeChoice",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Attribute",
                "verbose_name_plural": "Product Attributes",
            },
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductTag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=500)),
                (
                    "text_color",
                    models.CharField(
                        default="#000000",
                        max_length=7,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="Can you please provide a valid color hex !",
                                regex="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$",
                            )
                        ],
                    ),
                ),
                (
                    "background_color",
                    models.CharField(
                        default="#000000",
                        max_length=7,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="Can you please provide a valid color hex !",
                                regex="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$",
                            )
                        ],
                    ),
                ),
            ],
            options={
                "verbose_name": "Tag",
                "verbose_name_plural": "Tags",
            },
        ),
        migrations.CreateModel(
            name="ProductVariant",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(help_text="Name", max_length=200)),
                ("price", models.DecimalField(decimal_places=4, max_digits=10)),
                ("quantity", models.PositiveIntegerField()),
                ("sku", models.CharField(blank=True, max_length=100, null=True)),
                ("is_deliverable", models.BooleanField(default=False)),
                ("is_active", models.BooleanField(default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="product_variants",
                        to="stores.product",
                    ),
                ),
                (
                    "product_attributes",
                    models.ManyToManyField(
                        blank=True,
                        related_name="product_variants",
                        to="stores.ProductAttribute",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Variation",
                "verbose_name_plural": "Product Variations",
            },
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductMedia",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("is_primary", models.BooleanField(default=False)),
                (
                    "image",
                    models.ImageField(
                        upload_to=ob_dj_store.utils.helpers.product_media_upload_to
                    ),
                ),
                (
                    "order_value",
                    models.PositiveSmallIntegerField(
                        default=1, verbose_name="ordering"
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="images",
                        to="stores.product",
                        verbose_name="product",
                    ),
                ),
            ],
            options={
                "verbose_name": "product media",
                "verbose_name_plural": "Product medias",
                "ordering": ("order_value",),
            },
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
        migrations.AddField(
            model_name="product",
            name="tags",
            field=models.ManyToManyField(
                blank=True, related_name="products", to="stores.ProductTag"
            ),
        ),
        migrations.AddConstraint(
            model_name="productmedia",
            constraint=models.UniqueConstraint(
                condition=models.Q(is_primary=True),
                fields=("product_id", "is_primary"),
                name="stores_productmedia_unique_primary_image",
            ),
        ),
    ]
