# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FlinkJobTableArgs', 'FlinkJobTable']

@pulumi.input_type
class FlinkJobTableArgs:
    def __init__(__self__, *,
                 integration_id: pulumi.Input[str],
                 project: pulumi.Input[str],
                 schema_sql: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 table_name: pulumi.Input[str],
                 jdbc_table: Optional[pulumi.Input[str]] = None,
                 kafka_connector_type: Optional[pulumi.Input[str]] = None,
                 kafka_key_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kafka_key_format: Optional[pulumi.Input[str]] = None,
                 kafka_startup_mode: Optional[pulumi.Input[str]] = None,
                 kafka_topic: Optional[pulumi.Input[str]] = None,
                 kafka_value_fields_include: Optional[pulumi.Input[str]] = None,
                 kafka_value_format: Optional[pulumi.Input[str]] = None,
                 like_options: Optional[pulumi.Input[str]] = None,
                 opensearch_index: Optional[pulumi.Input[str]] = None,
                 upsert_kafka: Optional[pulumi.Input['FlinkJobTableUpsertKafkaArgs']] = None):
        """
        The set of arguments for constructing a FlinkJobTable resource.
        :param pulumi.Input[str] integration_id: The id of the service integration that is used with this table. It must have the service integration type `flink`. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] schema_sql: The SQL statement to create the table. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] table_name: Specifies the name of the table. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] jdbc_table: Name of the jdbc table that is to be connected to this table. Valid if the service integration id refers to a mysql or postgres service. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_connector_type: When used as a source, upsert Kafka connectors update values that use an existing key and delete values that are null. For sinks, the connector correspondingly writes update or delete messages in a compacted topic. If no matching key is found, the values are added as new entries. For more information, see the Apache Flink documentation The possible values are `kafka` and `upsert-kafka`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kafka_key_fields: Defines an explicit list of physical columns from the table schema that configure the data type for the key format. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_key_format: Kafka Key Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_startup_mode: Startup mode The possible values are `earliest-offset`, `latest-offset`, `group-offsets` and `timestamp`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_topic: Name of the kafka topic that is to be connected to this table. Valid if the service integration id refers to a kafka service. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_value_fields_include: Controls how key columns are handled in the message value. Select ALL to include the physical columns of the table schema in the message value. Select EXCEPT_KEY to exclude the physical columns of the table schema from the message value. This is the default for upsert Kafka connectors. The possible values are `[ALL EXCEPT_KEY]`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_value_format: Kafka Value Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] like_options: [LIKE](https://nightlies.apache.org/flink/flink-docs-master/docs/dev/table/sql/create/#like) statement for table creation. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] opensearch_index: For an OpenSearch table, the OpenSearch index the table outputs to. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input['FlinkJobTableUpsertKafkaArgs'] upsert_kafka: Kafka upsert connector configuration.
        """
        pulumi.set(__self__, "integration_id", integration_id)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "schema_sql", schema_sql)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "table_name", table_name)
        if jdbc_table is not None:
            pulumi.set(__self__, "jdbc_table", jdbc_table)
        if kafka_connector_type is not None:
            pulumi.set(__self__, "kafka_connector_type", kafka_connector_type)
        if kafka_key_fields is not None:
            pulumi.set(__self__, "kafka_key_fields", kafka_key_fields)
        if kafka_key_format is not None:
            pulumi.set(__self__, "kafka_key_format", kafka_key_format)
        if kafka_startup_mode is not None:
            pulumi.set(__self__, "kafka_startup_mode", kafka_startup_mode)
        if kafka_topic is not None:
            pulumi.set(__self__, "kafka_topic", kafka_topic)
        if kafka_value_fields_include is not None:
            pulumi.set(__self__, "kafka_value_fields_include", kafka_value_fields_include)
        if kafka_value_format is not None:
            pulumi.set(__self__, "kafka_value_format", kafka_value_format)
        if like_options is not None:
            pulumi.set(__self__, "like_options", like_options)
        if opensearch_index is not None:
            pulumi.set(__self__, "opensearch_index", opensearch_index)
        if upsert_kafka is not None:
            pulumi.set(__self__, "upsert_kafka", upsert_kafka)

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> pulumi.Input[str]:
        """
        The id of the service integration that is used with this table. It must have the service integration type `flink`. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "integration_id", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="schemaSql")
    def schema_sql(self) -> pulumi.Input[str]:
        """
        The SQL statement to create the table. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "schema_sql")

    @schema_sql.setter
    def schema_sql(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema_sql", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the table. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="jdbcTable")
    def jdbc_table(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the jdbc table that is to be connected to this table. Valid if the service integration id refers to a mysql or postgres service. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "jdbc_table")

    @jdbc_table.setter
    def jdbc_table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jdbc_table", value)

    @property
    @pulumi.getter(name="kafkaConnectorType")
    def kafka_connector_type(self) -> Optional[pulumi.Input[str]]:
        """
        When used as a source, upsert Kafka connectors update values that use an existing key and delete values that are null. For sinks, the connector correspondingly writes update or delete messages in a compacted topic. If no matching key is found, the values are added as new entries. For more information, see the Apache Flink documentation The possible values are `kafka` and `upsert-kafka`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_connector_type")

    @kafka_connector_type.setter
    def kafka_connector_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_connector_type", value)

    @property
    @pulumi.getter(name="kafkaKeyFields")
    def kafka_key_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Defines an explicit list of physical columns from the table schema that configure the data type for the key format. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_key_fields")

    @kafka_key_fields.setter
    def kafka_key_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kafka_key_fields", value)

    @property
    @pulumi.getter(name="kafkaKeyFormat")
    def kafka_key_format(self) -> Optional[pulumi.Input[str]]:
        """
        Kafka Key Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_key_format")

    @kafka_key_format.setter
    def kafka_key_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_key_format", value)

    @property
    @pulumi.getter(name="kafkaStartupMode")
    def kafka_startup_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Startup mode The possible values are `earliest-offset`, `latest-offset`, `group-offsets` and `timestamp`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_startup_mode")

    @kafka_startup_mode.setter
    def kafka_startup_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_startup_mode", value)

    @property
    @pulumi.getter(name="kafkaTopic")
    def kafka_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the kafka topic that is to be connected to this table. Valid if the service integration id refers to a kafka service. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_topic")

    @kafka_topic.setter
    def kafka_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_topic", value)

    @property
    @pulumi.getter(name="kafkaValueFieldsInclude")
    def kafka_value_fields_include(self) -> Optional[pulumi.Input[str]]:
        """
        Controls how key columns are handled in the message value. Select ALL to include the physical columns of the table schema in the message value. Select EXCEPT_KEY to exclude the physical columns of the table schema from the message value. This is the default for upsert Kafka connectors. The possible values are `[ALL EXCEPT_KEY]`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_value_fields_include")

    @kafka_value_fields_include.setter
    def kafka_value_fields_include(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_value_fields_include", value)

    @property
    @pulumi.getter(name="kafkaValueFormat")
    def kafka_value_format(self) -> Optional[pulumi.Input[str]]:
        """
        Kafka Value Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_value_format")

    @kafka_value_format.setter
    def kafka_value_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_value_format", value)

    @property
    @pulumi.getter(name="likeOptions")
    def like_options(self) -> Optional[pulumi.Input[str]]:
        """
        [LIKE](https://nightlies.apache.org/flink/flink-docs-master/docs/dev/table/sql/create/#like) statement for table creation. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "like_options")

    @like_options.setter
    def like_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "like_options", value)

    @property
    @pulumi.getter(name="opensearchIndex")
    def opensearch_index(self) -> Optional[pulumi.Input[str]]:
        """
        For an OpenSearch table, the OpenSearch index the table outputs to. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "opensearch_index")

    @opensearch_index.setter
    def opensearch_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opensearch_index", value)

    @property
    @pulumi.getter(name="upsertKafka")
    def upsert_kafka(self) -> Optional[pulumi.Input['FlinkJobTableUpsertKafkaArgs']]:
        """
        Kafka upsert connector configuration.
        """
        return pulumi.get(self, "upsert_kafka")

    @upsert_kafka.setter
    def upsert_kafka(self, value: Optional[pulumi.Input['FlinkJobTableUpsertKafkaArgs']]):
        pulumi.set(self, "upsert_kafka", value)


@pulumi.input_type
class _FlinkJobTableState:
    def __init__(__self__, *,
                 integration_id: Optional[pulumi.Input[str]] = None,
                 jdbc_table: Optional[pulumi.Input[str]] = None,
                 kafka_connector_type: Optional[pulumi.Input[str]] = None,
                 kafka_key_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kafka_key_format: Optional[pulumi.Input[str]] = None,
                 kafka_startup_mode: Optional[pulumi.Input[str]] = None,
                 kafka_topic: Optional[pulumi.Input[str]] = None,
                 kafka_value_fields_include: Optional[pulumi.Input[str]] = None,
                 kafka_value_format: Optional[pulumi.Input[str]] = None,
                 like_options: Optional[pulumi.Input[str]] = None,
                 opensearch_index: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 schema_sql: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 table_id: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 upsert_kafka: Optional[pulumi.Input['FlinkJobTableUpsertKafkaArgs']] = None):
        """
        Input properties used for looking up and filtering FlinkJobTable resources.
        :param pulumi.Input[str] integration_id: The id of the service integration that is used with this table. It must have the service integration type `flink`. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] jdbc_table: Name of the jdbc table that is to be connected to this table. Valid if the service integration id refers to a mysql or postgres service. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_connector_type: When used as a source, upsert Kafka connectors update values that use an existing key and delete values that are null. For sinks, the connector correspondingly writes update or delete messages in a compacted topic. If no matching key is found, the values are added as new entries. For more information, see the Apache Flink documentation The possible values are `kafka` and `upsert-kafka`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kafka_key_fields: Defines an explicit list of physical columns from the table schema that configure the data type for the key format. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_key_format: Kafka Key Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_startup_mode: Startup mode The possible values are `earliest-offset`, `latest-offset`, `group-offsets` and `timestamp`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_topic: Name of the kafka topic that is to be connected to this table. Valid if the service integration id refers to a kafka service. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_value_fields_include: Controls how key columns are handled in the message value. Select ALL to include the physical columns of the table schema in the message value. Select EXCEPT_KEY to exclude the physical columns of the table schema from the message value. This is the default for upsert Kafka connectors. The possible values are `[ALL EXCEPT_KEY]`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_value_format: Kafka Value Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] like_options: [LIKE](https://nightlies.apache.org/flink/flink-docs-master/docs/dev/table/sql/create/#like) statement for table creation. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] opensearch_index: For an OpenSearch table, the OpenSearch index the table outputs to. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] schema_sql: The SQL statement to create the table. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] table_id: The Table ID of the flink table in the flink service.
        :param pulumi.Input[str] table_name: Specifies the name of the table. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input['FlinkJobTableUpsertKafkaArgs'] upsert_kafka: Kafka upsert connector configuration.
        """
        if integration_id is not None:
            pulumi.set(__self__, "integration_id", integration_id)
        if jdbc_table is not None:
            pulumi.set(__self__, "jdbc_table", jdbc_table)
        if kafka_connector_type is not None:
            pulumi.set(__self__, "kafka_connector_type", kafka_connector_type)
        if kafka_key_fields is not None:
            pulumi.set(__self__, "kafka_key_fields", kafka_key_fields)
        if kafka_key_format is not None:
            pulumi.set(__self__, "kafka_key_format", kafka_key_format)
        if kafka_startup_mode is not None:
            pulumi.set(__self__, "kafka_startup_mode", kafka_startup_mode)
        if kafka_topic is not None:
            pulumi.set(__self__, "kafka_topic", kafka_topic)
        if kafka_value_fields_include is not None:
            pulumi.set(__self__, "kafka_value_fields_include", kafka_value_fields_include)
        if kafka_value_format is not None:
            pulumi.set(__self__, "kafka_value_format", kafka_value_format)
        if like_options is not None:
            pulumi.set(__self__, "like_options", like_options)
        if opensearch_index is not None:
            pulumi.set(__self__, "opensearch_index", opensearch_index)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if schema_sql is not None:
            pulumi.set(__self__, "schema_sql", schema_sql)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if upsert_kafka is not None:
            pulumi.set(__self__, "upsert_kafka", upsert_kafka)

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the service integration that is used with this table. It must have the service integration type `flink`. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integration_id", value)

    @property
    @pulumi.getter(name="jdbcTable")
    def jdbc_table(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the jdbc table that is to be connected to this table. Valid if the service integration id refers to a mysql or postgres service. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "jdbc_table")

    @jdbc_table.setter
    def jdbc_table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jdbc_table", value)

    @property
    @pulumi.getter(name="kafkaConnectorType")
    def kafka_connector_type(self) -> Optional[pulumi.Input[str]]:
        """
        When used as a source, upsert Kafka connectors update values that use an existing key and delete values that are null. For sinks, the connector correspondingly writes update or delete messages in a compacted topic. If no matching key is found, the values are added as new entries. For more information, see the Apache Flink documentation The possible values are `kafka` and `upsert-kafka`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_connector_type")

    @kafka_connector_type.setter
    def kafka_connector_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_connector_type", value)

    @property
    @pulumi.getter(name="kafkaKeyFields")
    def kafka_key_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Defines an explicit list of physical columns from the table schema that configure the data type for the key format. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_key_fields")

    @kafka_key_fields.setter
    def kafka_key_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kafka_key_fields", value)

    @property
    @pulumi.getter(name="kafkaKeyFormat")
    def kafka_key_format(self) -> Optional[pulumi.Input[str]]:
        """
        Kafka Key Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_key_format")

    @kafka_key_format.setter
    def kafka_key_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_key_format", value)

    @property
    @pulumi.getter(name="kafkaStartupMode")
    def kafka_startup_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Startup mode The possible values are `earliest-offset`, `latest-offset`, `group-offsets` and `timestamp`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_startup_mode")

    @kafka_startup_mode.setter
    def kafka_startup_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_startup_mode", value)

    @property
    @pulumi.getter(name="kafkaTopic")
    def kafka_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the kafka topic that is to be connected to this table. Valid if the service integration id refers to a kafka service. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_topic")

    @kafka_topic.setter
    def kafka_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_topic", value)

    @property
    @pulumi.getter(name="kafkaValueFieldsInclude")
    def kafka_value_fields_include(self) -> Optional[pulumi.Input[str]]:
        """
        Controls how key columns are handled in the message value. Select ALL to include the physical columns of the table schema in the message value. Select EXCEPT_KEY to exclude the physical columns of the table schema from the message value. This is the default for upsert Kafka connectors. The possible values are `[ALL EXCEPT_KEY]`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_value_fields_include")

    @kafka_value_fields_include.setter
    def kafka_value_fields_include(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_value_fields_include", value)

    @property
    @pulumi.getter(name="kafkaValueFormat")
    def kafka_value_format(self) -> Optional[pulumi.Input[str]]:
        """
        Kafka Value Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_value_format")

    @kafka_value_format.setter
    def kafka_value_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka_value_format", value)

    @property
    @pulumi.getter(name="likeOptions")
    def like_options(self) -> Optional[pulumi.Input[str]]:
        """
        [LIKE](https://nightlies.apache.org/flink/flink-docs-master/docs/dev/table/sql/create/#like) statement for table creation. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "like_options")

    @like_options.setter
    def like_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "like_options", value)

    @property
    @pulumi.getter(name="opensearchIndex")
    def opensearch_index(self) -> Optional[pulumi.Input[str]]:
        """
        For an OpenSearch table, the OpenSearch index the table outputs to. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "opensearch_index")

    @opensearch_index.setter
    def opensearch_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opensearch_index", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="schemaSql")
    def schema_sql(self) -> Optional[pulumi.Input[str]]:
        """
        The SQL statement to create the table. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "schema_sql")

    @schema_sql.setter
    def schema_sql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_sql", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Table ID of the flink table in the flink service.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_id", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the table. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="upsertKafka")
    def upsert_kafka(self) -> Optional[pulumi.Input['FlinkJobTableUpsertKafkaArgs']]:
        """
        Kafka upsert connector configuration.
        """
        return pulumi.get(self, "upsert_kafka")

    @upsert_kafka.setter
    def upsert_kafka(self, value: Optional[pulumi.Input['FlinkJobTableUpsertKafkaArgs']]):
        pulumi.set(self, "upsert_kafka", value)


class FlinkJobTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 integration_id: Optional[pulumi.Input[str]] = None,
                 jdbc_table: Optional[pulumi.Input[str]] = None,
                 kafka_connector_type: Optional[pulumi.Input[str]] = None,
                 kafka_key_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kafka_key_format: Optional[pulumi.Input[str]] = None,
                 kafka_startup_mode: Optional[pulumi.Input[str]] = None,
                 kafka_topic: Optional[pulumi.Input[str]] = None,
                 kafka_value_fields_include: Optional[pulumi.Input[str]] = None,
                 kafka_value_format: Optional[pulumi.Input[str]] = None,
                 like_options: Optional[pulumi.Input[str]] = None,
                 opensearch_index: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 schema_sql: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 upsert_kafka: Optional[pulumi.Input[pulumi.InputType['FlinkJobTableUpsertKafkaArgs']]] = None,
                 __props__=None):
        """
        The Flink Table resource allows the creation and management of Aiven Tables.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        table = aiven.FlinkJobTable("table",
            project=data["aiven_project"]["pr1"]["project"],
            service_name=aiven_flink["flink"]["service_name"],
            table_name="<TABLE_NAME>",
            integration_id=aiven_service_integration["flink_kafka"]["service_id"],
            jdbc_table="<JDBC_TABLE_NAME>",
            kafka_topic=aiven_kafka_topic["table_topic"]["topic_name"],
            schema_sql=\"\"\"      `+"`cpu`"+` INT,
              `+"`node`"+` INT,
              `+"`occurred_at`"+` TIMESTAMP(3) METADATA FROM 'timestamp',
              WATERMARK FOR `+"`occurred_at`"+` AS `+"`occurred_at`"+` - INTERVAL '5' SECOND
        \"\"\")
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/flinkJobTable:FlinkJobTable table project/service_name/table_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] integration_id: The id of the service integration that is used with this table. It must have the service integration type `flink`. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] jdbc_table: Name of the jdbc table that is to be connected to this table. Valid if the service integration id refers to a mysql or postgres service. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_connector_type: When used as a source, upsert Kafka connectors update values that use an existing key and delete values that are null. For sinks, the connector correspondingly writes update or delete messages in a compacted topic. If no matching key is found, the values are added as new entries. For more information, see the Apache Flink documentation The possible values are `kafka` and `upsert-kafka`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kafka_key_fields: Defines an explicit list of physical columns from the table schema that configure the data type for the key format. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_key_format: Kafka Key Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_startup_mode: Startup mode The possible values are `earliest-offset`, `latest-offset`, `group-offsets` and `timestamp`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_topic: Name of the kafka topic that is to be connected to this table. Valid if the service integration id refers to a kafka service. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_value_fields_include: Controls how key columns are handled in the message value. Select ALL to include the physical columns of the table schema in the message value. Select EXCEPT_KEY to exclude the physical columns of the table schema from the message value. This is the default for upsert Kafka connectors. The possible values are `[ALL EXCEPT_KEY]`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_value_format: Kafka Value Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] like_options: [LIKE](https://nightlies.apache.org/flink/flink-docs-master/docs/dev/table/sql/create/#like) statement for table creation. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] opensearch_index: For an OpenSearch table, the OpenSearch index the table outputs to. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] schema_sql: The SQL statement to create the table. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] table_name: Specifies the name of the table. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[pulumi.InputType['FlinkJobTableUpsertKafkaArgs']] upsert_kafka: Kafka upsert connector configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlinkJobTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Flink Table resource allows the creation and management of Aiven Tables.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        table = aiven.FlinkJobTable("table",
            project=data["aiven_project"]["pr1"]["project"],
            service_name=aiven_flink["flink"]["service_name"],
            table_name="<TABLE_NAME>",
            integration_id=aiven_service_integration["flink_kafka"]["service_id"],
            jdbc_table="<JDBC_TABLE_NAME>",
            kafka_topic=aiven_kafka_topic["table_topic"]["topic_name"],
            schema_sql=\"\"\"      `+"`cpu`"+` INT,
              `+"`node`"+` INT,
              `+"`occurred_at`"+` TIMESTAMP(3) METADATA FROM 'timestamp',
              WATERMARK FOR `+"`occurred_at`"+` AS `+"`occurred_at`"+` - INTERVAL '5' SECOND
        \"\"\")
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/flinkJobTable:FlinkJobTable table project/service_name/table_id
        ```

        :param str resource_name: The name of the resource.
        :param FlinkJobTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlinkJobTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 integration_id: Optional[pulumi.Input[str]] = None,
                 jdbc_table: Optional[pulumi.Input[str]] = None,
                 kafka_connector_type: Optional[pulumi.Input[str]] = None,
                 kafka_key_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kafka_key_format: Optional[pulumi.Input[str]] = None,
                 kafka_startup_mode: Optional[pulumi.Input[str]] = None,
                 kafka_topic: Optional[pulumi.Input[str]] = None,
                 kafka_value_fields_include: Optional[pulumi.Input[str]] = None,
                 kafka_value_format: Optional[pulumi.Input[str]] = None,
                 like_options: Optional[pulumi.Input[str]] = None,
                 opensearch_index: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 schema_sql: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 upsert_kafka: Optional[pulumi.Input[pulumi.InputType['FlinkJobTableUpsertKafkaArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlinkJobTableArgs.__new__(FlinkJobTableArgs)

            if integration_id is None and not opts.urn:
                raise TypeError("Missing required property 'integration_id'")
            __props__.__dict__["integration_id"] = integration_id
            __props__.__dict__["jdbc_table"] = jdbc_table
            __props__.__dict__["kafka_connector_type"] = kafka_connector_type
            __props__.__dict__["kafka_key_fields"] = kafka_key_fields
            __props__.__dict__["kafka_key_format"] = kafka_key_format
            __props__.__dict__["kafka_startup_mode"] = kafka_startup_mode
            __props__.__dict__["kafka_topic"] = kafka_topic
            __props__.__dict__["kafka_value_fields_include"] = kafka_value_fields_include
            __props__.__dict__["kafka_value_format"] = kafka_value_format
            __props__.__dict__["like_options"] = like_options
            __props__.__dict__["opensearch_index"] = opensearch_index
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if schema_sql is None and not opts.urn:
                raise TypeError("Missing required property 'schema_sql'")
            __props__.__dict__["schema_sql"] = schema_sql
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if table_name is None and not opts.urn:
                raise TypeError("Missing required property 'table_name'")
            __props__.__dict__["table_name"] = table_name
            __props__.__dict__["upsert_kafka"] = upsert_kafka
            __props__.__dict__["table_id"] = None
        super(FlinkJobTable, __self__).__init__(
            'aiven:index/flinkJobTable:FlinkJobTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            integration_id: Optional[pulumi.Input[str]] = None,
            jdbc_table: Optional[pulumi.Input[str]] = None,
            kafka_connector_type: Optional[pulumi.Input[str]] = None,
            kafka_key_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            kafka_key_format: Optional[pulumi.Input[str]] = None,
            kafka_startup_mode: Optional[pulumi.Input[str]] = None,
            kafka_topic: Optional[pulumi.Input[str]] = None,
            kafka_value_fields_include: Optional[pulumi.Input[str]] = None,
            kafka_value_format: Optional[pulumi.Input[str]] = None,
            like_options: Optional[pulumi.Input[str]] = None,
            opensearch_index: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            schema_sql: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            table_id: Optional[pulumi.Input[str]] = None,
            table_name: Optional[pulumi.Input[str]] = None,
            upsert_kafka: Optional[pulumi.Input[pulumi.InputType['FlinkJobTableUpsertKafkaArgs']]] = None) -> 'FlinkJobTable':
        """
        Get an existing FlinkJobTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] integration_id: The id of the service integration that is used with this table. It must have the service integration type `flink`. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] jdbc_table: Name of the jdbc table that is to be connected to this table. Valid if the service integration id refers to a mysql or postgres service. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_connector_type: When used as a source, upsert Kafka connectors update values that use an existing key and delete values that are null. For sinks, the connector correspondingly writes update or delete messages in a compacted topic. If no matching key is found, the values are added as new entries. For more information, see the Apache Flink documentation The possible values are `kafka` and `upsert-kafka`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kafka_key_fields: Defines an explicit list of physical columns from the table schema that configure the data type for the key format. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_key_format: Kafka Key Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_startup_mode: Startup mode The possible values are `earliest-offset`, `latest-offset`, `group-offsets` and `timestamp`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_topic: Name of the kafka topic that is to be connected to this table. Valid if the service integration id refers to a kafka service. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_value_fields_include: Controls how key columns are handled in the message value. Select ALL to include the physical columns of the table schema in the message value. Select EXCEPT_KEY to exclude the physical columns of the table schema from the message value. This is the default for upsert Kafka connectors. The possible values are `[ALL EXCEPT_KEY]`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] kafka_value_format: Kafka Value Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] like_options: [LIKE](https://nightlies.apache.org/flink/flink-docs-master/docs/dev/table/sql/create/#like) statement for table creation. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] opensearch_index: For an OpenSearch table, the OpenSearch index the table outputs to. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] schema_sql: The SQL statement to create the table. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] table_id: The Table ID of the flink table in the flink service.
        :param pulumi.Input[str] table_name: Specifies the name of the table. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[pulumi.InputType['FlinkJobTableUpsertKafkaArgs']] upsert_kafka: Kafka upsert connector configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlinkJobTableState.__new__(_FlinkJobTableState)

        __props__.__dict__["integration_id"] = integration_id
        __props__.__dict__["jdbc_table"] = jdbc_table
        __props__.__dict__["kafka_connector_type"] = kafka_connector_type
        __props__.__dict__["kafka_key_fields"] = kafka_key_fields
        __props__.__dict__["kafka_key_format"] = kafka_key_format
        __props__.__dict__["kafka_startup_mode"] = kafka_startup_mode
        __props__.__dict__["kafka_topic"] = kafka_topic
        __props__.__dict__["kafka_value_fields_include"] = kafka_value_fields_include
        __props__.__dict__["kafka_value_format"] = kafka_value_format
        __props__.__dict__["like_options"] = like_options
        __props__.__dict__["opensearch_index"] = opensearch_index
        __props__.__dict__["project"] = project
        __props__.__dict__["schema_sql"] = schema_sql
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["table_id"] = table_id
        __props__.__dict__["table_name"] = table_name
        __props__.__dict__["upsert_kafka"] = upsert_kafka
        return FlinkJobTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> pulumi.Output[str]:
        """
        The id of the service integration that is used with this table. It must have the service integration type `flink`. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "integration_id")

    @property
    @pulumi.getter(name="jdbcTable")
    def jdbc_table(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the jdbc table that is to be connected to this table. Valid if the service integration id refers to a mysql or postgres service. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "jdbc_table")

    @property
    @pulumi.getter(name="kafkaConnectorType")
    def kafka_connector_type(self) -> pulumi.Output[Optional[str]]:
        """
        When used as a source, upsert Kafka connectors update values that use an existing key and delete values that are null. For sinks, the connector correspondingly writes update or delete messages in a compacted topic. If no matching key is found, the values are added as new entries. For more information, see the Apache Flink documentation The possible values are `kafka` and `upsert-kafka`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_connector_type")

    @property
    @pulumi.getter(name="kafkaKeyFields")
    def kafka_key_fields(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Defines an explicit list of physical columns from the table schema that configure the data type for the key format. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_key_fields")

    @property
    @pulumi.getter(name="kafkaKeyFormat")
    def kafka_key_format(self) -> pulumi.Output[Optional[str]]:
        """
        Kafka Key Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_key_format")

    @property
    @pulumi.getter(name="kafkaStartupMode")
    def kafka_startup_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Startup mode The possible values are `earliest-offset`, `latest-offset`, `group-offsets` and `timestamp`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_startup_mode")

    @property
    @pulumi.getter(name="kafkaTopic")
    def kafka_topic(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the kafka topic that is to be connected to this table. Valid if the service integration id refers to a kafka service. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_topic")

    @property
    @pulumi.getter(name="kafkaValueFieldsInclude")
    def kafka_value_fields_include(self) -> pulumi.Output[Optional[str]]:
        """
        Controls how key columns are handled in the message value. Select ALL to include the physical columns of the table schema in the message value. Select EXCEPT_KEY to exclude the physical columns of the table schema from the message value. This is the default for upsert Kafka connectors. The possible values are `[ALL EXCEPT_KEY]`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_value_fields_include")

    @property
    @pulumi.getter(name="kafkaValueFormat")
    def kafka_value_format(self) -> pulumi.Output[Optional[str]]:
        """
        Kafka Value Format The possible values are `avro`, `avro-confluent`, `debezium-avro-confluent`, `debezium-json` and `json`. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "kafka_value_format")

    @property
    @pulumi.getter(name="likeOptions")
    def like_options(self) -> pulumi.Output[Optional[str]]:
        """
        [LIKE](https://nightlies.apache.org/flink/flink-docs-master/docs/dev/table/sql/create/#like) statement for table creation. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "like_options")

    @property
    @pulumi.getter(name="opensearchIndex")
    def opensearch_index(self) -> pulumi.Output[Optional[str]]:
        """
        For an OpenSearch table, the OpenSearch index the table outputs to. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "opensearch_index")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="schemaSql")
    def schema_sql(self) -> pulumi.Output[str]:
        """
        The SQL statement to create the table. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "schema_sql")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Output[str]:
        """
        The Table ID of the flink table in the flink service.
        """
        return pulumi.get(self, "table_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the table. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="upsertKafka")
    def upsert_kafka(self) -> pulumi.Output[Optional['outputs.FlinkJobTableUpsertKafka']]:
        """
        Kafka upsert connector configuration.
        """
        return pulumi.get(self, "upsert_kafka")

