# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAwsPrivatelinkResult',
    'AwaitableGetAwsPrivatelinkResult',
    'get_aws_privatelink',
    'get_aws_privatelink_output',
]

@pulumi.output_type
class GetAwsPrivatelinkResult:
    """
    A collection of values returned by getAwsPrivatelink.
    """
    def __init__(__self__, aws_service_id=None, aws_service_name=None, id=None, principals=None, project=None, service_name=None):
        if aws_service_id and not isinstance(aws_service_id, str):
            raise TypeError("Expected argument 'aws_service_id' to be a str")
        pulumi.set(__self__, "aws_service_id", aws_service_id)
        if aws_service_name and not isinstance(aws_service_name, str):
            raise TypeError("Expected argument 'aws_service_name' to be a str")
        pulumi.set(__self__, "aws_service_name", aws_service_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if principals and not isinstance(principals, list):
            raise TypeError("Expected argument 'principals' to be a list")
        pulumi.set(__self__, "principals", principals)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="awsServiceId")
    def aws_service_id(self) -> str:
        """
        AWS service ID
        """
        return pulumi.get(self, "aws_service_id")

    @property
    @pulumi.getter(name="awsServiceName")
    def aws_service_name(self) -> str:
        """
        AWS service name
        """
        return pulumi.get(self, "aws_service_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def principals(self) -> Sequence[str]:
        """
        List of allowed principals
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetAwsPrivatelinkResult(GetAwsPrivatelinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsPrivatelinkResult(
            aws_service_id=self.aws_service_id,
            aws_service_name=self.aws_service_name,
            id=self.id,
            principals=self.principals,
            project=self.project,
            service_name=self.service_name)


def get_aws_privatelink(project: Optional[str] = None,
                        service_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsPrivatelinkResult:
    """
    The AWS Privatelink resource allows the creation and management of Aiven AWS Privatelink for a services.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    foo = aiven.get_aws_privatelink(project=data["aiven_project"]["foo"]["project"],
        service_name=aiven_kafka["bar"]["service_name"])
    ```


    :param str project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getAwsPrivatelink:getAwsPrivatelink', __args__, opts=opts, typ=GetAwsPrivatelinkResult).value

    return AwaitableGetAwsPrivatelinkResult(
        aws_service_id=__ret__.aws_service_id,
        aws_service_name=__ret__.aws_service_name,
        id=__ret__.id,
        principals=__ret__.principals,
        project=__ret__.project,
        service_name=__ret__.service_name)


@_utilities.lift_output_func(get_aws_privatelink)
def get_aws_privatelink_output(project: Optional[pulumi.Input[str]] = None,
                               service_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAwsPrivatelinkResult]:
    """
    The AWS Privatelink resource allows the creation and management of Aiven AWS Privatelink for a services.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    foo = aiven.get_aws_privatelink(project=data["aiven_project"]["foo"]["project"],
        service_name=aiven_kafka["bar"]["service_name"])
    ```


    :param str project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    """
    ...
