# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetConnectionPoolResult',
    'AwaitableGetConnectionPoolResult',
    'get_connection_pool',
    'get_connection_pool_output',
]

@pulumi.output_type
class GetConnectionPoolResult:
    """
    A collection of values returned by getConnectionPool.
    """
    def __init__(__self__, connection_uri=None, database_name=None, id=None, pool_mode=None, pool_name=None, pool_size=None, project=None, service_name=None, username=None):
        if connection_uri and not isinstance(connection_uri, str):
            raise TypeError("Expected argument 'connection_uri' to be a str")
        pulumi.set(__self__, "connection_uri", connection_uri)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pool_mode and not isinstance(pool_mode, str):
            raise TypeError("Expected argument 'pool_mode' to be a str")
        pulumi.set(__self__, "pool_mode", pool_mode)
        if pool_name and not isinstance(pool_name, str):
            raise TypeError("Expected argument 'pool_name' to be a str")
        pulumi.set(__self__, "pool_name", pool_name)
        if pool_size and not isinstance(pool_size, int):
            raise TypeError("Expected argument 'pool_size' to be a int")
        pulumi.set(__self__, "pool_size", pool_size)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="connectionUri")
    def connection_uri(self) -> str:
        """
        The URI for connecting to the pool
        """
        return pulumi.get(self, "connection_uri")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of the database the pool connects to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="poolMode")
    def pool_mode(self) -> str:
        """
        The mode the pool operates in The possible values are `session`, `transaction` and `statement`. The default value is `transaction`.
        """
        return pulumi.get(self, "pool_mode")

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> str:
        """
        The name of the created pool. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "pool_name")

    @property
    @pulumi.getter(name="poolSize")
    def pool_size(self) -> int:
        """
        The number of connections the pool may create towards the backend server. This does not affect the number of incoming connections, which is always a much larger number. The default value is `10`.
        """
        return pulumi.get(self, "pool_size")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The name of the service user used to connect to the database. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "username")


class AwaitableGetConnectionPoolResult(GetConnectionPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionPoolResult(
            connection_uri=self.connection_uri,
            database_name=self.database_name,
            id=self.id,
            pool_mode=self.pool_mode,
            pool_name=self.pool_name,
            pool_size=self.pool_size,
            project=self.project,
            service_name=self.service_name,
            username=self.username)


def get_connection_pool(pool_name: Optional[str] = None,
                        project: Optional[str] = None,
                        service_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionPoolResult:
    """
    The Connection Pool data source provides information about the existing Aiven Connection Pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    mytestpool = aiven.get_connection_pool(project=aiven_project["myproject"]["project"],
        service_name=aiven_pg["mypg"]["service_name"],
        pool_name="mypool")
    ```


    :param str pool_name: The name of the created pool. This property cannot be changed, doing so forces recreation of the resource.
    :param str project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    """
    __args__ = dict()
    __args__['poolName'] = pool_name
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getConnectionPool:getConnectionPool', __args__, opts=opts, typ=GetConnectionPoolResult).value

    return AwaitableGetConnectionPoolResult(
        connection_uri=__ret__.connection_uri,
        database_name=__ret__.database_name,
        id=__ret__.id,
        pool_mode=__ret__.pool_mode,
        pool_name=__ret__.pool_name,
        pool_size=__ret__.pool_size,
        project=__ret__.project,
        service_name=__ret__.service_name,
        username=__ret__.username)


@_utilities.lift_output_func(get_connection_pool)
def get_connection_pool_output(pool_name: Optional[pulumi.Input[str]] = None,
                               project: Optional[pulumi.Input[str]] = None,
                               service_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionPoolResult]:
    """
    The Connection Pool data source provides information about the existing Aiven Connection Pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    mytestpool = aiven.get_connection_pool(project=aiven_project["myproject"]["project"],
        service_name=aiven_pg["mypg"]["service_name"],
        pool_name="mypool")
    ```


    :param str pool_name: The name of the created pool. This property cannot be changed, doing so forces recreation of the resource.
    :param str project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    """
    ...
