# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KafkaConnectorArgs', 'KafkaConnector']

@pulumi.input_type
class KafkaConnectorArgs:
    def __init__(__self__, *,
                 config: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 connector_name: pulumi.Input[str],
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a KafkaConnector resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: The Kafka Connector configuration parameters.
        :param pulumi.Input[str] connector_name: The kafka connector name. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "connector_name", connector_name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        The Kafka Connector configuration parameters.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> pulumi.Input[str]:
        """
        The kafka connector name. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "connector_name")

    @connector_name.setter
    def connector_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connector_name", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _KafkaConnectorState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 connector_name: Optional[pulumi.Input[str]] = None,
                 plugin_author: Optional[pulumi.Input[str]] = None,
                 plugin_class: Optional[pulumi.Input[str]] = None,
                 plugin_doc_url: Optional[pulumi.Input[str]] = None,
                 plugin_title: Optional[pulumi.Input[str]] = None,
                 plugin_type: Optional[pulumi.Input[str]] = None,
                 plugin_version: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaConnectorTaskArgs']]]] = None):
        """
        Input properties used for looking up and filtering KafkaConnector resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: The Kafka Connector configuration parameters.
        :param pulumi.Input[str] connector_name: The kafka connector name. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] plugin_author: The Kafka connector author.
        :param pulumi.Input[str] plugin_class: The Kafka connector Java class.
        :param pulumi.Input[str] plugin_doc_url: The Kafka connector documentation URL.
        :param pulumi.Input[str] plugin_title: The Kafka connector title.
        :param pulumi.Input[str] plugin_type: The Kafka connector type.
        :param pulumi.Input[str] plugin_version: The version of the kafka connector.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaConnectorTaskArgs']]] tasks: List of tasks of a connector.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if connector_name is not None:
            pulumi.set(__self__, "connector_name", connector_name)
        if plugin_author is not None:
            pulumi.set(__self__, "plugin_author", plugin_author)
        if plugin_class is not None:
            pulumi.set(__self__, "plugin_class", plugin_class)
        if plugin_doc_url is not None:
            pulumi.set(__self__, "plugin_doc_url", plugin_doc_url)
        if plugin_title is not None:
            pulumi.set(__self__, "plugin_title", plugin_title)
        if plugin_type is not None:
            pulumi.set(__self__, "plugin_type", plugin_type)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Kafka Connector configuration parameters.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> Optional[pulumi.Input[str]]:
        """
        The kafka connector name. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "connector_name")

    @connector_name.setter
    def connector_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_name", value)

    @property
    @pulumi.getter(name="pluginAuthor")
    def plugin_author(self) -> Optional[pulumi.Input[str]]:
        """
        The Kafka connector author.
        """
        return pulumi.get(self, "plugin_author")

    @plugin_author.setter
    def plugin_author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_author", value)

    @property
    @pulumi.getter(name="pluginClass")
    def plugin_class(self) -> Optional[pulumi.Input[str]]:
        """
        The Kafka connector Java class.
        """
        return pulumi.get(self, "plugin_class")

    @plugin_class.setter
    def plugin_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_class", value)

    @property
    @pulumi.getter(name="pluginDocUrl")
    def plugin_doc_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Kafka connector documentation URL.
        """
        return pulumi.get(self, "plugin_doc_url")

    @plugin_doc_url.setter
    def plugin_doc_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_doc_url", value)

    @property
    @pulumi.getter(name="pluginTitle")
    def plugin_title(self) -> Optional[pulumi.Input[str]]:
        """
        The Kafka connector title.
        """
        return pulumi.get(self, "plugin_title")

    @plugin_title.setter
    def plugin_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_title", value)

    @property
    @pulumi.getter(name="pluginType")
    def plugin_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Kafka connector type.
        """
        return pulumi.get(self, "plugin_type")

    @plugin_type.setter
    def plugin_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_type", value)

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the kafka connector.
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_version", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaConnectorTaskArgs']]]]:
        """
        List of tasks of a connector.
        """
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaConnectorTaskArgs']]]]):
        pulumi.set(self, "tasks", value)


class KafkaConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 connector_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The Kafka connectors resource allows the creation and management of Aiven Kafka connectors.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        kafka_os_con1 = aiven.KafkaConnector("kafka-os-con1",
            project=aiven_project["kafka-con-project1"]["project"],
            service_name=aiven_kafka["kafka-service1"]["service_name"],
            connector_name="kafka-os-con1",
            config={
                "topics": aiven_kafka_topic["kafka-topic1"]["topic_name"],
                "connector.class": "io.aiven.kafka.connect.opensearch.OpensearchSinkConnector",
                "type.name": "os-connector",
                "name": "kafka-os-con1",
                "connection.url": aiven_elasticsearch["os-service1"]["service_uri"],
                "connection.username": aiven_opensearch["os-service1"]["service_username"],
                "connection.password": aiven_opensearch["os-service1"]["service_password"],
            })
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/kafkaConnector:KafkaConnector kafka-os-con1 project/service_name/connector_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: The Kafka Connector configuration parameters.
        :param pulumi.Input[str] connector_name: The kafka connector name. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Kafka connectors resource allows the creation and management of Aiven Kafka connectors.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        kafka_os_con1 = aiven.KafkaConnector("kafka-os-con1",
            project=aiven_project["kafka-con-project1"]["project"],
            service_name=aiven_kafka["kafka-service1"]["service_name"],
            connector_name="kafka-os-con1",
            config={
                "topics": aiven_kafka_topic["kafka-topic1"]["topic_name"],
                "connector.class": "io.aiven.kafka.connect.opensearch.OpensearchSinkConnector",
                "type.name": "os-connector",
                "name": "kafka-os-con1",
                "connection.url": aiven_elasticsearch["os-service1"]["service_uri"],
                "connection.username": aiven_opensearch["os-service1"]["service_username"],
                "connection.password": aiven_opensearch["os-service1"]["service_password"],
            })
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/kafkaConnector:KafkaConnector kafka-os-con1 project/service_name/connector_name
        ```

        :param str resource_name: The name of the resource.
        :param KafkaConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 connector_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaConnectorArgs.__new__(KafkaConnectorArgs)

            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = None if config is None else pulumi.Output.secret(config)
            if connector_name is None and not opts.urn:
                raise TypeError("Missing required property 'connector_name'")
            __props__.__dict__["connector_name"] = connector_name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["plugin_author"] = None
            __props__.__dict__["plugin_class"] = None
            __props__.__dict__["plugin_doc_url"] = None
            __props__.__dict__["plugin_title"] = None
            __props__.__dict__["plugin_type"] = None
            __props__.__dict__["plugin_version"] = None
            __props__.__dict__["tasks"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["config"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(KafkaConnector, __self__).__init__(
            'aiven:index/kafkaConnector:KafkaConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            connector_name: Optional[pulumi.Input[str]] = None,
            plugin_author: Optional[pulumi.Input[str]] = None,
            plugin_class: Optional[pulumi.Input[str]] = None,
            plugin_doc_url: Optional[pulumi.Input[str]] = None,
            plugin_title: Optional[pulumi.Input[str]] = None,
            plugin_type: Optional[pulumi.Input[str]] = None,
            plugin_version: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            tasks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaConnectorTaskArgs']]]]] = None) -> 'KafkaConnector':
        """
        Get an existing KafkaConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: The Kafka Connector configuration parameters.
        :param pulumi.Input[str] connector_name: The kafka connector name. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] plugin_author: The Kafka connector author.
        :param pulumi.Input[str] plugin_class: The Kafka connector Java class.
        :param pulumi.Input[str] plugin_doc_url: The Kafka connector documentation URL.
        :param pulumi.Input[str] plugin_title: The Kafka connector title.
        :param pulumi.Input[str] plugin_type: The Kafka connector type.
        :param pulumi.Input[str] plugin_version: The version of the kafka connector.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaConnectorTaskArgs']]]] tasks: List of tasks of a connector.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaConnectorState.__new__(_KafkaConnectorState)

        __props__.__dict__["config"] = config
        __props__.__dict__["connector_name"] = connector_name
        __props__.__dict__["plugin_author"] = plugin_author
        __props__.__dict__["plugin_class"] = plugin_class
        __props__.__dict__["plugin_doc_url"] = plugin_doc_url
        __props__.__dict__["plugin_title"] = plugin_title
        __props__.__dict__["plugin_type"] = plugin_type
        __props__.__dict__["plugin_version"] = plugin_version
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["tasks"] = tasks
        return KafkaConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The Kafka Connector configuration parameters.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> pulumi.Output[str]:
        """
        The kafka connector name. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "connector_name")

    @property
    @pulumi.getter(name="pluginAuthor")
    def plugin_author(self) -> pulumi.Output[str]:
        """
        The Kafka connector author.
        """
        return pulumi.get(self, "plugin_author")

    @property
    @pulumi.getter(name="pluginClass")
    def plugin_class(self) -> pulumi.Output[str]:
        """
        The Kafka connector Java class.
        """
        return pulumi.get(self, "plugin_class")

    @property
    @pulumi.getter(name="pluginDocUrl")
    def plugin_doc_url(self) -> pulumi.Output[str]:
        """
        The Kafka connector documentation URL.
        """
        return pulumi.get(self, "plugin_doc_url")

    @property
    @pulumi.getter(name="pluginTitle")
    def plugin_title(self) -> pulumi.Output[str]:
        """
        The Kafka connector title.
        """
        return pulumi.get(self, "plugin_title")

    @property
    @pulumi.getter(name="pluginType")
    def plugin_type(self) -> pulumi.Output[str]:
        """
        The Kafka connector type.
        """
        return pulumi.get(self, "plugin_type")

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> pulumi.Output[str]:
        """
        The version of the kafka connector.
        """
        return pulumi.get(self, "plugin_version")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def tasks(self) -> pulumi.Output[Sequence['outputs.KafkaConnectorTask']]:
        """
        List of tasks of a connector.
        """
        return pulumi.get(self, "tasks")

