# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KafkaTopicArgs', 'KafkaTopic']

@pulumi.input_type
class KafkaTopicArgs:
    def __init__(__self__, *,
                 partitions: pulumi.Input[int],
                 project: pulumi.Input[str],
                 replication: pulumi.Input[int],
                 service_name: pulumi.Input[str],
                 topic_name: pulumi.Input[str],
                 config: Optional[pulumi.Input['KafkaTopicConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicTagArgs']]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a KafkaTopic resource.
        :param pulumi.Input[int] partitions: The number of partitions to create in the topic.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[int] replication: The replication factor for the topic.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] topic_name: The name of the topic. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input['KafkaTopicConfigArgs'] config: Kafka topic configuration
        :param pulumi.Input[Sequence[pulumi.Input['KafkaTopicTagArgs']]] tags: Kafka Topic tag.
        :param pulumi.Input[bool] termination_protection: It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
               enable this for any production Kafka topic containing critical data.
        """
        pulumi.set(__self__, "partitions", partitions)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "replication", replication)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "topic_name", topic_name)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Input[int]:
        """
        The number of partitions to create in the topic.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: pulumi.Input[int]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def replication(self) -> pulumi.Input[int]:
        """
        The replication factor for the topic.
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: pulumi.Input[int]):
        pulumi.set(self, "replication", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Input[str]:
        """
        The name of the topic. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_name", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['KafkaTopicConfigArgs']]:
        """
        Kafka topic configuration
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['KafkaTopicConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicTagArgs']]]]:
        """
        Kafka Topic tag.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
        enable this for any production Kafka topic containing critical data.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)


@pulumi.input_type
class _KafkaTopicState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['KafkaTopicConfigArgs']] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replication: Optional[pulumi.Input[int]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicTagArgs']]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KafkaTopic resources.
        :param pulumi.Input['KafkaTopicConfigArgs'] config: Kafka topic configuration
        :param pulumi.Input[int] partitions: The number of partitions to create in the topic.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[int] replication: The replication factor for the topic.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaTopicTagArgs']]] tags: Kafka Topic tag.
        :param pulumi.Input[bool] termination_protection: It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
               enable this for any production Kafka topic containing critical data.
        :param pulumi.Input[str] topic_name: The name of the topic. This property cannot be changed, doing so forces recreation of the resource.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)
        if topic_name is not None:
            pulumi.set(__self__, "topic_name", topic_name)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['KafkaTopicConfigArgs']]:
        """
        Kafka topic configuration
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['KafkaTopicConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[int]]:
        """
        The number of partitions to create in the topic.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input[int]]:
        """
        The replication factor for the topic.
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replication", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicTagArgs']]]]:
        """
        Kafka Topic tag.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
        enable this for any production Kafka topic containing critical data.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the topic. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_name", value)


class KafkaTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['KafkaTopicConfigArgs']]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replication: Optional[pulumi.Input[int]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaTopicTagArgs']]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The Kafka Topic resource allows the creation and management of Aiven Kafka Topics.

        ## Import

        ```sh
         $ pulumi import aiven:index/kafkaTopic:KafkaTopic mytesttopic project/service_name/topic_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['KafkaTopicConfigArgs']] config: Kafka topic configuration
        :param pulumi.Input[int] partitions: The number of partitions to create in the topic.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[int] replication: The replication factor for the topic.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaTopicTagArgs']]]] tags: Kafka Topic tag.
        :param pulumi.Input[bool] termination_protection: It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
               enable this for any production Kafka topic containing critical data.
        :param pulumi.Input[str] topic_name: The name of the topic. This property cannot be changed, doing so forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Kafka Topic resource allows the creation and management of Aiven Kafka Topics.

        ## Import

        ```sh
         $ pulumi import aiven:index/kafkaTopic:KafkaTopic mytesttopic project/service_name/topic_name
        ```

        :param str resource_name: The name of the resource.
        :param KafkaTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['KafkaTopicConfigArgs']]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replication: Optional[pulumi.Input[int]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaTopicTagArgs']]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaTopicArgs.__new__(KafkaTopicArgs)

            __props__.__dict__["config"] = config
            if partitions is None and not opts.urn:
                raise TypeError("Missing required property 'partitions'")
            __props__.__dict__["partitions"] = partitions
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if replication is None and not opts.urn:
                raise TypeError("Missing required property 'replication'")
            __props__.__dict__["replication"] = replication
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_protection"] = termination_protection
            if topic_name is None and not opts.urn:
                raise TypeError("Missing required property 'topic_name'")
            __props__.__dict__["topic_name"] = topic_name
        super(KafkaTopic, __self__).__init__(
            'aiven:index/kafkaTopic:KafkaTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[pulumi.InputType['KafkaTopicConfigArgs']]] = None,
            partitions: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            replication: Optional[pulumi.Input[int]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaTopicTagArgs']]]]] = None,
            termination_protection: Optional[pulumi.Input[bool]] = None,
            topic_name: Optional[pulumi.Input[str]] = None) -> 'KafkaTopic':
        """
        Get an existing KafkaTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['KafkaTopicConfigArgs']] config: Kafka topic configuration
        :param pulumi.Input[int] partitions: The number of partitions to create in the topic.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[int] replication: The replication factor for the topic.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaTopicTagArgs']]]] tags: Kafka Topic tag.
        :param pulumi.Input[bool] termination_protection: It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
               enable this for any production Kafka topic containing critical data.
        :param pulumi.Input[str] topic_name: The name of the topic. This property cannot be changed, doing so forces recreation of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaTopicState.__new__(_KafkaTopicState)

        __props__.__dict__["config"] = config
        __props__.__dict__["partitions"] = partitions
        __props__.__dict__["project"] = project
        __props__.__dict__["replication"] = replication
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["termination_protection"] = termination_protection
        __props__.__dict__["topic_name"] = topic_name
        return KafkaTopic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.KafkaTopicConfig']]:
        """
        Kafka topic configuration
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[int]:
        """
        The number of partitions to create in the topic.
        """
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def replication(self) -> pulumi.Output[int]:
        """
        The replication factor for the topic.
        """
        return pulumi.get(self, "replication")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.KafkaTopicTag']]]:
        """
        Kafka Topic tag.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
        enable this for any production Kafka topic containing critical data.
        """
        return pulumi.get(self, "termination_protection")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Output[str]:
        """
        The name of the topic. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "topic_name")

