# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceIntegrationArgs', 'ServiceIntegration']

@pulumi.input_type
class ServiceIntegrationArgs:
    def __init__(__self__, *,
                 integration_type: pulumi.Input[str],
                 project: pulumi.Input[str],
                 clickhouse_kafka_user_config: Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']] = None,
                 clickhouse_postgresql_user_config: Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']] = None,
                 datadog_user_config: Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']] = None,
                 destination_endpoint_id: Optional[pulumi.Input[str]] = None,
                 destination_service_name: Optional[pulumi.Input[str]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']] = None,
                 kafka_logs_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']] = None,
                 logs_user_config: Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']] = None,
                 metrics_user_config: Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']] = None,
                 mirrormaker_user_config: Optional[pulumi.Input['ServiceIntegrationMirrormakerUserConfigArgs']] = None,
                 source_endpoint_id: Optional[pulumi.Input[str]] = None,
                 source_service_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServiceIntegration resource.
        :param pulumi.Input[str] integration_type: Type of the service integration
        :param pulumi.Input[str] project: Project the integration belongs to
        :param pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs'] clickhouse_kafka_user_config: ClickhouseKafka user configurable settings
        :param pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs'] clickhouse_postgresql_user_config: ClickhousePostgresql user configurable settings
        :param pulumi.Input['ServiceIntegrationDatadogUserConfigArgs'] datadog_user_config: Datadog user configurable settings
        :param pulumi.Input[str] destination_endpoint_id: Destination endpoint for the integration (if any)
        :param pulumi.Input[str] destination_service_name: Destination service for the integration (if any)
        :param pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs'] kafka_connect_user_config: KafkaConnect user configurable settings
        :param pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs'] kafka_logs_user_config: KafkaLogs user configurable settings
        :param pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs'] kafka_mirrormaker_user_config: KafkaMirrormaker user configurable settings
        :param pulumi.Input['ServiceIntegrationLogsUserConfigArgs'] logs_user_config: Logs user configurable settings
        :param pulumi.Input['ServiceIntegrationMetricsUserConfigArgs'] metrics_user_config: Metrics user configurable settings
        :param pulumi.Input['ServiceIntegrationMirrormakerUserConfigArgs'] mirrormaker_user_config: Mirrormaker user configurable settings
        :param pulumi.Input[str] source_endpoint_id: Source endpoint for the integration (if any)
        :param pulumi.Input[str] source_service_name: Source service for the integration (if any)
        """
        pulumi.set(__self__, "integration_type", integration_type)
        pulumi.set(__self__, "project", project)
        if clickhouse_kafka_user_config is not None:
            pulumi.set(__self__, "clickhouse_kafka_user_config", clickhouse_kafka_user_config)
        if clickhouse_postgresql_user_config is not None:
            pulumi.set(__self__, "clickhouse_postgresql_user_config", clickhouse_postgresql_user_config)
        if datadog_user_config is not None:
            pulumi.set(__self__, "datadog_user_config", datadog_user_config)
        if destination_endpoint_id is not None:
            pulumi.set(__self__, "destination_endpoint_id", destination_endpoint_id)
        if destination_service_name is not None:
            pulumi.set(__self__, "destination_service_name", destination_service_name)
        if kafka_connect_user_config is not None:
            pulumi.set(__self__, "kafka_connect_user_config", kafka_connect_user_config)
        if kafka_logs_user_config is not None:
            pulumi.set(__self__, "kafka_logs_user_config", kafka_logs_user_config)
        if kafka_mirrormaker_user_config is not None:
            pulumi.set(__self__, "kafka_mirrormaker_user_config", kafka_mirrormaker_user_config)
        if logs_user_config is not None:
            pulumi.set(__self__, "logs_user_config", logs_user_config)
        if metrics_user_config is not None:
            pulumi.set(__self__, "metrics_user_config", metrics_user_config)
        if mirrormaker_user_config is not None:
            pulumi.set(__self__, "mirrormaker_user_config", mirrormaker_user_config)
        if source_endpoint_id is not None:
            pulumi.set(__self__, "source_endpoint_id", source_endpoint_id)
        if source_service_name is not None:
            pulumi.set(__self__, "source_service_name", source_service_name)

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Input[str]:
        """
        Type of the service integration
        """
        return pulumi.get(self, "integration_type")

    @integration_type.setter
    def integration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "integration_type", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Project the integration belongs to
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="clickhouseKafkaUserConfig")
    def clickhouse_kafka_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']]:
        """
        ClickhouseKafka user configurable settings
        """
        return pulumi.get(self, "clickhouse_kafka_user_config")

    @clickhouse_kafka_user_config.setter
    def clickhouse_kafka_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']]):
        pulumi.set(self, "clickhouse_kafka_user_config", value)

    @property
    @pulumi.getter(name="clickhousePostgresqlUserConfig")
    def clickhouse_postgresql_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]:
        """
        ClickhousePostgresql user configurable settings
        """
        return pulumi.get(self, "clickhouse_postgresql_user_config")

    @clickhouse_postgresql_user_config.setter
    def clickhouse_postgresql_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]):
        pulumi.set(self, "clickhouse_postgresql_user_config", value)

    @property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']]:
        """
        Datadog user configurable settings
        """
        return pulumi.get(self, "datadog_user_config")

    @datadog_user_config.setter
    def datadog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']]):
        pulumi.set(self, "datadog_user_config", value)

    @property
    @pulumi.getter(name="destinationEndpointId")
    def destination_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        Destination endpoint for the integration (if any)
        """
        return pulumi.get(self, "destination_endpoint_id")

    @destination_endpoint_id.setter
    def destination_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_id", value)

    @property
    @pulumi.getter(name="destinationServiceName")
    def destination_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Destination service for the integration (if any)
        """
        return pulumi.get(self, "destination_service_name")

    @destination_service_name.setter
    def destination_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_service_name", value)

    @property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']]:
        """
        KafkaConnect user configurable settings
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @kafka_connect_user_config.setter
    def kafka_connect_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']]):
        pulumi.set(self, "kafka_connect_user_config", value)

    @property
    @pulumi.getter(name="kafkaLogsUserConfig")
    def kafka_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']]:
        """
        KafkaLogs user configurable settings
        """
        return pulumi.get(self, "kafka_logs_user_config")

    @kafka_logs_user_config.setter
    def kafka_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']]):
        pulumi.set(self, "kafka_logs_user_config", value)

    @property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]:
        """
        KafkaMirrormaker user configurable settings
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @kafka_mirrormaker_user_config.setter
    def kafka_mirrormaker_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]):
        pulumi.set(self, "kafka_mirrormaker_user_config", value)

    @property
    @pulumi.getter(name="logsUserConfig")
    def logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']]:
        """
        Logs user configurable settings
        """
        return pulumi.get(self, "logs_user_config")

    @logs_user_config.setter
    def logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']]):
        pulumi.set(self, "logs_user_config", value)

    @property
    @pulumi.getter(name="metricsUserConfig")
    def metrics_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']]:
        """
        Metrics user configurable settings
        """
        return pulumi.get(self, "metrics_user_config")

    @metrics_user_config.setter
    def metrics_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']]):
        pulumi.set(self, "metrics_user_config", value)

    @property
    @pulumi.getter(name="mirrormakerUserConfig")
    def mirrormaker_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationMirrormakerUserConfigArgs']]:
        """
        Mirrormaker user configurable settings
        """
        return pulumi.get(self, "mirrormaker_user_config")

    @mirrormaker_user_config.setter
    def mirrormaker_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationMirrormakerUserConfigArgs']]):
        pulumi.set(self, "mirrormaker_user_config", value)

    @property
    @pulumi.getter(name="sourceEndpointId")
    def source_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        Source endpoint for the integration (if any)
        """
        return pulumi.get(self, "source_endpoint_id")

    @source_endpoint_id.setter
    def source_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_id", value)

    @property
    @pulumi.getter(name="sourceServiceName")
    def source_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Source service for the integration (if any)
        """
        return pulumi.get(self, "source_service_name")

    @source_service_name.setter
    def source_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_service_name", value)


@pulumi.input_type
class _ServiceIntegrationState:
    def __init__(__self__, *,
                 clickhouse_kafka_user_config: Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']] = None,
                 clickhouse_postgresql_user_config: Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']] = None,
                 datadog_user_config: Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']] = None,
                 destination_endpoint_id: Optional[pulumi.Input[str]] = None,
                 destination_service_name: Optional[pulumi.Input[str]] = None,
                 integration_id: Optional[pulumi.Input[str]] = None,
                 integration_type: Optional[pulumi.Input[str]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']] = None,
                 kafka_logs_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']] = None,
                 logs_user_config: Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']] = None,
                 metrics_user_config: Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']] = None,
                 mirrormaker_user_config: Optional[pulumi.Input['ServiceIntegrationMirrormakerUserConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_endpoint_id: Optional[pulumi.Input[str]] = None,
                 source_service_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceIntegration resources.
        :param pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs'] clickhouse_kafka_user_config: ClickhouseKafka user configurable settings
        :param pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs'] clickhouse_postgresql_user_config: ClickhousePostgresql user configurable settings
        :param pulumi.Input['ServiceIntegrationDatadogUserConfigArgs'] datadog_user_config: Datadog user configurable settings
        :param pulumi.Input[str] destination_endpoint_id: Destination endpoint for the integration (if any)
        :param pulumi.Input[str] destination_service_name: Destination service for the integration (if any)
        :param pulumi.Input[str] integration_id: Service Integration Id at aiven
        :param pulumi.Input[str] integration_type: Type of the service integration
        :param pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs'] kafka_connect_user_config: KafkaConnect user configurable settings
        :param pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs'] kafka_logs_user_config: KafkaLogs user configurable settings
        :param pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs'] kafka_mirrormaker_user_config: KafkaMirrormaker user configurable settings
        :param pulumi.Input['ServiceIntegrationLogsUserConfigArgs'] logs_user_config: Logs user configurable settings
        :param pulumi.Input['ServiceIntegrationMetricsUserConfigArgs'] metrics_user_config: Metrics user configurable settings
        :param pulumi.Input['ServiceIntegrationMirrormakerUserConfigArgs'] mirrormaker_user_config: Mirrormaker user configurable settings
        :param pulumi.Input[str] project: Project the integration belongs to
        :param pulumi.Input[str] source_endpoint_id: Source endpoint for the integration (if any)
        :param pulumi.Input[str] source_service_name: Source service for the integration (if any)
        """
        if clickhouse_kafka_user_config is not None:
            pulumi.set(__self__, "clickhouse_kafka_user_config", clickhouse_kafka_user_config)
        if clickhouse_postgresql_user_config is not None:
            pulumi.set(__self__, "clickhouse_postgresql_user_config", clickhouse_postgresql_user_config)
        if datadog_user_config is not None:
            pulumi.set(__self__, "datadog_user_config", datadog_user_config)
        if destination_endpoint_id is not None:
            pulumi.set(__self__, "destination_endpoint_id", destination_endpoint_id)
        if destination_service_name is not None:
            pulumi.set(__self__, "destination_service_name", destination_service_name)
        if integration_id is not None:
            pulumi.set(__self__, "integration_id", integration_id)
        if integration_type is not None:
            pulumi.set(__self__, "integration_type", integration_type)
        if kafka_connect_user_config is not None:
            pulumi.set(__self__, "kafka_connect_user_config", kafka_connect_user_config)
        if kafka_logs_user_config is not None:
            pulumi.set(__self__, "kafka_logs_user_config", kafka_logs_user_config)
        if kafka_mirrormaker_user_config is not None:
            pulumi.set(__self__, "kafka_mirrormaker_user_config", kafka_mirrormaker_user_config)
        if logs_user_config is not None:
            pulumi.set(__self__, "logs_user_config", logs_user_config)
        if metrics_user_config is not None:
            pulumi.set(__self__, "metrics_user_config", metrics_user_config)
        if mirrormaker_user_config is not None:
            pulumi.set(__self__, "mirrormaker_user_config", mirrormaker_user_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if source_endpoint_id is not None:
            pulumi.set(__self__, "source_endpoint_id", source_endpoint_id)
        if source_service_name is not None:
            pulumi.set(__self__, "source_service_name", source_service_name)

    @property
    @pulumi.getter(name="clickhouseKafkaUserConfig")
    def clickhouse_kafka_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']]:
        """
        ClickhouseKafka user configurable settings
        """
        return pulumi.get(self, "clickhouse_kafka_user_config")

    @clickhouse_kafka_user_config.setter
    def clickhouse_kafka_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']]):
        pulumi.set(self, "clickhouse_kafka_user_config", value)

    @property
    @pulumi.getter(name="clickhousePostgresqlUserConfig")
    def clickhouse_postgresql_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]:
        """
        ClickhousePostgresql user configurable settings
        """
        return pulumi.get(self, "clickhouse_postgresql_user_config")

    @clickhouse_postgresql_user_config.setter
    def clickhouse_postgresql_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]):
        pulumi.set(self, "clickhouse_postgresql_user_config", value)

    @property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']]:
        """
        Datadog user configurable settings
        """
        return pulumi.get(self, "datadog_user_config")

    @datadog_user_config.setter
    def datadog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']]):
        pulumi.set(self, "datadog_user_config", value)

    @property
    @pulumi.getter(name="destinationEndpointId")
    def destination_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        Destination endpoint for the integration (if any)
        """
        return pulumi.get(self, "destination_endpoint_id")

    @destination_endpoint_id.setter
    def destination_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_endpoint_id", value)

    @property
    @pulumi.getter(name="destinationServiceName")
    def destination_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Destination service for the integration (if any)
        """
        return pulumi.get(self, "destination_service_name")

    @destination_service_name.setter
    def destination_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_service_name", value)

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Service Integration Id at aiven
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integration_id", value)

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the service integration
        """
        return pulumi.get(self, "integration_type")

    @integration_type.setter
    def integration_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integration_type", value)

    @property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']]:
        """
        KafkaConnect user configurable settings
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @kafka_connect_user_config.setter
    def kafka_connect_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']]):
        pulumi.set(self, "kafka_connect_user_config", value)

    @property
    @pulumi.getter(name="kafkaLogsUserConfig")
    def kafka_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']]:
        """
        KafkaLogs user configurable settings
        """
        return pulumi.get(self, "kafka_logs_user_config")

    @kafka_logs_user_config.setter
    def kafka_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']]):
        pulumi.set(self, "kafka_logs_user_config", value)

    @property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]:
        """
        KafkaMirrormaker user configurable settings
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @kafka_mirrormaker_user_config.setter
    def kafka_mirrormaker_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]):
        pulumi.set(self, "kafka_mirrormaker_user_config", value)

    @property
    @pulumi.getter(name="logsUserConfig")
    def logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']]:
        """
        Logs user configurable settings
        """
        return pulumi.get(self, "logs_user_config")

    @logs_user_config.setter
    def logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']]):
        pulumi.set(self, "logs_user_config", value)

    @property
    @pulumi.getter(name="metricsUserConfig")
    def metrics_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']]:
        """
        Metrics user configurable settings
        """
        return pulumi.get(self, "metrics_user_config")

    @metrics_user_config.setter
    def metrics_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']]):
        pulumi.set(self, "metrics_user_config", value)

    @property
    @pulumi.getter(name="mirrormakerUserConfig")
    def mirrormaker_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationMirrormakerUserConfigArgs']]:
        """
        Mirrormaker user configurable settings
        """
        return pulumi.get(self, "mirrormaker_user_config")

    @mirrormaker_user_config.setter
    def mirrormaker_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationMirrormakerUserConfigArgs']]):
        pulumi.set(self, "mirrormaker_user_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Project the integration belongs to
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sourceEndpointId")
    def source_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        Source endpoint for the integration (if any)
        """
        return pulumi.get(self, "source_endpoint_id")

    @source_endpoint_id.setter
    def source_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_endpoint_id", value)

    @property
    @pulumi.getter(name="sourceServiceName")
    def source_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Source service for the integration (if any)
        """
        return pulumi.get(self, "source_service_name")

    @source_service_name.setter
    def source_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_service_name", value)


class ServiceIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clickhouse_kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationClickhouseKafkaUserConfigArgs']]] = None,
                 clickhouse_postgresql_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]] = None,
                 datadog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationDatadogUserConfigArgs']]] = None,
                 destination_endpoint_id: Optional[pulumi.Input[str]] = None,
                 destination_service_name: Optional[pulumi.Input[str]] = None,
                 integration_type: Optional[pulumi.Input[str]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaConnectUserConfigArgs']]] = None,
                 kafka_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaLogsUserConfigArgs']]] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]] = None,
                 logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationLogsUserConfigArgs']]] = None,
                 metrics_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationMetricsUserConfigArgs']]] = None,
                 mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationMirrormakerUserConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_endpoint_id: Optional[pulumi.Input[str]] = None,
                 source_service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The Service Integration resource allows the creation and management of Aiven Service Integrations.

        **Note** For services running on `hobbyist` plan service integrations are not supported.

        Service Integration defines an integration between two Aiven services or between Aiven service and an external
        integration endpoint. Integration could be for example sending metrics from Kafka service to an InfluxDB service,
        getting metrics from an InfluxDB service to a Grafana service to show dashboards, sending logs from any service to
        Elasticsearch, etc.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        my_integration_metrics = aiven.ServiceIntegration("myIntegrationMetrics",
            project=aiven_project["myproject"]["project"],
            integration_type="metrics",
            source_service_name=aiven_kafka["kfk1"]["service_name"],
            destination_service_name=aiven_m3db["m3db"]["service_name"])
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/serviceIntegration:ServiceIntegration myintegration project/integration_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationClickhouseKafkaUserConfigArgs']] clickhouse_kafka_user_config: ClickhouseKafka user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationClickhousePostgresqlUserConfigArgs']] clickhouse_postgresql_user_config: ClickhousePostgresql user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationDatadogUserConfigArgs']] datadog_user_config: Datadog user configurable settings
        :param pulumi.Input[str] destination_endpoint_id: Destination endpoint for the integration (if any)
        :param pulumi.Input[str] destination_service_name: Destination service for the integration (if any)
        :param pulumi.Input[str] integration_type: Type of the service integration
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaConnectUserConfigArgs']] kafka_connect_user_config: KafkaConnect user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaLogsUserConfigArgs']] kafka_logs_user_config: KafkaLogs user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaMirrormakerUserConfigArgs']] kafka_mirrormaker_user_config: KafkaMirrormaker user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationLogsUserConfigArgs']] logs_user_config: Logs user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationMetricsUserConfigArgs']] metrics_user_config: Metrics user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationMirrormakerUserConfigArgs']] mirrormaker_user_config: Mirrormaker user configurable settings
        :param pulumi.Input[str] project: Project the integration belongs to
        :param pulumi.Input[str] source_endpoint_id: Source endpoint for the integration (if any)
        :param pulumi.Input[str] source_service_name: Source service for the integration (if any)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Service Integration resource allows the creation and management of Aiven Service Integrations.

        **Note** For services running on `hobbyist` plan service integrations are not supported.

        Service Integration defines an integration between two Aiven services or between Aiven service and an external
        integration endpoint. Integration could be for example sending metrics from Kafka service to an InfluxDB service,
        getting metrics from an InfluxDB service to a Grafana service to show dashboards, sending logs from any service to
        Elasticsearch, etc.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        my_integration_metrics = aiven.ServiceIntegration("myIntegrationMetrics",
            project=aiven_project["myproject"]["project"],
            integration_type="metrics",
            source_service_name=aiven_kafka["kfk1"]["service_name"],
            destination_service_name=aiven_m3db["m3db"]["service_name"])
        ```

        ## Import

        ```sh
         $ pulumi import aiven:index/serviceIntegration:ServiceIntegration myintegration project/integration_id
        ```

        :param str resource_name: The name of the resource.
        :param ServiceIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clickhouse_kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationClickhouseKafkaUserConfigArgs']]] = None,
                 clickhouse_postgresql_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]] = None,
                 datadog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationDatadogUserConfigArgs']]] = None,
                 destination_endpoint_id: Optional[pulumi.Input[str]] = None,
                 destination_service_name: Optional[pulumi.Input[str]] = None,
                 integration_type: Optional[pulumi.Input[str]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaConnectUserConfigArgs']]] = None,
                 kafka_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaLogsUserConfigArgs']]] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]] = None,
                 logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationLogsUserConfigArgs']]] = None,
                 metrics_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationMetricsUserConfigArgs']]] = None,
                 mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationMirrormakerUserConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_endpoint_id: Optional[pulumi.Input[str]] = None,
                 source_service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceIntegrationArgs.__new__(ServiceIntegrationArgs)

            __props__.__dict__["clickhouse_kafka_user_config"] = clickhouse_kafka_user_config
            __props__.__dict__["clickhouse_postgresql_user_config"] = clickhouse_postgresql_user_config
            __props__.__dict__["datadog_user_config"] = datadog_user_config
            __props__.__dict__["destination_endpoint_id"] = destination_endpoint_id
            __props__.__dict__["destination_service_name"] = destination_service_name
            if integration_type is None and not opts.urn:
                raise TypeError("Missing required property 'integration_type'")
            __props__.__dict__["integration_type"] = integration_type
            __props__.__dict__["kafka_connect_user_config"] = kafka_connect_user_config
            __props__.__dict__["kafka_logs_user_config"] = kafka_logs_user_config
            __props__.__dict__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
            __props__.__dict__["logs_user_config"] = logs_user_config
            __props__.__dict__["metrics_user_config"] = metrics_user_config
            __props__.__dict__["mirrormaker_user_config"] = mirrormaker_user_config
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["source_endpoint_id"] = source_endpoint_id
            __props__.__dict__["source_service_name"] = source_service_name
            __props__.__dict__["integration_id"] = None
        super(ServiceIntegration, __self__).__init__(
            'aiven:index/serviceIntegration:ServiceIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            clickhouse_kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationClickhouseKafkaUserConfigArgs']]] = None,
            clickhouse_postgresql_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]] = None,
            datadog_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationDatadogUserConfigArgs']]] = None,
            destination_endpoint_id: Optional[pulumi.Input[str]] = None,
            destination_service_name: Optional[pulumi.Input[str]] = None,
            integration_id: Optional[pulumi.Input[str]] = None,
            integration_type: Optional[pulumi.Input[str]] = None,
            kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaConnectUserConfigArgs']]] = None,
            kafka_logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaLogsUserConfigArgs']]] = None,
            kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]] = None,
            logs_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationLogsUserConfigArgs']]] = None,
            metrics_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationMetricsUserConfigArgs']]] = None,
            mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceIntegrationMirrormakerUserConfigArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            source_endpoint_id: Optional[pulumi.Input[str]] = None,
            source_service_name: Optional[pulumi.Input[str]] = None) -> 'ServiceIntegration':
        """
        Get an existing ServiceIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationClickhouseKafkaUserConfigArgs']] clickhouse_kafka_user_config: ClickhouseKafka user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationClickhousePostgresqlUserConfigArgs']] clickhouse_postgresql_user_config: ClickhousePostgresql user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationDatadogUserConfigArgs']] datadog_user_config: Datadog user configurable settings
        :param pulumi.Input[str] destination_endpoint_id: Destination endpoint for the integration (if any)
        :param pulumi.Input[str] destination_service_name: Destination service for the integration (if any)
        :param pulumi.Input[str] integration_id: Service Integration Id at aiven
        :param pulumi.Input[str] integration_type: Type of the service integration
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaConnectUserConfigArgs']] kafka_connect_user_config: KafkaConnect user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaLogsUserConfigArgs']] kafka_logs_user_config: KafkaLogs user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationKafkaMirrormakerUserConfigArgs']] kafka_mirrormaker_user_config: KafkaMirrormaker user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationLogsUserConfigArgs']] logs_user_config: Logs user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationMetricsUserConfigArgs']] metrics_user_config: Metrics user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceIntegrationMirrormakerUserConfigArgs']] mirrormaker_user_config: Mirrormaker user configurable settings
        :param pulumi.Input[str] project: Project the integration belongs to
        :param pulumi.Input[str] source_endpoint_id: Source endpoint for the integration (if any)
        :param pulumi.Input[str] source_service_name: Source service for the integration (if any)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceIntegrationState.__new__(_ServiceIntegrationState)

        __props__.__dict__["clickhouse_kafka_user_config"] = clickhouse_kafka_user_config
        __props__.__dict__["clickhouse_postgresql_user_config"] = clickhouse_postgresql_user_config
        __props__.__dict__["datadog_user_config"] = datadog_user_config
        __props__.__dict__["destination_endpoint_id"] = destination_endpoint_id
        __props__.__dict__["destination_service_name"] = destination_service_name
        __props__.__dict__["integration_id"] = integration_id
        __props__.__dict__["integration_type"] = integration_type
        __props__.__dict__["kafka_connect_user_config"] = kafka_connect_user_config
        __props__.__dict__["kafka_logs_user_config"] = kafka_logs_user_config
        __props__.__dict__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
        __props__.__dict__["logs_user_config"] = logs_user_config
        __props__.__dict__["metrics_user_config"] = metrics_user_config
        __props__.__dict__["mirrormaker_user_config"] = mirrormaker_user_config
        __props__.__dict__["project"] = project
        __props__.__dict__["source_endpoint_id"] = source_endpoint_id
        __props__.__dict__["source_service_name"] = source_service_name
        return ServiceIntegration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clickhouseKafkaUserConfig")
    def clickhouse_kafka_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationClickhouseKafkaUserConfig']]:
        """
        ClickhouseKafka user configurable settings
        """
        return pulumi.get(self, "clickhouse_kafka_user_config")

    @property
    @pulumi.getter(name="clickhousePostgresqlUserConfig")
    def clickhouse_postgresql_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationClickhousePostgresqlUserConfig']]:
        """
        ClickhousePostgresql user configurable settings
        """
        return pulumi.get(self, "clickhouse_postgresql_user_config")

    @property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationDatadogUserConfig']]:
        """
        Datadog user configurable settings
        """
        return pulumi.get(self, "datadog_user_config")

    @property
    @pulumi.getter(name="destinationEndpointId")
    def destination_endpoint_id(self) -> pulumi.Output[Optional[str]]:
        """
        Destination endpoint for the integration (if any)
        """
        return pulumi.get(self, "destination_endpoint_id")

    @property
    @pulumi.getter(name="destinationServiceName")
    def destination_service_name(self) -> pulumi.Output[Optional[str]]:
        """
        Destination service for the integration (if any)
        """
        return pulumi.get(self, "destination_service_name")

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> pulumi.Output[str]:
        """
        Service Integration Id at aiven
        """
        return pulumi.get(self, "integration_id")

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Output[str]:
        """
        Type of the service integration
        """
        return pulumi.get(self, "integration_type")

    @property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationKafkaConnectUserConfig']]:
        """
        KafkaConnect user configurable settings
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @property
    @pulumi.getter(name="kafkaLogsUserConfig")
    def kafka_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationKafkaLogsUserConfig']]:
        """
        KafkaLogs user configurable settings
        """
        return pulumi.get(self, "kafka_logs_user_config")

    @property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationKafkaMirrormakerUserConfig']]:
        """
        KafkaMirrormaker user configurable settings
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @property
    @pulumi.getter(name="logsUserConfig")
    def logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationLogsUserConfig']]:
        """
        Logs user configurable settings
        """
        return pulumi.get(self, "logs_user_config")

    @property
    @pulumi.getter(name="metricsUserConfig")
    def metrics_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationMetricsUserConfig']]:
        """
        Metrics user configurable settings
        """
        return pulumi.get(self, "metrics_user_config")

    @property
    @pulumi.getter(name="mirrormakerUserConfig")
    def mirrormaker_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationMirrormakerUserConfig']]:
        """
        Mirrormaker user configurable settings
        """
        return pulumi.get(self, "mirrormaker_user_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project the integration belongs to
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sourceEndpointId")
    def source_endpoint_id(self) -> pulumi.Output[Optional[str]]:
        """
        Source endpoint for the integration (if any)
        """
        return pulumi.get(self, "source_endpoint_id")

    @property
    @pulumi.getter(name="sourceServiceName")
    def source_service_name(self) -> pulumi.Output[Optional[str]]:
        """
        Source service for the integration (if any)
        """
        return pulumi.get(self, "source_service_name")

