# Generated by Django 4.1.3 on 2023-01-02 01:31

import uuid

# import django.contrib.postgres.fields
import django.db.models.deletion
from django.db import migrations, models

import formkit_ninja.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="FormComponents",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order",
                    models.PositiveIntegerField(db_index=True, editable=False, verbose_name="order"),
                ),
            ],
            options={
                "ordering": ("order",),
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="FormKitSchemaNode",
            fields=[
                (
                    "node_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Component", "$cmp"),
                            ("Text", "text"),
                            ("Condition", "condition"),
                            ("FormKit", "$formkit"),
                            ("Element", "$el"),
                        ],
                        max_length=256,
                    ),
                ),
                (
                    "node_value",
                    models.CharField(
                        blank=True,
                        help_text="The value of the $el, $formkit or $cmp property",
                        max_length=256,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        help_text="Decribe the type of data / reason for this component",
                        null=True,
                    ),
                ),
                (
                    "id",
                    models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False),
                ),
                # (
                #     "children",
                #     django.contrib.postgres.fields.ArrayField(
                #         base_field=models.TextField(blank=True, null=True),
                #         blank=True,
                #         help_text="Content of the element",
                #         null=True,
                #         size=None,
                #     ),
                # ),
                (
                    "if_condition",
                    models.CharField(blank=True, max_length=256, null=True),
                ),
                (
                    "then_condition",
                    models.CharField(blank=True, max_length=256, null=True),
                ),
                (
                    "else_condition",
                    models.CharField(blank=True, max_length=256, null=True),
                ),
                ("name", models.CharField(blank=True, max_length=1024, null=True)),
                ("key", models.CharField(blank=True, max_length=1024, null=True)),
                (
                    "html_id",
                    models.CharField(
                        blank=True,
                        help_text="Use this ID if adding conditions to other fields",
                        max_length=1024,
                        null=True,
                    ),
                ),
                ("placeholder", models.CharField(blank=True, max_length=1024)),
                ("label", formkit_ninja.fields.TranslatedField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="SchemaCondition",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("if_condition", models.CharField(max_length=2048)),
            ],
        ),
        migrations.CreateModel(
            name="Option",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order",
                    models.PositiveIntegerField(db_index=True, editable=False, verbose_name="order"),
                ),
                ("value", models.CharField(max_length=1024)),
                ("label", formkit_ninja.fields.TranslatedField(blank=True, null=True)),
                (
                    "field",
                    models.ForeignKey(
                        limit_choices_to={
                            "node_type": "$formkit",
                            "node_value": "group",
                        },
                        on_delete=django.db.models.deletion.CASCADE,
                        to="formkit_ninja.formkitschemanode",
                    ),
                ),
            ],
            options={
                "ordering": ("order",),
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Membership",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order",
                    models.PositiveIntegerField(db_index=True, editable=False, verbose_name="order"),
                ),
                (
                    "group",
                    models.ForeignKey(
                        limit_choices_to={
                            "node_type": "$formkit",
                            "node_value": "group",
                        },
                        on_delete=django.db.models.deletion.CASCADE,
                        to="formkit_ninja.formkitschemanode",
                    ),
                ),
                (
                    "member",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="members",
                        to="formkit_ninja.formkitschemanode",
                    ),
                ),
            ],
            options={
                "ordering": ("order",),
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="FormKitSchema",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", formkit_ninja.fields.TranslatedField()),
                (
                    "nodes",
                    models.ManyToManyField(
                        through="formkit_ninja.FormComponents",
                        to="formkit_ninja.formkitschemanode",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="formcomponents",
            name="node",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="formkit_ninja.formkitschemanode",
            ),
        ),
        migrations.AddField(
            model_name="formcomponents",
            name="schem",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="formkit_ninja.formkitschema",
            ),
        ),
    ]
