# mypy-boto3-dynamodb

[![PyPI - mypy-boto3-dynamodb](https://img.shields.io/pypi/v/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DynamoDB 1.17.52](https://boto3.amazonaws.com/v1/documentation/api/1.17.52/reference/services/dynamodb.html#DynamoDB) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.5.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-dynamodb](#mypy-boto3-dynamodb)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `DynamoDB` service.

```bash
python -m pip install boto3-stubs[dynamodb]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[dynamodb]` in your environment: `python -m pip install 'boto3-stubs[dynamodb]'`

Both type checking and auto-complete should work for `DynamoDB` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[dynamodb]` in your environment: `python -m pip install 'boto3-stubs[dynamodb]'`

Both type checking and auto-complete should work for `DynamoDB` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[dynamodb]` in your environment: `python -m pip install 'boto3-stubs[dynamodb]'`
- Run `mypy` as usual

Type checking should work for `DynamoDB` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[dynamodb]` in your environment: `python -m pip install 'boto3-stubs[dynamodb]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DynamoDB` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`DynamoDBClient` provides annotations for `boto3.client("dynamodb")`.

```python
import boto3

from mypy_boto3_dynamodb import DynamoDBClient

client: DynamoDBClient = boto3.client("dynamodb")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DynamoDBClient = session.client("dynamodb")
```

### Paginators annotations

`mypy_boto3_dynamodb.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_dynamodb import DynamoDBClient
from mypy_boto3_dynamodb.paginator import (
    ListBackupsPaginator,
    ListTablesPaginator,
    ListTagsOfResourcePaginator,
    QueryPaginator,
    ScanPaginator,
)

client: DynamoDBClient = boto3.client("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_backups_paginator: ListBackupsPaginator = client.get_paginator("list_backups")
list_tables_paginator: ListTablesPaginator = client.get_paginator("list_tables")
list_tags_of_resource_paginator: ListTagsOfResourcePaginator = client.get_paginator("list_tags_of_resource")
query_paginator: QueryPaginator = client.get_paginator("query")
scan_paginator: ScanPaginator = client.get_paginator("scan")
```


### Waiters annotations

`mypy_boto3_dynamodb.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_dynamodb import DynamoDBClient
from mypy_boto3_dynamodb.waiter import (
    TableExistsWaiter,
    TableNotExistsWaiter,
)

client: DynamoDBClient = boto3.client("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
table_exists_waiter: TableExistsWaiter = client.get_waiter("table_exists")
table_not_exists_waiter: TableNotExistsWaiter = client.get_waiter("table_not_exists")
```


### Service Resource annotations

`DynamoDBServiceResource` provides annotations for `boto3.resource("dynamodb")`.

```python
from mypy_boto3_dynamodb import DynamoDBServiceResource

resource: DynamoDBServiceResource = boto3.resource("dynamodb")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: DynamoDBServiceResource = session.resource("dynamodb")
```


### Other resources annotations

`mypy_boto3_dynamodb.service_resource` module contains type annotations for all resources.

```python
from mypy_boto3_dynamodb import DynamoDBServiceResource
from mypy_boto3_dynamodb.service_resource import (
    Table,
)

resource: DynamoDBServiceResource = boto3.resource("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_table: Table = resource.Table(...)
```



### Collections annotations

`mypy_boto3_dynamodb.service_resource` module contains type annotations
for all `DynamoDBServiceResource` collections.

```python
from mypy_boto3_dynamodb import DynamoDBServiceResource
from mypy_boto3_dynamodb.service_resource import (
    ServiceResourceTablesCollection,
)

resource: DynamoDBServiceResource = boto3.resource("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
tables: dynamodb_resources.ServiceResourceTablesCollection = resource.tables
```




### Typed dictionations

`mypy_boto3_dynamodb.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_dynamodb.type_defs import (
    ArchivalSummaryTypeDef,
    AttributeDefinitionTypeDef,
    AutoScalingPolicyDescriptionTypeDef,
    AutoScalingPolicyUpdateTypeDef,
    AutoScalingSettingsDescriptionTypeDef,
    AutoScalingSettingsUpdateTypeDef,
    AutoScalingTargetTrackingScalingPolicyConfigurationDescriptionTypeDef,
    AutoScalingTargetTrackingScalingPolicyConfigurationUpdateTypeDef,
    BackupDescriptionTypeDef,
    BackupDetailsTypeDef,
    BackupSummaryTypeDef,
    BatchStatementErrorTypeDef,
    BatchStatementResponseTypeDef,
    BillingModeSummaryTypeDef,
    CapacityTypeDef,
    ConditionCheckTypeDef,
    ConsumedCapacityTypeDef,
    ContinuousBackupsDescriptionTypeDef,
    ContributorInsightsSummaryTypeDef,
    CreateGlobalSecondaryIndexActionTypeDef,
    CreateReplicaActionTypeDef,
    CreateReplicationGroupMemberActionTypeDef,
    DeleteGlobalSecondaryIndexActionTypeDef,
    DeleteReplicaActionTypeDef,
    DeleteReplicationGroupMemberActionTypeDef,
    DeleteRequestTypeDef,
    DeleteTypeDef,
    EndpointTypeDef,
    ExportDescriptionTypeDef,
    ExportSummaryTypeDef,
    FailureExceptionTypeDef,
    GetTypeDef,
    GlobalSecondaryIndexDescriptionTypeDef,
    GlobalSecondaryIndexInfoTypeDef,
    GlobalTableDescriptionTypeDef,
    GlobalTableTypeDef,
    ItemCollectionMetricsTypeDef,
    ItemResponseTypeDef,
    KeySchemaElementTypeDef,
    KeysAndAttributesTypeDef,
    KinesisDataStreamDestinationTypeDef,
    LocalSecondaryIndexDescriptionTypeDef,
    LocalSecondaryIndexInfoTypeDef,
    PointInTimeRecoveryDescriptionTypeDef,
    ProjectionTypeDef,
    ProvisionedThroughputDescriptionTypeDef,
    ProvisionedThroughputOverrideTypeDef,
    ProvisionedThroughputTypeDef,
    PutRequestTypeDef,
    PutTypeDef,
    ReplicaAutoScalingDescriptionTypeDef,
    ReplicaDescriptionTypeDef,
    ReplicaGlobalSecondaryIndexAutoScalingDescriptionTypeDef,
    ReplicaGlobalSecondaryIndexAutoScalingUpdateTypeDef,
    ReplicaGlobalSecondaryIndexDescriptionTypeDef,
    ReplicaGlobalSecondaryIndexSettingsDescriptionTypeDef,
    ReplicaGlobalSecondaryIndexSettingsUpdateTypeDef,
    ReplicaGlobalSecondaryIndexTypeDef,
    ReplicaSettingsDescriptionTypeDef,
    ReplicaTypeDef,
    ResponseMetadata,
    RestoreSummaryTypeDef,
    SSEDescriptionTypeDef,
    SourceTableDetailsTypeDef,
    SourceTableFeatureDetailsTypeDef,
    StreamSpecificationTypeDef,
    TableAutoScalingDescriptionTypeDef,
    TableDescriptionTypeDef,
    TagTypeDef,
    TimeToLiveDescriptionTypeDef,
    TimeToLiveSpecificationTypeDef,
    UpdateGlobalSecondaryIndexActionTypeDef,
    UpdateReplicationGroupMemberActionTypeDef,
    UpdateTypeDef,
    WriteRequestTypeDef,
    AttributeValueUpdateTypeDef,
    BatchExecuteStatementOutputTypeDef,
    BatchGetItemOutputTypeDef,
    BatchStatementRequestTypeDef,
    BatchWriteItemOutputTypeDef,
    ConditionTypeDef,
    CreateBackupOutputTypeDef,
    CreateGlobalTableOutputTypeDef,
    CreateTableOutputTypeDef,
    DeleteBackupOutputTypeDef,
    DeleteItemOutputTypeDef,
    DeleteTableOutputTypeDef,
    DescribeBackupOutputTypeDef,
    DescribeContinuousBackupsOutputTypeDef,
    DescribeContributorInsightsOutputTypeDef,
    DescribeEndpointsResponseTypeDef,
    DescribeExportOutputTypeDef,
    DescribeGlobalTableOutputTypeDef,
    DescribeGlobalTableSettingsOutputTypeDef,
    DescribeKinesisStreamingDestinationOutputTypeDef,
    DescribeLimitsOutputTypeDef,
    DescribeTableOutputTypeDef,
    DescribeTableReplicaAutoScalingOutputTypeDef,
    DescribeTimeToLiveOutputTypeDef,
    ExecuteStatementOutputTypeDef,
    ExecuteTransactionOutputTypeDef,
    ExpectedAttributeValueTypeDef,
    ExportTableToPointInTimeOutputTypeDef,
    GetItemOutputTypeDef,
    GlobalSecondaryIndexAutoScalingUpdateTypeDef,
    GlobalSecondaryIndexTypeDef,
    GlobalSecondaryIndexUpdateTypeDef,
    GlobalTableGlobalSecondaryIndexSettingsUpdateTypeDef,
    KinesisStreamingDestinationOutputTypeDef,
    ListBackupsOutputTypeDef,
    ListContributorInsightsOutputTypeDef,
    ListExportsOutputTypeDef,
    ListGlobalTablesOutputTypeDef,
    ListTablesOutputTypeDef,
    ListTagsOfResourceOutputTypeDef,
    LocalSecondaryIndexTypeDef,
    PaginatorConfigTypeDef,
    ParameterizedStatementTypeDef,
    PointInTimeRecoverySpecificationTypeDef,
    PutItemOutputTypeDef,
    QueryOutputTypeDef,
    ReplicaAutoScalingUpdateTypeDef,
    ReplicaSettingsUpdateTypeDef,
    ReplicaUpdateTypeDef,
    ReplicationGroupUpdateTypeDef,
    RestoreTableFromBackupOutputTypeDef,
    RestoreTableToPointInTimeOutputTypeDef,
    SSESpecificationTypeDef,
    ScanOutputTypeDef,
    TransactGetItemTypeDef,
    TransactGetItemsOutputTypeDef,
    TransactWriteItemTypeDef,
    TransactWriteItemsOutputTypeDef,
    UpdateContinuousBackupsOutputTypeDef,
    UpdateContributorInsightsOutputTypeDef,
    UpdateGlobalTableOutputTypeDef,
    UpdateGlobalTableSettingsOutputTypeDef,
    UpdateItemOutputTypeDef,
    UpdateTableOutputTypeDef,
    UpdateTableReplicaAutoScalingOutputTypeDef,
    UpdateTimeToLiveOutputTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> ArchivalSummaryTypeDef:
    return {
      ...
    }
```
