"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'can create receipt rules with second after first'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        new lib_1.ReceiptRuleSet(stack, 'RuleSet', {
            rules: [
                {
                    receiptRuleName: 'FirstRule',
                },
                {
                    enabled: false,
                    receiptRuleName: 'SecondRule',
                    recipients: ['hello@aws.com'],
                    scanEnabled: true,
                    tlsPolicy: lib_1.TlsPolicy.REQUIRE
                }
            ]
        });
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "RuleSetE30C6C48": {
                    "Type": "AWS::SES::ReceiptRuleSet"
                },
                "RuleSetRule023C3B8E1": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Name": "FirstRule",
                            "Enabled": true
                        },
                        "RuleSetName": {
                            "Ref": "RuleSetE30C6C48"
                        }
                    }
                },
                "RuleSetRule117041B57": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Enabled": false,
                            "Name": "SecondRule",
                            "Recipients": [
                                "hello@aws.com"
                            ],
                            "ScanEnabled": true,
                            "TlsPolicy": "Require"
                        },
                        "RuleSetName": {
                            "Ref": "RuleSetE30C6C48"
                        },
                        "After": {
                            "Ref": "RuleSetRule023C3B8E1"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'import receipt rule'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        const receiptRule = lib_1.ReceiptRule.fromReceiptRuleName(stack, 'ImportedRule', 'MyRule');
        const receiptRuleSet = new lib_1.ReceiptRuleSet(stack, 'RuleSet');
        receiptRuleSet.addRule('MyRule', {
            after: receiptRule
        });
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "RuleSetE30C6C48": {
                    "Type": "AWS::SES::ReceiptRuleSet"
                },
                "RuleSetMyRule60B1D107": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Enabled": true
                        },
                        "RuleSetName": {
                            "Ref": "RuleSetE30C6C48"
                        },
                        "After": "MyRule"
                    }
                }
            },
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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