# coding: utf-8

"""
    Browse API

    <p>The Browse API has the following resources:</p>   <ul> <li><b> item_summary: </b> Lets shoppers search for specific items by keyword, GTIN, category, charity, product, or item aspects and refine the results by using filters, such as aspects, compatibility, and fields values.</li>  <li> <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#API\" target=\"_blank\"><img src=\"/cms/img/docs/experimental-icon.svg\" class=\"legend-icon experimental-icon\" alt=\"Experimental Release\" title=\"Experimental Release\" />&nbsp;(Experimental)</a> <b> search_by_image: </b> Lets shoppers search for specific items by image. You can refine the results by using URI parameters and filters.</li>   <li><b> item: </b> <ul><li>Lets you retrieve the details of a specific item or all the items in an item group, which is an item with variations such as color and size and check if a product is compatible with the specified item, such as if a specific car is compatible with a specific part.</li> <li>Provides a bridge between the eBay legacy APIs, such as <b> Finding</b>, and the RESTful APIs, which use different formats for the item IDs.</li>  </ul> </li>  <li><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#API\" target=\"_blank\"><img src=\"/cms/img/docs/experimental-icon.svg\" class=\"legend-icon experimental-icon\" alt=\"Experimental Release\" title=\"Experimental Release\" />&nbsp;(Experimental)</a> <b> shopping_cart: </b> Provides the ability for eBay members to see the contents of their eBay cart, and add, remove, and change the quantity of items in their eBay cart.&nbsp;&nbsp;<b> Note: </b> This resource is not available in the eBay API Explorer.</li></ul>       <p>The <b> item_summary</b>, <b> search_by_image</b>, and <b> item</b> resource calls require an <a href=\"/api-docs/static/oauth-client-credentials-grant.html\">Application access token</a>. The <b> shopping_cart</b> resource calls require a <a href=\"/api-docs/static/oauth-authorization-code-grant.html\">User access token</a>.</p>  # noqa: E501

    OpenAPI spec version: v1.4.2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ItemSummary(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'additional_images': 'list[Image]',
        'adult_only': 'bool',
        'available_coupons': 'bool',
        'bid_count': 'int',
        'buying_options': 'list[str]',
        'categories': 'list[Category]',
        'compatibility_match': 'str',
        'compatibility_properties': 'list[CompatibilityProperty]',
        'condition': 'str',
        'condition_id': 'str',
        'current_bid_price': 'ConvertedAmount',
        'distance_from_pickup_location': 'TargetLocation',
        'energy_efficiency_class': 'str',
        'epid': 'str',
        'image': 'Image',
        'item_affiliate_web_url': 'str',
        'item_group_href': 'str',
        'item_group_type': 'str',
        'item_href': 'str',
        'item_id': 'str',
        'item_location': 'ItemLocationImpl',
        'item_web_url': 'str',
        'legacy_item_id': 'str',
        'marketing_price': 'MarketingPrice',
        'pickup_options': 'list[PickupOptionSummary]',
        'price': 'ConvertedAmount',
        'price_display_condition': 'str',
        'qualified_programs': 'list[str]',
        'seller': 'Seller',
        'shipping_options': 'list[ShippingOptionSummary]',
        'short_description': 'str',
        'thumbnail_images': 'list[Image]',
        'title': 'str',
        'unit_price': 'ConvertedAmount',
        'unit_pricing_measure': 'str'
    }

    attribute_map = {
        'additional_images': 'additionalImages',
        'adult_only': 'adultOnly',
        'available_coupons': 'availableCoupons',
        'bid_count': 'bidCount',
        'buying_options': 'buyingOptions',
        'categories': 'categories',
        'compatibility_match': 'compatibilityMatch',
        'compatibility_properties': 'compatibilityProperties',
        'condition': 'condition',
        'condition_id': 'conditionId',
        'current_bid_price': 'currentBidPrice',
        'distance_from_pickup_location': 'distanceFromPickupLocation',
        'energy_efficiency_class': 'energyEfficiencyClass',
        'epid': 'epid',
        'image': 'image',
        'item_affiliate_web_url': 'itemAffiliateWebUrl',
        'item_group_href': 'itemGroupHref',
        'item_group_type': 'itemGroupType',
        'item_href': 'itemHref',
        'item_id': 'itemId',
        'item_location': 'itemLocation',
        'item_web_url': 'itemWebUrl',
        'legacy_item_id': 'legacyItemId',
        'marketing_price': 'marketingPrice',
        'pickup_options': 'pickupOptions',
        'price': 'price',
        'price_display_condition': 'priceDisplayCondition',
        'qualified_programs': 'qualifiedPrograms',
        'seller': 'seller',
        'shipping_options': 'shippingOptions',
        'short_description': 'shortDescription',
        'thumbnail_images': 'thumbnailImages',
        'title': 'title',
        'unit_price': 'unitPrice',
        'unit_pricing_measure': 'unitPricingMeasure'
    }

    def __init__(self, additional_images=None, adult_only=None, available_coupons=None, bid_count=None, buying_options=None, categories=None, compatibility_match=None, compatibility_properties=None, condition=None, condition_id=None, current_bid_price=None, distance_from_pickup_location=None, energy_efficiency_class=None, epid=None, image=None, item_affiliate_web_url=None, item_group_href=None, item_group_type=None, item_href=None, item_id=None, item_location=None, item_web_url=None, legacy_item_id=None, marketing_price=None, pickup_options=None, price=None, price_display_condition=None, qualified_programs=None, seller=None, shipping_options=None, short_description=None, thumbnail_images=None, title=None, unit_price=None, unit_pricing_measure=None):  # noqa: E501
        """ItemSummary - a model defined in Swagger"""  # noqa: E501
        self._additional_images = None
        self._adult_only = None
        self._available_coupons = None
        self._bid_count = None
        self._buying_options = None
        self._categories = None
        self._compatibility_match = None
        self._compatibility_properties = None
        self._condition = None
        self._condition_id = None
        self._current_bid_price = None
        self._distance_from_pickup_location = None
        self._energy_efficiency_class = None
        self._epid = None
        self._image = None
        self._item_affiliate_web_url = None
        self._item_group_href = None
        self._item_group_type = None
        self._item_href = None
        self._item_id = None
        self._item_location = None
        self._item_web_url = None
        self._legacy_item_id = None
        self._marketing_price = None
        self._pickup_options = None
        self._price = None
        self._price_display_condition = None
        self._qualified_programs = None
        self._seller = None
        self._shipping_options = None
        self._short_description = None
        self._thumbnail_images = None
        self._title = None
        self._unit_price = None
        self._unit_pricing_measure = None
        self.discriminator = None
        if additional_images is not None:
            self.additional_images = additional_images
        if adult_only is not None:
            self.adult_only = adult_only
        if available_coupons is not None:
            self.available_coupons = available_coupons
        if bid_count is not None:
            self.bid_count = bid_count
        if buying_options is not None:
            self.buying_options = buying_options
        if categories is not None:
            self.categories = categories
        if compatibility_match is not None:
            self.compatibility_match = compatibility_match
        if compatibility_properties is not None:
            self.compatibility_properties = compatibility_properties
        if condition is not None:
            self.condition = condition
        if condition_id is not None:
            self.condition_id = condition_id
        if current_bid_price is not None:
            self.current_bid_price = current_bid_price
        if distance_from_pickup_location is not None:
            self.distance_from_pickup_location = distance_from_pickup_location
        if energy_efficiency_class is not None:
            self.energy_efficiency_class = energy_efficiency_class
        if epid is not None:
            self.epid = epid
        if image is not None:
            self.image = image
        if item_affiliate_web_url is not None:
            self.item_affiliate_web_url = item_affiliate_web_url
        if item_group_href is not None:
            self.item_group_href = item_group_href
        if item_group_type is not None:
            self.item_group_type = item_group_type
        if item_href is not None:
            self.item_href = item_href
        if item_id is not None:
            self.item_id = item_id
        if item_location is not None:
            self.item_location = item_location
        if item_web_url is not None:
            self.item_web_url = item_web_url
        if legacy_item_id is not None:
            self.legacy_item_id = legacy_item_id
        if marketing_price is not None:
            self.marketing_price = marketing_price
        if pickup_options is not None:
            self.pickup_options = pickup_options
        if price is not None:
            self.price = price
        if price_display_condition is not None:
            self.price_display_condition = price_display_condition
        if qualified_programs is not None:
            self.qualified_programs = qualified_programs
        if seller is not None:
            self.seller = seller
        if shipping_options is not None:
            self.shipping_options = shipping_options
        if short_description is not None:
            self.short_description = short_description
        if thumbnail_images is not None:
            self.thumbnail_images = thumbnail_images
        if title is not None:
            self.title = title
        if unit_price is not None:
            self.unit_price = unit_price
        if unit_pricing_measure is not None:
            self.unit_pricing_measure = unit_pricing_measure

    @property
    def additional_images(self):
        """Gets the additional_images of this ItemSummary.  # noqa: E501

        An array of containers with the URLs for the images that are in addition to the primary image. The primary image is returned in the image.imageUrl field.  # noqa: E501

        :return: The additional_images of this ItemSummary.  # noqa: E501
        :rtype: list[Image]
        """
        return self._additional_images

    @additional_images.setter
    def additional_images(self, additional_images):
        """Sets the additional_images of this ItemSummary.

        An array of containers with the URLs for the images that are in addition to the primary image. The primary image is returned in the image.imageUrl field.  # noqa: E501

        :param additional_images: The additional_images of this ItemSummary.  # noqa: E501
        :type: list[Image]
        """

        self._additional_images = additional_images

    @property
    def adult_only(self):
        """Gets the adult_only of this ItemSummary.  # noqa: E501

        This indicates if the item is for adults only. For more information about adult-only items on eBay, see Adult items policy for sellers and Adult-Only items on eBay for buyers.  # noqa: E501

        :return: The adult_only of this ItemSummary.  # noqa: E501
        :rtype: bool
        """
        return self._adult_only

    @adult_only.setter
    def adult_only(self, adult_only):
        """Sets the adult_only of this ItemSummary.

        This indicates if the item is for adults only. For more information about adult-only items on eBay, see Adult items policy for sellers and Adult-Only items on eBay for buyers.  # noqa: E501

        :param adult_only: The adult_only of this ItemSummary.  # noqa: E501
        :type: bool
        """

        self._adult_only = adult_only

    @property
    def available_coupons(self):
        """Gets the available_coupons of this ItemSummary.  # noqa: E501

        This boolean attribute indicates if coupons are available for the item.  # noqa: E501

        :return: The available_coupons of this ItemSummary.  # noqa: E501
        :rtype: bool
        """
        return self._available_coupons

    @available_coupons.setter
    def available_coupons(self, available_coupons):
        """Sets the available_coupons of this ItemSummary.

        This boolean attribute indicates if coupons are available for the item.  # noqa: E501

        :param available_coupons: The available_coupons of this ItemSummary.  # noqa: E501
        :type: bool
        """

        self._available_coupons = available_coupons

    @property
    def bid_count(self):
        """Gets the bid_count of this ItemSummary.  # noqa: E501

        This integer value indicates the total number of bids that have been placed for an auction item. This field is only returned for auction items.  # noqa: E501

        :return: The bid_count of this ItemSummary.  # noqa: E501
        :rtype: int
        """
        return self._bid_count

    @bid_count.setter
    def bid_count(self, bid_count):
        """Sets the bid_count of this ItemSummary.

        This integer value indicates the total number of bids that have been placed for an auction item. This field is only returned for auction items.  # noqa: E501

        :param bid_count: The bid_count of this ItemSummary.  # noqa: E501
        :type: int
        """

        self._bid_count = bid_count

    @property
    def buying_options(self):
        """Gets the buying_options of this ItemSummary.  # noqa: E501

        A comma separated list of all the purchase options available for the item. Values Returned: FIXED_PRICE - Indicates the buyer can purchase the item for a set price using the Buy It Now button. AUCTION - Indicates the buyer can place a bid for the item. After the first bid is placed, this becomes a live auction item and is the only buying option for this item. BEST_OFFER - Items where the buyer can send the seller a price they're willing to pay for the item. The seller can accept, reject, or send a counter offer. For details about Best Offer, see Best Offer. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The buying_options of this ItemSummary.  # noqa: E501
        :rtype: list[str]
        """
        return self._buying_options

    @buying_options.setter
    def buying_options(self, buying_options):
        """Sets the buying_options of this ItemSummary.

        A comma separated list of all the purchase options available for the item. Values Returned: FIXED_PRICE - Indicates the buyer can purchase the item for a set price using the Buy It Now button. AUCTION - Indicates the buyer can place a bid for the item. After the first bid is placed, this becomes a live auction item and is the only buying option for this item. BEST_OFFER - Items where the buyer can send the seller a price they're willing to pay for the item. The seller can accept, reject, or send a counter offer. For details about Best Offer, see Best Offer. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param buying_options: The buying_options of this ItemSummary.  # noqa: E501
        :type: list[str]
        """

        self._buying_options = buying_options

    @property
    def categories(self):
        """Gets the categories of this ItemSummary.  # noqa: E501

        This container returns the primary category ID of the item (as well as the secondary category if the item was listed in two categories).  # noqa: E501

        :return: The categories of this ItemSummary.  # noqa: E501
        :rtype: list[Category]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """Sets the categories of this ItemSummary.

        This container returns the primary category ID of the item (as well as the secondary category if the item was listed in two categories).  # noqa: E501

        :param categories: The categories of this ItemSummary.  # noqa: E501
        :type: list[Category]
        """

        self._categories = categories

    @property
    def compatibility_match(self):
        """Gets the compatibility_match of this ItemSummary.  # noqa: E501

        This indicates how well the item matches the compatibility_filter product attributes. Valid Values: EXACT or POSSIBLE Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/browse/types/gct:CompatibilityMatchEnum'>eBay API documentation</a>  # noqa: E501

        :return: The compatibility_match of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._compatibility_match

    @compatibility_match.setter
    def compatibility_match(self, compatibility_match):
        """Sets the compatibility_match of this ItemSummary.

        This indicates how well the item matches the compatibility_filter product attributes. Valid Values: EXACT or POSSIBLE Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/browse/types/gct:CompatibilityMatchEnum'>eBay API documentation</a>  # noqa: E501

        :param compatibility_match: The compatibility_match of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._compatibility_match = compatibility_match

    @property
    def compatibility_properties(self):
        """Gets the compatibility_properties of this ItemSummary.  # noqa: E501

        This container returns only the product attributes that are compatible with the item. These attributes were specified in the compatibility_filter in the request. This means that if you passed in 5 attributes and only 4 are compatible, only those 4 are returned. If none of the attributes are compatible, this container is not returned.  # noqa: E501

        :return: The compatibility_properties of this ItemSummary.  # noqa: E501
        :rtype: list[CompatibilityProperty]
        """
        return self._compatibility_properties

    @compatibility_properties.setter
    def compatibility_properties(self, compatibility_properties):
        """Sets the compatibility_properties of this ItemSummary.

        This container returns only the product attributes that are compatible with the item. These attributes were specified in the compatibility_filter in the request. This means that if you passed in 5 attributes and only 4 are compatible, only those 4 are returned. If none of the attributes are compatible, this container is not returned.  # noqa: E501

        :param compatibility_properties: The compatibility_properties of this ItemSummary.  # noqa: E501
        :type: list[CompatibilityProperty]
        """

        self._compatibility_properties = compatibility_properties

    @property
    def condition(self):
        """Gets the condition of this ItemSummary.  # noqa: E501

        The text describing the condition of the item, such as New or Used. For a list of condition names, see Item Condition IDs and Names. Code so that your app gracefully handles any future changes to this list. Note: In all eBay marketplaces, Condition ID 2000 now maps to an item condition of 'Certified Refurbished', and not 'Manufacturer Refurbished'. To list an item as 'Certified Refurbished', a seller must be pre-qualified by eBay for this feature.  # noqa: E501

        :return: The condition of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this ItemSummary.

        The text describing the condition of the item, such as New or Used. For a list of condition names, see Item Condition IDs and Names. Code so that your app gracefully handles any future changes to this list. Note: In all eBay marketplaces, Condition ID 2000 now maps to an item condition of 'Certified Refurbished', and not 'Manufacturer Refurbished'. To list an item as 'Certified Refurbished', a seller must be pre-qualified by eBay for this feature.  # noqa: E501

        :param condition: The condition of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def condition_id(self):
        """Gets the condition_id of this ItemSummary.  # noqa: E501

        The identifier of the condition of the item. For example, 1000 is the identifier for NEW. For a list of condition names and IDs, see Item Condition IDs and Names. Code so that your app gracefully handles any future changes to this list. Note: In all eBay marketplaces, Condition ID 2000 now maps to an item condition of 'Certified Refurbished', and not 'Manufacturer Refurbished'. To list an item as 'Certified Refurbished', a seller must be pre-qualified by eBay for this feature.  # noqa: E501

        :return: The condition_id of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._condition_id

    @condition_id.setter
    def condition_id(self, condition_id):
        """Sets the condition_id of this ItemSummary.

        The identifier of the condition of the item. For example, 1000 is the identifier for NEW. For a list of condition names and IDs, see Item Condition IDs and Names. Code so that your app gracefully handles any future changes to this list. Note: In all eBay marketplaces, Condition ID 2000 now maps to an item condition of 'Certified Refurbished', and not 'Manufacturer Refurbished'. To list an item as 'Certified Refurbished', a seller must be pre-qualified by eBay for this feature.  # noqa: E501

        :param condition_id: The condition_id of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._condition_id = condition_id

    @property
    def current_bid_price(self):
        """Gets the current_bid_price of this ItemSummary.  # noqa: E501


        :return: The current_bid_price of this ItemSummary.  # noqa: E501
        :rtype: ConvertedAmount
        """
        return self._current_bid_price

    @current_bid_price.setter
    def current_bid_price(self, current_bid_price):
        """Sets the current_bid_price of this ItemSummary.


        :param current_bid_price: The current_bid_price of this ItemSummary.  # noqa: E501
        :type: ConvertedAmount
        """

        self._current_bid_price = current_bid_price

    @property
    def distance_from_pickup_location(self):
        """Gets the distance_from_pickup_location of this ItemSummary.  # noqa: E501


        :return: The distance_from_pickup_location of this ItemSummary.  # noqa: E501
        :rtype: TargetLocation
        """
        return self._distance_from_pickup_location

    @distance_from_pickup_location.setter
    def distance_from_pickup_location(self, distance_from_pickup_location):
        """Sets the distance_from_pickup_location of this ItemSummary.


        :param distance_from_pickup_location: The distance_from_pickup_location of this ItemSummary.  # noqa: E501
        :type: TargetLocation
        """

        self._distance_from_pickup_location = distance_from_pickup_location

    @property
    def energy_efficiency_class(self):
        """Gets the energy_efficiency_class of this ItemSummary.  # noqa: E501

        This indicates the European energy efficiency rating (EEK) of the item. Energy efficiency ratings apply to products listed by commercial vendors in electronics categories only. Currently, this field is only applicable for the Germany site, and is only returned if the seller specified the energy efficiency rating through item specifics at listing time. Rating values include A+++, A++, A+, A, B, C, D, E, F, and G.  # noqa: E501

        :return: The energy_efficiency_class of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._energy_efficiency_class

    @energy_efficiency_class.setter
    def energy_efficiency_class(self, energy_efficiency_class):
        """Sets the energy_efficiency_class of this ItemSummary.

        This indicates the European energy efficiency rating (EEK) of the item. Energy efficiency ratings apply to products listed by commercial vendors in electronics categories only. Currently, this field is only applicable for the Germany site, and is only returned if the seller specified the energy efficiency rating through item specifics at listing time. Rating values include A+++, A++, A+, A, B, C, D, E, F, and G.  # noqa: E501

        :param energy_efficiency_class: The energy_efficiency_class of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._energy_efficiency_class = energy_efficiency_class

    @property
    def epid(self):
        """Gets the epid of this ItemSummary.  # noqa: E501

        An ePID is the eBay product identifier of a product from the eBay product catalog. This indicates the product in which the item belongs.  # noqa: E501

        :return: The epid of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._epid

    @epid.setter
    def epid(self, epid):
        """Sets the epid of this ItemSummary.

        An ePID is the eBay product identifier of a product from the eBay product catalog. This indicates the product in which the item belongs.  # noqa: E501

        :param epid: The epid of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._epid = epid

    @property
    def image(self):
        """Gets the image of this ItemSummary.  # noqa: E501


        :return: The image of this ItemSummary.  # noqa: E501
        :rtype: Image
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this ItemSummary.


        :param image: The image of this ItemSummary.  # noqa: E501
        :type: Image
        """

        self._image = image

    @property
    def item_affiliate_web_url(self):
        """Gets the item_affiliate_web_url of this ItemSummary.  # noqa: E501

        The URL to the View Item page of the item, which includes the affiliate tracking ID. This field is only returned if the seller enables affiliate tracking for the item by including the X-EBAY-C-ENDUSERCTX request header in the method. Note: eBay Partner Network, in order to receive a commission for your sales, you must use this URL to forward your buyer to the ebay.com site.  # noqa: E501

        :return: The item_affiliate_web_url of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._item_affiliate_web_url

    @item_affiliate_web_url.setter
    def item_affiliate_web_url(self, item_affiliate_web_url):
        """Sets the item_affiliate_web_url of this ItemSummary.

        The URL to the View Item page of the item, which includes the affiliate tracking ID. This field is only returned if the seller enables affiliate tracking for the item by including the X-EBAY-C-ENDUSERCTX request header in the method. Note: eBay Partner Network, in order to receive a commission for your sales, you must use this URL to forward your buyer to the ebay.com site.  # noqa: E501

        :param item_affiliate_web_url: The item_affiliate_web_url of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._item_affiliate_web_url = item_affiliate_web_url

    @property
    def item_group_href(self):
        """Gets the item_group_href of this ItemSummary.  # noqa: E501

        The HATEOAS reference of the parent page of the item group. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc. Note: This field is returned only for item groups.  # noqa: E501

        :return: The item_group_href of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._item_group_href

    @item_group_href.setter
    def item_group_href(self, item_group_href):
        """Sets the item_group_href of this ItemSummary.

        The HATEOAS reference of the parent page of the item group. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc. Note: This field is returned only for item groups.  # noqa: E501

        :param item_group_href: The item_group_href of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._item_group_href = item_group_href

    @property
    def item_group_type(self):
        """Gets the item_group_type of this ItemSummary.  # noqa: E501

        The indicates the item group type. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc. Currently only the SELLER_DEFINED_VARIATIONS is supported and indicates this is an item group created by the seller. Note: This field is returned only for item groups. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The item_group_type of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._item_group_type

    @item_group_type.setter
    def item_group_type(self, item_group_type):
        """Sets the item_group_type of this ItemSummary.

        The indicates the item group type. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc. Currently only the SELLER_DEFINED_VARIATIONS is supported and indicates this is an item group created by the seller. Note: This field is returned only for item groups. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param item_group_type: The item_group_type of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._item_group_type = item_group_type

    @property
    def item_href(self):
        """Gets the item_href of this ItemSummary.  # noqa: E501

        The URI for the Browse API getItem method, which can be used to retrieve more details about items in the search results.  # noqa: E501

        :return: The item_href of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._item_href

    @item_href.setter
    def item_href(self, item_href):
        """Sets the item_href of this ItemSummary.

        The URI for the Browse API getItem method, which can be used to retrieve more details about items in the search results.  # noqa: E501

        :param item_href: The item_href of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._item_href = item_href

    @property
    def item_id(self):
        """Gets the item_id of this ItemSummary.  # noqa: E501

        The unique RESTful identifier of the item.  # noqa: E501

        :return: The item_id of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this ItemSummary.

        The unique RESTful identifier of the item.  # noqa: E501

        :param item_id: The item_id of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._item_id = item_id

    @property
    def item_location(self):
        """Gets the item_location of this ItemSummary.  # noqa: E501


        :return: The item_location of this ItemSummary.  # noqa: E501
        :rtype: ItemLocationImpl
        """
        return self._item_location

    @item_location.setter
    def item_location(self, item_location):
        """Sets the item_location of this ItemSummary.


        :param item_location: The item_location of this ItemSummary.  # noqa: E501
        :type: ItemLocationImpl
        """

        self._item_location = item_location

    @property
    def item_web_url(self):
        """Gets the item_web_url of this ItemSummary.  # noqa: E501

        The URL to the View Item page of the item. This enables you to include a &quot;Report Item on eBay&quot; hyperlink that takes the buyer to the View Item page on eBay. From there they can report any issues regarding this item to eBay.  # noqa: E501

        :return: The item_web_url of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._item_web_url

    @item_web_url.setter
    def item_web_url(self, item_web_url):
        """Sets the item_web_url of this ItemSummary.

        The URL to the View Item page of the item. This enables you to include a &quot;Report Item on eBay&quot; hyperlink that takes the buyer to the View Item page on eBay. From there they can report any issues regarding this item to eBay.  # noqa: E501

        :param item_web_url: The item_web_url of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._item_web_url = item_web_url

    @property
    def legacy_item_id(self):
        """Gets the legacy_item_id of this ItemSummary.  # noqa: E501

        The unique identifier of the eBay listing that contains the item. This is the traditional/legacy ID that is often seen in the URL of the listing View Item page.  # noqa: E501

        :return: The legacy_item_id of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._legacy_item_id

    @legacy_item_id.setter
    def legacy_item_id(self, legacy_item_id):
        """Sets the legacy_item_id of this ItemSummary.

        The unique identifier of the eBay listing that contains the item. This is the traditional/legacy ID that is often seen in the URL of the listing View Item page.  # noqa: E501

        :param legacy_item_id: The legacy_item_id of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._legacy_item_id = legacy_item_id

    @property
    def marketing_price(self):
        """Gets the marketing_price of this ItemSummary.  # noqa: E501


        :return: The marketing_price of this ItemSummary.  # noqa: E501
        :rtype: MarketingPrice
        """
        return self._marketing_price

    @marketing_price.setter
    def marketing_price(self, marketing_price):
        """Sets the marketing_price of this ItemSummary.


        :param marketing_price: The marketing_price of this ItemSummary.  # noqa: E501
        :type: MarketingPrice
        """

        self._marketing_price = marketing_price

    @property
    def pickup_options(self):
        """Gets the pickup_options of this ItemSummary.  # noqa: E501

        This container returns the local pickup options available to the buyer. This container is only returned if the user is searching for local pickup items and set the local pickup filters in the method request.  # noqa: E501

        :return: The pickup_options of this ItemSummary.  # noqa: E501
        :rtype: list[PickupOptionSummary]
        """
        return self._pickup_options

    @pickup_options.setter
    def pickup_options(self, pickup_options):
        """Sets the pickup_options of this ItemSummary.

        This container returns the local pickup options available to the buyer. This container is only returned if the user is searching for local pickup items and set the local pickup filters in the method request.  # noqa: E501

        :param pickup_options: The pickup_options of this ItemSummary.  # noqa: E501
        :type: list[PickupOptionSummary]
        """

        self._pickup_options = pickup_options

    @property
    def price(self):
        """Gets the price of this ItemSummary.  # noqa: E501


        :return: The price of this ItemSummary.  # noqa: E501
        :rtype: ConvertedAmount
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this ItemSummary.


        :param price: The price of this ItemSummary.  # noqa: E501
        :type: ConvertedAmount
        """

        self._price = price

    @property
    def price_display_condition(self):
        """Gets the price_display_condition of this ItemSummary.  # noqa: E501

        Indicates when in the buying flow the item's price can appear for minimum advertised price (MAP) items, which is the lowest price a retailer can advertise/show for this item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/browse/types/gct:PriceDisplayConditionEnum'>eBay API documentation</a>  # noqa: E501

        :return: The price_display_condition of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._price_display_condition

    @price_display_condition.setter
    def price_display_condition(self, price_display_condition):
        """Sets the price_display_condition of this ItemSummary.

        Indicates when in the buying flow the item's price can appear for minimum advertised price (MAP) items, which is the lowest price a retailer can advertise/show for this item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/browse/types/gct:PriceDisplayConditionEnum'>eBay API documentation</a>  # noqa: E501

        :param price_display_condition: The price_display_condition of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._price_display_condition = price_display_condition

    @property
    def qualified_programs(self):
        """Gets the qualified_programs of this ItemSummary.  # noqa: E501

        An array of the qualified programs available for the item, such as EBAY_PLUS and AUTHENTICITY_VERIFICATION. eBay Plus is a premium account option for buyers, which provides benefits such as fast free domestic shipping and free returns on selected items. Top-Rated eBay sellers must opt in to eBay Plus to be able to offer the program on qualifying listings. Sellers must commit to next-day delivery of those items. Note: eBay Plus is available only to buyers in Germany, Austria, and Australia marketplaces. The eBay Authenticity Verification program enables third-party authenticators to perform authentication verification inspections on items such as watches and sneakers.  # noqa: E501

        :return: The qualified_programs of this ItemSummary.  # noqa: E501
        :rtype: list[str]
        """
        return self._qualified_programs

    @qualified_programs.setter
    def qualified_programs(self, qualified_programs):
        """Sets the qualified_programs of this ItemSummary.

        An array of the qualified programs available for the item, such as EBAY_PLUS and AUTHENTICITY_VERIFICATION. eBay Plus is a premium account option for buyers, which provides benefits such as fast free domestic shipping and free returns on selected items. Top-Rated eBay sellers must opt in to eBay Plus to be able to offer the program on qualifying listings. Sellers must commit to next-day delivery of those items. Note: eBay Plus is available only to buyers in Germany, Austria, and Australia marketplaces. The eBay Authenticity Verification program enables third-party authenticators to perform authentication verification inspections on items such as watches and sneakers.  # noqa: E501

        :param qualified_programs: The qualified_programs of this ItemSummary.  # noqa: E501
        :type: list[str]
        """

        self._qualified_programs = qualified_programs

    @property
    def seller(self):
        """Gets the seller of this ItemSummary.  # noqa: E501


        :return: The seller of this ItemSummary.  # noqa: E501
        :rtype: Seller
        """
        return self._seller

    @seller.setter
    def seller(self, seller):
        """Sets the seller of this ItemSummary.


        :param seller: The seller of this ItemSummary.  # noqa: E501
        :type: Seller
        """

        self._seller = seller

    @property
    def shipping_options(self):
        """Gets the shipping_options of this ItemSummary.  # noqa: E501

        This container returns the shipping options available to ship the item.  # noqa: E501

        :return: The shipping_options of this ItemSummary.  # noqa: E501
        :rtype: list[ShippingOptionSummary]
        """
        return self._shipping_options

    @shipping_options.setter
    def shipping_options(self, shipping_options):
        """Sets the shipping_options of this ItemSummary.

        This container returns the shipping options available to ship the item.  # noqa: E501

        :param shipping_options: The shipping_options of this ItemSummary.  # noqa: E501
        :type: list[ShippingOptionSummary]
        """

        self._shipping_options = shipping_options

    @property
    def short_description(self):
        """Gets the short_description of this ItemSummary.  # noqa: E501

        This text string is derived from the item condition and the item aspects (such as size, color, capacity, model, brand, etc.). Sometimes the title doesn't give enough information but the description is too big. Surfacing the shortDescription can often provide buyers with the additional information that could help them make a buying decision. For example: &quot; title&quot;: &quot;Petrel U42W FPV Drone RC Quadcopter w/HD Camera Live Video One Key Off / Landing&quot;, &quot;shortDescription&quot;: &quot;1 U42W Quadcopter. Syma X5SW-V3 Wifi FPV RC Drone Quadcopter 2.4Ghz 6-Axis Gyro with Headless Mode. Syma X20 Pocket Drone 2.4Ghz Mini RC Quadcopter Headless Mode Altitude Hold. One Key Take Off / Landing function: allow beginner to easy to fly the drone without any skill.&quot;, Restriction: This field is returned by the search method only when fieldgroups = EXTENDED.  # noqa: E501

        :return: The short_description of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """Sets the short_description of this ItemSummary.

        This text string is derived from the item condition and the item aspects (such as size, color, capacity, model, brand, etc.). Sometimes the title doesn't give enough information but the description is too big. Surfacing the shortDescription can often provide buyers with the additional information that could help them make a buying decision. For example: &quot; title&quot;: &quot;Petrel U42W FPV Drone RC Quadcopter w/HD Camera Live Video One Key Off / Landing&quot;, &quot;shortDescription&quot;: &quot;1 U42W Quadcopter. Syma X5SW-V3 Wifi FPV RC Drone Quadcopter 2.4Ghz 6-Axis Gyro with Headless Mode. Syma X20 Pocket Drone 2.4Ghz Mini RC Quadcopter Headless Mode Altitude Hold. One Key Take Off / Landing function: allow beginner to easy to fly the drone without any skill.&quot;, Restriction: This field is returned by the search method only when fieldgroups = EXTENDED.  # noqa: E501

        :param short_description: The short_description of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._short_description = short_description

    @property
    def thumbnail_images(self):
        """Gets the thumbnail_images of this ItemSummary.  # noqa: E501

        An array of thumbnail images for the item.  # noqa: E501

        :return: The thumbnail_images of this ItemSummary.  # noqa: E501
        :rtype: list[Image]
        """
        return self._thumbnail_images

    @thumbnail_images.setter
    def thumbnail_images(self, thumbnail_images):
        """Sets the thumbnail_images of this ItemSummary.

        An array of thumbnail images for the item.  # noqa: E501

        :param thumbnail_images: The thumbnail_images of this ItemSummary.  # noqa: E501
        :type: list[Image]
        """

        self._thumbnail_images = thumbnail_images

    @property
    def title(self):
        """Gets the title of this ItemSummary.  # noqa: E501

        The seller-created title of the item. Maximum Length: 80 characters  # noqa: E501

        :return: The title of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this ItemSummary.

        The seller-created title of the item. Maximum Length: 80 characters  # noqa: E501

        :param title: The title of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def unit_price(self):
        """Gets the unit_price of this ItemSummary.  # noqa: E501


        :return: The unit_price of this ItemSummary.  # noqa: E501
        :rtype: ConvertedAmount
        """
        return self._unit_price

    @unit_price.setter
    def unit_price(self, unit_price):
        """Sets the unit_price of this ItemSummary.


        :param unit_price: The unit_price of this ItemSummary.  # noqa: E501
        :type: ConvertedAmount
        """

        self._unit_price = unit_price

    @property
    def unit_pricing_measure(self):
        """Gets the unit_pricing_measure of this ItemSummary.  # noqa: E501

        The designation, such as size, weight, volume, count, etc., that was used to specify the quantity of the item. This helps buyers compare prices. For example, the following tells the buyer that the item is 7.99 per 100 grams. &quot;unitPricingMeasure&quot;: &quot;100g&quot;, &quot;unitPrice&quot;: { &nbsp;&nbsp;&quot;value&quot;: &quot;7.99&quot;, &nbsp;&nbsp;&quot;currency&quot;: &quot;GBP&quot;  # noqa: E501

        :return: The unit_pricing_measure of this ItemSummary.  # noqa: E501
        :rtype: str
        """
        return self._unit_pricing_measure

    @unit_pricing_measure.setter
    def unit_pricing_measure(self, unit_pricing_measure):
        """Sets the unit_pricing_measure of this ItemSummary.

        The designation, such as size, weight, volume, count, etc., that was used to specify the quantity of the item. This helps buyers compare prices. For example, the following tells the buyer that the item is 7.99 per 100 grams. &quot;unitPricingMeasure&quot;: &quot;100g&quot;, &quot;unitPrice&quot;: { &nbsp;&nbsp;&quot;value&quot;: &quot;7.99&quot;, &nbsp;&nbsp;&quot;currency&quot;: &quot;GBP&quot;  # noqa: E501

        :param unit_pricing_measure: The unit_pricing_measure of this ItemSummary.  # noqa: E501
        :type: str
        """

        self._unit_pricing_measure = unit_pricing_measure

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ItemSummary, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ItemSummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
