# coding: utf-8

"""
    Browse API

    <p>The Browse API has the following resources:</p>   <ul> <li><b> item_summary: </b> Lets shoppers search for specific items by keyword, GTIN, category, charity, product, or item aspects and refine the results by using filters, such as aspects, compatibility, and fields values.</li>  <li> <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#API\" target=\"_blank\"><img src=\"/cms/img/docs/experimental-icon.svg\" class=\"legend-icon experimental-icon\" alt=\"Experimental Release\" title=\"Experimental Release\" />&nbsp;(Experimental)</a> <b> search_by_image: </b> Lets shoppers search for specific items by image. You can refine the results by using URI parameters and filters.</li>   <li><b> item: </b> <ul><li>Lets you retrieve the details of a specific item or all the items in an item group, which is an item with variations such as color and size and check if a product is compatible with the specified item, such as if a specific car is compatible with a specific part.</li> <li>Provides a bridge between the eBay legacy APIs, such as <b> Finding</b>, and the RESTful APIs, which use different formats for the item IDs.</li>  </ul> </li>  <li><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#API\" target=\"_blank\"><img src=\"/cms/img/docs/experimental-icon.svg\" class=\"legend-icon experimental-icon\" alt=\"Experimental Release\" title=\"Experimental Release\" />&nbsp;(Experimental)</a> <b> shopping_cart: </b> Provides the ability for eBay members to see the contents of their eBay cart, and add, remove, and change the quantity of items in their eBay cart.&nbsp;&nbsp;<b> Note: </b> This resource is not available in the eBay API Explorer.</li></ul>       <p>The <b> item_summary</b>, <b> search_by_image</b>, and <b> item</b> resource calls require an <a href=\"/api-docs/static/oauth-client-credentials-grant.html\">Application access token</a>. The <b> shopping_cart</b> resource calls require a <a href=\"/api-docs/static/oauth-authorization-code-grant.html\">User access token</a>.</p>  # noqa: E501

    OpenAPI spec version: v1.4.2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ShipToRegion(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'region_id': 'str',
        'region_name': 'str',
        'region_type': 'str'
    }

    attribute_map = {
        'region_id': 'regionId',
        'region_name': 'regionName',
        'region_type': 'regionType'
    }

    def __init__(self, region_id=None, region_name=None, region_type=None):  # noqa: E501
        """ShipToRegion - a model defined in Swagger"""  # noqa: E501
        self._region_id = None
        self._region_name = None
        self._region_type = None
        self.discriminator = None
        if region_id is not None:
            self.region_id = region_id
        if region_name is not None:
            self.region_name = region_name
        if region_type is not None:
            self.region_type = region_type

    @property
    def region_id(self):
        """Gets the region_id of this ShipToRegion.  # noqa: E501

        The unique identifier of the shipping region. The value returned here is dependent on the corresponding regionType value. The regionId value for a region does not vary based on the eBay marketplace. However, the corresponding regionName value for a region is a localized, text-based description of the shipping region. If the regionType value is WORLDWIDE, the regionId value will also be WORLDWIDE. If the regionType value is WORLD_REGION, the regionId value will be one of the following: AFRICA, AMERICAS, ASIA, AUSTRALIA, CENTRAL_AMERICA_AND_CARIBBEAN, EUROPE, EUROPEAN_UNION, GREATER_CHINA, MIDDLE_EAST, NORTH_AMERICA, OCEANIA, SOUTH_AMERICA, SOUTHEAST_ASIA or CHANNEL_ISLANDS. If the regionType value is COUNTRY, the regionId value will be the two-letter code for the country, as defined in the ISO 3166 standard. If the regionType value is STATE_OR_PROVINCE, the regionId value will either be the two-letter code for US states and DC (as defined on this Social Security Administration page), or the two-letter code for Canadian provinces (as defined by this Canada Post page). If the regionType value is COUNTRY_REGION, the regionId value may be one of following: _AH (if a seller is not willing to ship to Alaska/Hawaii), _PR (if the seller is not willing to ship to US Protectorates), _AP (if seller is not willing to ship to a US Army or Fleet Post Office), and PO_BOX (if the seller is not willing to ship to a Post Office Box).  # noqa: E501

        :return: The region_id of this ShipToRegion.  # noqa: E501
        :rtype: str
        """
        return self._region_id

    @region_id.setter
    def region_id(self, region_id):
        """Sets the region_id of this ShipToRegion.

        The unique identifier of the shipping region. The value returned here is dependent on the corresponding regionType value. The regionId value for a region does not vary based on the eBay marketplace. However, the corresponding regionName value for a region is a localized, text-based description of the shipping region. If the regionType value is WORLDWIDE, the regionId value will also be WORLDWIDE. If the regionType value is WORLD_REGION, the regionId value will be one of the following: AFRICA, AMERICAS, ASIA, AUSTRALIA, CENTRAL_AMERICA_AND_CARIBBEAN, EUROPE, EUROPEAN_UNION, GREATER_CHINA, MIDDLE_EAST, NORTH_AMERICA, OCEANIA, SOUTH_AMERICA, SOUTHEAST_ASIA or CHANNEL_ISLANDS. If the regionType value is COUNTRY, the regionId value will be the two-letter code for the country, as defined in the ISO 3166 standard. If the regionType value is STATE_OR_PROVINCE, the regionId value will either be the two-letter code for US states and DC (as defined on this Social Security Administration page), or the two-letter code for Canadian provinces (as defined by this Canada Post page). If the regionType value is COUNTRY_REGION, the regionId value may be one of following: _AH (if a seller is not willing to ship to Alaska/Hawaii), _PR (if the seller is not willing to ship to US Protectorates), _AP (if seller is not willing to ship to a US Army or Fleet Post Office), and PO_BOX (if the seller is not willing to ship to a Post Office Box).  # noqa: E501

        :param region_id: The region_id of this ShipToRegion.  # noqa: E501
        :type: str
        """

        self._region_id = region_id

    @property
    def region_name(self):
        """Gets the region_name of this ShipToRegion.  # noqa: E501

        A localized text string that indicates the name of the shipping region. The value returned here is dependent on the corresponding regionType value. If the regionType value is WORLDWIDE, the regionName value will show Worldwide. If the regionType value is WORLD_REGION, the regionName value will be a localized text string for one of the following large geographical regions: Africa, Americas, Asia, Australia, Central America and Caribbean, Europe, European Union, Greater China, Middle East, North America, Oceania, South America, Southeast Asia, or Channel Islands. If the regionType value is COUNTRY, the regionName value will be a localized text string for any country in the world. If the regionType value is STATE_OR_PROVINCE, the regionName value will be a localized text string for any US state or Canadian province. If the regionType value is COUNTRY_REGION, the regionName value may be a localized version of one of the following: Alaska/Hawaii, US Protectorates, APO/FPO (Army or Fleet Post Office), or PO BOX.  # noqa: E501

        :return: The region_name of this ShipToRegion.  # noqa: E501
        :rtype: str
        """
        return self._region_name

    @region_name.setter
    def region_name(self, region_name):
        """Sets the region_name of this ShipToRegion.

        A localized text string that indicates the name of the shipping region. The value returned here is dependent on the corresponding regionType value. If the regionType value is WORLDWIDE, the regionName value will show Worldwide. If the regionType value is WORLD_REGION, the regionName value will be a localized text string for one of the following large geographical regions: Africa, Americas, Asia, Australia, Central America and Caribbean, Europe, European Union, Greater China, Middle East, North America, Oceania, South America, Southeast Asia, or Channel Islands. If the regionType value is COUNTRY, the regionName value will be a localized text string for any country in the world. If the regionType value is STATE_OR_PROVINCE, the regionName value will be a localized text string for any US state or Canadian province. If the regionType value is COUNTRY_REGION, the regionName value may be a localized version of one of the following: Alaska/Hawaii, US Protectorates, APO/FPO (Army or Fleet Post Office), or PO BOX.  # noqa: E501

        :param region_name: The region_name of this ShipToRegion.  # noqa: E501
        :type: str
        """

        self._region_name = region_name

    @property
    def region_type(self):
        """Gets the region_type of this ShipToRegion.  # noqa: E501

        An enumeration value that indicates the level or type of shipping region. Valid Values: COUNTRY_REGION - Indicates the region is a domestic region or special location within a country. STATE_OR_PROVINCE - Indicates the region is a state or province within a country, such as California or New York in the US, or Ontario or Alberta in Canada. COUNTRY - Indicates the region is a single country. WORLD_REGION - Indicates the region is a world region, such as Africa, the Middle East, or Southeast Asia. WORLDWIDE - Indicates the region is the entire world. This value is only applicable for included shiping regions, and not excluded shipping regions. For more detail on the actual regionName/regionId values that will be returned based on the regionType value, see the regionId and/or regionName field descriptions. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/browse/types/ba:RegionTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The region_type of this ShipToRegion.  # noqa: E501
        :rtype: str
        """
        return self._region_type

    @region_type.setter
    def region_type(self, region_type):
        """Sets the region_type of this ShipToRegion.

        An enumeration value that indicates the level or type of shipping region. Valid Values: COUNTRY_REGION - Indicates the region is a domestic region or special location within a country. STATE_OR_PROVINCE - Indicates the region is a state or province within a country, such as California or New York in the US, or Ontario or Alberta in Canada. COUNTRY - Indicates the region is a single country. WORLD_REGION - Indicates the region is a world region, such as Africa, the Middle East, or Southeast Asia. WORLDWIDE - Indicates the region is the entire world. This value is only applicable for included shiping regions, and not excluded shipping regions. For more detail on the actual regionName/regionId values that will be returned based on the regionType value, see the regionId and/or regionName field descriptions. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/browse/types/ba:RegionTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param region_type: The region_type of this ShipToRegion.  # noqa: E501
        :type: str
        """

        self._region_type = region_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ShipToRegion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShipToRegion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
