# coding: utf-8

"""
    Item Feed Service

    The Feed API provides the ability to download TSV_GZIP feed files containing eBay items and an hourly snapshot file of the items that have changed within an hour for a specific category, date and marketplace. <p>In addition to the API, there is an open source <a href=\"https://github.com/eBay/FeedSDK\" target=\"_blank\">Feed SDK</a> written in Java that downloads, combines files into a single file when needed, and unzips the entire feed file. It also lets you specify field filters to curate the items in the file.</p>  # noqa: E501

    OpenAPI spec version: v1_beta.25.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Item(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'item_id': 'str',
        'title': 'str',
        'image_url': 'str',
        'category': 'str',
        'category_id': 'str',
        'buying_options': 'str',
        'seller_username': 'str',
        'seller_feedback_percentage': 'str',
        'seller_feedback_score': 'str',
        'gtin': 'str',
        'brand': 'str',
        'mpn': 'str',
        'epid': 'str',
        'condition_id': 'str',
        'condition': 'str',
        'price_value': 'str',
        'price_currency': 'str',
        'primary_item_group_id': 'str',
        'primary_item_group_type': 'str',
        'item_end_date': 'str',
        'seller_item_revision': 'str',
        'item_location_country': 'str',
        'localized_aspects': 'str',
        'seller_trust_level': 'str',
        'availability': 'str',
        'image_altering_prohibited': 'bool',
        'estimated_available_quantity': 'int',
        'availability_threshold_type': 'str',
        'availability_threshold': 'int',
        'returns_accepted': 'bool',
        'return_period_value': 'int',
        'return_period_unit': 'str',
        'refund_method': 'str',
        'return_method': 'str',
        'return_shipping_cost_payer': 'str',
        'accepted_payment_methods': 'str',
        'delivery_options': 'str',
        'ship_to_included_regions': 'str',
        'ship_to_excluded_regions': 'str',
        'inferred_epid': 'str',
        'inferred_gtin': 'str',
        'inferred_brand': 'str',
        'inferred_mpn': 'str',
        'inferred_localized_aspects': 'str',
        'additional_image_urls': 'str',
        'original_price_value': 'str',
        'original_price_currency': 'str',
        'discount_amount': 'str',
        'discount_percentage': 'str',
        'energy_efficiency_class': 'str',
        'qualified_programs': 'str',
        'lot_size': 'int',
        'length_unit_of_measure': 'str',
        'package_width': 'str',
        'package_height': 'str',
        'package_length': 'str',
        'weight_unit_of_measure': 'str',
        'package_weight': 'str',
        'shipping_cost_type': 'str',
        'shipping_cost': 'str',
        'additional_shipping_cost_per_unit': 'str',
        'quantity_used_for_estimate': 'int',
        'shipping_carrier_code': 'str',
        'shipping_service_code': 'str',
        'shipping_type': 'str',
        'unit_price': 'str',
        'unit_pricing_measure': 'str',
        'legacy_item_id': 'str',
        'alerts': 'str',
        'seller_account_type': 'str',
        'tyre_label_image_url': 'str'
    }

    attribute_map = {
        'item_id': 'itemId',
        'title': 'title',
        'image_url': 'imageUrl',
        'category': 'category',
        'category_id': 'categoryId',
        'buying_options': 'buyingOptions',
        'seller_username': 'sellerUsername',
        'seller_feedback_percentage': 'sellerFeedbackPercentage',
        'seller_feedback_score': 'sellerFeedbackScore',
        'gtin': 'gtin',
        'brand': 'brand',
        'mpn': 'mpn',
        'epid': 'epid',
        'condition_id': 'conditionId',
        'condition': 'condition',
        'price_value': 'priceValue',
        'price_currency': 'priceCurrency',
        'primary_item_group_id': 'primaryItemGroupId',
        'primary_item_group_type': 'primaryItemGroupType',
        'item_end_date': 'itemEndDate',
        'seller_item_revision': 'sellerItemRevision',
        'item_location_country': 'itemLocationCountry',
        'localized_aspects': 'localizedAspects',
        'seller_trust_level': 'sellerTrustLevel',
        'availability': 'availability',
        'image_altering_prohibited': 'imageAlteringProhibited',
        'estimated_available_quantity': 'estimatedAvailableQuantity',
        'availability_threshold_type': 'availabilityThresholdType',
        'availability_threshold': 'availabilityThreshold',
        'returns_accepted': 'returnsAccepted',
        'return_period_value': 'returnPeriodValue',
        'return_period_unit': 'returnPeriodUnit',
        'refund_method': 'refundMethod',
        'return_method': 'returnMethod',
        'return_shipping_cost_payer': 'returnShippingCostPayer',
        'accepted_payment_methods': 'acceptedPaymentMethods',
        'delivery_options': 'deliveryOptions',
        'ship_to_included_regions': 'shipToIncludedRegions',
        'ship_to_excluded_regions': 'shipToExcludedRegions',
        'inferred_epid': 'inferredEpid',
        'inferred_gtin': 'inferredGtin',
        'inferred_brand': 'inferredBrand',
        'inferred_mpn': 'inferredMpn',
        'inferred_localized_aspects': 'inferredLocalizedAspects',
        'additional_image_urls': 'additionalImageUrls',
        'original_price_value': 'originalPriceValue',
        'original_price_currency': 'originalPriceCurrency',
        'discount_amount': 'discountAmount',
        'discount_percentage': 'discountPercentage',
        'energy_efficiency_class': 'energyEfficiencyClass',
        'qualified_programs': 'qualifiedPrograms',
        'lot_size': 'lotSize',
        'length_unit_of_measure': 'lengthUnitOfMeasure',
        'package_width': 'packageWidth',
        'package_height': 'packageHeight',
        'package_length': 'packageLength',
        'weight_unit_of_measure': 'weightUnitOfMeasure',
        'package_weight': 'packageWeight',
        'shipping_cost_type': 'shippingCostType',
        'shipping_cost': 'shippingCost',
        'additional_shipping_cost_per_unit': 'additionalShippingCostPerUnit',
        'quantity_used_for_estimate': 'quantityUsedForEstimate',
        'shipping_carrier_code': 'shippingCarrierCode',
        'shipping_service_code': 'shippingServiceCode',
        'shipping_type': 'shippingType',
        'unit_price': 'unitPrice',
        'unit_pricing_measure': 'unitPricingMeasure',
        'legacy_item_id': 'legacyItemId',
        'alerts': 'alerts',
        'seller_account_type': 'sellerAccountType',
        'tyre_label_image_url': 'tyreLabelImageUrl'
    }

    def __init__(self, item_id=None, title=None, image_url=None, category=None, category_id=None, buying_options=None, seller_username=None, seller_feedback_percentage=None, seller_feedback_score=None, gtin=None, brand=None, mpn=None, epid=None, condition_id=None, condition=None, price_value=None, price_currency=None, primary_item_group_id=None, primary_item_group_type=None, item_end_date=None, seller_item_revision=None, item_location_country=None, localized_aspects=None, seller_trust_level=None, availability=None, image_altering_prohibited=None, estimated_available_quantity=None, availability_threshold_type=None, availability_threshold=None, returns_accepted=None, return_period_value=None, return_period_unit=None, refund_method=None, return_method=None, return_shipping_cost_payer=None, accepted_payment_methods=None, delivery_options=None, ship_to_included_regions=None, ship_to_excluded_regions=None, inferred_epid=None, inferred_gtin=None, inferred_brand=None, inferred_mpn=None, inferred_localized_aspects=None, additional_image_urls=None, original_price_value=None, original_price_currency=None, discount_amount=None, discount_percentage=None, energy_efficiency_class=None, qualified_programs=None, lot_size=None, length_unit_of_measure=None, package_width=None, package_height=None, package_length=None, weight_unit_of_measure=None, package_weight=None, shipping_cost_type=None, shipping_cost=None, additional_shipping_cost_per_unit=None, quantity_used_for_estimate=None, shipping_carrier_code=None, shipping_service_code=None, shipping_type=None, unit_price=None, unit_pricing_measure=None, legacy_item_id=None, alerts=None, seller_account_type=None, tyre_label_image_url=None):  # noqa: E501
        """Item - a model defined in Swagger"""  # noqa: E501
        self._item_id = None
        self._title = None
        self._image_url = None
        self._category = None
        self._category_id = None
        self._buying_options = None
        self._seller_username = None
        self._seller_feedback_percentage = None
        self._seller_feedback_score = None
        self._gtin = None
        self._brand = None
        self._mpn = None
        self._epid = None
        self._condition_id = None
        self._condition = None
        self._price_value = None
        self._price_currency = None
        self._primary_item_group_id = None
        self._primary_item_group_type = None
        self._item_end_date = None
        self._seller_item_revision = None
        self._item_location_country = None
        self._localized_aspects = None
        self._seller_trust_level = None
        self._availability = None
        self._image_altering_prohibited = None
        self._estimated_available_quantity = None
        self._availability_threshold_type = None
        self._availability_threshold = None
        self._returns_accepted = None
        self._return_period_value = None
        self._return_period_unit = None
        self._refund_method = None
        self._return_method = None
        self._return_shipping_cost_payer = None
        self._accepted_payment_methods = None
        self._delivery_options = None
        self._ship_to_included_regions = None
        self._ship_to_excluded_regions = None
        self._inferred_epid = None
        self._inferred_gtin = None
        self._inferred_brand = None
        self._inferred_mpn = None
        self._inferred_localized_aspects = None
        self._additional_image_urls = None
        self._original_price_value = None
        self._original_price_currency = None
        self._discount_amount = None
        self._discount_percentage = None
        self._energy_efficiency_class = None
        self._qualified_programs = None
        self._lot_size = None
        self._length_unit_of_measure = None
        self._package_width = None
        self._package_height = None
        self._package_length = None
        self._weight_unit_of_measure = None
        self._package_weight = None
        self._shipping_cost_type = None
        self._shipping_cost = None
        self._additional_shipping_cost_per_unit = None
        self._quantity_used_for_estimate = None
        self._shipping_carrier_code = None
        self._shipping_service_code = None
        self._shipping_type = None
        self._unit_price = None
        self._unit_pricing_measure = None
        self._legacy_item_id = None
        self._alerts = None
        self._seller_account_type = None
        self._tyre_label_image_url = None
        self.discriminator = None
        if item_id is not None:
            self.item_id = item_id
        if title is not None:
            self.title = title
        if image_url is not None:
            self.image_url = image_url
        if category is not None:
            self.category = category
        if category_id is not None:
            self.category_id = category_id
        if buying_options is not None:
            self.buying_options = buying_options
        if seller_username is not None:
            self.seller_username = seller_username
        if seller_feedback_percentage is not None:
            self.seller_feedback_percentage = seller_feedback_percentage
        if seller_feedback_score is not None:
            self.seller_feedback_score = seller_feedback_score
        if gtin is not None:
            self.gtin = gtin
        if brand is not None:
            self.brand = brand
        if mpn is not None:
            self.mpn = mpn
        if epid is not None:
            self.epid = epid
        if condition_id is not None:
            self.condition_id = condition_id
        if condition is not None:
            self.condition = condition
        if price_value is not None:
            self.price_value = price_value
        if price_currency is not None:
            self.price_currency = price_currency
        if primary_item_group_id is not None:
            self.primary_item_group_id = primary_item_group_id
        if primary_item_group_type is not None:
            self.primary_item_group_type = primary_item_group_type
        if item_end_date is not None:
            self.item_end_date = item_end_date
        if seller_item_revision is not None:
            self.seller_item_revision = seller_item_revision
        if item_location_country is not None:
            self.item_location_country = item_location_country
        if localized_aspects is not None:
            self.localized_aspects = localized_aspects
        if seller_trust_level is not None:
            self.seller_trust_level = seller_trust_level
        if availability is not None:
            self.availability = availability
        if image_altering_prohibited is not None:
            self.image_altering_prohibited = image_altering_prohibited
        if estimated_available_quantity is not None:
            self.estimated_available_quantity = estimated_available_quantity
        if availability_threshold_type is not None:
            self.availability_threshold_type = availability_threshold_type
        if availability_threshold is not None:
            self.availability_threshold = availability_threshold
        if returns_accepted is not None:
            self.returns_accepted = returns_accepted
        if return_period_value is not None:
            self.return_period_value = return_period_value
        if return_period_unit is not None:
            self.return_period_unit = return_period_unit
        if refund_method is not None:
            self.refund_method = refund_method
        if return_method is not None:
            self.return_method = return_method
        if return_shipping_cost_payer is not None:
            self.return_shipping_cost_payer = return_shipping_cost_payer
        if accepted_payment_methods is not None:
            self.accepted_payment_methods = accepted_payment_methods
        if delivery_options is not None:
            self.delivery_options = delivery_options
        if ship_to_included_regions is not None:
            self.ship_to_included_regions = ship_to_included_regions
        if ship_to_excluded_regions is not None:
            self.ship_to_excluded_regions = ship_to_excluded_regions
        if inferred_epid is not None:
            self.inferred_epid = inferred_epid
        if inferred_gtin is not None:
            self.inferred_gtin = inferred_gtin
        if inferred_brand is not None:
            self.inferred_brand = inferred_brand
        if inferred_mpn is not None:
            self.inferred_mpn = inferred_mpn
        if inferred_localized_aspects is not None:
            self.inferred_localized_aspects = inferred_localized_aspects
        if additional_image_urls is not None:
            self.additional_image_urls = additional_image_urls
        if original_price_value is not None:
            self.original_price_value = original_price_value
        if original_price_currency is not None:
            self.original_price_currency = original_price_currency
        if discount_amount is not None:
            self.discount_amount = discount_amount
        if discount_percentage is not None:
            self.discount_percentage = discount_percentage
        if energy_efficiency_class is not None:
            self.energy_efficiency_class = energy_efficiency_class
        if qualified_programs is not None:
            self.qualified_programs = qualified_programs
        if lot_size is not None:
            self.lot_size = lot_size
        if length_unit_of_measure is not None:
            self.length_unit_of_measure = length_unit_of_measure
        if package_width is not None:
            self.package_width = package_width
        if package_height is not None:
            self.package_height = package_height
        if package_length is not None:
            self.package_length = package_length
        if weight_unit_of_measure is not None:
            self.weight_unit_of_measure = weight_unit_of_measure
        if package_weight is not None:
            self.package_weight = package_weight
        if shipping_cost_type is not None:
            self.shipping_cost_type = shipping_cost_type
        if shipping_cost is not None:
            self.shipping_cost = shipping_cost
        if additional_shipping_cost_per_unit is not None:
            self.additional_shipping_cost_per_unit = additional_shipping_cost_per_unit
        if quantity_used_for_estimate is not None:
            self.quantity_used_for_estimate = quantity_used_for_estimate
        if shipping_carrier_code is not None:
            self.shipping_carrier_code = shipping_carrier_code
        if shipping_service_code is not None:
            self.shipping_service_code = shipping_service_code
        if shipping_type is not None:
            self.shipping_type = shipping_type
        if unit_price is not None:
            self.unit_price = unit_price
        if unit_pricing_measure is not None:
            self.unit_pricing_measure = unit_pricing_measure
        if legacy_item_id is not None:
            self.legacy_item_id = legacy_item_id
        if alerts is not None:
            self.alerts = alerts
        if seller_account_type is not None:
            self.seller_account_type = seller_account_type
        if tyre_label_image_url is not None:
            self.tyre_label_image_url = tyre_label_image_url

    @property
    def item_id(self):
        """Gets the item_id of this Item.  # noqa: E501

        The unique identifier of an item in eBay RESTful format. An example would be v1|1**********2|4**********2.  # noqa: E501

        :return: The item_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this Item.

        The unique identifier of an item in eBay RESTful format. An example would be v1|1**********2|4**********2.  # noqa: E501

        :param item_id: The item_id of this Item.  # noqa: E501
        :type: str
        """

        self._item_id = item_id

    @property
    def title(self):
        """Gets the title of this Item.  # noqa: E501

        The seller created title of the item. This text is an escaped string when special characters are present, using the following rules: Double quotes (&quot;) and backslashes (\\) in the Title are escaped with a backslash (\\) character If there are any tabs (\\t), double quotes (&quot;), or backslashes (\\) in the Title, the entire Title will be wrapped in double quotes. For example Before: Misty Rainforest Modern Masters 2017 MTG Magic Fetch Land Free Ship W\\Tracking Marvel Legends HULK 8&quot; Figure Avengers Age of Ultron Studios 6&quot; Series After: &quot;Misty Rainforest Modern Masters 2017 MTG Magic Fetch Land Free Ship W\\\\ Tracking&quot; &quot;Marvel Legends HULK 8\\&quot; Figure Avengers Age of Ultron Studios 6\\&quot; Series&quot;  # noqa: E501

        :return: The title of this Item.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Item.

        The seller created title of the item. This text is an escaped string when special characters are present, using the following rules: Double quotes (&quot;) and backslashes (\\) in the Title are escaped with a backslash (\\) character If there are any tabs (\\t), double quotes (&quot;), or backslashes (\\) in the Title, the entire Title will be wrapped in double quotes. For example Before: Misty Rainforest Modern Masters 2017 MTG Magic Fetch Land Free Ship W\\Tracking Marvel Legends HULK 8&quot; Figure Avengers Age of Ultron Studios 6&quot; Series After: &quot;Misty Rainforest Modern Masters 2017 MTG Magic Fetch Land Free Ship W\\\\ Tracking&quot; &quot;Marvel Legends HULK 8\\&quot; Figure Avengers Age of Ultron Studios 6\\&quot; Series&quot;  # noqa: E501

        :param title: The title of this Item.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def image_url(self):
        """Gets the image_url of this Item.  # noqa: E501

        The URL to the primary image of the item. This is the URL of the largest image available based on what the seller submitted.  # noqa: E501

        :return: The image_url of this Item.  # noqa: E501
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url):
        """Sets the image_url of this Item.

        The URL to the primary image of the item. This is the URL of the largest image available based on what the seller submitted.  # noqa: E501

        :param image_url: The image_url of this Item.  # noqa: E501
        :type: str
        """

        self._image_url = image_url

    @property
    def category(self):
        """Gets the category of this Item.  # noqa: E501

        The label of the category. For example: Toys &amp; Hobbies|Action Figures|Comic Book Heroes  # noqa: E501

        :return: The category of this Item.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this Item.

        The label of the category. For example: Toys &amp; Hobbies|Action Figures|Comic Book Heroes  # noqa: E501

        :param category: The category of this Item.  # noqa: E501
        :type: str
        """

        self._category = category

    @property
    def category_id(self):
        """Gets the category_id of this Item.  # noqa: E501

        The ID of the category of the item. For example: The ID for Toys &amp; Hobbies|Action Figures|Comic Book Heroes is 158671.  # noqa: E501

        :return: The category_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this Item.

        The ID of the category of the item. For example: The ID for Toys &amp; Hobbies|Action Figures|Comic Book Heroes is 158671.  # noqa: E501

        :param category_id: The category_id of this Item.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    @property
    def buying_options(self):
        """Gets the buying_options of this Item.  # noqa: E501

        A comma-separated list of the purchase options available for the item, such as FIXED_PRICE, AUCTION. FIXED_PRICE - Returned for fixed-price items (non-auction) AUCTION - Returned for auction items without Buy It Now feature FIXED_PRICE and AUCTION - Returned for auction items enabled with the Buy It Now feature Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The buying_options of this Item.  # noqa: E501
        :rtype: str
        """
        return self._buying_options

    @buying_options.setter
    def buying_options(self, buying_options):
        """Sets the buying_options of this Item.

        A comma-separated list of the purchase options available for the item, such as FIXED_PRICE, AUCTION. FIXED_PRICE - Returned for fixed-price items (non-auction) AUCTION - Returned for auction items without Buy It Now feature FIXED_PRICE and AUCTION - Returned for auction items enabled with the Buy It Now feature Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param buying_options: The buying_options of this Item.  # noqa: E501
        :type: str
        """

        self._buying_options = buying_options

    @property
    def seller_username(self):
        """Gets the seller_username of this Item.  # noqa: E501

        The seller's eBay user name.  # noqa: E501

        :return: The seller_username of this Item.  # noqa: E501
        :rtype: str
        """
        return self._seller_username

    @seller_username.setter
    def seller_username(self, seller_username):
        """Sets the seller_username of this Item.

        The seller's eBay user name.  # noqa: E501

        :param seller_username: The seller_username of this Item.  # noqa: E501
        :type: str
        """

        self._seller_username = seller_username

    @property
    def seller_feedback_percentage(self):
        """Gets the seller_feedback_percentage of this Item.  # noqa: E501

        The percentage of the seller's total positive feedback.  # noqa: E501

        :return: The seller_feedback_percentage of this Item.  # noqa: E501
        :rtype: str
        """
        return self._seller_feedback_percentage

    @seller_feedback_percentage.setter
    def seller_feedback_percentage(self, seller_feedback_percentage):
        """Sets the seller_feedback_percentage of this Item.

        The percentage of the seller's total positive feedback.  # noqa: E501

        :param seller_feedback_percentage: The seller_feedback_percentage of this Item.  # noqa: E501
        :type: str
        """

        self._seller_feedback_percentage = seller_feedback_percentage

    @property
    def seller_feedback_score(self):
        """Gets the seller_feedback_score of this Item.  # noqa: E501

        The feedback score of the seller. This value is based on the ratings from eBay members that bought items from this seller.  # noqa: E501

        :return: The seller_feedback_score of this Item.  # noqa: E501
        :rtype: str
        """
        return self._seller_feedback_score

    @seller_feedback_score.setter
    def seller_feedback_score(self, seller_feedback_score):
        """Sets the seller_feedback_score of this Item.

        The feedback score of the seller. This value is based on the ratings from eBay members that bought items from this seller.  # noqa: E501

        :param seller_feedback_score: The seller_feedback_score of this Item.  # noqa: E501
        :type: str
        """

        self._seller_feedback_score = seller_feedback_score

    @property
    def gtin(self):
        """Gets the gtin of this Item.  # noqa: E501

        The unique Global Trade Item Number of the item as defined by https://www.gtin.info. This can be a UPC (Universal Product Code), EAN (European Article Number), or an ISBN (International Standard Book Number) value.  # noqa: E501

        :return: The gtin of this Item.  # noqa: E501
        :rtype: str
        """
        return self._gtin

    @gtin.setter
    def gtin(self, gtin):
        """Sets the gtin of this Item.

        The unique Global Trade Item Number of the item as defined by https://www.gtin.info. This can be a UPC (Universal Product Code), EAN (European Article Number), or an ISBN (International Standard Book Number) value.  # noqa: E501

        :param gtin: The gtin of this Item.  # noqa: E501
        :type: str
        """

        self._gtin = gtin

    @property
    def brand(self):
        """Gets the brand of this Item.  # noqa: E501

        The name brand of the item, such as Nike, Apple, etc.  # noqa: E501

        :return: The brand of this Item.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this Item.

        The name brand of the item, such as Nike, Apple, etc.  # noqa: E501

        :param brand: The brand of this Item.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def mpn(self):
        """Gets the mpn of this Item.  # noqa: E501

        The manufacturer part number, which is a number that is used in combination with brand to identify a product.  # noqa: E501

        :return: The mpn of this Item.  # noqa: E501
        :rtype: str
        """
        return self._mpn

    @mpn.setter
    def mpn(self, mpn):
        """Sets the mpn of this Item.

        The manufacturer part number, which is a number that is used in combination with brand to identify a product.  # noqa: E501

        :param mpn: The mpn of this Item.  # noqa: E501
        :type: str
        """

        self._mpn = mpn

    @property
    def epid(self):
        """Gets the epid of this Item.  # noqa: E501

        The eBay product identifier of a product from the eBay product catalog. You can use this value in the Browse API search method to retrieve items for this product and in the Marketing API methods to retrieve 'also viewed' and 'also bought' products to encourage up-selling and cross-selling.  # noqa: E501

        :return: The epid of this Item.  # noqa: E501
        :rtype: str
        """
        return self._epid

    @epid.setter
    def epid(self, epid):
        """Sets the epid of this Item.

        The eBay product identifier of a product from the eBay product catalog. You can use this value in the Browse API search method to retrieve items for this product and in the Marketing API methods to retrieve 'also viewed' and 'also bought' products to encourage up-selling and cross-selling.  # noqa: E501

        :param epid: The epid of this Item.  # noqa: E501
        :type: str
        """

        self._epid = epid

    @property
    def condition_id(self):
        """Gets the condition_id of this Item.  # noqa: E501

        The identifier of the condition of the item. For example, 1000 is the identifier for NEW. For a list of condition names and IDs, see Item Condition IDs and Names. Note: In all eBay marketplaces, Condition ID 2000 now maps to an item condition of 'Certified Refurbished', and not 'Manufacturer Refurbished'. To list an item as 'Certified Refurbished', a seller must be pre-qualified by eBay for this feature. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The condition_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._condition_id

    @condition_id.setter
    def condition_id(self, condition_id):
        """Sets the condition_id of this Item.

        The identifier of the condition of the item. For example, 1000 is the identifier for NEW. For a list of condition names and IDs, see Item Condition IDs and Names. Note: In all eBay marketplaces, Condition ID 2000 now maps to an item condition of 'Certified Refurbished', and not 'Manufacturer Refurbished'. To list an item as 'Certified Refurbished', a seller must be pre-qualified by eBay for this feature. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param condition_id: The condition_id of this Item.  # noqa: E501
        :type: str
        """

        self._condition_id = condition_id

    @property
    def condition(self):
        """Gets the condition of this Item.  # noqa: E501

        The text describing the condition of the item. For a list of condition names, see Item Condition IDs and Names. Note: In all eBay marketplaces, Condition ID 2000 now maps to an item condition of 'Certified Refurbished', and not 'Manufacturer Refurbished'. To list an item as 'Certified Refurbished', a seller must be pre-qualified by eBay for this feature. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The condition of this Item.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this Item.

        The text describing the condition of the item. For a list of condition names, see Item Condition IDs and Names. Note: In all eBay marketplaces, Condition ID 2000 now maps to an item condition of 'Certified Refurbished', and not 'Manufacturer Refurbished'. To list an item as 'Certified Refurbished', a seller must be pre-qualified by eBay for this feature. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param condition: The condition of this Item.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def price_value(self):
        """Gets the price_value of this Item.  # noqa: E501

        The price of the item, which can be a discounted price. If it is discounted, information about the discount is returned in the originalPriceValue, originalPriceCurrency, discountAmount, and discountPercentage columns. Note: The price includes the value-added tax (VAT) for applicable jurisdictions when requested from supported marketplaces. In this case, users must pass the X-EBAY-C-MARKETPLACE-ID request header specifying the supported marketplace (such as EBAY_GB) to see the VAT-inclusive pricing. For more information on VAT, refer to VAT Obligations in the EU.  # noqa: E501

        :return: The price_value of this Item.  # noqa: E501
        :rtype: str
        """
        return self._price_value

    @price_value.setter
    def price_value(self, price_value):
        """Sets the price_value of this Item.

        The price of the item, which can be a discounted price. If it is discounted, information about the discount is returned in the originalPriceValue, originalPriceCurrency, discountAmount, and discountPercentage columns. Note: The price includes the value-added tax (VAT) for applicable jurisdictions when requested from supported marketplaces. In this case, users must pass the X-EBAY-C-MARKETPLACE-ID request header specifying the supported marketplace (such as EBAY_GB) to see the VAT-inclusive pricing. For more information on VAT, refer to VAT Obligations in the EU.  # noqa: E501

        :param price_value: The price_value of this Item.  # noqa: E501
        :type: str
        """

        self._price_value = price_value

    @property
    def price_currency(self):
        """Gets the price_currency of this Item.  # noqa: E501

        The currency used for the price of the item. Generally, this is the currency used by the country of the eBay site offering the item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:CurrencyCodeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The price_currency of this Item.  # noqa: E501
        :rtype: str
        """
        return self._price_currency

    @price_currency.setter
    def price_currency(self, price_currency):
        """Sets the price_currency of this Item.

        The currency used for the price of the item. Generally, this is the currency used by the country of the eBay site offering the item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:CurrencyCodeEnum'>eBay API documentation</a>  # noqa: E501

        :param price_currency: The price_currency of this Item.  # noqa: E501
        :type: str
        """

        self._price_currency = price_currency

    @property
    def primary_item_group_id(self):
        """Gets the primary_item_group_id of this Item.  # noqa: E501

        The unique identifier for the item group that contains this item. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc.  # noqa: E501

        :return: The primary_item_group_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._primary_item_group_id

    @primary_item_group_id.setter
    def primary_item_group_id(self, primary_item_group_id):
        """Sets the primary_item_group_id of this Item.

        The unique identifier for the item group that contains this item. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc.  # noqa: E501

        :param primary_item_group_id: The primary_item_group_id of this Item.  # noqa: E501
        :type: str
        """

        self._primary_item_group_id = primary_item_group_id

    @property
    def primary_item_group_type(self):
        """Gets the primary_item_group_type of this Item.  # noqa: E501

        The item group type. Supported value: SELLER_DEFINED_VARIATIONS, indicates that the item group was created by the seller. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The primary_item_group_type of this Item.  # noqa: E501
        :rtype: str
        """
        return self._primary_item_group_type

    @primary_item_group_type.setter
    def primary_item_group_type(self, primary_item_group_type):
        """Sets the primary_item_group_type of this Item.

        The item group type. Supported value: SELLER_DEFINED_VARIATIONS, indicates that the item group was created by the seller. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param primary_item_group_type: The primary_item_group_type of this Item.  # noqa: E501
        :type: str
        """

        self._primary_item_group_type = primary_item_group_type

    @property
    def item_end_date(self):
        """Gets the item_end_date of this Item.  # noqa: E501

        A timestamp indicating when the item's sale period will end based on its start date and duration. For Good 'Til Cancelled items, no value is returned in this column. Format: UTC (yyyy-MM-ddThh:mm:ss.sssZ).  # noqa: E501

        :return: The item_end_date of this Item.  # noqa: E501
        :rtype: str
        """
        return self._item_end_date

    @item_end_date.setter
    def item_end_date(self, item_end_date):
        """Sets the item_end_date of this Item.

        A timestamp indicating when the item's sale period will end based on its start date and duration. For Good 'Til Cancelled items, no value is returned in this column. Format: UTC (yyyy-MM-ddThh:mm:ss.sssZ).  # noqa: E501

        :param item_end_date: The item_end_date of this Item.  # noqa: E501
        :type: str
        """

        self._item_end_date = item_end_date

    @property
    def seller_item_revision(self):
        """Gets the seller_item_revision of this Item.  # noqa: E501

        An identifier generated/incremented when a seller revises the item. There are two types of item revisions: Seller changes, such as changing the title eBay system changes, such as changing the quantity when an item is purchased This ID is changed only when the seller makes a change to the item.  # noqa: E501

        :return: The seller_item_revision of this Item.  # noqa: E501
        :rtype: str
        """
        return self._seller_item_revision

    @seller_item_revision.setter
    def seller_item_revision(self, seller_item_revision):
        """Sets the seller_item_revision of this Item.

        An identifier generated/incremented when a seller revises the item. There are two types of item revisions: Seller changes, such as changing the title eBay system changes, such as changing the quantity when an item is purchased This ID is changed only when the seller makes a change to the item.  # noqa: E501

        :param seller_item_revision: The seller_item_revision of this Item.  # noqa: E501
        :type: str
        """

        self._seller_item_revision = seller_item_revision

    @property
    def item_location_country(self):
        """Gets the item_location_country of this Item.  # noqa: E501

        The country where the item is physically located.  # noqa: E501

        :return: The item_location_country of this Item.  # noqa: E501
        :rtype: str
        """
        return self._item_location_country

    @item_location_country.setter
    def item_location_country(self, item_location_country):
        """Sets the item_location_country of this Item.

        The country where the item is physically located.  # noqa: E501

        :param item_location_country: The item_location_country of this Item.  # noqa: E501
        :type: str
        """

        self._item_location_country = item_location_country

    @property
    def localized_aspects(self):
        """Gets the localized_aspects of this Item.  # noqa: E501

        A semicolon separated list of the name/value pairs for the aspects of the item, which are BASE64 encoded. The aspect label is separated by a pipe (|), the aspect name and value are separated by a colon (:) and the name/value pairs are separated by a semicolon (;). Example without Label &nbsp;&nbsp; Encoded Format: &nbsp;&nbsp;&nbsp;encodedName:encodedValue;encodedName:encodedValue;encodedName:encodedValue &nbsp;&nbsp; Encoded Example (The delimiters are emphasized): &nbsp;&nbsp;&nbsp;U2l6ZQ==:WEw=;Q29sb3I=:UmVk;U2xlZXZlcw==:TG9uZw== &nbsp;&nbsp; Decoded: &nbsp;&nbsp;&nbsp;Size:XL;Color:Red;Sleeves:Long Example with Label &nbsp;&nbsp; Encoded Format: &nbsp;&nbsp;&nbsp;encodedLabel|encodedName:encodedValue;encodedName:encodedValue;encodedLabel| &nbsp;&nbsp; Encoded Example (The delimiters are emphasized): &nbsp;&nbsp;&nbsp;UHJvZHVjdCBJZGVudGlmaWVycw==|R1RJTg==:MDE5MDE5ODA2NjYzMw==;QlJBTkQ=:QXBwbGU=;UHJvZHVjdCBLZXkgRmVhdHVyZXM=|TW9kZWw=:aVBob25lIDc= &nbsp;&nbsp; Decoded: &nbsp;&nbsp;&nbsp;Product Identifiers|GTIN:0190198066633;BRAND:Apple;Product Key Features|Model:iPhone 7 Note: The separators ( | : ; ) are not encoded. You must decode each label, name, and value separately. You cannot decode the entire string. For more information, see Encoded Aspects in the Buying Integration Guide.  # noqa: E501

        :return: The localized_aspects of this Item.  # noqa: E501
        :rtype: str
        """
        return self._localized_aspects

    @localized_aspects.setter
    def localized_aspects(self, localized_aspects):
        """Sets the localized_aspects of this Item.

        A semicolon separated list of the name/value pairs for the aspects of the item, which are BASE64 encoded. The aspect label is separated by a pipe (|), the aspect name and value are separated by a colon (:) and the name/value pairs are separated by a semicolon (;). Example without Label &nbsp;&nbsp; Encoded Format: &nbsp;&nbsp;&nbsp;encodedName:encodedValue;encodedName:encodedValue;encodedName:encodedValue &nbsp;&nbsp; Encoded Example (The delimiters are emphasized): &nbsp;&nbsp;&nbsp;U2l6ZQ==:WEw=;Q29sb3I=:UmVk;U2xlZXZlcw==:TG9uZw== &nbsp;&nbsp; Decoded: &nbsp;&nbsp;&nbsp;Size:XL;Color:Red;Sleeves:Long Example with Label &nbsp;&nbsp; Encoded Format: &nbsp;&nbsp;&nbsp;encodedLabel|encodedName:encodedValue;encodedName:encodedValue;encodedLabel| &nbsp;&nbsp; Encoded Example (The delimiters are emphasized): &nbsp;&nbsp;&nbsp;UHJvZHVjdCBJZGVudGlmaWVycw==|R1RJTg==:MDE5MDE5ODA2NjYzMw==;QlJBTkQ=:QXBwbGU=;UHJvZHVjdCBLZXkgRmVhdHVyZXM=|TW9kZWw=:aVBob25lIDc= &nbsp;&nbsp; Decoded: &nbsp;&nbsp;&nbsp;Product Identifiers|GTIN:0190198066633;BRAND:Apple;Product Key Features|Model:iPhone 7 Note: The separators ( | : ; ) are not encoded. You must decode each label, name, and value separately. You cannot decode the entire string. For more information, see Encoded Aspects in the Buying Integration Guide.  # noqa: E501

        :param localized_aspects: The localized_aspects of this Item.  # noqa: E501
        :type: str
        """

        self._localized_aspects = localized_aspects

    @property
    def seller_trust_level(self):
        """Gets the seller_trust_level of this Item.  # noqa: E501

        An enumeration value representing the eBay status of the seller. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:SellerTrustLevelEnum'>eBay API documentation</a>  # noqa: E501

        :return: The seller_trust_level of this Item.  # noqa: E501
        :rtype: str
        """
        return self._seller_trust_level

    @seller_trust_level.setter
    def seller_trust_level(self, seller_trust_level):
        """Sets the seller_trust_level of this Item.

        An enumeration value representing the eBay status of the seller. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:SellerTrustLevelEnum'>eBay API documentation</a>  # noqa: E501

        :param seller_trust_level: The seller_trust_level of this Item.  # noqa: E501
        :type: str
        """

        self._seller_trust_level = seller_trust_level

    @property
    def availability(self):
        """Gets the availability of this Item.  # noqa: E501

        An enumeration value representing the item's availability (possibility of being purchased). Values: AVAILABLE TEMPORARILY_UNAVAILABLE UNAVAILABLE Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:AvailabilityEnum'>eBay API documentation</a>  # noqa: E501

        :return: The availability of this Item.  # noqa: E501
        :rtype: str
        """
        return self._availability

    @availability.setter
    def availability(self, availability):
        """Sets the availability of this Item.

        An enumeration value representing the item's availability (possibility of being purchased). Values: AVAILABLE TEMPORARILY_UNAVAILABLE UNAVAILABLE Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:AvailabilityEnum'>eBay API documentation</a>  # noqa: E501

        :param availability: The availability of this Item.  # noqa: E501
        :type: str
        """

        self._availability = availability

    @property
    def image_altering_prohibited(self):
        """Gets the image_altering_prohibited of this Item.  # noqa: E501

        A boolean that indicates whether the images can be altered. If the value is true, you cannot modify the image. Note: Due to image licensing agreements and other legal concerns, modification (including resizing) of some images is strictly prohibited. These images are for display as-is only.  # noqa: E501

        :return: The image_altering_prohibited of this Item.  # noqa: E501
        :rtype: bool
        """
        return self._image_altering_prohibited

    @image_altering_prohibited.setter
    def image_altering_prohibited(self, image_altering_prohibited):
        """Sets the image_altering_prohibited of this Item.

        A boolean that indicates whether the images can be altered. If the value is true, you cannot modify the image. Note: Due to image licensing agreements and other legal concerns, modification (including resizing) of some images is strictly prohibited. These images are for display as-is only.  # noqa: E501

        :param image_altering_prohibited: The image_altering_prohibited of this Item.  # noqa: E501
        :type: bool
        """

        self._image_altering_prohibited = image_altering_prohibited

    @property
    def estimated_available_quantity(self):
        """Gets the estimated_available_quantity of this Item.  # noqa: E501

        The estimated number of this item that are available for purchase. Because the quantity of an item can change several times within a second, it is impossible to return the exact quantity. So instead of returning quantity, the estimated availability of the item is returned.  # noqa: E501

        :return: The estimated_available_quantity of this Item.  # noqa: E501
        :rtype: int
        """
        return self._estimated_available_quantity

    @estimated_available_quantity.setter
    def estimated_available_quantity(self, estimated_available_quantity):
        """Sets the estimated_available_quantity of this Item.

        The estimated number of this item that are available for purchase. Because the quantity of an item can change several times within a second, it is impossible to return the exact quantity. So instead of returning quantity, the estimated availability of the item is returned.  # noqa: E501

        :param estimated_available_quantity: The estimated_available_quantity of this Item.  # noqa: E501
        :type: int
        """

        self._estimated_available_quantity = estimated_available_quantity

    @property
    def availability_threshold_type(self):
        """Gets the availability_threshold_type of this Item.  # noqa: E501

        This column has a value only when the seller sets their Display Item Quantity preference to Display &quot;More than 10 available&quot; in your listing (if applicable). The value of this column will be MORE_THAN. This indicates that the seller has more than the 'Display Item Quantity', which is 10, in stock for this item. The following are the Display Item Quantity preferences the seller can set. Display &quot;More than 10 available&quot; in your listing (if applicable) If the seller enables this preference, this column will have a value as long as there are more than 10 of this item in inventory. If the quantity is equal to 10 or drops below 10, this column will be null and the estimated quantity of the item is returned in the estimatedAvailableQuantity column. Display the exact quantity in your items If the seller enables this preference, the availabilityThresholdType and availabilityThreshold columns will be null and the estimated quantity of the item is returned in the estimatedAvailableQuantity column. Note: Because the quantity of an item can change several times within a second, it is impossible to return the exact quantity. Code so that your app gracefully handles any future changes to these preferences. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:AvailabilityThresholdEnum'>eBay API documentation</a>  # noqa: E501

        :return: The availability_threshold_type of this Item.  # noqa: E501
        :rtype: str
        """
        return self._availability_threshold_type

    @availability_threshold_type.setter
    def availability_threshold_type(self, availability_threshold_type):
        """Sets the availability_threshold_type of this Item.

        This column has a value only when the seller sets their Display Item Quantity preference to Display &quot;More than 10 available&quot; in your listing (if applicable). The value of this column will be MORE_THAN. This indicates that the seller has more than the 'Display Item Quantity', which is 10, in stock for this item. The following are the Display Item Quantity preferences the seller can set. Display &quot;More than 10 available&quot; in your listing (if applicable) If the seller enables this preference, this column will have a value as long as there are more than 10 of this item in inventory. If the quantity is equal to 10 or drops below 10, this column will be null and the estimated quantity of the item is returned in the estimatedAvailableQuantity column. Display the exact quantity in your items If the seller enables this preference, the availabilityThresholdType and availabilityThreshold columns will be null and the estimated quantity of the item is returned in the estimatedAvailableQuantity column. Note: Because the quantity of an item can change several times within a second, it is impossible to return the exact quantity. Code so that your app gracefully handles any future changes to these preferences. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:AvailabilityThresholdEnum'>eBay API documentation</a>  # noqa: E501

        :param availability_threshold_type: The availability_threshold_type of this Item.  # noqa: E501
        :type: str
        """

        self._availability_threshold_type = availability_threshold_type

    @property
    def availability_threshold(self):
        """Gets the availability_threshold of this Item.  # noqa: E501

        This column has a value only when the seller sets their 'display item quantity' preference to Display &quot;More than 10 available&quot; in your listing (if applicable). The value of this column will be &quot;10&quot;, which is the threshold value. Code so that your app gracefully handles any future changes to this value.  # noqa: E501

        :return: The availability_threshold of this Item.  # noqa: E501
        :rtype: int
        """
        return self._availability_threshold

    @availability_threshold.setter
    def availability_threshold(self, availability_threshold):
        """Sets the availability_threshold of this Item.

        This column has a value only when the seller sets their 'display item quantity' preference to Display &quot;More than 10 available&quot; in your listing (if applicable). The value of this column will be &quot;10&quot;, which is the threshold value. Code so that your app gracefully handles any future changes to this value.  # noqa: E501

        :param availability_threshold: The availability_threshold of this Item.  # noqa: E501
        :type: int
        """

        self._availability_threshold = availability_threshold

    @property
    def returns_accepted(self):
        """Gets the returns_accepted of this Item.  # noqa: E501

        Indicates whether the seller accepts returns for the item.  # noqa: E501

        :return: The returns_accepted of this Item.  # noqa: E501
        :rtype: bool
        """
        return self._returns_accepted

    @returns_accepted.setter
    def returns_accepted(self, returns_accepted):
        """Sets the returns_accepted of this Item.

        Indicates whether the seller accepts returns for the item.  # noqa: E501

        :param returns_accepted: The returns_accepted of this Item.  # noqa: E501
        :type: bool
        """

        self._returns_accepted = returns_accepted

    @property
    def return_period_value(self):
        """Gets the return_period_value of this Item.  # noqa: E501

        The amount of days that the buyer has to return the item after the purchase date. For example, if this value is '30', the return period is 30 days.  # noqa: E501

        :return: The return_period_value of this Item.  # noqa: E501
        :rtype: int
        """
        return self._return_period_value

    @return_period_value.setter
    def return_period_value(self, return_period_value):
        """Sets the return_period_value of this Item.

        The amount of days that the buyer has to return the item after the purchase date. For example, if this value is '30', the return period is 30 days.  # noqa: E501

        :param return_period_value: The return_period_value of this Item.  # noqa: E501
        :type: int
        """

        self._return_period_value = return_period_value

    @property
    def return_period_unit(self):
        """Gets the return_period_unit of this Item.  # noqa: E501

        An enumeration value that indicates the period of time being used to measure the duration, such as business days, months, or years. TimeDurationUnitEnum is a common type shared by multiple eBay APIs and fields to express the time unit, but for return period duration, this value will always be DAY. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:TimeDurationUnitEnum'>eBay API documentation</a>  # noqa: E501

        :return: The return_period_unit of this Item.  # noqa: E501
        :rtype: str
        """
        return self._return_period_unit

    @return_period_unit.setter
    def return_period_unit(self, return_period_unit):
        """Sets the return_period_unit of this Item.

        An enumeration value that indicates the period of time being used to measure the duration, such as business days, months, or years. TimeDurationUnitEnum is a common type shared by multiple eBay APIs and fields to express the time unit, but for return period duration, this value will always be DAY. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:TimeDurationUnitEnum'>eBay API documentation</a>  # noqa: E501

        :param return_period_unit: The return_period_unit of this Item.  # noqa: E501
        :type: str
        """

        self._return_period_unit = return_period_unit

    @property
    def refund_method(self):
        """Gets the refund_method of this Item.  # noqa: E501

        An enumeration value that indicates how a buyer is refunded when an item is returned. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:RefundMethodEnum'>eBay API documentation</a>  # noqa: E501

        :return: The refund_method of this Item.  # noqa: E501
        :rtype: str
        """
        return self._refund_method

    @refund_method.setter
    def refund_method(self, refund_method):
        """Sets the refund_method of this Item.

        An enumeration value that indicates how a buyer is refunded when an item is returned. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:RefundMethodEnum'>eBay API documentation</a>  # noqa: E501

        :param refund_method: The refund_method of this Item.  # noqa: E501
        :type: str
        """

        self._refund_method = refund_method

    @property
    def return_method(self):
        """Gets the return_method of this Item.  # noqa: E501

        An enumeration value that indicates the alternative methods for a full refund when an item is returned. This column will have data if the seller offers the buyer an item replacement or exchange instead of a monetary refund. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:ReturnMethodEnum'>eBay API documentation</a>  # noqa: E501

        :return: The return_method of this Item.  # noqa: E501
        :rtype: str
        """
        return self._return_method

    @return_method.setter
    def return_method(self, return_method):
        """Sets the return_method of this Item.

        An enumeration value that indicates the alternative methods for a full refund when an item is returned. This column will have data if the seller offers the buyer an item replacement or exchange instead of a monetary refund. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:ReturnMethodEnum'>eBay API documentation</a>  # noqa: E501

        :param return_method: The return_method of this Item.  # noqa: E501
        :type: str
        """

        self._return_method = return_method

    @property
    def return_shipping_cost_payer(self):
        """Gets the return_shipping_cost_payer of this Item.  # noqa: E501

        The party responsible for the return shipping costs when an item is returned. Valid Values: BUYER or SELLER Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:ReturnShippingCostPayerEnum'>eBay API documentation</a>  # noqa: E501

        :return: The return_shipping_cost_payer of this Item.  # noqa: E501
        :rtype: str
        """
        return self._return_shipping_cost_payer

    @return_shipping_cost_payer.setter
    def return_shipping_cost_payer(self, return_shipping_cost_payer):
        """Sets the return_shipping_cost_payer of this Item.

        The party responsible for the return shipping costs when an item is returned. Valid Values: BUYER or SELLER Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:ReturnShippingCostPayerEnum'>eBay API documentation</a>  # noqa: E501

        :param return_shipping_cost_payer: The return_shipping_cost_payer of this Item.  # noqa: E501
        :type: str
        """

        self._return_shipping_cost_payer = return_shipping_cost_payer

    @property
    def accepted_payment_methods(self):
        """Gets the accepted_payment_methods of this Item.  # noqa: E501

        Indicates the credit card service that will be used to process the transaction. If this column contains PAYPAL, you can use the Buy Order API to checkout and purchase the item. If this column is empty, you must use another method for checkout.  # noqa: E501

        :return: The accepted_payment_methods of this Item.  # noqa: E501
        :rtype: str
        """
        return self._accepted_payment_methods

    @accepted_payment_methods.setter
    def accepted_payment_methods(self, accepted_payment_methods):
        """Sets the accepted_payment_methods of this Item.

        Indicates the credit card service that will be used to process the transaction. If this column contains PAYPAL, you can use the Buy Order API to checkout and purchase the item. If this column is empty, you must use another method for checkout.  # noqa: E501

        :param accepted_payment_methods: The accepted_payment_methods of this Item.  # noqa: E501
        :type: str
        """

        self._accepted_payment_methods = accepted_payment_methods

    @property
    def delivery_options(self):
        """Gets the delivery_options of this Item.  # noqa: E501

        A comma-separated list of available delivery options. This column lets you filter out items than cannot be shipped to the buyer. Valid Values: SHIP_TO_HOME, SELLER_ARRANGED_LOCAL_PICKUP, IN_STORE_PICKUP, and PICKUP_DROP_OFF. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:DeliveryOptionsEnum'>eBay API documentation</a>  # noqa: E501

        :return: The delivery_options of this Item.  # noqa: E501
        :rtype: str
        """
        return self._delivery_options

    @delivery_options.setter
    def delivery_options(self, delivery_options):
        """Sets the delivery_options of this Item.

        A comma-separated list of available delivery options. This column lets you filter out items than cannot be shipped to the buyer. Valid Values: SHIP_TO_HOME, SELLER_ARRANGED_LOCAL_PICKUP, IN_STORE_PICKUP, and PICKUP_DROP_OFF. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:DeliveryOptionsEnum'>eBay API documentation</a>  # noqa: E501

        :param delivery_options: The delivery_options of this Item.  # noqa: E501
        :type: str
        """

        self._delivery_options = delivery_options

    @property
    def ship_to_included_regions(self):
        """Gets the ship_to_included_regions of this Item.  # noqa: E501

        A pipe (|) separated alphabetical list of the geographic countries and regions where the seller will ship the item. If a region is specified, you will need to subtract any countries and regions returned in the shipToExcludedRegions column to fully understand where the seller will ship. The COUNTRY: list is separated from the REGION: list with a semicolon (;). Format Example: COUNTRY:US|BM|GL|MX|PM;REGION:AFRICA|ASIA|CENTRAL_AMERICA_AND_CARIBBEAN|EUROPE|MIDDLE_EAST|OCEANIA|SOUTH_AMERICA|SOUTHEAST_ASIA; Country Values: The two-letter ISO 3166 standard code of the country. Region Values: AFRICA, AMERICAS, ANTARCTIC, ARCTIC, ASIA, AUSTRALIA, CENTRAL_AMERICA_AND_CARIBBEAN, EUROPE, EURO_UNION, GREATER_CHINA, MIDDLE_EAST, NORTH_AMERICA, OCEANIA, REST_OF_ASIA, SOUTHEAST_ASIA, SOUTH_AMERICA, WORLDWIDE Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The ship_to_included_regions of this Item.  # noqa: E501
        :rtype: str
        """
        return self._ship_to_included_regions

    @ship_to_included_regions.setter
    def ship_to_included_regions(self, ship_to_included_regions):
        """Sets the ship_to_included_regions of this Item.

        A pipe (|) separated alphabetical list of the geographic countries and regions where the seller will ship the item. If a region is specified, you will need to subtract any countries and regions returned in the shipToExcludedRegions column to fully understand where the seller will ship. The COUNTRY: list is separated from the REGION: list with a semicolon (;). Format Example: COUNTRY:US|BM|GL|MX|PM;REGION:AFRICA|ASIA|CENTRAL_AMERICA_AND_CARIBBEAN|EUROPE|MIDDLE_EAST|OCEANIA|SOUTH_AMERICA|SOUTHEAST_ASIA; Country Values: The two-letter ISO 3166 standard code of the country. Region Values: AFRICA, AMERICAS, ANTARCTIC, ARCTIC, ASIA, AUSTRALIA, CENTRAL_AMERICA_AND_CARIBBEAN, EUROPE, EURO_UNION, GREATER_CHINA, MIDDLE_EAST, NORTH_AMERICA, OCEANIA, REST_OF_ASIA, SOUTHEAST_ASIA, SOUTH_AMERICA, WORLDWIDE Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param ship_to_included_regions: The ship_to_included_regions of this Item.  # noqa: E501
        :type: str
        """

        self._ship_to_included_regions = ship_to_included_regions

    @property
    def ship_to_excluded_regions(self):
        """Gets the ship_to_excluded_regions of this Item.  # noqa: E501

        A pipe (|) separated alphabetical list of the geographic countries and regions where the item cannot be shipped. These countries and regions refine (restrict) the shipToIncludedRegions list. The COUNTRY: list is separated from the REGION: list with a semicolon (;). Format Example: COUNTRY:US|BM|GL|MX|PM;REGION:AFRICA|ASIA|CENTRAL_AMERICA_AND_CARIBBEAN|EUROPE|MIDDLE_EAST|OCEANIA|SOUTH_AMERICA|SOUTHEAST_ASIA; Country Values: The two-letter ISO 3166 standard code of the country. Region Values: AFRICA, AMERICAS, ANTARCTIC, ARCTIC, ASIA, AUSTRALIA, CENTRAL_AMERICA_AND_CARIBBEAN, EUROPE, EURO_UNION, GREATER_CHINA, MIDDLE_EAST, NORTH_AMERICA, OCEANIA, REST_OF_ASIA, SOUTHEAST_ASIA, SOUTH_AMERICA, WORLDWIDE Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The ship_to_excluded_regions of this Item.  # noqa: E501
        :rtype: str
        """
        return self._ship_to_excluded_regions

    @ship_to_excluded_regions.setter
    def ship_to_excluded_regions(self, ship_to_excluded_regions):
        """Sets the ship_to_excluded_regions of this Item.

        A pipe (|) separated alphabetical list of the geographic countries and regions where the item cannot be shipped. These countries and regions refine (restrict) the shipToIncludedRegions list. The COUNTRY: list is separated from the REGION: list with a semicolon (;). Format Example: COUNTRY:US|BM|GL|MX|PM;REGION:AFRICA|ASIA|CENTRAL_AMERICA_AND_CARIBBEAN|EUROPE|MIDDLE_EAST|OCEANIA|SOUTH_AMERICA|SOUTHEAST_ASIA; Country Values: The two-letter ISO 3166 standard code of the country. Region Values: AFRICA, AMERICAS, ANTARCTIC, ARCTIC, ASIA, AUSTRALIA, CENTRAL_AMERICA_AND_CARIBBEAN, EUROPE, EURO_UNION, GREATER_CHINA, MIDDLE_EAST, NORTH_AMERICA, OCEANIA, REST_OF_ASIA, SOUTHEAST_ASIA, SOUTH_AMERICA, WORLDWIDE Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param ship_to_excluded_regions: The ship_to_excluded_regions of this Item.  # noqa: E501
        :type: str
        """

        self._ship_to_excluded_regions = ship_to_excluded_regions

    @property
    def inferred_epid(self):
        """Gets the inferred_epid of this Item.  # noqa: E501

        The ePID (eBay Product ID of a product in the eBay product catalog) for the item, which has been programmatically determined by eBay using the item's title, aspects, and other data. If the seller actually provided an ePID at listing time for the item, the ePID value is returned in the epid column instead.  # noqa: E501

        :return: The inferred_epid of this Item.  # noqa: E501
        :rtype: str
        """
        return self._inferred_epid

    @inferred_epid.setter
    def inferred_epid(self, inferred_epid):
        """Sets the inferred_epid of this Item.

        The ePID (eBay Product ID of a product in the eBay product catalog) for the item, which has been programmatically determined by eBay using the item's title, aspects, and other data. If the seller actually provided an ePID at listing time for the item, the ePID value is returned in the epid column instead.  # noqa: E501

        :param inferred_epid: The inferred_epid of this Item.  # noqa: E501
        :type: str
        """

        self._inferred_epid = inferred_epid

    @property
    def inferred_gtin(self):
        """Gets the inferred_gtin of this Item.  # noqa: E501

        The GTIN (Global Trade Item Number) of the product as defined by https://www.gtin.info, which as been programmatically determined by eBay. This can be a UPC (Universal Product Code), EAN (European Article Number), or an ISBN (International Standard Book Number) value. If the seller provided a GTIN for the item, the seller's value is returned in the gtin column.  # noqa: E501

        :return: The inferred_gtin of this Item.  # noqa: E501
        :rtype: str
        """
        return self._inferred_gtin

    @inferred_gtin.setter
    def inferred_gtin(self, inferred_gtin):
        """Sets the inferred_gtin of this Item.

        The GTIN (Global Trade Item Number) of the product as defined by https://www.gtin.info, which as been programmatically determined by eBay. This can be a UPC (Universal Product Code), EAN (European Article Number), or an ISBN (International Standard Book Number) value. If the seller provided a GTIN for the item, the seller's value is returned in the gtin column.  # noqa: E501

        :param inferred_gtin: The inferred_gtin of this Item.  # noqa: E501
        :type: str
        """

        self._inferred_gtin = inferred_gtin

    @property
    def inferred_brand(self):
        """Gets the inferred_brand of this Item.  # noqa: E501

        The name brand for the item, such as Nike or Apple, which has been programmatically determined by eBay. To identify the product, this is always used along with MPN. If the seller provided a brand for the item, the seller's value is returned in the brand column.  # noqa: E501

        :return: The inferred_brand of this Item.  # noqa: E501
        :rtype: str
        """
        return self._inferred_brand

    @inferred_brand.setter
    def inferred_brand(self, inferred_brand):
        """Sets the inferred_brand of this Item.

        The name brand for the item, such as Nike or Apple, which has been programmatically determined by eBay. To identify the product, this is always used along with MPN. If the seller provided a brand for the item, the seller's value is returned in the brand column.  # noqa: E501

        :param inferred_brand: The inferred_brand of this Item.  # noqa: E501
        :type: str
        """

        self._inferred_brand = inferred_brand

    @property
    def inferred_mpn(self):
        """Gets the inferred_mpn of this Item.  # noqa: E501

        The MPN (Manufacturer's Part Number) for the item, which has been programmatically determined by eBay. To identify the product, this is always used along with brand. If the seller provided a MPN for the item, the seller's value is returned in the mpn column.  # noqa: E501

        :return: The inferred_mpn of this Item.  # noqa: E501
        :rtype: str
        """
        return self._inferred_mpn

    @inferred_mpn.setter
    def inferred_mpn(self, inferred_mpn):
        """Sets the inferred_mpn of this Item.

        The MPN (Manufacturer's Part Number) for the item, which has been programmatically determined by eBay. To identify the product, this is always used along with brand. If the seller provided a MPN for the item, the seller's value is returned in the mpn column.  # noqa: E501

        :param inferred_mpn: The inferred_mpn of this Item.  # noqa: E501
        :type: str
        """

        self._inferred_mpn = inferred_mpn

    @property
    def inferred_localized_aspects(self):
        """Gets the inferred_localized_aspects of this Item.  # noqa: E501

        A semicolon separated list of the name/value pairs for the aspects of the item, which are BASE64 encoded. These aspects have been programmatically determined by eBay. If the seller provided aspects for the item, the seller's values are returned in the localizedAspects column. The aspect label is separated by a pipe (|), the aspect name and value are separated by a colon (:) and the name/value pairs are separated by a semicolon (;). Example without Label &nbsp;&nbsp; Encoded Format: &nbsp;&nbsp;&nbsp;encodedName:encodedValue;encodedName:encodedValue;encodedName:encodedValue &nbsp;&nbsp; Encoded Example (The delimiters are emphasized): &nbsp;&nbsp;&nbsp;U2l6ZQ==:WEw=;Q29sb3I=:UmVk;U2xlZXZlcw==:TG9uZw== &nbsp;&nbsp; Decoded: &nbsp;&nbsp;&nbsp;Size:XL;Color:Red;Sleeves:Long Example with Label &nbsp;&nbsp; Encoded Format: &nbsp;&nbsp;&nbsp;encodedLabel|encodedName:encodedValue;encodedName:encodedValue;encodedLabel| &nbsp;&nbsp; Encoded Example (The delimiters are emphasized): &nbsp;&nbsp;&nbsp;UHJvZHVjdCBJZGVudGlmaWVycw==|R1RJTg==:MDE5MDE5ODA2NjYzMw==;QlJBTkQ=:QXBwbGU=;UHJvZHVjdCBLZXkgRmVhdHVyZXM=|TW9kZWw=:aVBob25lIDc= &nbsp;&nbsp; Decoded: &nbsp;&nbsp;&nbsp;Product Identifiers|GTIN:0190198066633;BRAND:Apple;Product Key Features|Model:iPhone 7 Note: The separators ( | : ; ) are not encoded. You must decode each label, name, and value separately. You cannot decode the entire string. For more information, see Encoded Aspects in the Buying Integration Guide.  # noqa: E501

        :return: The inferred_localized_aspects of this Item.  # noqa: E501
        :rtype: str
        """
        return self._inferred_localized_aspects

    @inferred_localized_aspects.setter
    def inferred_localized_aspects(self, inferred_localized_aspects):
        """Sets the inferred_localized_aspects of this Item.

        A semicolon separated list of the name/value pairs for the aspects of the item, which are BASE64 encoded. These aspects have been programmatically determined by eBay. If the seller provided aspects for the item, the seller's values are returned in the localizedAspects column. The aspect label is separated by a pipe (|), the aspect name and value are separated by a colon (:) and the name/value pairs are separated by a semicolon (;). Example without Label &nbsp;&nbsp; Encoded Format: &nbsp;&nbsp;&nbsp;encodedName:encodedValue;encodedName:encodedValue;encodedName:encodedValue &nbsp;&nbsp; Encoded Example (The delimiters are emphasized): &nbsp;&nbsp;&nbsp;U2l6ZQ==:WEw=;Q29sb3I=:UmVk;U2xlZXZlcw==:TG9uZw== &nbsp;&nbsp; Decoded: &nbsp;&nbsp;&nbsp;Size:XL;Color:Red;Sleeves:Long Example with Label &nbsp;&nbsp; Encoded Format: &nbsp;&nbsp;&nbsp;encodedLabel|encodedName:encodedValue;encodedName:encodedValue;encodedLabel| &nbsp;&nbsp; Encoded Example (The delimiters are emphasized): &nbsp;&nbsp;&nbsp;UHJvZHVjdCBJZGVudGlmaWVycw==|R1RJTg==:MDE5MDE5ODA2NjYzMw==;QlJBTkQ=:QXBwbGU=;UHJvZHVjdCBLZXkgRmVhdHVyZXM=|TW9kZWw=:aVBob25lIDc= &nbsp;&nbsp; Decoded: &nbsp;&nbsp;&nbsp;Product Identifiers|GTIN:0190198066633;BRAND:Apple;Product Key Features|Model:iPhone 7 Note: The separators ( | : ; ) are not encoded. You must decode each label, name, and value separately. You cannot decode the entire string. For more information, see Encoded Aspects in the Buying Integration Guide.  # noqa: E501

        :param inferred_localized_aspects: The inferred_localized_aspects of this Item.  # noqa: E501
        :type: str
        """

        self._inferred_localized_aspects = inferred_localized_aspects

    @property
    def additional_image_urls(self):
        """Gets the additional_image_urls of this Item.  # noqa: E501

        A pipe separated (|) list of URLs for the additional images of the item. These images are in addition to the primary image, which is returned in the imageUrl column. Note: This column can contain multiple values.  # noqa: E501

        :return: The additional_image_urls of this Item.  # noqa: E501
        :rtype: str
        """
        return self._additional_image_urls

    @additional_image_urls.setter
    def additional_image_urls(self, additional_image_urls):
        """Sets the additional_image_urls of this Item.

        A pipe separated (|) list of URLs for the additional images of the item. These images are in addition to the primary image, which is returned in the imageUrl column. Note: This column can contain multiple values.  # noqa: E501

        :param additional_image_urls: The additional_image_urls of this Item.  # noqa: E501
        :type: str
        """

        self._additional_image_urls = additional_image_urls

    @property
    def original_price_value(self):
        """Gets the original_price_value of this Item.  # noqa: E501

        The original selling price of the item. This lets you surface a strikethrough price for the item.  # noqa: E501

        :return: The original_price_value of this Item.  # noqa: E501
        :rtype: str
        """
        return self._original_price_value

    @original_price_value.setter
    def original_price_value(self, original_price_value):
        """Sets the original_price_value of this Item.

        The original selling price of the item. This lets you surface a strikethrough price for the item.  # noqa: E501

        :param original_price_value: The original_price_value of this Item.  # noqa: E501
        :type: str
        """

        self._original_price_value = original_price_value

    @property
    def original_price_currency(self):
        """Gets the original_price_currency of this Item.  # noqa: E501

        The currency of the originalPriceValue of the item and the discountAmount. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:CurrencyCodeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The original_price_currency of this Item.  # noqa: E501
        :rtype: str
        """
        return self._original_price_currency

    @original_price_currency.setter
    def original_price_currency(self, original_price_currency):
        """Sets the original_price_currency of this Item.

        The currency of the originalPriceValue of the item and the discountAmount. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:CurrencyCodeEnum'>eBay API documentation</a>  # noqa: E501

        :param original_price_currency: The original_price_currency of this Item.  # noqa: E501
        :type: str
        """

        self._original_price_currency = original_price_currency

    @property
    def discount_amount(self):
        """Gets the discount_amount of this Item.  # noqa: E501

        The calculated amount of the discount (originalPriceValue - priceValue). For example, if originalPriceValue is 70 and priceValue is 56, this value would be 14. Note: The currency shown in originalPriceCurrency is used for both discountAmount and originalPriceCurrency.  # noqa: E501

        :return: The discount_amount of this Item.  # noqa: E501
        :rtype: str
        """
        return self._discount_amount

    @discount_amount.setter
    def discount_amount(self, discount_amount):
        """Sets the discount_amount of this Item.

        The calculated amount of the discount (originalPriceValue - priceValue). For example, if originalPriceValue is 70 and priceValue is 56, this value would be 14. Note: The currency shown in originalPriceCurrency is used for both discountAmount and originalPriceCurrency.  # noqa: E501

        :param discount_amount: The discount_amount of this Item.  # noqa: E501
        :type: str
        """

        self._discount_amount = discount_amount

    @property
    def discount_percentage(self):
        """Gets the discount_percentage of this Item.  # noqa: E501

        The calculated discount percentage. For example, if originalPriceValue is 70 and discountAmount is 14, this value will be 20.  # noqa: E501

        :return: The discount_percentage of this Item.  # noqa: E501
        :rtype: str
        """
        return self._discount_percentage

    @discount_percentage.setter
    def discount_percentage(self, discount_percentage):
        """Sets the discount_percentage of this Item.

        The calculated discount percentage. For example, if originalPriceValue is 70 and discountAmount is 14, this value will be 20.  # noqa: E501

        :param discount_percentage: The discount_percentage of this Item.  # noqa: E501
        :type: str
        """

        self._discount_percentage = discount_percentage

    @property
    def energy_efficiency_class(self):
        """Gets the energy_efficiency_class of this Item.  # noqa: E501

        Indicates the European energy efficiency rating (EEK) of the item. Data is returned in this column only if the seller specified the energy efficiency rating. The rating is a set of energy efficiency classes from A to G, where 'A' is the most energy efficient and 'G' is the least efficient. This rating helps buyers choose between various models. To retrieve the manufacturer's specifications for this item, when they are available, use the getItem method in the Browse API. The information is returned in the productFicheWebUrl field.  # noqa: E501

        :return: The energy_efficiency_class of this Item.  # noqa: E501
        :rtype: str
        """
        return self._energy_efficiency_class

    @energy_efficiency_class.setter
    def energy_efficiency_class(self, energy_efficiency_class):
        """Sets the energy_efficiency_class of this Item.

        Indicates the European energy efficiency rating (EEK) of the item. Data is returned in this column only if the seller specified the energy efficiency rating. The rating is a set of energy efficiency classes from A to G, where 'A' is the most energy efficient and 'G' is the least efficient. This rating helps buyers choose between various models. To retrieve the manufacturer's specifications for this item, when they are available, use the getItem method in the Browse API. The information is returned in the productFicheWebUrl field.  # noqa: E501

        :param energy_efficiency_class: The energy_efficiency_class of this Item.  # noqa: E501
        :type: str
        """

        self._energy_efficiency_class = energy_efficiency_class

    @property
    def qualified_programs(self):
        """Gets the qualified_programs of this Item.  # noqa: E501

        A pipe separated list of the qualified programs available for the item. Currently, the only qualified program returned is EBAY_PLUS. Note: The EBAY_PLUS program is supported only on the EBAY_DE and EBAY_AU marketplaces. This means the qualifiedPrograms column will be populated only in feed files for these marketplaces. Program Values: EBAY_PLUS  # noqa: E501

        :return: The qualified_programs of this Item.  # noqa: E501
        :rtype: str
        """
        return self._qualified_programs

    @qualified_programs.setter
    def qualified_programs(self, qualified_programs):
        """Sets the qualified_programs of this Item.

        A pipe separated list of the qualified programs available for the item. Currently, the only qualified program returned is EBAY_PLUS. Note: The EBAY_PLUS program is supported only on the EBAY_DE and EBAY_AU marketplaces. This means the qualifiedPrograms column will be populated only in feed files for these marketplaces. Program Values: EBAY_PLUS  # noqa: E501

        :param qualified_programs: The qualified_programs of this Item.  # noqa: E501
        :type: str
        """

        self._qualified_programs = qualified_programs

    @property
    def lot_size(self):
        """Gets the lot_size of this Item.  # noqa: E501

        The number of items in a lot. In other words, a lot size is the number of items that are being sold together. A lot is a set of two or more items included in a single listing that must be purchased together in a single order line item. All the items in the lot are the same but there can be multiple items in a single lot, such as the package of batteries shown in the example below. For example: Item Lot Definition Lot Size A package of 24 AA batteries A box of 10 packages 10 A P235/75-15 Goodyear tire 4 tires 4 Fashion Jewelry Rings Package of 100 assorted rings 100 Note: Lots are not supported in all categories.  # noqa: E501

        :return: The lot_size of this Item.  # noqa: E501
        :rtype: int
        """
        return self._lot_size

    @lot_size.setter
    def lot_size(self, lot_size):
        """Sets the lot_size of this Item.

        The number of items in a lot. In other words, a lot size is the number of items that are being sold together. A lot is a set of two or more items included in a single listing that must be purchased together in a single order line item. All the items in the lot are the same but there can be multiple items in a single lot, such as the package of batteries shown in the example below. For example: Item Lot Definition Lot Size A package of 24 AA batteries A box of 10 packages 10 A P235/75-15 Goodyear tire 4 tires 4 Fashion Jewelry Rings Package of 100 assorted rings 100 Note: Lots are not supported in all categories.  # noqa: E501

        :param lot_size: The lot_size of this Item.  # noqa: E501
        :type: int
        """

        self._lot_size = lot_size

    @property
    def length_unit_of_measure(self):
        """Gets the length_unit_of_measure of this Item.  # noqa: E501

        The unit of measurement used for the package dimensions, such as INCH, FEET, CENTIMETER, or METER. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:LengthUnitOfMeasureEnum'>eBay API documentation</a>  # noqa: E501

        :return: The length_unit_of_measure of this Item.  # noqa: E501
        :rtype: str
        """
        return self._length_unit_of_measure

    @length_unit_of_measure.setter
    def length_unit_of_measure(self, length_unit_of_measure):
        """Sets the length_unit_of_measure of this Item.

        The unit of measurement used for the package dimensions, such as INCH, FEET, CENTIMETER, or METER. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:LengthUnitOfMeasureEnum'>eBay API documentation</a>  # noqa: E501

        :param length_unit_of_measure: The length_unit_of_measure of this Item.  # noqa: E501
        :type: str
        """

        self._length_unit_of_measure = length_unit_of_measure

    @property
    def package_width(self):
        """Gets the package_width of this Item.  # noqa: E501

        The width of the shipping package that contains the item.  # noqa: E501

        :return: The package_width of this Item.  # noqa: E501
        :rtype: str
        """
        return self._package_width

    @package_width.setter
    def package_width(self, package_width):
        """Sets the package_width of this Item.

        The width of the shipping package that contains the item.  # noqa: E501

        :param package_width: The package_width of this Item.  # noqa: E501
        :type: str
        """

        self._package_width = package_width

    @property
    def package_height(self):
        """Gets the package_height of this Item.  # noqa: E501

        The height of the shipping package that contains the item.  # noqa: E501

        :return: The package_height of this Item.  # noqa: E501
        :rtype: str
        """
        return self._package_height

    @package_height.setter
    def package_height(self, package_height):
        """Sets the package_height of this Item.

        The height of the shipping package that contains the item.  # noqa: E501

        :param package_height: The package_height of this Item.  # noqa: E501
        :type: str
        """

        self._package_height = package_height

    @property
    def package_length(self):
        """Gets the package_length of this Item.  # noqa: E501

        The length of the shipping package that contains the item.  # noqa: E501

        :return: The package_length of this Item.  # noqa: E501
        :rtype: str
        """
        return self._package_length

    @package_length.setter
    def package_length(self, package_length):
        """Sets the package_length of this Item.

        The length of the shipping package that contains the item.  # noqa: E501

        :param package_length: The package_length of this Item.  # noqa: E501
        :type: str
        """

        self._package_length = package_length

    @property
    def weight_unit_of_measure(self):
        """Gets the weight_unit_of_measure of this Item.  # noqa: E501

        The unit of measurement used for the package weight, such as POUND, KILOGRAM, OUNCE, or GRAM. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:WeightUnitOfMeasureEnum'>eBay API documentation</a>  # noqa: E501

        :return: The weight_unit_of_measure of this Item.  # noqa: E501
        :rtype: str
        """
        return self._weight_unit_of_measure

    @weight_unit_of_measure.setter
    def weight_unit_of_measure(self, weight_unit_of_measure):
        """Sets the weight_unit_of_measure of this Item.

        The unit of measurement used for the package weight, such as POUND, KILOGRAM, OUNCE, or GRAM. Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:WeightUnitOfMeasureEnum'>eBay API documentation</a>  # noqa: E501

        :param weight_unit_of_measure: The weight_unit_of_measure of this Item.  # noqa: E501
        :type: str
        """

        self._weight_unit_of_measure = weight_unit_of_measure

    @property
    def package_weight(self):
        """Gets the package_weight of this Item.  # noqa: E501

        The weight of the package that contains the item.  # noqa: E501

        :return: The package_weight of this Item.  # noqa: E501
        :rtype: str
        """
        return self._package_weight

    @package_weight.setter
    def package_weight(self, package_weight):
        """Sets the package_weight of this Item.

        The weight of the package that contains the item.  # noqa: E501

        :param package_weight: The package_weight of this Item.  # noqa: E501
        :type: str
        """

        self._package_weight = package_weight

    @property
    def shipping_cost_type(self):
        """Gets the shipping_cost_type of this Item.  # noqa: E501

        Indicates the class of the shipping cost. Valid Values: FIXED or CALCULATED.  # noqa: E501

        :return: The shipping_cost_type of this Item.  # noqa: E501
        :rtype: str
        """
        return self._shipping_cost_type

    @shipping_cost_type.setter
    def shipping_cost_type(self, shipping_cost_type):
        """Sets the shipping_cost_type of this Item.

        Indicates the class of the shipping cost. Valid Values: FIXED or CALCULATED.  # noqa: E501

        :param shipping_cost_type: The shipping_cost_type of this Item.  # noqa: E501
        :type: str
        """

        self._shipping_cost_type = shipping_cost_type

    @property
    def shipping_cost(self):
        """Gets the shipping_cost of this Item.  # noqa: E501

        The final shipping cost for all the items after all discounts are applied. Note: The price includes the value-added tax (VAT) for applicable jurisdictions when requested from supported marketplaces. In this case, users must pass the X-EBAY-C-MARKETPLACE-ID request header specifying the supported marketplace (such as EBAY_GB) to see the VAT-inclusive pricing. For more information on VAT, refer to VAT Obligations in the EU.  # noqa: E501

        :return: The shipping_cost of this Item.  # noqa: E501
        :rtype: str
        """
        return self._shipping_cost

    @shipping_cost.setter
    def shipping_cost(self, shipping_cost):
        """Sets the shipping_cost of this Item.

        The final shipping cost for all the items after all discounts are applied. Note: The price includes the value-added tax (VAT) for applicable jurisdictions when requested from supported marketplaces. In this case, users must pass the X-EBAY-C-MARKETPLACE-ID request header specifying the supported marketplace (such as EBAY_GB) to see the VAT-inclusive pricing. For more information on VAT, refer to VAT Obligations in the EU.  # noqa: E501

        :param shipping_cost: The shipping_cost of this Item.  # noqa: E501
        :type: str
        """

        self._shipping_cost = shipping_cost

    @property
    def additional_shipping_cost_per_unit(self):
        """Gets the additional_shipping_cost_per_unit of this Item.  # noqa: E501

        Any per item additional shipping costs for a multi-item purchase. For example, let's say the shipping cost for a power cord is $3. But for an additional cord, the shipping cost is only $1. So if you bought 3 cords, the shippingCost would be $3 and this value would be $2 ($1 for each additional item).  # noqa: E501

        :return: The additional_shipping_cost_per_unit of this Item.  # noqa: E501
        :rtype: str
        """
        return self._additional_shipping_cost_per_unit

    @additional_shipping_cost_per_unit.setter
    def additional_shipping_cost_per_unit(self, additional_shipping_cost_per_unit):
        """Sets the additional_shipping_cost_per_unit of this Item.

        Any per item additional shipping costs for a multi-item purchase. For example, let's say the shipping cost for a power cord is $3. But for an additional cord, the shipping cost is only $1. So if you bought 3 cords, the shippingCost would be $3 and this value would be $2 ($1 for each additional item).  # noqa: E501

        :param additional_shipping_cost_per_unit: The additional_shipping_cost_per_unit of this Item.  # noqa: E501
        :type: str
        """

        self._additional_shipping_cost_per_unit = additional_shipping_cost_per_unit

    @property
    def quantity_used_for_estimate(self):
        """Gets the quantity_used_for_estimate of this Item.  # noqa: E501

        The number of items used when calculating the estimation information.  # noqa: E501

        :return: The quantity_used_for_estimate of this Item.  # noqa: E501
        :rtype: int
        """
        return self._quantity_used_for_estimate

    @quantity_used_for_estimate.setter
    def quantity_used_for_estimate(self, quantity_used_for_estimate):
        """Sets the quantity_used_for_estimate of this Item.

        The number of items used when calculating the estimation information.  # noqa: E501

        :param quantity_used_for_estimate: The quantity_used_for_estimate of this Item.  # noqa: E501
        :type: int
        """

        self._quantity_used_for_estimate = quantity_used_for_estimate

    @property
    def shipping_carrier_code(self):
        """Gets the shipping_carrier_code of this Item.  # noqa: E501

        The name of the shipping provider, such as FedEx, or USPS.  # noqa: E501

        :return: The shipping_carrier_code of this Item.  # noqa: E501
        :rtype: str
        """
        return self._shipping_carrier_code

    @shipping_carrier_code.setter
    def shipping_carrier_code(self, shipping_carrier_code):
        """Sets the shipping_carrier_code of this Item.

        The name of the shipping provider, such as FedEx, or USPS.  # noqa: E501

        :param shipping_carrier_code: The shipping_carrier_code of this Item.  # noqa: E501
        :type: str
        """

        self._shipping_carrier_code = shipping_carrier_code

    @property
    def shipping_service_code(self):
        """Gets the shipping_service_code of this Item.  # noqa: E501

        The type of shipping service. For example, USPS First Class.  # noqa: E501

        :return: The shipping_service_code of this Item.  # noqa: E501
        :rtype: str
        """
        return self._shipping_service_code

    @shipping_service_code.setter
    def shipping_service_code(self, shipping_service_code):
        """Sets the shipping_service_code of this Item.

        The type of shipping service. For example, USPS First Class.  # noqa: E501

        :param shipping_service_code: The shipping_service_code of this Item.  # noqa: E501
        :type: str
        """

        self._shipping_service_code = shipping_service_code

    @property
    def shipping_type(self):
        """Gets the shipping_type of this Item.  # noqa: E501

        The type of a shipping option, such as EXPEDITED, ONE_DAY, STANDARD, ECONOMY, PICKUP, etc.  # noqa: E501

        :return: The shipping_type of this Item.  # noqa: E501
        :rtype: str
        """
        return self._shipping_type

    @shipping_type.setter
    def shipping_type(self, shipping_type):
        """Sets the shipping_type of this Item.

        The type of a shipping option, such as EXPEDITED, ONE_DAY, STANDARD, ECONOMY, PICKUP, etc.  # noqa: E501

        :param shipping_type: The shipping_type of this Item.  # noqa: E501
        :type: str
        """

        self._shipping_type = shipping_type

    @property
    def unit_price(self):
        """Gets the unit_price of this Item.  # noqa: E501

        This is the price per unit for the item. Some European countries require listings for certain types of products to include the price per unit so buyers can accurately compare prices. For example: &quot;unitPricingMeasure&quot;: &quot;100g&quot;, &quot;unitPrice&quot;: { &nbsp;&nbsp;&quot;value&quot;: &quot;7.99&quot;, &nbsp;&nbsp;&quot;currency&quot;: &quot;GBP&quot;  # noqa: E501

        :return: The unit_price of this Item.  # noqa: E501
        :rtype: str
        """
        return self._unit_price

    @unit_price.setter
    def unit_price(self, unit_price):
        """Sets the unit_price of this Item.

        This is the price per unit for the item. Some European countries require listings for certain types of products to include the price per unit so buyers can accurately compare prices. For example: &quot;unitPricingMeasure&quot;: &quot;100g&quot;, &quot;unitPrice&quot;: { &nbsp;&nbsp;&quot;value&quot;: &quot;7.99&quot;, &nbsp;&nbsp;&quot;currency&quot;: &quot;GBP&quot;  # noqa: E501

        :param unit_price: The unit_price of this Item.  # noqa: E501
        :type: str
        """

        self._unit_price = unit_price

    @property
    def unit_pricing_measure(self):
        """Gets the unit_pricing_measure of this Item.  # noqa: E501

        The designation, such as size, weight, volume, count, etc., that was used to specify the quantity of the item. This helps buyers compare prices. For example, the following tells the buyer that the item is 7.99 per 100 grams. &quot;unitPricingMeasure&quot;: &quot;100g&quot;, &quot;unitPrice&quot;: { &nbsp;&nbsp;&quot;value&quot;: &quot;7.99&quot;, &nbsp;&nbsp;&quot;currency&quot;: &quot;GBP&quot;  # noqa: E501

        :return: The unit_pricing_measure of this Item.  # noqa: E501
        :rtype: str
        """
        return self._unit_pricing_measure

    @unit_pricing_measure.setter
    def unit_pricing_measure(self, unit_pricing_measure):
        """Sets the unit_pricing_measure of this Item.

        The designation, such as size, weight, volume, count, etc., that was used to specify the quantity of the item. This helps buyers compare prices. For example, the following tells the buyer that the item is 7.99 per 100 grams. &quot;unitPricingMeasure&quot;: &quot;100g&quot;, &quot;unitPrice&quot;: { &nbsp;&nbsp;&quot;value&quot;: &quot;7.99&quot;, &nbsp;&nbsp;&quot;currency&quot;: &quot;GBP&quot;  # noqa: E501

        :param unit_pricing_measure: The unit_pricing_measure of this Item.  # noqa: E501
        :type: str
        """

        self._unit_pricing_measure = unit_pricing_measure

    @property
    def legacy_item_id(self):
        """Gets the legacy_item_id of this Item.  # noqa: E501

        The unique identifier of the eBay listing that contains the item. This is the traditional/legacy ID that is often seen in the URL of the listing View Item page.  # noqa: E501

        :return: The legacy_item_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._legacy_item_id

    @legacy_item_id.setter
    def legacy_item_id(self, legacy_item_id):
        """Sets the legacy_item_id of this Item.

        The unique identifier of the eBay listing that contains the item. This is the traditional/legacy ID that is often seen in the URL of the listing View Item page.  # noqa: E501

        :param legacy_item_id: The legacy_item_id of this Item.  # noqa: E501
        :type: str
        """

        self._legacy_item_id = legacy_item_id

    @property
    def alerts(self):
        """Gets the alerts of this Item.  # noqa: E501

        A pipe-separated list of alerts available for the item. For example, if the DELAYED_DELIVERY alert was returned for an item, it would indicate a delay in shipping by the seller.  # noqa: E501

        :return: The alerts of this Item.  # noqa: E501
        :rtype: str
        """
        return self._alerts

    @alerts.setter
    def alerts(self, alerts):
        """Sets the alerts of this Item.

        A pipe-separated list of alerts available for the item. For example, if the DELAYED_DELIVERY alert was returned for an item, it would indicate a delay in shipping by the seller.  # noqa: E501

        :param alerts: The alerts of this Item.  # noqa: E501
        :type: str
        """

        self._alerts = alerts

    @property
    def seller_account_type(self):
        """Gets the seller_account_type of this Item.  # noqa: E501

        A string value that specifies whether the seller is a business or an individual. This is determined when the seller registers with eBay. If the seller registers for a business account, the value returned in this field will be BUSINESS. If the seller registers for a private account, the value returned in this field will be INDIVIDUAL. Note: This designation is required by the tax laws in some countries. This field is returned only on the following sites: EBAY_AT, EBAY_BE, EBAY_CH, EBAY_DE, EBAY_ES, EBAY_FR, EBAY_GB, EBAY_IE, EBAY_IT, and EBAY_PL. Code so that your app gracefully handles any future changes to this list. Valid Values: BUSINESS or INDIVIDUAL  # noqa: E501

        :return: The seller_account_type of this Item.  # noqa: E501
        :rtype: str
        """
        return self._seller_account_type

    @seller_account_type.setter
    def seller_account_type(self, seller_account_type):
        """Sets the seller_account_type of this Item.

        A string value that specifies whether the seller is a business or an individual. This is determined when the seller registers with eBay. If the seller registers for a business account, the value returned in this field will be BUSINESS. If the seller registers for a private account, the value returned in this field will be INDIVIDUAL. Note: This designation is required by the tax laws in some countries. This field is returned only on the following sites: EBAY_AT, EBAY_BE, EBAY_CH, EBAY_DE, EBAY_ES, EBAY_FR, EBAY_GB, EBAY_IE, EBAY_IT, and EBAY_PL. Code so that your app gracefully handles any future changes to this list. Valid Values: BUSINESS or INDIVIDUAL  # noqa: E501

        :param seller_account_type: The seller_account_type of this Item.  # noqa: E501
        :type: str
        """

        self._seller_account_type = seller_account_type

    @property
    def tyre_label_image_url(self):
        """Gets the tyre_label_image_url of this Item.  # noqa: E501

        The URL to the image that shows the information on the tyre label.  # noqa: E501

        :return: The tyre_label_image_url of this Item.  # noqa: E501
        :rtype: str
        """
        return self._tyre_label_image_url

    @tyre_label_image_url.setter
    def tyre_label_image_url(self, tyre_label_image_url):
        """Sets the tyre_label_image_url of this Item.

        The URL to the image that shows the information on the tyre label.  # noqa: E501

        :param tyre_label_image_url: The tyre_label_image_url of this Item.  # noqa: E501
        :type: str
        """

        self._tyre_label_image_url = tyre_label_image_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Item, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Item):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
