# coding: utf-8

"""
    Marketplace Insights API

    <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#Limited\" target=\"_blank\"> <img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\" title=\"Limited Release\"  alt=\"Limited Release\" />(Limited Release)</a> The Marketplace Insights API provides the ability to search for sold items on eBay by keyword, GTIN, category, and product and returns the of sales history of those items.  # noqa: E501

    OpenAPI spec version: v1_beta.2.2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ItemSales(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'additional_images': 'list[Image]',
        'adult_only': 'bool',
        'bid_count': 'int',
        'buying_options': 'list[str]',
        'categories': 'list[Category]',
        'condition': 'str',
        'condition_id': 'str',
        'epid': 'str',
        'image': 'Image',
        'item_affiliate_web_url': 'str',
        'item_group_href': 'str',
        'item_group_type': 'str',
        'item_href': 'str',
        'item_id': 'str',
        'item_location': 'ItemLocation',
        'item_web_url': 'str',
        'last_sold_date': 'str',
        'last_sold_price': 'ConvertedAmount',
        'seller': 'Seller',
        'thumbnail_images': 'list[Image]',
        'title': 'str',
        'total_sold_quantity': 'int'
    }

    attribute_map = {
        'additional_images': 'additionalImages',
        'adult_only': 'adultOnly',
        'bid_count': 'bidCount',
        'buying_options': 'buyingOptions',
        'categories': 'categories',
        'condition': 'condition',
        'condition_id': 'conditionId',
        'epid': 'epid',
        'image': 'image',
        'item_affiliate_web_url': 'itemAffiliateWebUrl',
        'item_group_href': 'itemGroupHref',
        'item_group_type': 'itemGroupType',
        'item_href': 'itemHref',
        'item_id': 'itemId',
        'item_location': 'itemLocation',
        'item_web_url': 'itemWebUrl',
        'last_sold_date': 'lastSoldDate',
        'last_sold_price': 'lastSoldPrice',
        'seller': 'seller',
        'thumbnail_images': 'thumbnailImages',
        'title': 'title',
        'total_sold_quantity': 'totalSoldQuantity'
    }

    def __init__(self, additional_images=None, adult_only=None, bid_count=None, buying_options=None, categories=None, condition=None, condition_id=None, epid=None, image=None, item_affiliate_web_url=None, item_group_href=None, item_group_type=None, item_href=None, item_id=None, item_location=None, item_web_url=None, last_sold_date=None, last_sold_price=None, seller=None, thumbnail_images=None, title=None, total_sold_quantity=None):  # noqa: E501
        """ItemSales - a model defined in Swagger"""  # noqa: E501
        self._additional_images = None
        self._adult_only = None
        self._bid_count = None
        self._buying_options = None
        self._categories = None
        self._condition = None
        self._condition_id = None
        self._epid = None
        self._image = None
        self._item_affiliate_web_url = None
        self._item_group_href = None
        self._item_group_type = None
        self._item_href = None
        self._item_id = None
        self._item_location = None
        self._item_web_url = None
        self._last_sold_date = None
        self._last_sold_price = None
        self._seller = None
        self._thumbnail_images = None
        self._title = None
        self._total_sold_quantity = None
        self.discriminator = None
        if additional_images is not None:
            self.additional_images = additional_images
        if adult_only is not None:
            self.adult_only = adult_only
        if bid_count is not None:
            self.bid_count = bid_count
        if buying_options is not None:
            self.buying_options = buying_options
        if categories is not None:
            self.categories = categories
        if condition is not None:
            self.condition = condition
        if condition_id is not None:
            self.condition_id = condition_id
        if epid is not None:
            self.epid = epid
        if image is not None:
            self.image = image
        if item_affiliate_web_url is not None:
            self.item_affiliate_web_url = item_affiliate_web_url
        if item_group_href is not None:
            self.item_group_href = item_group_href
        if item_group_type is not None:
            self.item_group_type = item_group_type
        if item_href is not None:
            self.item_href = item_href
        if item_id is not None:
            self.item_id = item_id
        if item_location is not None:
            self.item_location = item_location
        if item_web_url is not None:
            self.item_web_url = item_web_url
        if last_sold_date is not None:
            self.last_sold_date = last_sold_date
        if last_sold_price is not None:
            self.last_sold_price = last_sold_price
        if seller is not None:
            self.seller = seller
        if thumbnail_images is not None:
            self.thumbnail_images = thumbnail_images
        if title is not None:
            self.title = title
        if total_sold_quantity is not None:
            self.total_sold_quantity = total_sold_quantity

    @property
    def additional_images(self):
        """Gets the additional_images of this ItemSales.  # noqa: E501

        An array of containers with the URLs for the images that are in addition to the primary image. The primary image is returned in the image.imageUrl field.  # noqa: E501

        :return: The additional_images of this ItemSales.  # noqa: E501
        :rtype: list[Image]
        """
        return self._additional_images

    @additional_images.setter
    def additional_images(self, additional_images):
        """Sets the additional_images of this ItemSales.

        An array of containers with the URLs for the images that are in addition to the primary image. The primary image is returned in the image.imageUrl field.  # noqa: E501

        :param additional_images: The additional_images of this ItemSales.  # noqa: E501
        :type: list[Image]
        """

        self._additional_images = additional_images

    @property
    def adult_only(self):
        """Gets the adult_only of this ItemSales.  # noqa: E501

        This indicates if the item is for adults only. For more information about adult-only items on eBay, see Adult items policy for sellers and Adult-Only items on eBay for buyers.  # noqa: E501

        :return: The adult_only of this ItemSales.  # noqa: E501
        :rtype: bool
        """
        return self._adult_only

    @adult_only.setter
    def adult_only(self, adult_only):
        """Sets the adult_only of this ItemSales.

        This indicates if the item is for adults only. For more information about adult-only items on eBay, see Adult items policy for sellers and Adult-Only items on eBay for buyers.  # noqa: E501

        :param adult_only: The adult_only of this ItemSales.  # noqa: E501
        :type: bool
        """

        self._adult_only = adult_only

    @property
    def bid_count(self):
        """Gets the bid_count of this ItemSales.  # noqa: E501

        This integer value indicates the total number of bids that have been placed for an auction item. This field is only returned for auction items.  # noqa: E501

        :return: The bid_count of this ItemSales.  # noqa: E501
        :rtype: int
        """
        return self._bid_count

    @bid_count.setter
    def bid_count(self, bid_count):
        """Sets the bid_count of this ItemSales.

        This integer value indicates the total number of bids that have been placed for an auction item. This field is only returned for auction items.  # noqa: E501

        :param bid_count: The bid_count of this ItemSales.  # noqa: E501
        :type: int
        """

        self._bid_count = bid_count

    @property
    def buying_options(self):
        """Gets the buying_options of this ItemSales.  # noqa: E501

        A comma separated list of the purchase options available for the item, such as FIXED_PRICE, AUCTION. FIXED_PRICE - Returned for fixed-price items (non-auction) AUCTION - Returned for auction items without Buy It Now feature FIXED_PRICE and AUCTION - Returned for auction items enabled with the Buy It Now feature Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The buying_options of this ItemSales.  # noqa: E501
        :rtype: list[str]
        """
        return self._buying_options

    @buying_options.setter
    def buying_options(self, buying_options):
        """Sets the buying_options of this ItemSales.

        A comma separated list of the purchase options available for the item, such as FIXED_PRICE, AUCTION. FIXED_PRICE - Returned for fixed-price items (non-auction) AUCTION - Returned for auction items without Buy It Now feature FIXED_PRICE and AUCTION - Returned for auction items enabled with the Buy It Now feature Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param buying_options: The buying_options of this ItemSales.  # noqa: E501
        :type: list[str]
        """

        self._buying_options = buying_options

    @property
    def categories(self):
        """Gets the categories of this ItemSales.  # noqa: E501

        This container returns the primary category ID of the item, as well as the secondary category if the item was listed in two categories.  # noqa: E501

        :return: The categories of this ItemSales.  # noqa: E501
        :rtype: list[Category]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """Sets the categories of this ItemSales.

        This container returns the primary category ID of the item, as well as the secondary category if the item was listed in two categories.  # noqa: E501

        :param categories: The categories of this ItemSales.  # noqa: E501
        :type: list[Category]
        """

        self._categories = categories

    @property
    def condition(self):
        """Gets the condition of this ItemSales.  # noqa: E501

        The text describing the condition of the item, such as New or Used. For a list of condition names, see Item Condition IDs and Names. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The condition of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this ItemSales.

        The text describing the condition of the item, such as New or Used. For a list of condition names, see Item Condition IDs and Names. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param condition: The condition of this ItemSales.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def condition_id(self):
        """Gets the condition_id of this ItemSales.  # noqa: E501

        The identifier of the condition of the item. For example, 1000 is the identifier for NEW. For a list of condition names and IDs, see Item Condition IDs and Names. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The condition_id of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._condition_id

    @condition_id.setter
    def condition_id(self, condition_id):
        """Sets the condition_id of this ItemSales.

        The identifier of the condition of the item. For example, 1000 is the identifier for NEW. For a list of condition names and IDs, see Item Condition IDs and Names. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param condition_id: The condition_id of this ItemSales.  # noqa: E501
        :type: str
        """

        self._condition_id = condition_id

    @property
    def epid(self):
        """Gets the epid of this ItemSales.  # noqa: E501

        An ePID is the eBay product identifier of a product from the eBay product catalog. This indicates the product in which the item belongs.  # noqa: E501

        :return: The epid of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._epid

    @epid.setter
    def epid(self, epid):
        """Sets the epid of this ItemSales.

        An ePID is the eBay product identifier of a product from the eBay product catalog. This indicates the product in which the item belongs.  # noqa: E501

        :param epid: The epid of this ItemSales.  # noqa: E501
        :type: str
        """

        self._epid = epid

    @property
    def image(self):
        """Gets the image of this ItemSales.  # noqa: E501


        :return: The image of this ItemSales.  # noqa: E501
        :rtype: Image
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this ItemSales.


        :param image: The image of this ItemSales.  # noqa: E501
        :type: Image
        """

        self._image = image

    @property
    def item_affiliate_web_url(self):
        """Gets the item_affiliate_web_url of this ItemSales.  # noqa: E501

        The URL to the View Item page of the item, which includes the affiliate tracking ID. This field is only returned if the eBay partner enables affiliate tracking for the item by including the X-EBAY-C-ENDUSERCTX request header in the method.  # noqa: E501

        :return: The item_affiliate_web_url of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._item_affiliate_web_url

    @item_affiliate_web_url.setter
    def item_affiliate_web_url(self, item_affiliate_web_url):
        """Sets the item_affiliate_web_url of this ItemSales.

        The URL to the View Item page of the item, which includes the affiliate tracking ID. This field is only returned if the eBay partner enables affiliate tracking for the item by including the X-EBAY-C-ENDUSERCTX request header in the method.  # noqa: E501

        :param item_affiliate_web_url: The item_affiliate_web_url of this ItemSales.  # noqa: E501
        :type: str
        """

        self._item_affiliate_web_url = item_affiliate_web_url

    @property
    def item_group_href(self):
        """Gets the item_group_href of this ItemSales.  # noqa: E501

        The HATEOAS reference of the parent page of the item group. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc. Note: This field is returned only for item groups.  # noqa: E501

        :return: The item_group_href of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._item_group_href

    @item_group_href.setter
    def item_group_href(self, item_group_href):
        """Sets the item_group_href of this ItemSales.

        The HATEOAS reference of the parent page of the item group. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc. Note: This field is returned only for item groups.  # noqa: E501

        :param item_group_href: The item_group_href of this ItemSales.  # noqa: E501
        :type: str
        """

        self._item_group_href = item_group_href

    @property
    def item_group_type(self):
        """Gets the item_group_type of this ItemSales.  # noqa: E501

        Indicates the item group type. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc. Currently, only the SELLER_DEFINED_VARIATIONS group type is supported and indicates that this is an item group created by the seller. Note: This field is returned only for item groups. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The item_group_type of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._item_group_type

    @item_group_type.setter
    def item_group_type(self, item_group_type):
        """Sets the item_group_type of this ItemSales.

        Indicates the item group type. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc. Currently, only the SELLER_DEFINED_VARIATIONS group type is supported and indicates that this is an item group created by the seller. Note: This field is returned only for item groups. Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param item_group_type: The item_group_type of this ItemSales.  # noqa: E501
        :type: str
        """

        self._item_group_type = item_group_type

    @property
    def item_href(self):
        """Gets the item_href of this ItemSales.  # noqa: E501

        The URI of the item.  # noqa: E501

        :return: The item_href of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._item_href

    @item_href.setter
    def item_href(self, item_href):
        """Sets the item_href of this ItemSales.

        The URI of the item.  # noqa: E501

        :param item_href: The item_href of this ItemSales.  # noqa: E501
        :type: str
        """

        self._item_href = item_href

    @property
    def item_id(self):
        """Gets the item_id of this ItemSales.  # noqa: E501

        The unique RESTful identifier of the item.  # noqa: E501

        :return: The item_id of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this ItemSales.

        The unique RESTful identifier of the item.  # noqa: E501

        :param item_id: The item_id of this ItemSales.  # noqa: E501
        :type: str
        """

        self._item_id = item_id

    @property
    def item_location(self):
        """Gets the item_location of this ItemSales.  # noqa: E501


        :return: The item_location of this ItemSales.  # noqa: E501
        :rtype: ItemLocation
        """
        return self._item_location

    @item_location.setter
    def item_location(self, item_location):
        """Sets the item_location of this ItemSales.


        :param item_location: The item_location of this ItemSales.  # noqa: E501
        :type: ItemLocation
        """

        self._item_location = item_location

    @property
    def item_web_url(self):
        """Gets the item_web_url of this ItemSales.  # noqa: E501

        The URL to the View Item page of the item.  # noqa: E501

        :return: The item_web_url of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._item_web_url

    @item_web_url.setter
    def item_web_url(self, item_web_url):
        """Sets the item_web_url of this ItemSales.

        The URL to the View Item page of the item.  # noqa: E501

        :param item_web_url: The item_web_url of this ItemSales.  # noqa: E501
        :type: str
        """

        self._item_web_url = item_web_url

    @property
    def last_sold_date(self):
        """Gets the last_sold_date of this ItemSales.  # noqa: E501

        The date the last item was purchased within the last 90 days. The totalSoldQuantity returns the total number of items that were sold. This field returns the date the last item in that group was sold.  # noqa: E501

        :return: The last_sold_date of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._last_sold_date

    @last_sold_date.setter
    def last_sold_date(self, last_sold_date):
        """Sets the last_sold_date of this ItemSales.

        The date the last item was purchased within the last 90 days. The totalSoldQuantity returns the total number of items that were sold. This field returns the date the last item in that group was sold.  # noqa: E501

        :param last_sold_date: The last_sold_date of this ItemSales.  # noqa: E501
        :type: str
        """

        self._last_sold_date = last_sold_date

    @property
    def last_sold_price(self):
        """Gets the last_sold_price of this ItemSales.  # noqa: E501


        :return: The last_sold_price of this ItemSales.  # noqa: E501
        :rtype: ConvertedAmount
        """
        return self._last_sold_price

    @last_sold_price.setter
    def last_sold_price(self, last_sold_price):
        """Sets the last_sold_price of this ItemSales.


        :param last_sold_price: The last_sold_price of this ItemSales.  # noqa: E501
        :type: ConvertedAmount
        """

        self._last_sold_price = last_sold_price

    @property
    def seller(self):
        """Gets the seller of this ItemSales.  # noqa: E501


        :return: The seller of this ItemSales.  # noqa: E501
        :rtype: Seller
        """
        return self._seller

    @seller.setter
    def seller(self, seller):
        """Sets the seller of this ItemSales.


        :param seller: The seller of this ItemSales.  # noqa: E501
        :type: Seller
        """

        self._seller = seller

    @property
    def thumbnail_images(self):
        """Gets the thumbnail_images of this ItemSales.  # noqa: E501

        An array of thumbnail images for the item.  # noqa: E501

        :return: The thumbnail_images of this ItemSales.  # noqa: E501
        :rtype: list[Image]
        """
        return self._thumbnail_images

    @thumbnail_images.setter
    def thumbnail_images(self, thumbnail_images):
        """Sets the thumbnail_images of this ItemSales.

        An array of thumbnail images for the item.  # noqa: E501

        :param thumbnail_images: The thumbnail_images of this ItemSales.  # noqa: E501
        :type: list[Image]
        """

        self._thumbnail_images = thumbnail_images

    @property
    def title(self):
        """Gets the title of this ItemSales.  # noqa: E501

        The seller-created title of the item. Maximum Length: 80 characters  # noqa: E501

        :return: The title of this ItemSales.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this ItemSales.

        The seller-created title of the item. Maximum Length: 80 characters  # noqa: E501

        :param title: The title of this ItemSales.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def total_sold_quantity(self):
        """Gets the total_sold_quantity of this ItemSales.  # noqa: E501

        The total number of this item that have been sold.  # noqa: E501

        :return: The total_sold_quantity of this ItemSales.  # noqa: E501
        :rtype: int
        """
        return self._total_sold_quantity

    @total_sold_quantity.setter
    def total_sold_quantity(self, total_sold_quantity):
        """Sets the total_sold_quantity of this ItemSales.

        The total number of this item that have been sold.  # noqa: E501

        :param total_sold_quantity: The total_sold_quantity of this ItemSales.  # noqa: E501
        :type: int
        """

        self._total_sold_quantity = total_sold_quantity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ItemSales, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ItemSales):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
