# coding: utf-8

"""
    Marketplace Insights API

    <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#Limited\" target=\"_blank\"> <img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\" title=\"Limited Release\"  alt=\"Limited Release\" />(Limited Release)</a> The Marketplace Insights API provides the ability to search for sold items on eBay by keyword, GTIN, category, and product and returns the of sales history of those items.  # noqa: E501

    OpenAPI spec version: v1_beta.2.2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SalesHistoryPagedCollection(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'href': 'str',
        'item_sales': 'list[ItemSales]',
        'limit': 'int',
        'next': 'str',
        'offset': 'int',
        'prev': 'str',
        'refinement': 'Refinement',
        'total': 'int'
    }

    attribute_map = {
        'href': 'href',
        'item_sales': 'itemSales',
        'limit': 'limit',
        'next': 'next',
        'offset': 'offset',
        'prev': 'prev',
        'refinement': 'refinement',
        'total': 'total'
    }

    def __init__(self, href=None, item_sales=None, limit=None, next=None, offset=None, prev=None, refinement=None, total=None):  # noqa: E501
        """SalesHistoryPagedCollection - a model defined in Swagger"""  # noqa: E501
        self._href = None
        self._item_sales = None
        self._limit = None
        self._next = None
        self._offset = None
        self._prev = None
        self._refinement = None
        self._total = None
        self.discriminator = None
        if href is not None:
            self.href = href
        if item_sales is not None:
            self.item_sales = item_sales
        if limit is not None:
            self.limit = limit
        if next is not None:
            self.next = next
        if offset is not None:
            self.offset = offset
        if prev is not None:
            self.prev = prev
        if refinement is not None:
            self.refinement = refinement
        if total is not None:
            self.total = total

    @property
    def href(self):
        """Gets the href of this SalesHistoryPagedCollection.  # noqa: E501

        The URI of the current page of results from the result set. The following example returns items 1 thru 5 from the list of items found. https://api.ebay.com/buy/marketplace_insights/v1_beta/item_sales/search?q=shirt&amp;&amp;limit=5&amp;offset=0  # noqa: E501

        :return: The href of this SalesHistoryPagedCollection.  # noqa: E501
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """Sets the href of this SalesHistoryPagedCollection.

        The URI of the current page of results from the result set. The following example returns items 1 thru 5 from the list of items found. https://api.ebay.com/buy/marketplace_insights/v1_beta/item_sales/search?q=shirt&amp;&amp;limit=5&amp;offset=0  # noqa: E501

        :param href: The href of this SalesHistoryPagedCollection.  # noqa: E501
        :type: str
        """

        self._href = href

    @property
    def item_sales(self):
        """Gets the item_sales of this SalesHistoryPagedCollection.  # noqa: E501

        The type that defines the fields for a paginated result set of the sold items. The response consists of 0 or more sequenced result sets where each result sets has 0 or more items. Note: For items with multiple quantities that might result in multiple transactions, and items with the SELLER_DEFINED_VARIATIONS group type that might result in multiple transactions, only one deduped transaction is returned in the search results.  # noqa: E501

        :return: The item_sales of this SalesHistoryPagedCollection.  # noqa: E501
        :rtype: list[ItemSales]
        """
        return self._item_sales

    @item_sales.setter
    def item_sales(self, item_sales):
        """Sets the item_sales of this SalesHistoryPagedCollection.

        The type that defines the fields for a paginated result set of the sold items. The response consists of 0 or more sequenced result sets where each result sets has 0 or more items. Note: For items with multiple quantities that might result in multiple transactions, and items with the SELLER_DEFINED_VARIATIONS group type that might result in multiple transactions, only one deduped transaction is returned in the search results.  # noqa: E501

        :param item_sales: The item_sales of this SalesHistoryPagedCollection.  # noqa: E501
        :type: list[ItemSales]
        """

        self._item_sales = item_sales

    @property
    def limit(self):
        """Gets the limit of this SalesHistoryPagedCollection.  # noqa: E501

        The number of items returned on a single page from the result set. This value can be set in the request with the limit query parameter.  # noqa: E501

        :return: The limit of this SalesHistoryPagedCollection.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this SalesHistoryPagedCollection.

        The number of items returned on a single page from the result set. This value can be set in the request with the limit query parameter.  # noqa: E501

        :param limit: The limit of this SalesHistoryPagedCollection.  # noqa: E501
        :type: int
        """

        self._limit = limit

    @property
    def next(self):
        """Gets the next of this SalesHistoryPagedCollection.  # noqa: E501

        The URI for the following page of results. This value is returned only if there is an additional page of results to display from the result set. Max length: 2048  # noqa: E501

        :return: The next of this SalesHistoryPagedCollection.  # noqa: E501
        :rtype: str
        """
        return self._next

    @next.setter
    def next(self, next):
        """Sets the next of this SalesHistoryPagedCollection.

        The URI for the following page of results. This value is returned only if there is an additional page of results to display from the result set. Max length: 2048  # noqa: E501

        :param next: The next of this SalesHistoryPagedCollection.  # noqa: E501
        :type: str
        """

        self._next = next

    @property
    def offset(self):
        """Gets the offset of this SalesHistoryPagedCollection.  # noqa: E501

        The number of results skipped in the result set before listing the first returned result. This value can be set in the request with the offset query parameter.  # noqa: E501

        :return: The offset of this SalesHistoryPagedCollection.  # noqa: E501
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Sets the offset of this SalesHistoryPagedCollection.

        The number of results skipped in the result set before listing the first returned result. This value can be set in the request with the offset query parameter.  # noqa: E501

        :param offset: The offset of this SalesHistoryPagedCollection.  # noqa: E501
        :type: int
        """

        self._offset = offset

    @property
    def prev(self):
        """Gets the prev of this SalesHistoryPagedCollection.  # noqa: E501

        The URI for the preceding page of results. This value is returned only if there is a previous page of results to display from the result set. Max length: 2048  # noqa: E501

        :return: The prev of this SalesHistoryPagedCollection.  # noqa: E501
        :rtype: str
        """
        return self._prev

    @prev.setter
    def prev(self, prev):
        """Sets the prev of this SalesHistoryPagedCollection.

        The URI for the preceding page of results. This value is returned only if there is a previous page of results to display from the result set. Max length: 2048  # noqa: E501

        :param prev: The prev of this SalesHistoryPagedCollection.  # noqa: E501
        :type: str
        """

        self._prev = prev

    @property
    def refinement(self):
        """Gets the refinement of this SalesHistoryPagedCollection.  # noqa: E501


        :return: The refinement of this SalesHistoryPagedCollection.  # noqa: E501
        :rtype: Refinement
        """
        return self._refinement

    @refinement.setter
    def refinement(self, refinement):
        """Sets the refinement of this SalesHistoryPagedCollection.


        :param refinement: The refinement of this SalesHistoryPagedCollection.  # noqa: E501
        :type: Refinement
        """

        self._refinement = refinement

    @property
    def total(self):
        """Gets the total of this SalesHistoryPagedCollection.  # noqa: E501

        The total number of items retrieved in the result set. If no items are found, this field is returned with a value of 0.  # noqa: E501

        :return: The total of this SalesHistoryPagedCollection.  # noqa: E501
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this SalesHistoryPagedCollection.

        The total number of items retrieved in the result set. If no items are found, this field is returned with a value of 0.  # noqa: E501

        :param total: The total of this SalesHistoryPagedCollection.  # noqa: E501
        :type: int
        """

        self._total = total

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SalesHistoryPagedCollection, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SalesHistoryPagedCollection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
