# coding: utf-8

"""
    Buy Offer API

    The Buy Offer API enables Partners to place proxy bids for a buyer and retrieve the auctions where the buyer is bidding.  By placing a proxy bid, the buyer is agreeing to purchase the item if they win the auction. </p>   # noqa: E501

    OpenAPI spec version: v1_beta.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Bidding(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auction_end_date': 'str',
        'auction_status': 'str',
        'bid_count': 'int',
        'current_price': 'Amount',
        'current_proxy_bid': 'ProxyBid',
        'high_bidder': 'bool',
        'item_id': 'str',
        'reserve_price_met': 'bool',
        'suggested_bid_amounts': 'list[Amount]'
    }

    attribute_map = {
        'auction_end_date': 'auctionEndDate',
        'auction_status': 'auctionStatus',
        'bid_count': 'bidCount',
        'current_price': 'currentPrice',
        'current_proxy_bid': 'currentProxyBid',
        'high_bidder': 'highBidder',
        'item_id': 'itemId',
        'reserve_price_met': 'reservePriceMet',
        'suggested_bid_amounts': 'suggestedBidAmounts'
    }

    def __init__(self, auction_end_date=None, auction_status=None, bid_count=None, current_price=None, current_proxy_bid=None, high_bidder=None, item_id=None, reserve_price_met=None, suggested_bid_amounts=None):  # noqa: E501
        """Bidding - a model defined in Swagger"""  # noqa: E501
        self._auction_end_date = None
        self._auction_status = None
        self._bid_count = None
        self._current_price = None
        self._current_proxy_bid = None
        self._high_bidder = None
        self._item_id = None
        self._reserve_price_met = None
        self._suggested_bid_amounts = None
        self.discriminator = None
        if auction_end_date is not None:
            self.auction_end_date = auction_end_date
        if auction_status is not None:
            self.auction_status = auction_status
        if bid_count is not None:
            self.bid_count = bid_count
        if current_price is not None:
            self.current_price = current_price
        if current_proxy_bid is not None:
            self.current_proxy_bid = current_proxy_bid
        if high_bidder is not None:
            self.high_bidder = high_bidder
        if item_id is not None:
            self.item_id = item_id
        if reserve_price_met is not None:
            self.reserve_price_met = reserve_price_met
        if suggested_bid_amounts is not None:
            self.suggested_bid_amounts = suggested_bid_amounts

    @property
    def auction_end_date(self):
        """Gets the auction_end_date of this Bidding.  # noqa: E501

        The date the auction will end.  # noqa: E501

        :return: The auction_end_date of this Bidding.  # noqa: E501
        :rtype: str
        """
        return self._auction_end_date

    @auction_end_date.setter
    def auction_end_date(self, auction_end_date):
        """Sets the auction_end_date of this Bidding.

        The date the auction will end.  # noqa: E501

        :param auction_end_date: The auction_end_date of this Bidding.  # noqa: E501
        :type: str
        """

        self._auction_end_date = auction_end_date

    @property
    def auction_status(self):
        """Gets the auction_status of this Bidding.  # noqa: E501

        An enumeration value that represents the current state of the auction, such as ACTIVE or ENDED. If this value is ENDED and the value of highBidder is true, this indicates the buyer has won the auction. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/offer/types/api:AuctionStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The auction_status of this Bidding.  # noqa: E501
        :rtype: str
        """
        return self._auction_status

    @auction_status.setter
    def auction_status(self, auction_status):
        """Sets the auction_status of this Bidding.

        An enumeration value that represents the current state of the auction, such as ACTIVE or ENDED. If this value is ENDED and the value of highBidder is true, this indicates the buyer has won the auction. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/offer/types/api:AuctionStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param auction_status: The auction_status of this Bidding.  # noqa: E501
        :type: str
        """

        self._auction_status = auction_status

    @property
    def bid_count(self):
        """Gets the bid_count of this Bidding.  # noqa: E501

        The number of proxy bids that have been placed for the auction.  # noqa: E501

        :return: The bid_count of this Bidding.  # noqa: E501
        :rtype: int
        """
        return self._bid_count

    @bid_count.setter
    def bid_count(self, bid_count):
        """Sets the bid_count of this Bidding.

        The number of proxy bids that have been placed for the auction.  # noqa: E501

        :param bid_count: The bid_count of this Bidding.  # noqa: E501
        :type: int
        """

        self._bid_count = bid_count

    @property
    def current_price(self):
        """Gets the current_price of this Bidding.  # noqa: E501


        :return: The current_price of this Bidding.  # noqa: E501
        :rtype: Amount
        """
        return self._current_price

    @current_price.setter
    def current_price(self, current_price):
        """Sets the current_price of this Bidding.


        :param current_price: The current_price of this Bidding.  # noqa: E501
        :type: Amount
        """

        self._current_price = current_price

    @property
    def current_proxy_bid(self):
        """Gets the current_proxy_bid of this Bidding.  # noqa: E501


        :return: The current_proxy_bid of this Bidding.  # noqa: E501
        :rtype: ProxyBid
        """
        return self._current_proxy_bid

    @current_proxy_bid.setter
    def current_proxy_bid(self, current_proxy_bid):
        """Sets the current_proxy_bid of this Bidding.


        :param current_proxy_bid: The current_proxy_bid of this Bidding.  # noqa: E501
        :type: ProxyBid
        """

        self._current_proxy_bid = current_proxy_bid

    @property
    def high_bidder(self):
        """Gets the high_bidder of this Bidding.  # noqa: E501

        Indicates if the buyer is the highest bidder. If the value is false, this indicates that either the buyer has not bid on this item or has been out-bid. If this value is true, this indicates the buyer is winning the auction and if the value of auctionStatus is ENDED, this indicates the buyer has won the auction.  # noqa: E501

        :return: The high_bidder of this Bidding.  # noqa: E501
        :rtype: bool
        """
        return self._high_bidder

    @high_bidder.setter
    def high_bidder(self, high_bidder):
        """Sets the high_bidder of this Bidding.

        Indicates if the buyer is the highest bidder. If the value is false, this indicates that either the buyer has not bid on this item or has been out-bid. If this value is true, this indicates the buyer is winning the auction and if the value of auctionStatus is ENDED, this indicates the buyer has won the auction.  # noqa: E501

        :param high_bidder: The high_bidder of this Bidding.  # noqa: E501
        :type: bool
        """

        self._high_bidder = high_bidder

    @property
    def item_id(self):
        """Gets the item_id of this Bidding.  # noqa: E501

        The eBay RESTful identifier of an item being bid on, which was submitted in the request.  # noqa: E501

        :return: The item_id of this Bidding.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this Bidding.

        The eBay RESTful identifier of an item being bid on, which was submitted in the request.  # noqa: E501

        :param item_id: The item_id of this Bidding.  # noqa: E501
        :type: str
        """

        self._item_id = item_id

    @property
    def reserve_price_met(self):
        """Gets the reserve_price_met of this Bidding.  # noqa: E501

        This indicates if the reserve price of the item has been met. A reserve price is set by the seller and is the minimum amount the seller is willing to sell the item for. If the highest bid is not equal to or higher than the reserve price when the auction ends, the listing ends and the item is not sold. Note: This is returned only for auctions that have a reserve price.  # noqa: E501

        :return: The reserve_price_met of this Bidding.  # noqa: E501
        :rtype: bool
        """
        return self._reserve_price_met

    @reserve_price_met.setter
    def reserve_price_met(self, reserve_price_met):
        """Sets the reserve_price_met of this Bidding.

        This indicates if the reserve price of the item has been met. A reserve price is set by the seller and is the minimum amount the seller is willing to sell the item for. If the highest bid is not equal to or higher than the reserve price when the auction ends, the listing ends and the item is not sold. Note: This is returned only for auctions that have a reserve price.  # noqa: E501

        :param reserve_price_met: The reserve_price_met of this Bidding.  # noqa: E501
        :type: bool
        """

        self._reserve_price_met = reserve_price_met

    @property
    def suggested_bid_amounts(self):
        """Gets the suggested_bid_amounts of this Bidding.  # noqa: E501

        The suggested bid amount for the next bid. Note: These are generated suggestions and do not guarantee the buyer will win the bid. This means these suggestions do not take into account the max bid amount of other bidders. The buyer can be outbid even if they submit the highest suggested bid.  # noqa: E501

        :return: The suggested_bid_amounts of this Bidding.  # noqa: E501
        :rtype: list[Amount]
        """
        return self._suggested_bid_amounts

    @suggested_bid_amounts.setter
    def suggested_bid_amounts(self, suggested_bid_amounts):
        """Sets the suggested_bid_amounts of this Bidding.

        The suggested bid amount for the next bid. Note: These are generated suggestions and do not guarantee the buyer will win the bid. This means these suggestions do not take into account the max bid amount of other bidders. The buyer can be outbid even if they submit the highest suggested bid.  # noqa: E501

        :param suggested_bid_amounts: The suggested_bid_amounts of this Bidding.  # noqa: E501
        :type: list[Amount]
        """

        self._suggested_bid_amounts = suggested_bid_amounts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Bidding, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Bidding):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
