# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ...buy_order.api_client import ApiClient


class CheckoutSessionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def apply_coupon(self, checkout_session_id, **kwargs):  # noqa: E501
        """apply_coupon  # noqa: E501

        (Limited Release) You must be whitelisted to use this method. This method adds a coupon to an eBay proxy guest checkout session and applies it to all the eligible items in the order. The checkoutSessionId is passed in as a URI parameter and is required. The redemption code of the coupon is in the payload and is also required. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/{checkoutSessionId}/apply_coupon Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/{checkoutSessionId}/apply_coupon Restrictions Maximum: One coupon per order For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.apply_coupon(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param CouponRequest body: The container for the fields used to apply a coupon to a checkout session.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.apply_coupon_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.apply_coupon_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
            return data

    def apply_coupon_with_http_info(self, checkout_session_id, **kwargs):  # noqa: E501
        """apply_coupon  # noqa: E501

        (Limited Release) You must be whitelisted to use this method. This method adds a coupon to an eBay proxy guest checkout session and applies it to all the eligible items in the order. The checkoutSessionId is passed in as a URI parameter and is required. The redemption code of the coupon is in the payload and is also required. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/{checkoutSessionId}/apply_coupon Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/{checkoutSessionId}/apply_coupon Restrictions Maximum: One coupon per order For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.apply_coupon_with_http_info(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param CouponRequest body: The container for the fields used to apply a coupon to a checkout session.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method apply_coupon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `apply_coupon`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/checkout_session/{checkoutSessionId}/apply_coupon', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_checkout_session(self, checkout_session_id, **kwargs):  # noqa: E501
        """get_checkout_session  # noqa: E501

        This method returns the details of the specified eBay member checkout session. The checkoutSessionId is passed in as a URI parameter and is required. This method has no request payload. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId} Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId} Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checkout_session(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checkout_session_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checkout_session_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
            return data

    def get_checkout_session_with_http_info(self, checkout_session_id, **kwargs):  # noqa: E501
        """get_checkout_session  # noqa: E501

        This method returns the details of the specified eBay member checkout session. The checkoutSessionId is passed in as a URI parameter and is required. This method has no request payload. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId} Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId} Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checkout_session_with_http_info(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['checkout_session_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checkout_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `get_checkout_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/checkout_session/{checkoutSessionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def initiate_checkout_session(self, **kwargs):  # noqa: E501
        """initiate_checkout_session  # noqa: E501

        This method creates an eBay member checkout session, which is the first step in performing a checkout. You use this method to create a checkout session before you can process a checkout. This method assumes (and checks for) a credit card that is saved in the buyer's eBay account. You can use the updatePaymentInfo method to pay with a credit card. If the address submitted cannot be validated, a warning message will be returned. The method returns a checkoutSessionId that you use as a URI parameter in subsequent checkout methods. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/initiate Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/initiate Also see Negative Testing Using Stubs for information on how to emulate error conditions for this method using stubs. Tip: To test the entire checkout flow, you might need a &quot;test&quot; credit card. You can generate a credit card number from http://www.getcreditcardnumbers.com. Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview. Note: Mixed cart: Because they follow different checkout flows, you cannot include eBay managed payments line items and non-eBay managed payments line items in the same checkout session. You will need to create separate sessions for eBay managed payments and non-eBay managed payments. To determine whether or not a listing uses the eBay managed payments checkout flow, use the getItem method of the Browse API and read the eligibleForInlineCheckout flag in the response. A response of true indicates a non-eBay managed payments item. A response of false indicates an eBay-managed payments item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.initiate_checkout_session(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSignInCheckoutSessionRequest body: The container for the fields used by the initiateCheckoutSession method.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.initiate_checkout_session_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.initiate_checkout_session_with_http_info(**kwargs)  # noqa: E501
            return data

    def initiate_checkout_session_with_http_info(self, **kwargs):  # noqa: E501
        """initiate_checkout_session  # noqa: E501

        This method creates an eBay member checkout session, which is the first step in performing a checkout. You use this method to create a checkout session before you can process a checkout. This method assumes (and checks for) a credit card that is saved in the buyer's eBay account. You can use the updatePaymentInfo method to pay with a credit card. If the address submitted cannot be validated, a warning message will be returned. The method returns a checkoutSessionId that you use as a URI parameter in subsequent checkout methods. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/initiate Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/initiate Also see Negative Testing Using Stubs for information on how to emulate error conditions for this method using stubs. Tip: To test the entire checkout flow, you might need a &quot;test&quot; credit card. You can generate a credit card number from http://www.getcreditcardnumbers.com. Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview. Note: Mixed cart: Because they follow different checkout flows, you cannot include eBay managed payments line items and non-eBay managed payments line items in the same checkout session. You will need to create separate sessions for eBay managed payments and non-eBay managed payments. To determine whether or not a listing uses the eBay managed payments checkout flow, use the getItem method of the Browse API and read the eligibleForInlineCheckout flag in the response. A response of true indicates a non-eBay managed payments item. A response of false indicates an eBay-managed payments item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.initiate_checkout_session_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSignInCheckoutSessionRequest body: The container for the fields used by the initiateCheckoutSession method.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method initiate_checkout_session" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/checkout_session/initiate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def place_order(self, checkout_session_id, **kwargs):  # noqa: E501
        """place_order  # noqa: E501

        This method creates the purchase order, pays for the items, and terminates the specified eBay member checkout session. The checkoutSessionId is passed in as a URI parameter and is required. Although there is not a request payload, for this method you must pass in { } in the request body. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/place_order Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/place_order Also see Negative Testing Using Stubs for information on how to emulate error conditions for this method using stubs. Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview. Note: If the credit card is declined, the checkout session is unusable. You will need to create a new checkout session for the order using the initiateCheckoutSession method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.place_order(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. (required)
        :return: PurchaseOrderSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.place_order_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.place_order_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
            return data

    def place_order_with_http_info(self, checkout_session_id, **kwargs):  # noqa: E501
        """place_order  # noqa: E501

        This method creates the purchase order, pays for the items, and terminates the specified eBay member checkout session. The checkoutSessionId is passed in as a URI parameter and is required. Although there is not a request payload, for this method you must pass in { } in the request body. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/place_order Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/place_order Also see Negative Testing Using Stubs for information on how to emulate error conditions for this method using stubs. Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview. Note: If the credit card is declined, the checkout session is unusable. You will need to create a new checkout session for the order using the initiateCheckoutSession method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.place_order_with_http_info(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. (required)
        :return: PurchaseOrderSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['checkout_session_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method place_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `place_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/checkout_session/{checkoutSessionId}/place_order', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PurchaseOrderSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_coupon(self, checkout_session_id, **kwargs):  # noqa: E501
        """remove_coupon  # noqa: E501

        (Limited Release) You must be whitelisted to use this method. This method removes a coupon from an eBay member checkout session. The checkoutSessionId is passed in as a URI parameter and is required. The redemption code of the coupon is specified in the payload and is also required. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/remove_coupon Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/remove_coupon Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_coupon(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param CouponRequest body: The container for the fields used to remove a coupon from a checkout session.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_coupon_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_coupon_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
            return data

    def remove_coupon_with_http_info(self, checkout_session_id, **kwargs):  # noqa: E501
        """remove_coupon  # noqa: E501

        (Limited Release) You must be whitelisted to use this method. This method removes a coupon from an eBay member checkout session. The checkoutSessionId is passed in as a URI parameter and is required. The redemption code of the coupon is specified in the payload and is also required. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/remove_coupon Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/remove_coupon Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_coupon_with_http_info(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param CouponRequest body: The container for the fields used to remove a coupon from a checkout session.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_coupon" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `remove_coupon`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/checkout_session/{checkoutSessionId}/remove_coupon', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_payment_info(self, checkout_session_id, **kwargs):  # noqa: E501
        """update_payment_info  # noqa: E501

        This method changes the payment method information of the specified eBay member checkout session. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_payment_info Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_payment_info Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_payment_info(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param UpdatePaymentInformation body: The container for the fields used by the updatePaymentInfo method.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_payment_info_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_payment_info_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
            return data

    def update_payment_info_with_http_info(self, checkout_session_id, **kwargs):  # noqa: E501
        """update_payment_info  # noqa: E501

        This method changes the payment method information of the specified eBay member checkout session. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_payment_info Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_payment_info Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_payment_info_with_http_info(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param UpdatePaymentInformation body: The container for the fields used by the updatePaymentInfo method.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_payment_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `update_payment_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/checkout_session/{checkoutSessionId}/update_payment_info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_quantity(self, checkout_session_id, **kwargs):  # noqa: E501
        """update_quantity  # noqa: E501

        This method changes the quantity of the specified line item in an eBay member checkout session. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_quantity Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_quantity Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_quantity(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param UpdateQuantity body: The container for the fields used by the updateQuantity method.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_quantity_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_quantity_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
            return data

    def update_quantity_with_http_info(self, checkout_session_id, **kwargs):  # noqa: E501
        """update_quantity  # noqa: E501

        This method changes the quantity of the specified line item in an eBay member checkout session. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_quantity Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_quantity Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_quantity_with_http_info(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param UpdateQuantity body: The container for the fields used by the updateQuantity method.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_quantity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `update_quantity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/checkout_session/{checkoutSessionId}/update_quantity', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_shipping_address(self, checkout_session_id, **kwargs):  # noqa: E501
        """update_shipping_address  # noqa: E501

        This method changes the shipping address for in an eBay member checkout session. All the line items in an order must be shipped to the same address, but the shipping method can be specific to the line item. Note: If the address submitted cannot be validated, a warning message will be returned. This does not prevent the method from executing, but you may want to verify the address. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_shipping_address Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_shipping_address Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shipping_address(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param ShippingAddressImpl body: The container for the fields used by the updateShippingAddress method.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_shipping_address_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_shipping_address_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
            return data

    def update_shipping_address_with_http_info(self, checkout_session_id, **kwargs):  # noqa: E501
        """update_shipping_address  # noqa: E501

        This method changes the shipping address for in an eBay member checkout session. All the line items in an order must be shipped to the same address, but the shipping method can be specific to the line item. Note: If the address submitted cannot be validated, a warning message will be returned. This does not prevent the method from executing, but you may want to verify the address. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_shipping_address Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_shipping_address Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shipping_address_with_http_info(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned session ID, for a specific eBay marketplace, that is returned by the initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param ShippingAddressImpl body: The container for the fields used by the updateShippingAddress method.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_shipping_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `update_shipping_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/checkout_session/{checkoutSessionId}/update_shipping_address', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_shipping_option(self, checkout_session_id, **kwargs):  # noqa: E501
        """update_shipping_option  # noqa: E501

        This method changes the shipping method for the specified line item in an eBay member checkout session. The shipping option can be set for each line item. This gives the shopper the ability choose the cost of shipping for each line item. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_shipping_option Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_shipping_option Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shipping_option(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned checkout session ID, for a specific eBay marketplace, that is returned by initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param UpdateShippingOption body: The container for the fields used by the updateShippingOption method.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_shipping_option_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_shipping_option_with_http_info(checkout_session_id, **kwargs)  # noqa: E501
            return data

    def update_shipping_option_with_http_info(self, checkout_session_id, **kwargs):  # noqa: E501
        """update_shipping_option  # noqa: E501

        This method changes the shipping method for the specified line item in an eBay member checkout session. The shipping option can be set for each line item. This gives the shopper the ability choose the cost of shipping for each line item. The URLs for this method are: Production URL: https://apix.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_shipping_option Sandbox URL: https://apix.sandbox.ebay.com/buy/order/v1/checkout_session/{checkoutSessionId}/update_shipping_option Restrictions For a list of supported sites and other restrictions, see API Restrictions in the Order API overview.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shipping_option_with_http_info(checkout_session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checkout_session_id: The eBay-assigned checkout session ID, for a specific eBay marketplace, that is returned by initiateCheckoutSession method. Note: When using this ID, the X-EBAY-C-MARKETPLACE-ID value and developer App ID must be the same as what was used when this checkout session was created. See Checkout session restrictions in the Buy Integration Guide. (required)
        :param UpdateShippingOption body: The container for the fields used by the updateShippingOption method.
        :return: CheckoutSessionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['checkout_session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_shipping_option" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'checkout_session_id' is set
        if ('checkout_session_id' not in params or
                params['checkout_session_id'] is None):
            raise ValueError("Missing the required parameter `checkout_session_id` when calling `update_shipping_option`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'checkout_session_id' in params:
            path_params['checkoutSessionId'] = params['checkout_session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/checkout_session/{checkoutSessionId}/update_shipping_option', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckoutSessionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
