# coding: utf-8

# flake8: noqa
"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# import models into model package
from ...buy_order.models.adjustment import Adjustment
from ...buy_order.models.amount import Amount
from ...buy_order.models.authenticity_verification_program import AuthenticityVerificationProgram
from ...buy_order.models.billing_address import BillingAddress
from ...buy_order.models.checkout_session_request_without_payment import CheckoutSessionRequestWithoutPayment
from ...buy_order.models.checkout_session_response import CheckoutSessionResponse
from ...buy_order.models.coupon import Coupon
from ...buy_order.models.coupon_request import CouponRequest
from ...buy_order.models.create_guest_checkout_session_request import CreateGuestCheckoutSessionRequest
from ...buy_order.models.create_sign_in_checkout_session_request import CreateSignInCheckoutSessionRequest
from ...buy_order.models.credit_card import CreditCard
from ...buy_order.models.error import Error
from ...buy_order.models.error_parameter import ErrorParameter
from ...buy_order.models.event_location import EventLocation
from ...buy_order.models.fee import Fee
from ...buy_order.models.guest_checkout_session_response import GuestCheckoutSessionResponse
from ...buy_order.models.guest_place_order_request import GuestPlaceOrderRequest
from ...buy_order.models.guest_purchase_order import GuestPurchaseOrder
from ...buy_order.models.image import Image
from ...buy_order.models.import_tax import ImportTax
from ...buy_order.models.initiate_payment_request import InitiatePaymentRequest
from ...buy_order.models.legacy_reference import LegacyReference
from ...buy_order.models.line_item import LineItem
from ...buy_order.models.line_item_input import LineItemInput
from ...buy_order.models.line_item_reference import LineItemReference
from ...buy_order.models.marketing_message import MarketingMessage
from ...buy_order.models.marketing_terms import MarketingTerms
from ...buy_order.models.order_line_item import OrderLineItem
from ...buy_order.models.payment_instrument import PaymentInstrument
from ...buy_order.models.payment_instrument_reference import PaymentInstrumentReference
from ...buy_order.models.payment_method import PaymentMethod
from ...buy_order.models.payment_method_brand import PaymentMethodBrand
from ...buy_order.models.payment_method_message import PaymentMethodMessage
from ...buy_order.models.pricing_summary import PricingSummary
from ...buy_order.models.promotion import Promotion
from ...buy_order.models.provided_payment_instrument import ProvidedPaymentInstrument
from ...buy_order.models.purchase_order import PurchaseOrder
from ...buy_order.models.purchase_order_summary import PurchaseOrderSummary
from ...buy_order.models.region import Region
from ...buy_order.models.seller import Seller
from ...buy_order.models.shipment_tracking_events import ShipmentTrackingEvents
from ...buy_order.models.shipping_address import ShippingAddress
from ...buy_order.models.shipping_address_impl import ShippingAddressImpl
from ...buy_order.models.shipping_detail import ShippingDetail
from ...buy_order.models.shipping_fulfillment import ShippingFulfillment
from ...buy_order.models.shipping_option import ShippingOption
from ...buy_order.models.tax_detail import TaxDetail
from ...buy_order.models.tax_jurisdiction import TaxJurisdiction
from ...buy_order.models.update_payment_information import UpdatePaymentInformation
from ...buy_order.models.update_quantity import UpdateQuantity
from ...buy_order.models.update_shipping_option import UpdateShippingOption
from ...buy_order.models.wallet import Wallet
