# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AuthenticityVerificationProgram(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'outcome_reason': 'str',
        'status': 'str',
        'terms_web_url': 'str'
    }

    attribute_map = {
        'description': 'description',
        'outcome_reason': 'outcomeReason',
        'status': 'status',
        'terms_web_url': 'termsWebUrl'
    }

    def __init__(self, description=None, outcome_reason=None, status=None, terms_web_url=None):  # noqa: E501
        """AuthenticityVerificationProgram - a model defined in Swagger"""  # noqa: E501
        self._description = None
        self._outcome_reason = None
        self._status = None
        self._terms_web_url = None
        self.discriminator = None
        if description is not None:
            self.description = description
        if outcome_reason is not None:
            self.outcome_reason = outcome_reason
        if status is not None:
            self.status = status
        if terms_web_url is not None:
            self.terms_web_url = terms_web_url

    @property
    def description(self):
        """Gets the description of this AuthenticityVerificationProgram.  # noqa: E501

        An informational message that applies to the Authenticity Guarantee program.  # noqa: E501

        :return: The description of this AuthenticityVerificationProgram.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AuthenticityVerificationProgram.

        An informational message that applies to the Authenticity Guarantee program.  # noqa: E501

        :param description: The description of this AuthenticityVerificationProgram.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def outcome_reason(self):
        """Gets the outcome_reason of this AuthenticityVerificationProgram.  # noqa: E501

        An informational message regarding the authentication outcome of an authenticity verification inspection. Note: This field is conditionally returned when there is information that applies to the Authenticity Guarantee program.  # noqa: E501

        :return: The outcome_reason of this AuthenticityVerificationProgram.  # noqa: E501
        :rtype: str
        """
        return self._outcome_reason

    @outcome_reason.setter
    def outcome_reason(self, outcome_reason):
        """Sets the outcome_reason of this AuthenticityVerificationProgram.

        An informational message regarding the authentication outcome of an authenticity verification inspection. Note: This field is conditionally returned when there is information that applies to the Authenticity Guarantee program.  # noqa: E501

        :param outcome_reason: The outcome_reason of this AuthenticityVerificationProgram.  # noqa: E501
        :type: str
        """

        self._outcome_reason = outcome_reason

    @property
    def status(self):
        """Gets the status of this AuthenticityVerificationProgram.  # noqa: E501

        The value in this field indicates whether the order line item has passed or failed the authenticity verification inspection, or if the inspection and/or results are still pending. The possible values returned here are PENDING, PASSED, FAILED, or INELIGIBLE. Note: This field is conditionally returned when purchase is complete. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:AuthenticityVerificationStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The status of this AuthenticityVerificationProgram.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this AuthenticityVerificationProgram.

        The value in this field indicates whether the order line item has passed or failed the authenticity verification inspection, or if the inspection and/or results are still pending. The possible values returned here are PENDING, PASSED, FAILED, or INELIGIBLE. Note: This field is conditionally returned when purchase is complete. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:AuthenticityVerificationStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param status: The status of this AuthenticityVerificationProgram.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def terms_web_url(self):
        """Gets the terms_web_url of this AuthenticityVerificationProgram.  # noqa: E501

        The terms and conditions that apply to the Authenticity Guarantee program.  # noqa: E501

        :return: The terms_web_url of this AuthenticityVerificationProgram.  # noqa: E501
        :rtype: str
        """
        return self._terms_web_url

    @terms_web_url.setter
    def terms_web_url(self, terms_web_url):
        """Sets the terms_web_url of this AuthenticityVerificationProgram.

        The terms and conditions that apply to the Authenticity Guarantee program.  # noqa: E501

        :param terms_web_url: The terms_web_url of this AuthenticityVerificationProgram.  # noqa: E501
        :type: str
        """

        self._terms_web_url = terms_web_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AuthenticityVerificationProgram, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuthenticityVerificationProgram):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
