# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CreateGuestCheckoutSessionRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'contact_email': 'str',
        'contact_first_name': 'str',
        'contact_last_name': 'str',
        'credit_card': 'CreditCard',
        'line_item_inputs': 'list[LineItemInput]',
        'shipping_address': 'ShippingAddress'
    }

    attribute_map = {
        'contact_email': 'contactEmail',
        'contact_first_name': 'contactFirstName',
        'contact_last_name': 'contactLastName',
        'credit_card': 'creditCard',
        'line_item_inputs': 'lineItemInputs',
        'shipping_address': 'shippingAddress'
    }

    def __init__(self, contact_email=None, contact_first_name=None, contact_last_name=None, credit_card=None, line_item_inputs=None, shipping_address=None):  # noqa: E501
        """CreateGuestCheckoutSessionRequest - a model defined in Swagger"""  # noqa: E501
        self._contact_email = None
        self._contact_first_name = None
        self._contact_last_name = None
        self._credit_card = None
        self._line_item_inputs = None
        self._shipping_address = None
        self.discriminator = None
        if contact_email is not None:
            self.contact_email = contact_email
        if contact_first_name is not None:
            self.contact_first_name = contact_first_name
        if contact_last_name is not None:
            self.contact_last_name = contact_last_name
        if credit_card is not None:
            self.credit_card = credit_card
        if line_item_inputs is not None:
            self.line_item_inputs = line_item_inputs
        if shipping_address is not None:
            self.shipping_address = shipping_address

    @property
    def contact_email(self):
        """Gets the contact_email of this CreateGuestCheckoutSessionRequest.  # noqa: E501

        The buyer's email address.  # noqa: E501

        :return: The contact_email of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :rtype: str
        """
        return self._contact_email

    @contact_email.setter
    def contact_email(self, contact_email):
        """Sets the contact_email of this CreateGuestCheckoutSessionRequest.

        The buyer's email address.  # noqa: E501

        :param contact_email: The contact_email of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :type: str
        """

        self._contact_email = contact_email

    @property
    def contact_first_name(self):
        """Gets the contact_first_name of this CreateGuestCheckoutSessionRequest.  # noqa: E501

        The buyer's first name.  # noqa: E501

        :return: The contact_first_name of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :rtype: str
        """
        return self._contact_first_name

    @contact_first_name.setter
    def contact_first_name(self, contact_first_name):
        """Sets the contact_first_name of this CreateGuestCheckoutSessionRequest.

        The buyer's first name.  # noqa: E501

        :param contact_first_name: The contact_first_name of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :type: str
        """

        self._contact_first_name = contact_first_name

    @property
    def contact_last_name(self):
        """Gets the contact_last_name of this CreateGuestCheckoutSessionRequest.  # noqa: E501

        The buyer's last name.  # noqa: E501

        :return: The contact_last_name of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :rtype: str
        """
        return self._contact_last_name

    @contact_last_name.setter
    def contact_last_name(self, contact_last_name):
        """Sets the contact_last_name of this CreateGuestCheckoutSessionRequest.

        The buyer's last name.  # noqa: E501

        :param contact_last_name: The contact_last_name of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :type: str
        """

        self._contact_last_name = contact_last_name

    @property
    def credit_card(self):
        """Gets the credit_card of this CreateGuestCheckoutSessionRequest.  # noqa: E501


        :return: The credit_card of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :rtype: CreditCard
        """
        return self._credit_card

    @credit_card.setter
    def credit_card(self, credit_card):
        """Sets the credit_card of this CreateGuestCheckoutSessionRequest.


        :param credit_card: The credit_card of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :type: CreditCard
        """

        self._credit_card = credit_card

    @property
    def line_item_inputs(self):
        """Gets the line_item_inputs of this CreateGuestCheckoutSessionRequest.  # noqa: E501

        The type that defines the fields for a line item in an eBay guest checkout session. Maximum number of line items: 10  # noqa: E501

        :return: The line_item_inputs of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :rtype: list[LineItemInput]
        """
        return self._line_item_inputs

    @line_item_inputs.setter
    def line_item_inputs(self, line_item_inputs):
        """Sets the line_item_inputs of this CreateGuestCheckoutSessionRequest.

        The type that defines the fields for a line item in an eBay guest checkout session. Maximum number of line items: 10  # noqa: E501

        :param line_item_inputs: The line_item_inputs of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :type: list[LineItemInput]
        """

        self._line_item_inputs = line_item_inputs

    @property
    def shipping_address(self):
        """Gets the shipping_address of this CreateGuestCheckoutSessionRequest.  # noqa: E501


        :return: The shipping_address of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :rtype: ShippingAddress
        """
        return self._shipping_address

    @shipping_address.setter
    def shipping_address(self, shipping_address):
        """Sets the shipping_address of this CreateGuestCheckoutSessionRequest.


        :param shipping_address: The shipping_address of this CreateGuestCheckoutSessionRequest.  # noqa: E501
        :type: ShippingAddress
        """

        self._shipping_address = shipping_address

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateGuestCheckoutSessionRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateGuestCheckoutSessionRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
