# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CreditCard(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'account_holder_name': 'str',
        'billing_address': 'BillingAddress',
        'brand': 'str',
        'card_number': 'str',
        'cvv_number': 'str',
        'expire_month': 'int',
        'expire_year': 'int'
    }

    attribute_map = {
        'account_holder_name': 'accountHolderName',
        'billing_address': 'billingAddress',
        'brand': 'brand',
        'card_number': 'cardNumber',
        'cvv_number': 'cvvNumber',
        'expire_month': 'expireMonth',
        'expire_year': 'expireYear'
    }

    def __init__(self, account_holder_name=None, billing_address=None, brand=None, card_number=None, cvv_number=None, expire_month=None, expire_year=None):  # noqa: E501
        """CreditCard - a model defined in Swagger"""  # noqa: E501
        self._account_holder_name = None
        self._billing_address = None
        self._brand = None
        self._card_number = None
        self._cvv_number = None
        self._expire_month = None
        self._expire_year = None
        self.discriminator = None
        if account_holder_name is not None:
            self.account_holder_name = account_holder_name
        if billing_address is not None:
            self.billing_address = billing_address
        if brand is not None:
            self.brand = brand
        if card_number is not None:
            self.card_number = card_number
        if cvv_number is not None:
            self.cvv_number = cvv_number
        if expire_month is not None:
            self.expire_month = expire_month
        if expire_year is not None:
            self.expire_year = expire_year

    @property
    def account_holder_name(self):
        """Gets the account_holder_name of this CreditCard.  # noqa: E501

        The name of the card holder under which the credit card was issued.  # noqa: E501

        :return: The account_holder_name of this CreditCard.  # noqa: E501
        :rtype: str
        """
        return self._account_holder_name

    @account_holder_name.setter
    def account_holder_name(self, account_holder_name):
        """Sets the account_holder_name of this CreditCard.

        The name of the card holder under which the credit card was issued.  # noqa: E501

        :param account_holder_name: The account_holder_name of this CreditCard.  # noqa: E501
        :type: str
        """

        self._account_holder_name = account_holder_name

    @property
    def billing_address(self):
        """Gets the billing_address of this CreditCard.  # noqa: E501


        :return: The billing_address of this CreditCard.  # noqa: E501
        :rtype: BillingAddress
        """
        return self._billing_address

    @billing_address.setter
    def billing_address(self, billing_address):
        """Sets the billing_address of this CreditCard.


        :param billing_address: The billing_address of this CreditCard.  # noqa: E501
        :type: BillingAddress
        """

        self._billing_address = billing_address

    @property
    def brand(self):
        """Gets the brand of this CreditCard.  # noqa: E501

        The type of the credit card, such as Visa or MasterCard.  # noqa: E501

        :return: The brand of this CreditCard.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this CreditCard.

        The type of the credit card, such as Visa or MasterCard.  # noqa: E501

        :param brand: The brand of this CreditCard.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def card_number(self):
        """Gets the card_number of this CreditCard.  # noqa: E501

        The credit card number on the card.  # noqa: E501

        :return: The card_number of this CreditCard.  # noqa: E501
        :rtype: str
        """
        return self._card_number

    @card_number.setter
    def card_number(self, card_number):
        """Sets the card_number of this CreditCard.

        The credit card number on the card.  # noqa: E501

        :param card_number: The card_number of this CreditCard.  # noqa: E501
        :type: str
        """

        self._card_number = card_number

    @property
    def cvv_number(self):
        """Gets the cvv_number of this CreditCard.  # noqa: E501

        The Card Verification Value of the credit card. This value is also known as the card verification code (CVC) or card security code (CSC). This is a three-digit number on VISA, MasterCard, and Discover branded credit and debit cards. On American Express branded cards, this is a four-digit numeric code. Note: This number is not the PIN associated with the card.  # noqa: E501

        :return: The cvv_number of this CreditCard.  # noqa: E501
        :rtype: str
        """
        return self._cvv_number

    @cvv_number.setter
    def cvv_number(self, cvv_number):
        """Sets the cvv_number of this CreditCard.

        The Card Verification Value of the credit card. This value is also known as the card verification code (CVC) or card security code (CSC). This is a three-digit number on VISA, MasterCard, and Discover branded credit and debit cards. On American Express branded cards, this is a four-digit numeric code. Note: This number is not the PIN associated with the card.  # noqa: E501

        :param cvv_number: The cvv_number of this CreditCard.  # noqa: E501
        :type: str
        """

        self._cvv_number = cvv_number

    @property
    def expire_month(self):
        """Gets the expire_month of this CreditCard.  # noqa: E501

        The month the credit card expires.  # noqa: E501

        :return: The expire_month of this CreditCard.  # noqa: E501
        :rtype: int
        """
        return self._expire_month

    @expire_month.setter
    def expire_month(self, expire_month):
        """Sets the expire_month of this CreditCard.

        The month the credit card expires.  # noqa: E501

        :param expire_month: The expire_month of this CreditCard.  # noqa: E501
        :type: int
        """

        self._expire_month = expire_month

    @property
    def expire_year(self):
        """Gets the expire_year of this CreditCard.  # noqa: E501

        The year the credit card expires.  # noqa: E501

        :return: The expire_year of this CreditCard.  # noqa: E501
        :rtype: int
        """
        return self._expire_year

    @expire_year.setter
    def expire_year(self, expire_year):
        """Sets the expire_year of this CreditCard.

        The year the credit card expires.  # noqa: E501

        :param expire_year: The expire_year of this CreditCard.  # noqa: E501
        :type: int
        """

        self._expire_year = expire_year

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreditCard, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreditCard):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
