# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GuestCheckoutSessionResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'accepted_payment_methods': 'list[PaymentMethod]',
        'applied_coupons': 'list[Coupon]',
        'checkout_session_id': 'str',
        'expiration_date': 'str',
        'line_items': 'list[LineItem]',
        'marketing_messages': 'list[MarketingMessage]',
        'pricing_summary': 'PricingSummary',
        'provided_payment_instrument': 'ProvidedPaymentInstrument',
        'shipping_address': 'ShippingAddress',
        'warnings': 'list[Error]'
    }

    attribute_map = {
        'accepted_payment_methods': 'acceptedPaymentMethods',
        'applied_coupons': 'appliedCoupons',
        'checkout_session_id': 'checkoutSessionId',
        'expiration_date': 'expirationDate',
        'line_items': 'lineItems',
        'marketing_messages': 'marketingMessages',
        'pricing_summary': 'pricingSummary',
        'provided_payment_instrument': 'providedPaymentInstrument',
        'shipping_address': 'shippingAddress',
        'warnings': 'warnings'
    }

    def __init__(self, accepted_payment_methods=None, applied_coupons=None, checkout_session_id=None, expiration_date=None, line_items=None, marketing_messages=None, pricing_summary=None, provided_payment_instrument=None, shipping_address=None, warnings=None):  # noqa: E501
        """GuestCheckoutSessionResponse - a model defined in Swagger"""  # noqa: E501
        self._accepted_payment_methods = None
        self._applied_coupons = None
        self._checkout_session_id = None
        self._expiration_date = None
        self._line_items = None
        self._marketing_messages = None
        self._pricing_summary = None
        self._provided_payment_instrument = None
        self._shipping_address = None
        self._warnings = None
        self.discriminator = None
        if accepted_payment_methods is not None:
            self.accepted_payment_methods = accepted_payment_methods
        if applied_coupons is not None:
            self.applied_coupons = applied_coupons
        if checkout_session_id is not None:
            self.checkout_session_id = checkout_session_id
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if line_items is not None:
            self.line_items = line_items
        if marketing_messages is not None:
            self.marketing_messages = marketing_messages
        if pricing_summary is not None:
            self.pricing_summary = pricing_summary
        if provided_payment_instrument is not None:
            self.provided_payment_instrument = provided_payment_instrument
        if shipping_address is not None:
            self.shipping_address = shipping_address
        if warnings is not None:
            self.warnings = warnings

    @property
    def accepted_payment_methods(self):
        """Gets the accepted_payment_methods of this GuestCheckoutSessionResponse.  # noqa: E501

        The container that returns the payment methods that can be used to purchase the items.  # noqa: E501

        :return: The accepted_payment_methods of this GuestCheckoutSessionResponse.  # noqa: E501
        :rtype: list[PaymentMethod]
        """
        return self._accepted_payment_methods

    @accepted_payment_methods.setter
    def accepted_payment_methods(self, accepted_payment_methods):
        """Sets the accepted_payment_methods of this GuestCheckoutSessionResponse.

        The container that returns the payment methods that can be used to purchase the items.  # noqa: E501

        :param accepted_payment_methods: The accepted_payment_methods of this GuestCheckoutSessionResponse.  # noqa: E501
        :type: list[PaymentMethod]
        """

        self._accepted_payment_methods = accepted_payment_methods

    @property
    def applied_coupons(self):
        """Gets the applied_coupons of this GuestCheckoutSessionResponse.  # noqa: E501

        The container that returns the information for the coupons that were applied in the checkout session.  # noqa: E501

        :return: The applied_coupons of this GuestCheckoutSessionResponse.  # noqa: E501
        :rtype: list[Coupon]
        """
        return self._applied_coupons

    @applied_coupons.setter
    def applied_coupons(self, applied_coupons):
        """Sets the applied_coupons of this GuestCheckoutSessionResponse.

        The container that returns the information for the coupons that were applied in the checkout session.  # noqa: E501

        :param applied_coupons: The applied_coupons of this GuestCheckoutSessionResponse.  # noqa: E501
        :type: list[Coupon]
        """

        self._applied_coupons = applied_coupons

    @property
    def checkout_session_id(self):
        """Gets the checkout_session_id of this GuestCheckoutSessionResponse.  # noqa: E501

        The checkoutSessionId submitted in the request.  # noqa: E501

        :return: The checkout_session_id of this GuestCheckoutSessionResponse.  # noqa: E501
        :rtype: str
        """
        return self._checkout_session_id

    @checkout_session_id.setter
    def checkout_session_id(self, checkout_session_id):
        """Sets the checkout_session_id of this GuestCheckoutSessionResponse.

        The checkoutSessionId submitted in the request.  # noqa: E501

        :param checkout_session_id: The checkout_session_id of this GuestCheckoutSessionResponse.  # noqa: E501
        :type: str
        """

        self._checkout_session_id = checkout_session_id

    @property
    def expiration_date(self):
        """Gets the expiration_date of this GuestCheckoutSessionResponse.  # noqa: E501

        The time the checkout session will end. To purchase the items the order must be placed before this time.  # noqa: E501

        :return: The expiration_date of this GuestCheckoutSessionResponse.  # noqa: E501
        :rtype: str
        """
        return self._expiration_date

    @expiration_date.setter
    def expiration_date(self, expiration_date):
        """Sets the expiration_date of this GuestCheckoutSessionResponse.

        The time the checkout session will end. To purchase the items the order must be placed before this time.  # noqa: E501

        :param expiration_date: The expiration_date of this GuestCheckoutSessionResponse.  # noqa: E501
        :type: str
        """

        self._expiration_date = expiration_date

    @property
    def line_items(self):
        """Gets the line_items of this GuestCheckoutSessionResponse.  # noqa: E501

        An array of line items associated with the checkout session.  # noqa: E501

        :return: The line_items of this GuestCheckoutSessionResponse.  # noqa: E501
        :rtype: list[LineItem]
        """
        return self._line_items

    @line_items.setter
    def line_items(self, line_items):
        """Sets the line_items of this GuestCheckoutSessionResponse.

        An array of line items associated with the checkout session.  # noqa: E501

        :param line_items: The line_items of this GuestCheckoutSessionResponse.  # noqa: E501
        :type: list[LineItem]
        """

        self._line_items = line_items

    @property
    def marketing_messages(self):
        """Gets the marketing_messages of this GuestCheckoutSessionResponse.  # noqa: E501

        The container that returns the marketing consent fields. These fields show the legal marketing consent message that is to be shown to the buyer when they place the order, and the marketing channels, for example email, and marketing types, for example promotions, the buyer can choose to receive.  # noqa: E501

        :return: The marketing_messages of this GuestCheckoutSessionResponse.  # noqa: E501
        :rtype: list[MarketingMessage]
        """
        return self._marketing_messages

    @marketing_messages.setter
    def marketing_messages(self, marketing_messages):
        """Sets the marketing_messages of this GuestCheckoutSessionResponse.

        The container that returns the marketing consent fields. These fields show the legal marketing consent message that is to be shown to the buyer when they place the order, and the marketing channels, for example email, and marketing types, for example promotions, the buyer can choose to receive.  # noqa: E501

        :param marketing_messages: The marketing_messages of this GuestCheckoutSessionResponse.  # noqa: E501
        :type: list[MarketingMessage]
        """

        self._marketing_messages = marketing_messages

    @property
    def pricing_summary(self):
        """Gets the pricing_summary of this GuestCheckoutSessionResponse.  # noqa: E501


        :return: The pricing_summary of this GuestCheckoutSessionResponse.  # noqa: E501
        :rtype: PricingSummary
        """
        return self._pricing_summary

    @pricing_summary.setter
    def pricing_summary(self, pricing_summary):
        """Sets the pricing_summary of this GuestCheckoutSessionResponse.


        :param pricing_summary: The pricing_summary of this GuestCheckoutSessionResponse.  # noqa: E501
        :type: PricingSummary
        """

        self._pricing_summary = pricing_summary

    @property
    def provided_payment_instrument(self):
        """Gets the provided_payment_instrument of this GuestCheckoutSessionResponse.  # noqa: E501


        :return: The provided_payment_instrument of this GuestCheckoutSessionResponse.  # noqa: E501
        :rtype: ProvidedPaymentInstrument
        """
        return self._provided_payment_instrument

    @provided_payment_instrument.setter
    def provided_payment_instrument(self, provided_payment_instrument):
        """Sets the provided_payment_instrument of this GuestCheckoutSessionResponse.


        :param provided_payment_instrument: The provided_payment_instrument of this GuestCheckoutSessionResponse.  # noqa: E501
        :type: ProvidedPaymentInstrument
        """

        self._provided_payment_instrument = provided_payment_instrument

    @property
    def shipping_address(self):
        """Gets the shipping_address of this GuestCheckoutSessionResponse.  # noqa: E501


        :return: The shipping_address of this GuestCheckoutSessionResponse.  # noqa: E501
        :rtype: ShippingAddress
        """
        return self._shipping_address

    @shipping_address.setter
    def shipping_address(self, shipping_address):
        """Sets the shipping_address of this GuestCheckoutSessionResponse.


        :param shipping_address: The shipping_address of this GuestCheckoutSessionResponse.  # noqa: E501
        :type: ShippingAddress
        """

        self._shipping_address = shipping_address

    @property
    def warnings(self):
        """Gets the warnings of this GuestCheckoutSessionResponse.  # noqa: E501

        An array of any process errors or warnings that were generated during the method processing.  # noqa: E501

        :return: The warnings of this GuestCheckoutSessionResponse.  # noqa: E501
        :rtype: list[Error]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this GuestCheckoutSessionResponse.

        An array of any process errors or warnings that were generated during the method processing.  # noqa: E501

        :param warnings: The warnings of this GuestCheckoutSessionResponse.  # noqa: E501
        :type: list[Error]
        """

        self._warnings = warnings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GuestCheckoutSessionResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GuestCheckoutSessionResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
