# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class LegacyReference(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'legacy_item_id': 'str',
        'legacy_order_id': 'str',
        'legacy_transaction_id': 'str'
    }

    attribute_map = {
        'legacy_item_id': 'legacyItemId',
        'legacy_order_id': 'legacyOrderId',
        'legacy_transaction_id': 'legacyTransactionId'
    }

    def __init__(self, legacy_item_id=None, legacy_order_id=None, legacy_transaction_id=None):  # noqa: E501
        """LegacyReference - a model defined in Swagger"""  # noqa: E501
        self._legacy_item_id = None
        self._legacy_order_id = None
        self._legacy_transaction_id = None
        self.discriminator = None
        if legacy_item_id is not None:
            self.legacy_item_id = legacy_item_id
        if legacy_order_id is not None:
            self.legacy_order_id = legacy_order_id
        if legacy_transaction_id is not None:
            self.legacy_transaction_id = legacy_transaction_id

    @property
    def legacy_item_id(self):
        """Gets the legacy_item_id of this LegacyReference.  # noqa: E501

        The legacy ID used to identify an item. This is used by the Post Order API Create Return Request method. This call initiates the item return process. For more information on how to use this field in the Post Order API, see Create a return request in the Buy Integration Guide. Restriction: The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :return: The legacy_item_id of this LegacyReference.  # noqa: E501
        :rtype: str
        """
        return self._legacy_item_id

    @legacy_item_id.setter
    def legacy_item_id(self, legacy_item_id):
        """Sets the legacy_item_id of this LegacyReference.

        The legacy ID used to identify an item. This is used by the Post Order API Create Return Request method. This call initiates the item return process. For more information on how to use this field in the Post Order API, see Create a return request in the Buy Integration Guide. Restriction: The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :param legacy_item_id: The legacy_item_id of this LegacyReference.  # noqa: E501
        :type: str
        """

        self._legacy_item_id = legacy_item_id

    @property
    def legacy_order_id(self):
        """Gets the legacy_order_id of this LegacyReference.  # noqa: E501

        The legacy ID of the order. This is used by the Post Order API Submit Cancellation Request method. This method initiates the item cancellation process. For more information on how to use this field in the Post Order API, see Using the Post Order API. Restriction: The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :return: The legacy_order_id of this LegacyReference.  # noqa: E501
        :rtype: str
        """
        return self._legacy_order_id

    @legacy_order_id.setter
    def legacy_order_id(self, legacy_order_id):
        """Sets the legacy_order_id of this LegacyReference.

        The legacy ID of the order. This is used by the Post Order API Submit Cancellation Request method. This method initiates the item cancellation process. For more information on how to use this field in the Post Order API, see Using the Post Order API. Restriction: The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :param legacy_order_id: The legacy_order_id of this LegacyReference.  # noqa: E501
        :type: str
        """

        self._legacy_order_id = legacy_order_id

    @property
    def legacy_transaction_id(self):
        """Gets the legacy_transaction_id of this LegacyReference.  # noqa: E501

        The legacy ID of the transaction. This is used by the Post Order API Create Return Request call. This call initiates the item return process. For more information on how to use this field in the Post Order API, see Using the Post Order API in the Buy Integration Guide. Restriction: The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :return: The legacy_transaction_id of this LegacyReference.  # noqa: E501
        :rtype: str
        """
        return self._legacy_transaction_id

    @legacy_transaction_id.setter
    def legacy_transaction_id(self, legacy_transaction_id):
        """Sets the legacy_transaction_id of this LegacyReference.

        The legacy ID of the transaction. This is used by the Post Order API Create Return Request call. This call initiates the item return process. For more information on how to use this field in the Post Order API, see Using the Post Order API in the Buy Integration Guide. Restriction: The Post Order API can be used only with eBay member checkouts.  # noqa: E501

        :param legacy_transaction_id: The legacy_transaction_id of this LegacyReference.  # noqa: E501
        :type: str
        """

        self._legacy_transaction_id = legacy_transaction_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LegacyReference, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LegacyReference):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
