# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class MarketingMessage(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'legal_message': 'str',
        'marketing_channels': 'list[str]',
        'marketing_types': 'list[str]'
    }

    attribute_map = {
        'legal_message': 'legalMessage',
        'marketing_channels': 'marketingChannels',
        'marketing_types': 'marketingTypes'
    }

    def __init__(self, legal_message=None, marketing_channels=None, marketing_types=None):  # noqa: E501
        """MarketingMessage - a model defined in Swagger"""  # noqa: E501
        self._legal_message = None
        self._marketing_channels = None
        self._marketing_types = None
        self.discriminator = None
        if legal_message is not None:
            self.legal_message = legal_message
        if marketing_channels is not None:
            self.marketing_channels = marketing_channels
        if marketing_types is not None:
            self.marketing_types = marketing_types

    @property
    def legal_message(self):
        """Gets the legal_message of this MarketingMessage.  # noqa: E501

        This field returns the following legal marketing consent message. This message is to be shown to the buyer when they place the order. I agree to receive marketing offers, promotions, and surveys from eBay through emails.  # noqa: E501

        :return: The legal_message of this MarketingMessage.  # noqa: E501
        :rtype: str
        """
        return self._legal_message

    @legal_message.setter
    def legal_message(self, legal_message):
        """Sets the legal_message of this MarketingMessage.

        This field returns the following legal marketing consent message. This message is to be shown to the buyer when they place the order. I agree to receive marketing offers, promotions, and surveys from eBay through emails.  # noqa: E501

        :param legal_message: The legal_message of this MarketingMessage.  # noqa: E501
        :type: str
        """

        self._legal_message = legal_message

    @property
    def marketing_channels(self):
        """Gets the marketing_channels of this MarketingMessage.  # noqa: E501

        A list of enumeration values representing the marketing channels, such as email, that the buyer can choose to receive. These are to be shown to the buyer when they place the order.  # noqa: E501

        :return: The marketing_channels of this MarketingMessage.  # noqa: E501
        :rtype: list[str]
        """
        return self._marketing_channels

    @marketing_channels.setter
    def marketing_channels(self, marketing_channels):
        """Sets the marketing_channels of this MarketingMessage.

        A list of enumeration values representing the marketing channels, such as email, that the buyer can choose to receive. These are to be shown to the buyer when they place the order.  # noqa: E501

        :param marketing_channels: The marketing_channels of this MarketingMessage.  # noqa: E501
        :type: list[str]
        """

        self._marketing_channels = marketing_channels

    @property
    def marketing_types(self):
        """Gets the marketing_types of this MarketingMessage.  # noqa: E501

        A list of enumeration values representing the marketing types, such as OFFER, that the buyer can choose to receive. These are to be shown to the buyer when they place the order.  # noqa: E501

        :return: The marketing_types of this MarketingMessage.  # noqa: E501
        :rtype: list[str]
        """
        return self._marketing_types

    @marketing_types.setter
    def marketing_types(self, marketing_types):
        """Sets the marketing_types of this MarketingMessage.

        A list of enumeration values representing the marketing types, such as OFFER, that the buyer can choose to receive. These are to be shown to the buyer when they place the order.  # noqa: E501

        :param marketing_types: The marketing_types of this MarketingMessage.  # noqa: E501
        :type: list[str]
        """

        self._marketing_types = marketing_types

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MarketingMessage, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MarketingMessage):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
