# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class MarketingTerms(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'marketing_channels': 'list[str]',
        'marketing_terms_accepted': 'bool',
        'marketing_types': 'list[str]'
    }

    attribute_map = {
        'marketing_channels': 'marketingChannels',
        'marketing_terms_accepted': 'marketingTermsAccepted',
        'marketing_types': 'marketingTypes'
    }

    def __init__(self, marketing_channels=None, marketing_terms_accepted=None, marketing_types=None):  # noqa: E501
        """MarketingTerms - a model defined in Swagger"""  # noqa: E501
        self._marketing_channels = None
        self._marketing_terms_accepted = None
        self._marketing_types = None
        self.discriminator = None
        if marketing_channels is not None:
            self.marketing_channels = marketing_channels
        if marketing_terms_accepted is not None:
            self.marketing_terms_accepted = marketing_terms_accepted
        if marketing_types is not None:
            self.marketing_types = marketing_types

    @property
    def marketing_channels(self):
        """Gets the marketing_channels of this MarketingTerms.  # noqa: E501

        An enumeration value representing the available marketing channels. Valid Values: EMAIL Required: You must always pass in all the values, even if marketingTermsAccepted is set to false. See the Samples for an example.  # noqa: E501

        :return: The marketing_channels of this MarketingTerms.  # noqa: E501
        :rtype: list[str]
        """
        return self._marketing_channels

    @marketing_channels.setter
    def marketing_channels(self, marketing_channels):
        """Sets the marketing_channels of this MarketingTerms.

        An enumeration value representing the available marketing channels. Valid Values: EMAIL Required: You must always pass in all the values, even if marketingTermsAccepted is set to false. See the Samples for an example.  # noqa: E501

        :param marketing_channels: The marketing_channels of this MarketingTerms.  # noqa: E501
        :type: list[str]
        """

        self._marketing_channels = marketing_channels

    @property
    def marketing_terms_accepted(self):
        """Gets the marketing_terms_accepted of this MarketingTerms.  # noqa: E501

        A boolean that indicates whether the buyer wants to receive marketing messages.  # noqa: E501

        :return: The marketing_terms_accepted of this MarketingTerms.  # noqa: E501
        :rtype: bool
        """
        return self._marketing_terms_accepted

    @marketing_terms_accepted.setter
    def marketing_terms_accepted(self, marketing_terms_accepted):
        """Sets the marketing_terms_accepted of this MarketingTerms.

        A boolean that indicates whether the buyer wants to receive marketing messages.  # noqa: E501

        :param marketing_terms_accepted: The marketing_terms_accepted of this MarketingTerms.  # noqa: E501
        :type: bool
        """

        self._marketing_terms_accepted = marketing_terms_accepted

    @property
    def marketing_types(self):
        """Gets the marketing_types of this MarketingTerms.  # noqa: E501

        An enumeration value representing the available types of marketing messages. Valid Values: OFFER PROMOTION SURVEY Required: You must always pass in all these values, even if marketingTermsAccepted is set to false. See the Samples for an example.  # noqa: E501

        :return: The marketing_types of this MarketingTerms.  # noqa: E501
        :rtype: list[str]
        """
        return self._marketing_types

    @marketing_types.setter
    def marketing_types(self, marketing_types):
        """Sets the marketing_types of this MarketingTerms.

        An enumeration value representing the available types of marketing messages. Valid Values: OFFER PROMOTION SURVEY Required: You must always pass in all these values, even if marketingTermsAccepted is set to false. See the Samples for an example.  # noqa: E501

        :param marketing_types: The marketing_types of this MarketingTerms.  # noqa: E501
        :type: list[str]
        """

        self._marketing_types = marketing_types

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MarketingTerms, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MarketingTerms):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
