# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class OrderLineItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'authenticity_verification': 'AuthenticityVerificationProgram',
        'base_unit_price': 'Amount',
        'fees': 'list[Fee]',
        'image': 'Image',
        'item_id': 'str',
        'legacy_reference': 'LegacyReference',
        'line_item_id': 'str',
        'line_item_payment_status': 'str',
        'line_item_status': 'str',
        'net_price': 'Amount',
        'order_id': 'str',
        'promotions': 'list[Promotion]',
        'quantity': 'int',
        'seller': 'Seller',
        'shipping_detail': 'ShippingDetail',
        'tax_details': 'list[TaxDetail]',
        'title': 'str'
    }

    attribute_map = {
        'authenticity_verification': 'authenticityVerification',
        'base_unit_price': 'baseUnitPrice',
        'fees': 'fees',
        'image': 'image',
        'item_id': 'itemId',
        'legacy_reference': 'legacyReference',
        'line_item_id': 'lineItemId',
        'line_item_payment_status': 'lineItemPaymentStatus',
        'line_item_status': 'lineItemStatus',
        'net_price': 'netPrice',
        'order_id': 'orderId',
        'promotions': 'promotions',
        'quantity': 'quantity',
        'seller': 'seller',
        'shipping_detail': 'shippingDetail',
        'tax_details': 'taxDetails',
        'title': 'title'
    }

    def __init__(self, authenticity_verification=None, base_unit_price=None, fees=None, image=None, item_id=None, legacy_reference=None, line_item_id=None, line_item_payment_status=None, line_item_status=None, net_price=None, order_id=None, promotions=None, quantity=None, seller=None, shipping_detail=None, tax_details=None, title=None):  # noqa: E501
        """OrderLineItem - a model defined in Swagger"""  # noqa: E501
        self._authenticity_verification = None
        self._base_unit_price = None
        self._fees = None
        self._image = None
        self._item_id = None
        self._legacy_reference = None
        self._line_item_id = None
        self._line_item_payment_status = None
        self._line_item_status = None
        self._net_price = None
        self._order_id = None
        self._promotions = None
        self._quantity = None
        self._seller = None
        self._shipping_detail = None
        self._tax_details = None
        self._title = None
        self.discriminator = None
        if authenticity_verification is not None:
            self.authenticity_verification = authenticity_verification
        if base_unit_price is not None:
            self.base_unit_price = base_unit_price
        if fees is not None:
            self.fees = fees
        if image is not None:
            self.image = image
        if item_id is not None:
            self.item_id = item_id
        if legacy_reference is not None:
            self.legacy_reference = legacy_reference
        if line_item_id is not None:
            self.line_item_id = line_item_id
        if line_item_payment_status is not None:
            self.line_item_payment_status = line_item_payment_status
        if line_item_status is not None:
            self.line_item_status = line_item_status
        if net_price is not None:
            self.net_price = net_price
        if order_id is not None:
            self.order_id = order_id
        if promotions is not None:
            self.promotions = promotions
        if quantity is not None:
            self.quantity = quantity
        if seller is not None:
            self.seller = seller
        if shipping_detail is not None:
            self.shipping_detail = shipping_detail
        if tax_details is not None:
            self.tax_details = tax_details
        if title is not None:
            self.title = title

    @property
    def authenticity_verification(self):
        """Gets the authenticity_verification of this OrderLineItem.  # noqa: E501


        :return: The authenticity_verification of this OrderLineItem.  # noqa: E501
        :rtype: AuthenticityVerificationProgram
        """
        return self._authenticity_verification

    @authenticity_verification.setter
    def authenticity_verification(self, authenticity_verification):
        """Sets the authenticity_verification of this OrderLineItem.


        :param authenticity_verification: The authenticity_verification of this OrderLineItem.  # noqa: E501
        :type: AuthenticityVerificationProgram
        """

        self._authenticity_verification = authenticity_verification

    @property
    def base_unit_price(self):
        """Gets the base_unit_price of this OrderLineItem.  # noqa: E501


        :return: The base_unit_price of this OrderLineItem.  # noqa: E501
        :rtype: Amount
        """
        return self._base_unit_price

    @base_unit_price.setter
    def base_unit_price(self, base_unit_price):
        """Sets the base_unit_price of this OrderLineItem.


        :param base_unit_price: The base_unit_price of this OrderLineItem.  # noqa: E501
        :type: Amount
        """

        self._base_unit_price = base_unit_price

    @property
    def fees(self):
        """Gets the fees of this OrderLineItem.  # noqa: E501

        A breakdown of the fees applicable to the line item.  # noqa: E501

        :return: The fees of this OrderLineItem.  # noqa: E501
        :rtype: list[Fee]
        """
        return self._fees

    @fees.setter
    def fees(self, fees):
        """Sets the fees of this OrderLineItem.

        A breakdown of the fees applicable to the line item.  # noqa: E501

        :param fees: The fees of this OrderLineItem.  # noqa: E501
        :type: list[Fee]
        """

        self._fees = fees

    @property
    def image(self):
        """Gets the image of this OrderLineItem.  # noqa: E501


        :return: The image of this OrderLineItem.  # noqa: E501
        :rtype: Image
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this OrderLineItem.


        :param image: The image of this OrderLineItem.  # noqa: E501
        :type: Image
        """

        self._image = image

    @property
    def item_id(self):
        """Gets the item_id of this OrderLineItem.  # noqa: E501

        The identifier of the item.  # noqa: E501

        :return: The item_id of this OrderLineItem.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this OrderLineItem.

        The identifier of the item.  # noqa: E501

        :param item_id: The item_id of this OrderLineItem.  # noqa: E501
        :type: str
        """

        self._item_id = item_id

    @property
    def legacy_reference(self):
        """Gets the legacy_reference of this OrderLineItem.  # noqa: E501


        :return: The legacy_reference of this OrderLineItem.  # noqa: E501
        :rtype: LegacyReference
        """
        return self._legacy_reference

    @legacy_reference.setter
    def legacy_reference(self, legacy_reference):
        """Sets the legacy_reference of this OrderLineItem.


        :param legacy_reference: The legacy_reference of this OrderLineItem.  # noqa: E501
        :type: LegacyReference
        """

        self._legacy_reference = legacy_reference

    @property
    def line_item_id(self):
        """Gets the line_item_id of this OrderLineItem.  # noqa: E501

        The identifier of this line item. This is created by the initiateCheckoutSession for a member and initiateGuestCheckoutSession for a guest calls.  # noqa: E501

        :return: The line_item_id of this OrderLineItem.  # noqa: E501
        :rtype: str
        """
        return self._line_item_id

    @line_item_id.setter
    def line_item_id(self, line_item_id):
        """Sets the line_item_id of this OrderLineItem.

        The identifier of this line item. This is created by the initiateCheckoutSession for a member and initiateGuestCheckoutSession for a guest calls.  # noqa: E501

        :param line_item_id: The line_item_id of this OrderLineItem.  # noqa: E501
        :type: str
        """

        self._line_item_id = line_item_id

    @property
    def line_item_payment_status(self):
        """Gets the line_item_payment_status of this OrderLineItem.  # noqa: E501

        An enumeration value that indicates the payment status of this line item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:LineItemPaymentStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The line_item_payment_status of this OrderLineItem.  # noqa: E501
        :rtype: str
        """
        return self._line_item_payment_status

    @line_item_payment_status.setter
    def line_item_payment_status(self, line_item_payment_status):
        """Sets the line_item_payment_status of this OrderLineItem.

        An enumeration value that indicates the payment status of this line item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:LineItemPaymentStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param line_item_payment_status: The line_item_payment_status of this OrderLineItem.  # noqa: E501
        :type: str
        """

        self._line_item_payment_status = line_item_payment_status

    @property
    def line_item_status(self):
        """Gets the line_item_status of this OrderLineItem.  # noqa: E501

        An enumeration value that indicates the fulfillment state of this line item. Note: When there is no tracking information, this status will never change from FULFILLMENT_IN_PROGRESS because without tracking information eBay has no way of knowing if the order was delivered. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:LineItemStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The line_item_status of this OrderLineItem.  # noqa: E501
        :rtype: str
        """
        return self._line_item_status

    @line_item_status.setter
    def line_item_status(self, line_item_status):
        """Sets the line_item_status of this OrderLineItem.

        An enumeration value that indicates the fulfillment state of this line item. Note: When there is no tracking information, this status will never change from FULFILLMENT_IN_PROGRESS because without tracking information eBay has no way of knowing if the order was delivered. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:LineItemStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param line_item_status: The line_item_status of this OrderLineItem.  # noqa: E501
        :type: str
        """

        self._line_item_status = line_item_status

    @property
    def net_price(self):
        """Gets the net_price of this OrderLineItem.  # noqa: E501


        :return: The net_price of this OrderLineItem.  # noqa: E501
        :rtype: Amount
        """
        return self._net_price

    @net_price.setter
    def net_price(self, net_price):
        """Sets the net_price of this OrderLineItem.


        :param net_price: The net_price of this OrderLineItem.  # noqa: E501
        :type: Amount
        """

        self._net_price = net_price

    @property
    def order_id(self):
        """Gets the order_id of this OrderLineItem.  # noqa: E501

        The unique order ID for this line item. This value is the new eBay unique order ID. For details see, Easier order management with updated order numbers. In the future, you will use this value in the Post Order API instead of the lineItems.legacyReference fields. Maximum Length: 40 characters  # noqa: E501

        :return: The order_id of this OrderLineItem.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this OrderLineItem.

        The unique order ID for this line item. This value is the new eBay unique order ID. For details see, Easier order management with updated order numbers. In the future, you will use this value in the Post Order API instead of the lineItems.legacyReference fields. Maximum Length: 40 characters  # noqa: E501

        :param order_id: The order_id of this OrderLineItem.  # noqa: E501
        :type: str
        """

        self._order_id = order_id

    @property
    def promotions(self):
        """Gets the promotions of this OrderLineItem.  # noqa: E501

        An array of promotions applied to the items in this line item.  # noqa: E501

        :return: The promotions of this OrderLineItem.  # noqa: E501
        :rtype: list[Promotion]
        """
        return self._promotions

    @promotions.setter
    def promotions(self, promotions):
        """Sets the promotions of this OrderLineItem.

        An array of promotions applied to the items in this line item.  # noqa: E501

        :param promotions: The promotions of this OrderLineItem.  # noqa: E501
        :type: list[Promotion]
        """

        self._promotions = promotions

    @property
    def quantity(self):
        """Gets the quantity of this OrderLineItem.  # noqa: E501

        The number of individual items in this line item.  # noqa: E501

        :return: The quantity of this OrderLineItem.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this OrderLineItem.

        The number of individual items in this line item.  # noqa: E501

        :param quantity: The quantity of this OrderLineItem.  # noqa: E501
        :type: int
        """

        self._quantity = quantity

    @property
    def seller(self):
        """Gets the seller of this OrderLineItem.  # noqa: E501


        :return: The seller of this OrderLineItem.  # noqa: E501
        :rtype: Seller
        """
        return self._seller

    @seller.setter
    def seller(self, seller):
        """Sets the seller of this OrderLineItem.


        :param seller: The seller of this OrderLineItem.  # noqa: E501
        :type: Seller
        """

        self._seller = seller

    @property
    def shipping_detail(self):
        """Gets the shipping_detail of this OrderLineItem.  # noqa: E501


        :return: The shipping_detail of this OrderLineItem.  # noqa: E501
        :rtype: ShippingDetail
        """
        return self._shipping_detail

    @shipping_detail.setter
    def shipping_detail(self, shipping_detail):
        """Sets the shipping_detail of this OrderLineItem.


        :param shipping_detail: The shipping_detail of this OrderLineItem.  # noqa: E501
        :type: ShippingDetail
        """

        self._shipping_detail = shipping_detail

    @property
    def tax_details(self):
        """Gets the tax_details of this OrderLineItem.  # noqa: E501

        A container for the tax information for the line item. Note: The information in this container is only returned when requested from the GB marketplace, when applicable.  # noqa: E501

        :return: The tax_details of this OrderLineItem.  # noqa: E501
        :rtype: list[TaxDetail]
        """
        return self._tax_details

    @tax_details.setter
    def tax_details(self, tax_details):
        """Sets the tax_details of this OrderLineItem.

        A container for the tax information for the line item. Note: The information in this container is only returned when requested from the GB marketplace, when applicable.  # noqa: E501

        :param tax_details: The tax_details of this OrderLineItem.  # noqa: E501
        :type: list[TaxDetail]
        """

        self._tax_details = tax_details

    @property
    def title(self):
        """Gets the title of this OrderLineItem.  # noqa: E501

        The seller created title of the item.  # noqa: E501

        :return: The title of this OrderLineItem.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this OrderLineItem.

        The seller created title of the item.  # noqa: E501

        :param title: The title of this OrderLineItem.  # noqa: E501
        :type: str
        """

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrderLineItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderLineItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
