# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PaymentInstrumentReference(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'external_reference_id': 'str',
        'last_four_digit_for_credit_card': 'str'
    }

    attribute_map = {
        'external_reference_id': 'externalReferenceId',
        'last_four_digit_for_credit_card': 'lastFourDigitForCreditCard'
    }

    def __init__(self, external_reference_id=None, last_four_digit_for_credit_card=None):  # noqa: E501
        """PaymentInstrumentReference - a model defined in Swagger"""  # noqa: E501
        self._external_reference_id = None
        self._last_four_digit_for_credit_card = None
        self.discriminator = None
        if external_reference_id is not None:
            self.external_reference_id = external_reference_id
        if last_four_digit_for_credit_card is not None:
            self.last_four_digit_for_credit_card = last_four_digit_for_credit_card

    @property
    def external_reference_id(self):
        """Gets the external_reference_id of this PaymentInstrumentReference.  # noqa: E501

        The identifier of the buyer's PayPal cart, which is returned by the initiateGuestPayment method. This ID is generated by PayPal and required for the PayPal Smart Button eBay guest payment flow.  # noqa: E501

        :return: The external_reference_id of this PaymentInstrumentReference.  # noqa: E501
        :rtype: str
        """
        return self._external_reference_id

    @external_reference_id.setter
    def external_reference_id(self, external_reference_id):
        """Sets the external_reference_id of this PaymentInstrumentReference.

        The identifier of the buyer's PayPal cart, which is returned by the initiateGuestPayment method. This ID is generated by PayPal and required for the PayPal Smart Button eBay guest payment flow.  # noqa: E501

        :param external_reference_id: The external_reference_id of this PaymentInstrumentReference.  # noqa: E501
        :type: str
        """

        self._external_reference_id = external_reference_id

    @property
    def last_four_digit_for_credit_card(self):
        """Gets the last_four_digit_for_credit_card of this PaymentInstrumentReference.  # noqa: E501

        The last four digits of the credit card number being used to pay for the items.  # noqa: E501

        :return: The last_four_digit_for_credit_card of this PaymentInstrumentReference.  # noqa: E501
        :rtype: str
        """
        return self._last_four_digit_for_credit_card

    @last_four_digit_for_credit_card.setter
    def last_four_digit_for_credit_card(self, last_four_digit_for_credit_card):
        """Sets the last_four_digit_for_credit_card of this PaymentInstrumentReference.

        The last four digits of the credit card number being used to pay for the items.  # noqa: E501

        :param last_four_digit_for_credit_card: The last_four_digit_for_credit_card of this PaymentInstrumentReference.  # noqa: E501
        :type: str
        """

        self._last_four_digit_for_credit_card = last_four_digit_for_credit_card

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PaymentInstrumentReference, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentInstrumentReference):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
