# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PaymentMethod(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'label': 'str',
        'logo_image': 'Image',
        'payment_method_brands': 'list[PaymentMethodBrand]',
        'payment_method_messages': 'list[PaymentMethodMessage]',
        'payment_method_type': 'str'
    }

    attribute_map = {
        'label': 'label',
        'logo_image': 'logoImage',
        'payment_method_brands': 'paymentMethodBrands',
        'payment_method_messages': 'paymentMethodMessages',
        'payment_method_type': 'paymentMethodType'
    }

    def __init__(self, label=None, logo_image=None, payment_method_brands=None, payment_method_messages=None, payment_method_type=None):  # noqa: E501
        """PaymentMethod - a model defined in Swagger"""  # noqa: E501
        self._label = None
        self._logo_image = None
        self._payment_method_brands = None
        self._payment_method_messages = None
        self._payment_method_type = None
        self.discriminator = None
        if label is not None:
            self.label = label
        if logo_image is not None:
            self.logo_image = logo_image
        if payment_method_brands is not None:
            self.payment_method_brands = payment_method_brands
        if payment_method_messages is not None:
            self.payment_method_messages = payment_method_messages
        if payment_method_type is not None:
            self.payment_method_type = payment_method_type

    @property
    def label(self):
        """Gets the label of this PaymentMethod.  # noqa: E501

        Text indicating the payment type. For example, when paying by credit card, this value will be CC. When paying using PayPal Smart Button eBay guest payment flow the value will be WALLET.  # noqa: E501

        :return: The label of this PaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this PaymentMethod.

        Text indicating the payment type. For example, when paying by credit card, this value will be CC. When paying using PayPal Smart Button eBay guest payment flow the value will be WALLET.  # noqa: E501

        :param label: The label of this PaymentMethod.  # noqa: E501
        :type: str
        """

        self._label = label

    @property
    def logo_image(self):
        """Gets the logo_image of this PaymentMethod.  # noqa: E501


        :return: The logo_image of this PaymentMethod.  # noqa: E501
        :rtype: Image
        """
        return self._logo_image

    @logo_image.setter
    def logo_image(self, logo_image):
        """Sets the logo_image of this PaymentMethod.


        :param logo_image: The logo_image of this PaymentMethod.  # noqa: E501
        :type: Image
        """

        self._logo_image = logo_image

    @property
    def payment_method_brands(self):
        """Gets the payment_method_brands of this PaymentMethod.  # noqa: E501

        An array of credit card brands that can be used as the payment method.  # noqa: E501

        :return: The payment_method_brands of this PaymentMethod.  # noqa: E501
        :rtype: list[PaymentMethodBrand]
        """
        return self._payment_method_brands

    @payment_method_brands.setter
    def payment_method_brands(self, payment_method_brands):
        """Sets the payment_method_brands of this PaymentMethod.

        An array of credit card brands that can be used as the payment method.  # noqa: E501

        :param payment_method_brands: The payment_method_brands of this PaymentMethod.  # noqa: E501
        :type: list[PaymentMethodBrand]
        """

        self._payment_method_brands = payment_method_brands

    @property
    def payment_method_messages(self):
        """Gets the payment_method_messages of this PaymentMethod.  # noqa: E501

        The type that defines the fields for legal messages and buyer consent verification.  # noqa: E501

        :return: The payment_method_messages of this PaymentMethod.  # noqa: E501
        :rtype: list[PaymentMethodMessage]
        """
        return self._payment_method_messages

    @payment_method_messages.setter
    def payment_method_messages(self, payment_method_messages):
        """Sets the payment_method_messages of this PaymentMethod.

        The type that defines the fields for legal messages and buyer consent verification.  # noqa: E501

        :param payment_method_messages: The payment_method_messages of this PaymentMethod.  # noqa: E501
        :type: list[PaymentMethodMessage]
        """

        self._payment_method_messages = payment_method_messages

    @property
    def payment_method_type(self):
        """Gets the payment_method_type of this PaymentMethod.  # noqa: E501

        An enumeration value that indicates the method of payment, such as credit card. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:PaymentMethodTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The payment_method_type of this PaymentMethod.  # noqa: E501
        :rtype: str
        """
        return self._payment_method_type

    @payment_method_type.setter
    def payment_method_type(self, payment_method_type):
        """Sets the payment_method_type of this PaymentMethod.

        An enumeration value that indicates the method of payment, such as credit card. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:PaymentMethodTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param payment_method_type: The payment_method_type of this PaymentMethod.  # noqa: E501
        :type: str
        """

        self._payment_method_type = payment_method_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PaymentMethod, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentMethod):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
