# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Promotion(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'discount': 'Amount',
        'discount_percentage': 'str',
        'message': 'str',
        'promotion_code': 'str',
        'promotion_type': 'str'
    }

    attribute_map = {
        'discount': 'discount',
        'discount_percentage': 'discountPercentage',
        'message': 'message',
        'promotion_code': 'promotionCode',
        'promotion_type': 'promotionType'
    }

    def __init__(self, discount=None, discount_percentage=None, message=None, promotion_code=None, promotion_type=None):  # noqa: E501
        """Promotion - a model defined in Swagger"""  # noqa: E501
        self._discount = None
        self._discount_percentage = None
        self._message = None
        self._promotion_code = None
        self._promotion_type = None
        self.discriminator = None
        if discount is not None:
            self.discount = discount
        if discount_percentage is not None:
            self.discount_percentage = discount_percentage
        if message is not None:
            self.message = message
        if promotion_code is not None:
            self.promotion_code = promotion_code
        if promotion_type is not None:
            self.promotion_type = promotion_type

    @property
    def discount(self):
        """Gets the discount of this Promotion.  # noqa: E501


        :return: The discount of this Promotion.  # noqa: E501
        :rtype: Amount
        """
        return self._discount

    @discount.setter
    def discount(self, discount):
        """Sets the discount of this Promotion.


        :param discount: The discount of this Promotion.  # noqa: E501
        :type: Amount
        """

        self._discount = discount

    @property
    def discount_percentage(self):
        """Gets the discount_percentage of this Promotion.  # noqa: E501

        Note: This field is not return in the purchase order methods response.  # noqa: E501

        :return: The discount_percentage of this Promotion.  # noqa: E501
        :rtype: str
        """
        return self._discount_percentage

    @discount_percentage.setter
    def discount_percentage(self, discount_percentage):
        """Sets the discount_percentage of this Promotion.

        Note: This field is not return in the purchase order methods response.  # noqa: E501

        :param discount_percentage: The discount_percentage of this Promotion.  # noqa: E501
        :type: str
        """

        self._discount_percentage = discount_percentage

    @property
    def message(self):
        """Gets the message of this Promotion.  # noqa: E501

        The text for the promotion title, which describes the promotion. For example, Buy 1 Get 1.  # noqa: E501

        :return: The message of this Promotion.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this Promotion.

        The text for the promotion title, which describes the promotion. For example, Buy 1 Get 1.  # noqa: E501

        :param message: The message of this Promotion.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def promotion_code(self):
        """Gets the promotion_code of this Promotion.  # noqa: E501

        An identifier of the promotion that was generated by the system when the promotion was created. Note: No data is returned in this field for the getPurchaseOrder and getGuestPurchaseOrder methods.  # noqa: E501

        :return: The promotion_code of this Promotion.  # noqa: E501
        :rtype: str
        """
        return self._promotion_code

    @promotion_code.setter
    def promotion_code(self, promotion_code):
        """Sets the promotion_code of this Promotion.

        An identifier of the promotion that was generated by the system when the promotion was created. Note: No data is returned in this field for the getPurchaseOrder and getGuestPurchaseOrder methods.  # noqa: E501

        :param promotion_code: The promotion_code of this Promotion.  # noqa: E501
        :type: str
        """

        self._promotion_code = promotion_code

    @property
    def promotion_type(self):
        """Gets the promotion_type of this Promotion.  # noqa: E501

        Indicates the kind of promotion. Some examples are: SellerDiscountedPromotionalOffer and COUPON.  # noqa: E501

        :return: The promotion_type of this Promotion.  # noqa: E501
        :rtype: str
        """
        return self._promotion_type

    @promotion_type.setter
    def promotion_type(self, promotion_type):
        """Sets the promotion_type of this Promotion.

        Indicates the kind of promotion. Some examples are: SellerDiscountedPromotionalOffer and COUPON.  # noqa: E501

        :param promotion_type: The promotion_type of this Promotion.  # noqa: E501
        :type: str
        """

        self._promotion_type = promotion_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Promotion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Promotion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
