# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProvidedPaymentInstrument(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'payment_instrument_reference': 'PaymentInstrumentReference',
        'payment_method_brand': 'PaymentMethodBrand',
        'payment_method_type': 'str'
    }

    attribute_map = {
        'payment_instrument_reference': 'paymentInstrumentReference',
        'payment_method_brand': 'paymentMethodBrand',
        'payment_method_type': 'paymentMethodType'
    }

    def __init__(self, payment_instrument_reference=None, payment_method_brand=None, payment_method_type=None):  # noqa: E501
        """ProvidedPaymentInstrument - a model defined in Swagger"""  # noqa: E501
        self._payment_instrument_reference = None
        self._payment_method_brand = None
        self._payment_method_type = None
        self.discriminator = None
        if payment_instrument_reference is not None:
            self.payment_instrument_reference = payment_instrument_reference
        if payment_method_brand is not None:
            self.payment_method_brand = payment_method_brand
        if payment_method_type is not None:
            self.payment_method_type = payment_method_type

    @property
    def payment_instrument_reference(self):
        """Gets the payment_instrument_reference of this ProvidedPaymentInstrument.  # noqa: E501


        :return: The payment_instrument_reference of this ProvidedPaymentInstrument.  # noqa: E501
        :rtype: PaymentInstrumentReference
        """
        return self._payment_instrument_reference

    @payment_instrument_reference.setter
    def payment_instrument_reference(self, payment_instrument_reference):
        """Sets the payment_instrument_reference of this ProvidedPaymentInstrument.


        :param payment_instrument_reference: The payment_instrument_reference of this ProvidedPaymentInstrument.  # noqa: E501
        :type: PaymentInstrumentReference
        """

        self._payment_instrument_reference = payment_instrument_reference

    @property
    def payment_method_brand(self):
        """Gets the payment_method_brand of this ProvidedPaymentInstrument.  # noqa: E501


        :return: The payment_method_brand of this ProvidedPaymentInstrument.  # noqa: E501
        :rtype: PaymentMethodBrand
        """
        return self._payment_method_brand

    @payment_method_brand.setter
    def payment_method_brand(self, payment_method_brand):
        """Sets the payment_method_brand of this ProvidedPaymentInstrument.


        :param payment_method_brand: The payment_method_brand of this ProvidedPaymentInstrument.  # noqa: E501
        :type: PaymentMethodBrand
        """

        self._payment_method_brand = payment_method_brand

    @property
    def payment_method_type(self):
        """Gets the payment_method_type of this ProvidedPaymentInstrument.  # noqa: E501

        An enumeration value that indicates the method of payment, such as CREDIT_CARD. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:PaymentMethodTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The payment_method_type of this ProvidedPaymentInstrument.  # noqa: E501
        :rtype: str
        """
        return self._payment_method_type

    @payment_method_type.setter
    def payment_method_type(self, payment_method_type):
        """Sets the payment_method_type of this ProvidedPaymentInstrument.

        An enumeration value that indicates the method of payment, such as CREDIT_CARD. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:PaymentMethodTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param payment_method_type: The payment_method_type of this ProvidedPaymentInstrument.  # noqa: E501
        :type: str
        """

        self._payment_method_type = payment_method_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProvidedPaymentInstrument, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProvidedPaymentInstrument):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
