# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PurchaseOrderSummary(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'purchase_order_href': 'str',
        'purchase_order_id': 'str',
        'purchase_order_payment_status': 'str',
        'warnings': 'list[Error]'
    }

    attribute_map = {
        'purchase_order_href': 'purchaseOrderHref',
        'purchase_order_id': 'purchaseOrderId',
        'purchase_order_payment_status': 'purchaseOrderPaymentStatus',
        'warnings': 'warnings'
    }

    def __init__(self, purchase_order_href=None, purchase_order_id=None, purchase_order_payment_status=None, warnings=None):  # noqa: E501
        """PurchaseOrderSummary - a model defined in Swagger"""  # noqa: E501
        self._purchase_order_href = None
        self._purchase_order_id = None
        self._purchase_order_payment_status = None
        self._warnings = None
        self.discriminator = None
        if purchase_order_href is not None:
            self.purchase_order_href = purchase_order_href
        if purchase_order_id is not None:
            self.purchase_order_id = purchase_order_id
        if purchase_order_payment_status is not None:
            self.purchase_order_payment_status = purchase_order_payment_status
        if warnings is not None:
            self.warnings = warnings

    @property
    def purchase_order_href(self):
        """Gets the purchase_order_href of this PurchaseOrderSummary.  # noqa: E501

        The URI of the purchase order.  # noqa: E501

        :return: The purchase_order_href of this PurchaseOrderSummary.  # noqa: E501
        :rtype: str
        """
        return self._purchase_order_href

    @purchase_order_href.setter
    def purchase_order_href(self, purchase_order_href):
        """Sets the purchase_order_href of this PurchaseOrderSummary.

        The URI of the purchase order.  # noqa: E501

        :param purchase_order_href: The purchase_order_href of this PurchaseOrderSummary.  # noqa: E501
        :type: str
        """

        self._purchase_order_href = purchase_order_href

    @property
    def purchase_order_id(self):
        """Gets the purchase_order_id of this PurchaseOrderSummary.  # noqa: E501

        A unique identifier of the purchase order. When a checkout session completes, a purchase order ID is generated but this does not indicate that the item has been paid for. Note: If there is a problem with the payment information, the purchase order ID will be returned and the PurchaseOrderPaymentStatusEnum field will return FAILED.  # noqa: E501

        :return: The purchase_order_id of this PurchaseOrderSummary.  # noqa: E501
        :rtype: str
        """
        return self._purchase_order_id

    @purchase_order_id.setter
    def purchase_order_id(self, purchase_order_id):
        """Sets the purchase_order_id of this PurchaseOrderSummary.

        A unique identifier of the purchase order. When a checkout session completes, a purchase order ID is generated but this does not indicate that the item has been paid for. Note: If there is a problem with the payment information, the purchase order ID will be returned and the PurchaseOrderPaymentStatusEnum field will return FAILED.  # noqa: E501

        :param purchase_order_id: The purchase_order_id of this PurchaseOrderSummary.  # noqa: E501
        :type: str
        """

        self._purchase_order_id = purchase_order_id

    @property
    def purchase_order_payment_status(self):
        """Gets the purchase_order_payment_status of this PurchaseOrderSummary.  # noqa: E501

        An enumeration value that indicates the payment status for the purchase order. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:PurchaseOrderPaymentStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The purchase_order_payment_status of this PurchaseOrderSummary.  # noqa: E501
        :rtype: str
        """
        return self._purchase_order_payment_status

    @purchase_order_payment_status.setter
    def purchase_order_payment_status(self, purchase_order_payment_status):
        """Sets the purchase_order_payment_status of this PurchaseOrderSummary.

        An enumeration value that indicates the payment status for the purchase order. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/order/types/gct:PurchaseOrderPaymentStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param purchase_order_payment_status: The purchase_order_payment_status of this PurchaseOrderSummary.  # noqa: E501
        :type: str
        """

        self._purchase_order_payment_status = purchase_order_payment_status

    @property
    def warnings(self):
        """Gets the warnings of this PurchaseOrderSummary.  # noqa: E501

        An array of warning messages.  # noqa: E501

        :return: The warnings of this PurchaseOrderSummary.  # noqa: E501
        :rtype: list[Error]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this PurchaseOrderSummary.

        An array of warning messages.  # noqa: E501

        :param warnings: The warnings of this PurchaseOrderSummary.  # noqa: E501
        :type: list[Error]
        """

        self._warnings = warnings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PurchaseOrderSummary, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PurchaseOrderSummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
