# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Seller(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'feedback_percentage': 'str',
        'feedback_score': 'int',
        'seller_account_type': 'str',
        'username': 'str'
    }

    attribute_map = {
        'feedback_percentage': 'feedbackPercentage',
        'feedback_score': 'feedbackScore',
        'seller_account_type': 'sellerAccountType',
        'username': 'username'
    }

    def __init__(self, feedback_percentage=None, feedback_score=None, seller_account_type=None, username=None):  # noqa: E501
        """Seller - a model defined in Swagger"""  # noqa: E501
        self._feedback_percentage = None
        self._feedback_score = None
        self._seller_account_type = None
        self._username = None
        self.discriminator = None
        if feedback_percentage is not None:
            self.feedback_percentage = feedback_percentage
        if feedback_score is not None:
            self.feedback_score = feedback_score
        if seller_account_type is not None:
            self.seller_account_type = seller_account_type
        if username is not None:
            self.username = username

    @property
    def feedback_percentage(self):
        """Gets the feedback_percentage of this Seller.  # noqa: E501

        The percentage of the total positive feedback.  # noqa: E501

        :return: The feedback_percentage of this Seller.  # noqa: E501
        :rtype: str
        """
        return self._feedback_percentage

    @feedback_percentage.setter
    def feedback_percentage(self, feedback_percentage):
        """Sets the feedback_percentage of this Seller.

        The percentage of the total positive feedback.  # noqa: E501

        :param feedback_percentage: The feedback_percentage of this Seller.  # noqa: E501
        :type: str
        """

        self._feedback_percentage = feedback_percentage

    @property
    def feedback_score(self):
        """Gets the feedback_score of this Seller.  # noqa: E501

        The feedback score of the seller. This value is based on the ratings from eBay members that bought items from this seller.  # noqa: E501

        :return: The feedback_score of this Seller.  # noqa: E501
        :rtype: int
        """
        return self._feedback_score

    @feedback_score.setter
    def feedback_score(self, feedback_score):
        """Sets the feedback_score of this Seller.

        The feedback score of the seller. This value is based on the ratings from eBay members that bought items from this seller.  # noqa: E501

        :param feedback_score: The feedback_score of this Seller.  # noqa: E501
        :type: int
        """

        self._feedback_score = feedback_score

    @property
    def seller_account_type(self):
        """Gets the seller_account_type of this Seller.  # noqa: E501

        Indicates if the seller is a business or an individual. This is determined when the seller registers with eBay. If they register for a business account, this value will be BUSINESS. If they register for a private account, this value will be INDIVIDUAL. This designation is required by the tax laws in some countries. This field is returned only on the following sites. EBAY_AT, EBAY_BE, EBAY_CH, EBAY_DE, EBAY_ES, EBAY_FR, EBAY_GB, EBAY_IE, EBAY_IT, EBAY_PL Valid values: BUSINESS INDIVIDUALCode so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The seller_account_type of this Seller.  # noqa: E501
        :rtype: str
        """
        return self._seller_account_type

    @seller_account_type.setter
    def seller_account_type(self, seller_account_type):
        """Sets the seller_account_type of this Seller.

        Indicates if the seller is a business or an individual. This is determined when the seller registers with eBay. If they register for a business account, this value will be BUSINESS. If they register for a private account, this value will be INDIVIDUAL. This designation is required by the tax laws in some countries. This field is returned only on the following sites. EBAY_AT, EBAY_BE, EBAY_CH, EBAY_DE, EBAY_ES, EBAY_FR, EBAY_GB, EBAY_IE, EBAY_IT, EBAY_PL Valid values: BUSINESS INDIVIDUALCode so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param seller_account_type: The seller_account_type of this Seller.  # noqa: E501
        :type: str
        """

        self._seller_account_type = seller_account_type

    @property
    def username(self):
        """Gets the username of this Seller.  # noqa: E501

        The user name created by the seller for use on eBay.  # noqa: E501

        :return: The username of this Seller.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this Seller.

        The user name created by the seller for use on eBay.  # noqa: E501

        :param username: The username of this Seller.  # noqa: E501
        :type: str
        """

        self._username = username

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Seller, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Seller):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
