# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ShippingFulfillment(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'actual_delivery_date': 'str',
        'line_item_references': 'list[LineItemReference]',
        'max_estimated_delivery_date': 'str',
        'min_estimated_delivery_date': 'str',
        'shipment_tracking_events': 'list[ShipmentTrackingEvents]',
        'shipment_tracking_number': 'str',
        'shipment_tracking_url': 'str',
        'shipped_date': 'str',
        'shipping_carrier_code': 'str',
        'shipping_service_code': 'str'
    }

    attribute_map = {
        'actual_delivery_date': 'actualDeliveryDate',
        'line_item_references': 'lineItemReferences',
        'max_estimated_delivery_date': 'maxEstimatedDeliveryDate',
        'min_estimated_delivery_date': 'minEstimatedDeliveryDate',
        'shipment_tracking_events': 'shipmentTrackingEvents',
        'shipment_tracking_number': 'shipmentTrackingNumber',
        'shipment_tracking_url': 'shipmentTrackingUrl',
        'shipped_date': 'shippedDate',
        'shipping_carrier_code': 'shippingCarrierCode',
        'shipping_service_code': 'shippingServiceCode'
    }

    def __init__(self, actual_delivery_date=None, line_item_references=None, max_estimated_delivery_date=None, min_estimated_delivery_date=None, shipment_tracking_events=None, shipment_tracking_number=None, shipment_tracking_url=None, shipped_date=None, shipping_carrier_code=None, shipping_service_code=None):  # noqa: E501
        """ShippingFulfillment - a model defined in Swagger"""  # noqa: E501
        self._actual_delivery_date = None
        self._line_item_references = None
        self._max_estimated_delivery_date = None
        self._min_estimated_delivery_date = None
        self._shipment_tracking_events = None
        self._shipment_tracking_number = None
        self._shipment_tracking_url = None
        self._shipped_date = None
        self._shipping_carrier_code = None
        self._shipping_service_code = None
        self.discriminator = None
        if actual_delivery_date is not None:
            self.actual_delivery_date = actual_delivery_date
        if line_item_references is not None:
            self.line_item_references = line_item_references
        if max_estimated_delivery_date is not None:
            self.max_estimated_delivery_date = max_estimated_delivery_date
        if min_estimated_delivery_date is not None:
            self.min_estimated_delivery_date = min_estimated_delivery_date
        if shipment_tracking_events is not None:
            self.shipment_tracking_events = shipment_tracking_events
        if shipment_tracking_number is not None:
            self.shipment_tracking_number = shipment_tracking_number
        if shipment_tracking_url is not None:
            self.shipment_tracking_url = shipment_tracking_url
        if shipped_date is not None:
            self.shipped_date = shipped_date
        if shipping_carrier_code is not None:
            self.shipping_carrier_code = shipping_carrier_code
        if shipping_service_code is not None:
            self.shipping_service_code = shipping_service_code

    @property
    def actual_delivery_date(self):
        """Gets the actual_delivery_date of this ShippingFulfillment.  # noqa: E501

        The date the purchase order was delivered.  # noqa: E501

        :return: The actual_delivery_date of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._actual_delivery_date

    @actual_delivery_date.setter
    def actual_delivery_date(self, actual_delivery_date):
        """Sets the actual_delivery_date of this ShippingFulfillment.

        The date the purchase order was delivered.  # noqa: E501

        :param actual_delivery_date: The actual_delivery_date of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._actual_delivery_date = actual_delivery_date

    @property
    def line_item_references(self):
        """Gets the line_item_references of this ShippingFulfillment.  # noqa: E501

        The container the returns the fields for the line item ID and the quantity.  # noqa: E501

        :return: The line_item_references of this ShippingFulfillment.  # noqa: E501
        :rtype: list[LineItemReference]
        """
        return self._line_item_references

    @line_item_references.setter
    def line_item_references(self, line_item_references):
        """Sets the line_item_references of this ShippingFulfillment.

        The container the returns the fields for the line item ID and the quantity.  # noqa: E501

        :param line_item_references: The line_item_references of this ShippingFulfillment.  # noqa: E501
        :type: list[LineItemReference]
        """

        self._line_item_references = line_item_references

    @property
    def max_estimated_delivery_date(self):
        """Gets the max_estimated_delivery_date of this ShippingFulfillment.  # noqa: E501

        The end of the date range in which the purchase order is expected to be delivered to the shipping address.  # noqa: E501

        :return: The max_estimated_delivery_date of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._max_estimated_delivery_date

    @max_estimated_delivery_date.setter
    def max_estimated_delivery_date(self, max_estimated_delivery_date):
        """Sets the max_estimated_delivery_date of this ShippingFulfillment.

        The end of the date range in which the purchase order is expected to be delivered to the shipping address.  # noqa: E501

        :param max_estimated_delivery_date: The max_estimated_delivery_date of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._max_estimated_delivery_date = max_estimated_delivery_date

    @property
    def min_estimated_delivery_date(self):
        """Gets the min_estimated_delivery_date of this ShippingFulfillment.  # noqa: E501

        The beginning of the date range in which the purchase order is expected to be delivered to the shipping address.  # noqa: E501

        :return: The min_estimated_delivery_date of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._min_estimated_delivery_date

    @min_estimated_delivery_date.setter
    def min_estimated_delivery_date(self, min_estimated_delivery_date):
        """Sets the min_estimated_delivery_date of this ShippingFulfillment.

        The beginning of the date range in which the purchase order is expected to be delivered to the shipping address.  # noqa: E501

        :param min_estimated_delivery_date: The min_estimated_delivery_date of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._min_estimated_delivery_date = min_estimated_delivery_date

    @property
    def shipment_tracking_events(self):
        """Gets the shipment_tracking_events of this ShippingFulfillment.  # noqa: E501

        The container that returns all the shipment tracking events.  # noqa: E501

        :return: The shipment_tracking_events of this ShippingFulfillment.  # noqa: E501
        :rtype: list[ShipmentTrackingEvents]
        """
        return self._shipment_tracking_events

    @shipment_tracking_events.setter
    def shipment_tracking_events(self, shipment_tracking_events):
        """Sets the shipment_tracking_events of this ShippingFulfillment.

        The container that returns all the shipment tracking events.  # noqa: E501

        :param shipment_tracking_events: The shipment_tracking_events of this ShippingFulfillment.  # noqa: E501
        :type: list[ShipmentTrackingEvents]
        """

        self._shipment_tracking_events = shipment_tracking_events

    @property
    def shipment_tracking_number(self):
        """Gets the shipment_tracking_number of this ShippingFulfillment.  # noqa: E501

        The shipping provider number associated with the purchase order that can be used to track the package.  # noqa: E501

        :return: The shipment_tracking_number of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._shipment_tracking_number

    @shipment_tracking_number.setter
    def shipment_tracking_number(self, shipment_tracking_number):
        """Sets the shipment_tracking_number of this ShippingFulfillment.

        The shipping provider number associated with the purchase order that can be used to track the package.  # noqa: E501

        :param shipment_tracking_number: The shipment_tracking_number of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._shipment_tracking_number = shipment_tracking_number

    @property
    def shipment_tracking_url(self):
        """Gets the shipment_tracking_url of this ShippingFulfillment.  # noqa: E501

        The URL of the shipping provider's shipment tracking page.  # noqa: E501

        :return: The shipment_tracking_url of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._shipment_tracking_url

    @shipment_tracking_url.setter
    def shipment_tracking_url(self, shipment_tracking_url):
        """Sets the shipment_tracking_url of this ShippingFulfillment.

        The URL of the shipping provider's shipment tracking page.  # noqa: E501

        :param shipment_tracking_url: The shipment_tracking_url of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._shipment_tracking_url = shipment_tracking_url

    @property
    def shipped_date(self):
        """Gets the shipped_date of this ShippingFulfillment.  # noqa: E501

        The date the seller gave the purchase order to the shipping provider.  # noqa: E501

        :return: The shipped_date of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._shipped_date

    @shipped_date.setter
    def shipped_date(self, shipped_date):
        """Sets the shipped_date of this ShippingFulfillment.

        The date the seller gave the purchase order to the shipping provider.  # noqa: E501

        :param shipped_date: The shipped_date of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._shipped_date = shipped_date

    @property
    def shipping_carrier_code(self):
        """Gets the shipping_carrier_code of this ShippingFulfillment.  # noqa: E501

        A name of the shipping provider, such as FedEx, or USPS.  # noqa: E501

        :return: The shipping_carrier_code of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._shipping_carrier_code

    @shipping_carrier_code.setter
    def shipping_carrier_code(self, shipping_carrier_code):
        """Sets the shipping_carrier_code of this ShippingFulfillment.

        A name of the shipping provider, such as FedEx, or USPS.  # noqa: E501

        :param shipping_carrier_code: The shipping_carrier_code of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._shipping_carrier_code = shipping_carrier_code

    @property
    def shipping_service_code(self):
        """Gets the shipping_service_code of this ShippingFulfillment.  # noqa: E501

        A name of a shipping type. For example, Priority Mail Express (provided by USPS) or FedEx International Priority (Provided by FedEx).  # noqa: E501

        :return: The shipping_service_code of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._shipping_service_code

    @shipping_service_code.setter
    def shipping_service_code(self, shipping_service_code):
        """Sets the shipping_service_code of this ShippingFulfillment.

        A name of a shipping type. For example, Priority Mail Express (provided by USPS) or FedEx International Priority (Provided by FedEx).  # noqa: E501

        :param shipping_service_code: The shipping_service_code of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._shipping_service_code = shipping_service_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ShippingFulfillment, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShippingFulfillment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
