# coding: utf-8

"""
    Order API

    The Order API provides interfaces that let shoppers pay for items (for both eBay guest and eBay member buyers). It also returns payment and shipping status of the order. It enables eBay partners to use accept payment without being <a href=\"https://www.pcisecuritystandards.org/\">PCI compliant</a> and use the <a href=\"/api-docs/buy/static/api-order.html#Post\">Post Order API</a> for returns and cancellations for eBay member buyers.   <p>The Order API has the following resources:  </p>  <ul>  <li><b>checkout_session:</b> Lets eBay members purchase items using PayPal or a credit card.</li>  <li><b>guest_checkout_session:</b> Lets eBay guests purchase items using a credit card or the <a href=\"/api-docs/buy/static/api-order.html#spb-checkout\">PayPal Smart Button</a>.</li>   <li><b>proxy_guest_checkout_session:</b> Lets eBay guests purchase items through a <a href=\"/api-docs/buy/static/api-order.html#vsp-checkout\">vault service provider</a> (VSP). &nbsp;&nbsp;<b>*Note:* </b>Due to the requirement of having a VSP, this resource is not available in the eBay <a href=\"https://developer.ebay.com/my/api_test_tool?index=0\">API Explorer</a>.</li>  <li><b>guest_purchase_order</b> and <b>purchase_order:</b> Lets eBay partners track the payment status and show the buyers their purchase order. </li> </ul>  # noqa: E501

    OpenAPI spec version: v1_beta.29.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ShippingOption(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'base_delivery_cost': 'Amount',
        'delivery_discount': 'Amount',
        'import_charges': 'Amount',
        'max_estimated_delivery_date': 'str',
        'min_estimated_delivery_date': 'str',
        'selected': 'bool',
        'shipping_carrier_code': 'str',
        'shipping_option_id': 'str',
        'shipping_service_code': 'str'
    }

    attribute_map = {
        'base_delivery_cost': 'baseDeliveryCost',
        'delivery_discount': 'deliveryDiscount',
        'import_charges': 'importCharges',
        'max_estimated_delivery_date': 'maxEstimatedDeliveryDate',
        'min_estimated_delivery_date': 'minEstimatedDeliveryDate',
        'selected': 'selected',
        'shipping_carrier_code': 'shippingCarrierCode',
        'shipping_option_id': 'shippingOptionId',
        'shipping_service_code': 'shippingServiceCode'
    }

    def __init__(self, base_delivery_cost=None, delivery_discount=None, import_charges=None, max_estimated_delivery_date=None, min_estimated_delivery_date=None, selected=None, shipping_carrier_code=None, shipping_option_id=None, shipping_service_code=None):  # noqa: E501
        """ShippingOption - a model defined in Swagger"""  # noqa: E501
        self._base_delivery_cost = None
        self._delivery_discount = None
        self._import_charges = None
        self._max_estimated_delivery_date = None
        self._min_estimated_delivery_date = None
        self._selected = None
        self._shipping_carrier_code = None
        self._shipping_option_id = None
        self._shipping_service_code = None
        self.discriminator = None
        if base_delivery_cost is not None:
            self.base_delivery_cost = base_delivery_cost
        if delivery_discount is not None:
            self.delivery_discount = delivery_discount
        if import_charges is not None:
            self.import_charges = import_charges
        if max_estimated_delivery_date is not None:
            self.max_estimated_delivery_date = max_estimated_delivery_date
        if min_estimated_delivery_date is not None:
            self.min_estimated_delivery_date = min_estimated_delivery_date
        if selected is not None:
            self.selected = selected
        if shipping_carrier_code is not None:
            self.shipping_carrier_code = shipping_carrier_code
        if shipping_option_id is not None:
            self.shipping_option_id = shipping_option_id
        if shipping_service_code is not None:
            self.shipping_service_code = shipping_service_code

    @property
    def base_delivery_cost(self):
        """Gets the base_delivery_cost of this ShippingOption.  # noqa: E501


        :return: The base_delivery_cost of this ShippingOption.  # noqa: E501
        :rtype: Amount
        """
        return self._base_delivery_cost

    @base_delivery_cost.setter
    def base_delivery_cost(self, base_delivery_cost):
        """Sets the base_delivery_cost of this ShippingOption.


        :param base_delivery_cost: The base_delivery_cost of this ShippingOption.  # noqa: E501
        :type: Amount
        """

        self._base_delivery_cost = base_delivery_cost

    @property
    def delivery_discount(self):
        """Gets the delivery_discount of this ShippingOption.  # noqa: E501


        :return: The delivery_discount of this ShippingOption.  # noqa: E501
        :rtype: Amount
        """
        return self._delivery_discount

    @delivery_discount.setter
    def delivery_discount(self, delivery_discount):
        """Sets the delivery_discount of this ShippingOption.


        :param delivery_discount: The delivery_discount of this ShippingOption.  # noqa: E501
        :type: Amount
        """

        self._delivery_discount = delivery_discount

    @property
    def import_charges(self):
        """Gets the import_charges of this ShippingOption.  # noqa: E501


        :return: The import_charges of this ShippingOption.  # noqa: E501
        :rtype: Amount
        """
        return self._import_charges

    @import_charges.setter
    def import_charges(self, import_charges):
        """Sets the import_charges of this ShippingOption.


        :param import_charges: The import_charges of this ShippingOption.  # noqa: E501
        :type: Amount
        """

        self._import_charges = import_charges

    @property
    def max_estimated_delivery_date(self):
        """Gets the max_estimated_delivery_date of this ShippingOption.  # noqa: E501

        The end of the date range in which the purchase order is expected to be delivered to the shipping address.  # noqa: E501

        :return: The max_estimated_delivery_date of this ShippingOption.  # noqa: E501
        :rtype: str
        """
        return self._max_estimated_delivery_date

    @max_estimated_delivery_date.setter
    def max_estimated_delivery_date(self, max_estimated_delivery_date):
        """Sets the max_estimated_delivery_date of this ShippingOption.

        The end of the date range in which the purchase order is expected to be delivered to the shipping address.  # noqa: E501

        :param max_estimated_delivery_date: The max_estimated_delivery_date of this ShippingOption.  # noqa: E501
        :type: str
        """

        self._max_estimated_delivery_date = max_estimated_delivery_date

    @property
    def min_estimated_delivery_date(self):
        """Gets the min_estimated_delivery_date of this ShippingOption.  # noqa: E501

        The beginning of the date range in which the purchase order is expected to be delivered to the shipping address.  # noqa: E501

        :return: The min_estimated_delivery_date of this ShippingOption.  # noqa: E501
        :rtype: str
        """
        return self._min_estimated_delivery_date

    @min_estimated_delivery_date.setter
    def min_estimated_delivery_date(self, min_estimated_delivery_date):
        """Sets the min_estimated_delivery_date of this ShippingOption.

        The beginning of the date range in which the purchase order is expected to be delivered to the shipping address.  # noqa: E501

        :param min_estimated_delivery_date: The min_estimated_delivery_date of this ShippingOption.  # noqa: E501
        :type: str
        """

        self._min_estimated_delivery_date = min_estimated_delivery_date

    @property
    def selected(self):
        """Gets the selected of this ShippingOption.  # noqa: E501

        Indicates if the shipping method is selected.  # noqa: E501

        :return: The selected of this ShippingOption.  # noqa: E501
        :rtype: bool
        """
        return self._selected

    @selected.setter
    def selected(self, selected):
        """Sets the selected of this ShippingOption.

        Indicates if the shipping method is selected.  # noqa: E501

        :param selected: The selected of this ShippingOption.  # noqa: E501
        :type: bool
        """

        self._selected = selected

    @property
    def shipping_carrier_code(self):
        """Gets the shipping_carrier_code of this ShippingOption.  # noqa: E501

        The shipping provider, such as FedEx, or USPS for the line item.  # noqa: E501

        :return: The shipping_carrier_code of this ShippingOption.  # noqa: E501
        :rtype: str
        """
        return self._shipping_carrier_code

    @shipping_carrier_code.setter
    def shipping_carrier_code(self, shipping_carrier_code):
        """Sets the shipping_carrier_code of this ShippingOption.

        The shipping provider, such as FedEx, or USPS for the line item.  # noqa: E501

        :param shipping_carrier_code: The shipping_carrier_code of this ShippingOption.  # noqa: E501
        :type: str
        """

        self._shipping_carrier_code = shipping_carrier_code

    @property
    def shipping_option_id(self):
        """Gets the shipping_option_id of this ShippingOption.  # noqa: E501

        A unique ID for the selected shipping option/method.  # noqa: E501

        :return: The shipping_option_id of this ShippingOption.  # noqa: E501
        :rtype: str
        """
        return self._shipping_option_id

    @shipping_option_id.setter
    def shipping_option_id(self, shipping_option_id):
        """Sets the shipping_option_id of this ShippingOption.

        A unique ID for the selected shipping option/method.  # noqa: E501

        :param shipping_option_id: The shipping_option_id of this ShippingOption.  # noqa: E501
        :type: str
        """

        self._shipping_option_id = shipping_option_id

    @property
    def shipping_service_code(self):
        """Gets the shipping_service_code of this ShippingOption.  # noqa: E501

        A name of a shipping type. For example, Priority Mail Express (provided by USPS) or FedEx International Priority (Provided by FedEx).  # noqa: E501

        :return: The shipping_service_code of this ShippingOption.  # noqa: E501
        :rtype: str
        """
        return self._shipping_service_code

    @shipping_service_code.setter
    def shipping_service_code(self, shipping_service_code):
        """Sets the shipping_service_code of this ShippingOption.

        A name of a shipping type. For example, Priority Mail Express (provided by USPS) or FedEx International Priority (Provided by FedEx).  # noqa: E501

        :param shipping_service_code: The shipping_service_code of this ShippingOption.  # noqa: E501
        :type: str
        """

        self._shipping_service_code = shipping_service_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ShippingOption, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShippingOption):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
