# coding: utf-8

# flake8: noqa
"""
    Catalog API

    The Catalog API allows users to search for and locate an eBay catalog product that is a direct match for the product that they wish to sell. Listing against an eBay catalog product helps insure that all listings (based off of that catalog product) have complete and accurate information. In addition to helping to create high-quality listings, another benefit to the seller of using catalog information to create listings is that much of the details of the listing will be prefilled, including the listing title, the listing description, the item specifics, and a stock image for the product (if available). Sellers will not have to enter item specifics themselves, and the overall listing process is a lot faster and easier.  # noqa: E501

    OpenAPI spec version: v1_beta.5.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# import models into model package
from ...commerce_catalog.models.aspect import Aspect
from ...commerce_catalog.models.aspect_distribution import AspectDistribution
from ...commerce_catalog.models.aspect_value_distribution import AspectValueDistribution
from ...commerce_catalog.models.error import Error
from ...commerce_catalog.models.error_parameter import ErrorParameter
from ...commerce_catalog.models.image import Image
from ...commerce_catalog.models.product import Product
from ...commerce_catalog.models.product_search_response import ProductSearchResponse
from ...commerce_catalog.models.product_summary import ProductSummary
from ...commerce_catalog.models.refinement import Refinement
