# coding: utf-8

"""
    Catalog API

    The Catalog API allows users to search for and locate an eBay catalog product that is a direct match for the product that they wish to sell. Listing against an eBay catalog product helps insure that all listings (based off of that catalog product) have complete and accurate information. In addition to helping to create high-quality listings, another benefit to the seller of using catalog information to create listings is that much of the details of the listing will be prefilled, including the listing title, the listing description, the item specifics, and a stock image for the product (if available). Sellers will not have to enter item specifics themselves, and the overall listing process is a lot faster and easier.  # noqa: E501

    OpenAPI spec version: v1_beta.5.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Refinement(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aspect_distributions': 'list[AspectDistribution]',
        'dominant_category_id': 'str'
    }

    attribute_map = {
        'aspect_distributions': 'aspectDistributions',
        'dominant_category_id': 'dominantCategoryId'
    }

    def __init__(self, aspect_distributions=None, dominant_category_id=None):  # noqa: E501
        """Refinement - a model defined in Swagger"""  # noqa: E501
        self._aspect_distributions = None
        self._dominant_category_id = None
        self.discriminator = None
        if aspect_distributions is not None:
            self.aspect_distributions = aspect_distributions
        if dominant_category_id is not None:
            self.dominant_category_id = dominant_category_id

    @property
    def aspect_distributions(self):
        """Gets the aspect_distributions of this Refinement.  # noqa: E501

        Contains information about one or more aspects that are associated with the category identified by dominantCategoryId.  # noqa: E501

        :return: The aspect_distributions of this Refinement.  # noqa: E501
        :rtype: list[AspectDistribution]
        """
        return self._aspect_distributions

    @aspect_distributions.setter
    def aspect_distributions(self, aspect_distributions):
        """Sets the aspect_distributions of this Refinement.

        Contains information about one or more aspects that are associated with the category identified by dominantCategoryId.  # noqa: E501

        :param aspect_distributions: The aspect_distributions of this Refinement.  # noqa: E501
        :type: list[AspectDistribution]
        """

        self._aspect_distributions = aspect_distributions

    @property
    def dominant_category_id(self):
        """Gets the dominant_category_id of this Refinement.  # noqa: E501

        The ID of the category that eBay determines is most likely to cover the products matching the search criteria.  # noqa: E501

        :return: The dominant_category_id of this Refinement.  # noqa: E501
        :rtype: str
        """
        return self._dominant_category_id

    @dominant_category_id.setter
    def dominant_category_id(self, dominant_category_id):
        """Sets the dominant_category_id of this Refinement.

        The ID of the category that eBay determines is most likely to cover the products matching the search criteria.  # noqa: E501

        :param dominant_category_id: The dominant_category_id of this Refinement.  # noqa: E501
        :type: str
        """

        self._dominant_category_id = dominant_category_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Refinement, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Refinement):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
