# coding: utf-8

"""
    Identity API

    Retrieves the authenticated user's account profile information. It can be used to let users log into your app or site using eBay, which frees you from needing to store and protect user's PII (Personal Identifiable Information) data.  # noqa: E501

    OpenAPI spec version: v1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class BusinessAccount(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'address': 'Address',
        'doing_business_as': 'str',
        'email': 'str',
        'name': 'str',
        'primary_contact': 'Contact',
        'primary_phone': 'Phone',
        'secondary_phone': 'Phone',
        'website': 'str'
    }

    attribute_map = {
        'address': 'address',
        'doing_business_as': 'doingBusinessAs',
        'email': 'email',
        'name': 'name',
        'primary_contact': 'primaryContact',
        'primary_phone': 'primaryPhone',
        'secondary_phone': 'secondaryPhone',
        'website': 'website'
    }

    def __init__(self, address=None, doing_business_as=None, email=None, name=None, primary_contact=None, primary_phone=None, secondary_phone=None, website=None):  # noqa: E501
        """BusinessAccount - a model defined in Swagger"""  # noqa: E501
        self._address = None
        self._doing_business_as = None
        self._email = None
        self._name = None
        self._primary_contact = None
        self._primary_phone = None
        self._secondary_phone = None
        self._website = None
        self.discriminator = None
        if address is not None:
            self.address = address
        if doing_business_as is not None:
            self.doing_business_as = doing_business_as
        if email is not None:
            self.email = email
        if name is not None:
            self.name = name
        if primary_contact is not None:
            self.primary_contact = primary_contact
        if primary_phone is not None:
            self.primary_phone = primary_phone
        if secondary_phone is not None:
            self.secondary_phone = secondary_phone
        if website is not None:
            self.website = website

    @property
    def address(self):
        """Gets the address of this BusinessAccount.  # noqa: E501


        :return: The address of this BusinessAccount.  # noqa: E501
        :rtype: Address
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this BusinessAccount.


        :param address: The address of this BusinessAccount.  # noqa: E501
        :type: Address
        """

        self._address = address

    @property
    def doing_business_as(self):
        """Gets the doing_business_as of this BusinessAccount.  # noqa: E501

        An additional name that is used for their business on eBay. The business name is returned in the name field.  # noqa: E501

        :return: The doing_business_as of this BusinessAccount.  # noqa: E501
        :rtype: str
        """
        return self._doing_business_as

    @doing_business_as.setter
    def doing_business_as(self, doing_business_as):
        """Sets the doing_business_as of this BusinessAccount.

        An additional name that is used for their business on eBay. The business name is returned in the name field.  # noqa: E501

        :param doing_business_as: The doing_business_as of this BusinessAccount.  # noqa: E501
        :type: str
        """

        self._doing_business_as = doing_business_as

    @property
    def email(self):
        """Gets the email of this BusinessAccount.  # noqa: E501

        The email address of the business account.  # noqa: E501

        :return: The email of this BusinessAccount.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this BusinessAccount.

        The email address of the business account.  # noqa: E501

        :param email: The email of this BusinessAccount.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def name(self):
        """Gets the name of this BusinessAccount.  # noqa: E501

        The business name associated with the user's eBay account.  # noqa: E501

        :return: The name of this BusinessAccount.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BusinessAccount.

        The business name associated with the user's eBay account.  # noqa: E501

        :param name: The name of this BusinessAccount.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def primary_contact(self):
        """Gets the primary_contact of this BusinessAccount.  # noqa: E501


        :return: The primary_contact of this BusinessAccount.  # noqa: E501
        :rtype: Contact
        """
        return self._primary_contact

    @primary_contact.setter
    def primary_contact(self, primary_contact):
        """Sets the primary_contact of this BusinessAccount.


        :param primary_contact: The primary_contact of this BusinessAccount.  # noqa: E501
        :type: Contact
        """

        self._primary_contact = primary_contact

    @property
    def primary_phone(self):
        """Gets the primary_phone of this BusinessAccount.  # noqa: E501


        :return: The primary_phone of this BusinessAccount.  # noqa: E501
        :rtype: Phone
        """
        return self._primary_phone

    @primary_phone.setter
    def primary_phone(self, primary_phone):
        """Sets the primary_phone of this BusinessAccount.


        :param primary_phone: The primary_phone of this BusinessAccount.  # noqa: E501
        :type: Phone
        """

        self._primary_phone = primary_phone

    @property
    def secondary_phone(self):
        """Gets the secondary_phone of this BusinessAccount.  # noqa: E501


        :return: The secondary_phone of this BusinessAccount.  # noqa: E501
        :rtype: Phone
        """
        return self._secondary_phone

    @secondary_phone.setter
    def secondary_phone(self, secondary_phone):
        """Sets the secondary_phone of this BusinessAccount.


        :param secondary_phone: The secondary_phone of this BusinessAccount.  # noqa: E501
        :type: Phone
        """

        self._secondary_phone = secondary_phone

    @property
    def website(self):
        """Gets the website of this BusinessAccount.  # noqa: E501

        The business website address associated with the eBay account.  # noqa: E501

        :return: The website of this BusinessAccount.  # noqa: E501
        :rtype: str
        """
        return self._website

    @website.setter
    def website(self, website):
        """Sets the website of this BusinessAccount.

        The business website address associated with the eBay account.  # noqa: E501

        :param website: The website of this BusinessAccount.  # noqa: E501
        :type: str
        """

        self._website = website

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BusinessAccount, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BusinessAccount):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
