# coding: utf-8

"""
    Identity API

    Retrieves the authenticated user's account profile information. It can be used to let users log into your app or site using eBay, which frees you from needing to store and protect user's PII (Personal Identifiable Information) data.  # noqa: E501

    OpenAPI spec version: v1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class UserResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'account_type': 'str',
        'business_account': 'BusinessAccount',
        'individual_account': 'IndividualAccount',
        'registration_marketplace_id': 'str',
        'status': 'str',
        'user_id': 'str',
        'username': 'str'
    }

    attribute_map = {
        'account_type': 'accountType',
        'business_account': 'businessAccount',
        'individual_account': 'individualAccount',
        'registration_marketplace_id': 'registrationMarketplaceId',
        'status': 'status',
        'user_id': 'userId',
        'username': 'username'
    }

    def __init__(self, account_type=None, business_account=None, individual_account=None, registration_marketplace_id=None, status=None, user_id=None, username=None):  # noqa: E501
        """UserResponse - a model defined in Swagger"""  # noqa: E501
        self._account_type = None
        self._business_account = None
        self._individual_account = None
        self._registration_marketplace_id = None
        self._status = None
        self._user_id = None
        self._username = None
        self.discriminator = None
        if account_type is not None:
            self.account_type = account_type
        if business_account is not None:
            self.business_account = business_account
        if individual_account is not None:
            self.individual_account = individual_account
        if registration_marketplace_id is not None:
            self.registration_marketplace_id = registration_marketplace_id
        if status is not None:
            self.status = status
        if user_id is not None:
            self.user_id = user_id
        if username is not None:
            self.username = username

    @property
    def account_type(self):
        """Gets the account_type of this UserResponse.  # noqa: E501

        Indicates the user account type. This is determined when the user registers with eBay. If they register for a business account, this value will be BUSINESS. If they register for a private account, this value will be INDIVIDUAL. This designation is required by the tax laws in the following countries: EBAY_AT, EBAY_BE, EBAY_CH, EBAY_DE, EBAY_ES, EBAY_FR, EBAY_GB, EBAY_IE, EBAY_IT, EBAY_PL Valid Values: BUSINESS or INDIVIDUAL Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/identity/types/api:AccountTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The account_type of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._account_type

    @account_type.setter
    def account_type(self, account_type):
        """Sets the account_type of this UserResponse.

        Indicates the user account type. This is determined when the user registers with eBay. If they register for a business account, this value will be BUSINESS. If they register for a private account, this value will be INDIVIDUAL. This designation is required by the tax laws in the following countries: EBAY_AT, EBAY_BE, EBAY_CH, EBAY_DE, EBAY_ES, EBAY_FR, EBAY_GB, EBAY_IE, EBAY_IT, EBAY_PL Valid Values: BUSINESS or INDIVIDUAL Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/identity/types/api:AccountTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param account_type: The account_type of this UserResponse.  # noqa: E501
        :type: str
        """

        self._account_type = account_type

    @property
    def business_account(self):
        """Gets the business_account of this UserResponse.  # noqa: E501


        :return: The business_account of this UserResponse.  # noqa: E501
        :rtype: BusinessAccount
        """
        return self._business_account

    @business_account.setter
    def business_account(self, business_account):
        """Sets the business_account of this UserResponse.


        :param business_account: The business_account of this UserResponse.  # noqa: E501
        :type: BusinessAccount
        """

        self._business_account = business_account

    @property
    def individual_account(self):
        """Gets the individual_account of this UserResponse.  # noqa: E501


        :return: The individual_account of this UserResponse.  # noqa: E501
        :rtype: IndividualAccount
        """
        return self._individual_account

    @individual_account.setter
    def individual_account(self, individual_account):
        """Sets the individual_account of this UserResponse.


        :param individual_account: The individual_account of this UserResponse.  # noqa: E501
        :type: IndividualAccount
        """

        self._individual_account = individual_account

    @property
    def registration_marketplace_id(self):
        """Gets the registration_marketplace_id of this UserResponse.  # noqa: E501

        The eBay site on which the account is registered. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/identity/types/bas:MarketplaceIdEnum'>eBay API documentation</a>  # noqa: E501

        :return: The registration_marketplace_id of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._registration_marketplace_id

    @registration_marketplace_id.setter
    def registration_marketplace_id(self, registration_marketplace_id):
        """Sets the registration_marketplace_id of this UserResponse.

        The eBay site on which the account is registered. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/identity/types/bas:MarketplaceIdEnum'>eBay API documentation</a>  # noqa: E501

        :param registration_marketplace_id: The registration_marketplace_id of this UserResponse.  # noqa: E501
        :type: str
        """

        self._registration_marketplace_id = registration_marketplace_id

    @property
    def status(self):
        """Gets the status of this UserResponse.  # noqa: E501

        Indicates the user's account status. Possible values: CONFIRMED, UNCONFIRMED, ACCOUNTONHOLD and UNDETERMINED. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/identity/types/api:UserStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The status of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this UserResponse.

        Indicates the user's account status. Possible values: CONFIRMED, UNCONFIRMED, ACCOUNTONHOLD and UNDETERMINED. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/commerce/identity/types/api:UserStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param status: The status of this UserResponse.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def user_id(self):
        """Gets the user_id of this UserResponse.  # noqa: E501

        The eBay immutable user ID of the user's account and can always be used to identify the user.  # noqa: E501

        :return: The user_id of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this UserResponse.

        The eBay immutable user ID of the user's account and can always be used to identify the user.  # noqa: E501

        :param user_id: The user_id of this UserResponse.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def username(self):
        """Gets the username of this UserResponse.  # noqa: E501

        The user name, which was specific by the user when they created the account. Note: This value can be changed by the user.  # noqa: E501

        :return: The username of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this UserResponse.

        The user name, which was specific by the user when they created the account. Note: This value can be changed by the user.  # noqa: E501

        :param username: The username of this UserResponse.  # noqa: E501
        :type: str
        """

        self._username = username

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
